/*    Calendar.xs
 *
 *    $Id: Calendar.xs,v 1.14 2002/06/30 04:21:25 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell and James
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "unicode/utypes.h"
#include  "unicode/datefmt.h"
#include  "unicode/timezone.h"
#include  "unicode/calendar.h"
#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/TimeZone.h"
#include  "picu/DateFormat.h"
#include  "picu/Locale.h"
#include  "picu/Calendar.h"

char *Calendar_class_string = "ICU::Calendar";
static int debugLevel = 0;

static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {

    case 'A':
        if (strEQ(name, "AM"))
            return Calendar::AM;
        else if (strEQ(name, "AM_PM"))
            return Calendar::AM_PM;
        else if (strEQ(name, "APRIL"))
            return Calendar::APRIL;
        else if (strEQ(name, "AUGUST"))
            return Calendar::AUGUST;
        break;
    case 'D':
        if (strEQ(name, "DATE"))
            return Calendar::DATE;
        else if (strEQ(name, "DAY_OF_YEAR"))
            return Calendar::DAY_OF_YEAR;
        else if (strEQ(name, "DAY_OF_WEEK"))
            return Calendar::DAY_OF_WEEK;
        else if (strEQ(name, "DAY_OF_WEEK_IN_MONTH"))
            return Calendar::DAY_OF_WEEK_IN_MONTH;
        else if (strEQ(name, "DST_OFFSET"))
            return Calendar::DST_OFFSET;
        else if (strEQ(name, "DAY_OF_MONTH"))
            return Calendar::DAY_OF_MONTH;
        else if (strEQ(name, "DATE"))
            return Calendar::DATE;
        else if (strEQ(name, "DOW_LOCAL"))
            return Calendar::DOW_LOCAL;
        else if (strEQ(name, "DECEMBER"))
            return Calendar::DECEMBER;
        break;
    case 'E':
        if (strEQ(name, "ERA"))
           return Calendar::ERA;
        break;
    case 'F':
        if (strEQ(name, "FIELD_COUNT"))
            return Calendar::FIELD_COUNT;
        else if (strEQ(name, "FRIDAY"))
            return Calendar::FRIDAY;
        else if (strEQ(name, "FEBRUARY"))
            return Calendar::FEBRUARY;
        break;
    case 'H':
        if (strEQ(name, "HOUR"))
            return Calendar::HOUR;
        else if (strEQ(name, "HOUR_OF_DAY"))
            return Calendar::HOUR_OF_DAY;
        break;
    case 'J':
        if (strEQ(name, "JUNE"))
            return Calendar::JUNE;
        else if (strEQ(name, "JULY"))
            return Calendar::JULY;
        else if (strEQ(name, "JANUARY"))
            return Calendar::JANUARY;
        break;
    case 'M':
        if (strEQ(name, "MARCH"))
            return Calendar::MARCH;
        else if (strEQ(name, "MAY"))
            return Calendar::MAY;
        else if (strEQ(name, "MONTH"))
            return Calendar::MONTH;
        else if (strEQ(name, "MINUTE"))
            return Calendar::MINUTE;
        else if (strEQ(name, "MILLISECOND"))
            return Calendar::MILLISECOND;
        else if (strEQ(name, "MONDAY"))
            return Calendar::MONDAY;
        break;
    case 'N':
        if (strEQ(name, "NOVEMBER"))
            return Calendar::NOVEMBER;
        break;
    case 'O':
        if (strEQ(name, "OCTOBER"))
            return Calendar::OCTOBER;
        break;
    case 'P':
        if (strEQ(name, "PM"))
            return Calendar::PM;
        break;
    case 'S':
        if (strEQ(name, "SECOND"))
            return Calendar::SECOND;
        else if (strEQ(name, "SUNDAY"))
            return Calendar::SUNDAY;
        else if (strEQ(name, "SATURDAY"))
            return Calendar::SATURDAY;
        else if (strEQ(name, "SEPTEMBER"))
            return Calendar::SEPTEMBER;
        break;
    case 'T':
        if (strEQ(name, "TUESDAY"))
            return Calendar::TUESDAY;
        else if (strEQ(name, "THURSDAY"))
            return Calendar::THURSDAY;
        break;
    case 'U':
        if (strEQ(name, "UNDECIMBER"))
            return Calendar::UNDECIMBER;
        break;
    case 'W':
        if (strEQ(name, "WEDNESDAY"))
            return Calendar::WEDNESDAY;
        else if (strEQ(name, "WEEK_OF_YEAR"))
            return Calendar::WEEK_OF_YEAR;
        else if (strEQ(name, "WEEK_OF_MONTH"))
            return Calendar::WEEK_OF_MONTH;
        break;
    case 'Y':
        if (strEQ(name, "YEAR"))
            return Calendar::YEAR;
        else if (strEQ(name, "YEAR_WOY"))
            return Calendar::YEAR_WOY;
        break;
    case 'Z':
        if (strEQ(name, "ZONE_OFFSET"))
            return Calendar::ZONE_OFFSET;
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum Calendar::EDateFields Calendar__EDateFields;
typedef enum Calendar::EDaysOfWeek Calendar__EDaysOfWeek;
typedef enum Calendar::EMonths Calendar__EMonths;
typedef enum Calendar::EAmpm Calendar__EAmpm;

MODULE = ICU::Calendar    PACKAGE = ICU::Calendar  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name, arg)
    char *name
    int arg

Calendar *
createInstance(CLASS, ...)
    char * CLASS;
    PREINIT:
    UErrorCode status = U_ZERO_ERROR;
    SV *sv_status = NULL;
    CODE:
        DEBUG100("createInstance items=%d", items);
        if (items < 2 || items > 3) {
            Perl_croak(aTHX_ "Usage: ICU::Calendar::createInstance( [ $zoneToAdopt ], \\$status )");
        }
 
        if (items == 2) {                                                       
            if (!SVIsIntRef(ST(1))) {
                Perl_croak(aTHX_ "ICU::Calendar::createInstance: param 2 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(1));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
            DEBUG100("status = %d", status); 
            RETVAL = Calendar::createInstance(status);
        }
        else if (items == 3) {
           TimeZone *zoneToAdopt;

            if (!SVIsIntRef(ST(2))) {
                Perl_croak(aTHX_ "ICU::Calendar::createInstance: param 3 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(2));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
            DEBUG100("status = %d", status);
            RETVAL = Calendar::createInstance(zoneToAdopt, status);
        }
        DEBUG100("status = %d", status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:
        RETVAL

void
Calendar::DESTROY()
    CODE:
        DEBUG100("Calendar::DESTROY()");
        delete THIS;
        DEBUG100("Calendar::DESTROY()");

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::Calendar::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
        printf("in setDebugLevel ...\n");
    OUTPUT:
        RETVAL

UDate
Calendar::getTime( ... )
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
    CODE:
        DEBUG100("getTime items=%d", items);
        if (items > 2 ) {
            Perl_croak(aTHX_ "Usage: ICU::Calendar::getTime( [ \\$status ] )");
        }

        if (items == 2) {
            if (!SVIsIntRef(ST(1))) {
                Perl_croak(aTHX_ "ICU::Calendar::getTime: param 1 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(1));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
            DEBUG100("status = %d", status);
        }
        UDate val = THIS->getTime(status);
        DEBUG100("getTime date = %lu", (UDate)val);
        ST(0) = sv_newmortal();
        sv_setnv(ST(0), (UDate)val);
        DEBUG100("status = %d", status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }

void
Calendar::setTime(date, ... )
        UDate date;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
    CODE:
        DEBUG100("setTime date = %lu", (UDate)date);
        if (items > 3 ) {
            Perl_croak(aTHX_ "Usage: ICU::Calendar::setTime( $date, [ \\$status ] )");
        }
 
        if (items == 3) {
            if (!SVIsIntRef(ST(2))) {
                Perl_croak(aTHX_ "ICU::Calendar::setTime: param 2 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(2));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
            DEBUG100("status = %d", status);
        }
        THIS->setTime(date, status);
        DEBUG100("status = %d", status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }

void
Calendar::roll(field, up, status)
        Calendar__EDateFields field;
        UBool up;
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        THIS->roll(field, up, status);

void
Calendar::adoptTimeZone(zone)
        TimeZone *zone;
    CODE:
        THIS->adoptTimeZone(zone);

void
Calendar::setTimeZone(zone)
        TimeZone *zone;
    CODE:
        THIS->setTimeZone((const TimeZone &)(*zone));

TimeZone *
Calendar::getTimeZone()
    PPCODE:
        TimeZone *x = ((TimeZone *)&THIS->getTimeZone())->clone();
        EXTEND(SP, 1);
        SV *sv = sv_newmortal();
        sv_setref_pv(sv, TimeZone_class_string, (void *)x);
        PUSHs(sv);

void
Calendar::setLenient(lenient)
        UBool lenient;
    CODE:
        THIS->setLenient(lenient);

UBool
Calendar::isLenient()
    CODE:
        RETVAL = THIS->isLenient();
    OUTPUT:
        RETVAL

void
Calendar::setFirstDayOfWeek(value)
        Calendar__EDaysOfWeek value;
    CODE:
        THIS->setFirstDayOfWeek(value);

Calendar__EDaysOfWeek
Calendar::getFirstDayOfWeek()
    CODE:
        RETVAL = THIS->getFirstDayOfWeek();
    OUTPUT:
        RETVAL

void
Calendar::setMinimalDaysInFirstWeek(value)
        uint8_t value;
    CODE:
        THIS->setMinimalDaysInFirstWeek(value);

uint8_t
Calendar::getMinimalDaysInFirstWeek()
    CODE:
        RETVAL = THIS->getMinimalDaysInFirstWeek();
    OUTPUT:
        RETVAL

int32_t
Calendar::getActualMinimum(field, status)
        Calendar__EDateFields field;
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        RETVAL = THIS->getActualMinimum(field, status);
    OUTPUT:
        RETVAL

int32_t
Calendar::getActualMaximum(field, status)
        Calendar__EDateFields field;
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        RETVAL = THIS->getActualMaximum(field, status);
    OUTPUT:
        RETVAL

int32_t
Calendar::get(field, status)
        Calendar__EDateFields field;
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        RETVAL = THIS->get(field, status);
    OUTPUT:
        RETVAL

UBool
Calendar::isSet(field)
        Calendar__EDateFields field;
    CODE:
        RETVAL = THIS->isSet(field);
    OUTPUT:
        RETVAL

void
Calendar::set( ... )
    CODE:
        DEBUG100("set items=%d", items);
        if (items < 3 || items == 5 || items > 7) {
            Perl_croak(aTHX_ "Usage: $cal->set( ... )");
        }

        if (items == 3) {
            Calendar__EDateFields field = (Calendar__EDateFields) SvIV(ST(1));
            int32_t value = SvIV(ST(2));

            THIS->set(field, value);
        }
        else if (items == 4) {
            int32_t year  = SvIV(ST(1));
            int32_t month = SvIV(ST(2));
            int32_t date  = SvIV(ST(3));

            THIS->set(year, month, date);
        }
        else if (items == 6) {
            int32_t year   = SvIV(ST(1));
            int32_t month  = SvIV(ST(2));
            int32_t date   = SvIV(ST(3));
            int32_t hour   = SvIV(ST(4));
            int32_t minute = SvIV(ST(5));

            THIS->set(year, month, date, hour, minute);
        }
        else if (items == 7) {
            int32_t year   = SvIV(ST(1));
            int32_t month  = SvIV(ST(2));
            int32_t date   = SvIV(ST(3));
            int32_t hour   = SvIV(ST(4));
            int32_t minute = SvIV(ST(5));
            int32_t second = SvIV(ST(6));

            THIS->set(year, month, date, hour, minute, second);
        }

void
Calendar::clear()
    CODE:
        THIS->clear();

void
Calendar::clear_field(field)
        Calendar__EDateFields field;
    CODE:
        THIS->clear(field);

