# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 5038 + 1;
use Test::NoWarnings;

use Unicode::UCD;
use Net::IDN::UTS46 (':all');

no warnings 'utf8';

our $UCD_VERSION = eval('v'.(Unicode::UCD::UnicodeVersion()));

my %p = ("TransitionalProcessing" => "0");

is(eval{uts46_to_unicode("fass.de", %p)},	"fass.de",	"to_unicode\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:63\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:65\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--fa-hia.de", %p)},	"faß.de",	"to_unicode\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:66\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{05D0}", %p)},	undef,	"to_unicode\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{05D0}", %p)},	undef,	"to_unicode\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0à.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0à\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0a\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0A\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0À.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0À\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0-sfa.xn--4db", %p)},	"0à.\x{05D0}",	"to_unicode\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca.xn--ssa73l", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}.\x{05D0}", %p)},	undef,	"to_unicode\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'a\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'A\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'Àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca88g.xn--4db", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca81i.xn--4db", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ab", %p)},	"ab",	"to_unicode\(\'ab\'\)\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf", %p)},	"a\x{094D}b",	"to_unicode\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}B", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf604u", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf014u", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¡", %p)},	"¡",	"to_unicode\(\'\¡\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7a", %p)},	"¡",	"to_unicode\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("᧚", %p)},	"᧚",	"to_unicode\(\'᧚\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--pkf", %p)},	"᧚",	"to_unicode\(\'xn\-\-pkf\'\)\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("。", %p)},	undef,	"to_unicode\(\'\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("ꭠ", %p)},	"ꭠ",	"to_unicode\(\'ꭠ\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("xn--3y9a", %p)},	"ꭠ",	"to_unicode\(\'xn\-\-3y9a\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("1234567890ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.eXample.cOm", %p)},	"www.example.com",	"to_unicode\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bücher.de", %p)},	"bücher.de",	"to_unicode\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bücher.de", %p)},	"bücher.de",	"to_unicode\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BÜCHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BU\x{0308}CHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bcher-kva.de", %p)},	"bücher.de",	"to_unicode\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ÖBB", %p)},	"öbb",	"to_unicode\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}BB", %p)},	"öbb",	"to_unicode\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("o\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("öbb", %p)},	"öbb",	"to_unicode\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Öbb", %p)},	"öbb",	"to_unicode\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bb-eka", %p)},	"öbb",	"to_unicode\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b.com", %p)},	"βόλοσ.com",	"to_unicode\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c.com", %p)},	"βόλος.com",	"to_unicode\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c", %p)},	"βόλος",	"to_unicode\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b", %p)},	"βόλοσ",	"to_unicode\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b660p.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b．c\。d｡\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c。d。", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\。d\。\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c.d.", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--tda.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.ü", %p)},	"ü.ü",	"to_unicode\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.U\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.Ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--u-ccb", %p)},	undef,	"to_unicode\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a⒈com", %p)},	undef,	"to_unicode\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a1.com", %p)},	"a1.com",	"to_unicode\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈COM", %p)},	undef,	"to_unicode\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈Com", %p)},	undef,	"to_unicode\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ecp.ru", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0.pt", %p)},	undef,	"to_unicode\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-Ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-a\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-Ä.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-A\x{0308}.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-Ä.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ＪＰ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。JP", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。JP\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--wgv71a119e.jp", %p)},	"日本語.jp",	"to_unicode\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語.jp", %p)},	"日本語.jp",	"to_unicode\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。Ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("☕", %p)},	"☕",	"to_unicode\(\'\☕\'\)\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--53h", %p)},	"☕",	"to_unicode\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bss", %p)},	"夙",	"to_unicode\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夙", %p)},	"夙",	"to_unicode\(\'夙\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰󠇯ﬄ", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\󠇯ﬄ\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("xn--bssffl", %p)},	"夡夞夜夙",	"to_unicode\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夡夞夜夙", %p)},	"夡夞夜夙",	"to_unicode\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--ä-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--Ä-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..xn---q----jra.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a..c", %p)},	undef,	"to_unicode\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-b.", %p)},	undef,	"to_unicode\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b-.c", %p)},	undef,	"to_unicode\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-.c", %p)},	undef,	"to_unicode\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.bc--de.f", %p)},	undef,	"to_unicode\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-b.", %p)},	undef,	"to_unicode\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-b.", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-B.", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-B.", %p)},	undef,	"to_unicode\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.b-.c", %p)},	undef,	"to_unicode\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.b-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.B-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.B-.C", %p)},	undef,	"to_unicode\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-.c", %p)},	undef,	"to_unicode\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-.C", %p)},	undef,	"to_unicode\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.bc--de.f", %p)},	undef,	"to_unicode\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.bc--de.f", %p)},	undef,	"to_unicode\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.BC--DE.F", %p)},	undef,	"to_unicode\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.BC--DE.F", %p)},	undef,	"to_unicode\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.\x{0308}c.d", %p)},	undef,	"to_unicode\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B.\x{0308}C.D", %p)},	undef,	"to_unicode\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.xn--c-bcb.d", %p)},	undef,	"to_unicode\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A0", %p)},	"a0",	"to_unicode\(\'A0\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A", %p)},	"0a",	"to_unicode\(\'0A\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A.\x{05D0}", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0A\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a.xn--4db", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0a\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.xn--0-eha.xn--4db", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0u\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0u\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0U\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0U\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0Ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0Ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("b-.\x{05D0}", %p)},	undef,	"to_unicode\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("d.xn----dha.xn--4db", %p)},	undef,	"to_unicode\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}\x{05C7}", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--vdbr", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}9\x{05C7}", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--9-ihcz", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}a\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}A\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{05D0}\x{05EA}", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05F3}\x{05EA}", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c0a", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}Tz", %p)},	undef,	"to_unicode\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}tz", %p)},	undef,	"to_unicode\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}TZ", %p)},	undef,	"to_unicode\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}tz", %p)},	undef,	"to_unicode\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}T\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}t\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{05EA}", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7-zhc3f", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{0667}\x{05EA}", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c6t", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a7\x{0667}z", %p)},	undef,	"to_unicode\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}Z", %p)},	undef,	"to_unicode\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}z", %p)},	undef,	"to_unicode\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b194h", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc", %p)},	"ஹ",	"to_unicode\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ", %p)},	"ஹ",	"to_unicode\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4by94h", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia7523a", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3q", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3qq34f", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga828w", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06EF}", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a953d", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxq", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--cmba", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{06EF}", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb", %p)},	"\x{0644}",	"to_unicode\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}", %p)},	"\x{0644}",	"to_unicode\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒕∝\x{065F}򓤦．-󠄯", %p)},	undef,	"to_unicode\(\'⒕\∝\\u065F\?．\-\󠄯\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("14.∝\x{065F}򓤦.-󠄯", %p)},	undef,	"to_unicode\(\'14\.\∝\\u065F\?\.\-\󠄯\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡣ.\x{07CF}", %p)},	"ꡣ.\x{07CF}",	"to_unicode\(\'ꡣ\.\\u07CF\'\)\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--8c9a.xn--qsb", %p)},	"ꡣ.\x{07CF}",	"to_unicode\(\'xn\-\-8c9a\.xn\-\-qsb\'\)\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{0603}｡-", %p)},	undef,	"to_unicode\(\'\≯\\u0603｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0603}｡-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0603｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0603}。-", %p)},	undef,	"to_unicode\(\'\≯\\u0603\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0603}。-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0603\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛𐹧⾕.\x{115F}󠗰ςႭ", %p)},	undef,	"to_unicode\(\'⾛𐹧⾕\.\\u115F\?ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走𐹧谷.\x{115F}󠗰ςႭ", %p)},	undef,	"to_unicode\(\'走𐹧谷\.\\u115F\?ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走𐹧谷.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_unicode\(\'走𐹧谷\.\\u115F\?ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走𐹧谷.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_unicode\(\'走𐹧谷\.\\u115F\?ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走𐹧谷.\x{115F}󠗰σⴍ", %p)},	undef,	"to_unicode\(\'走𐹧谷\.\\u115F\?σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走𐹧谷.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_unicode\(\'走𐹧谷\.\\u115F\?Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛𐹧⾕.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_unicode\(\'⾛𐹧⾕\.\\u115F\?ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛𐹧⾕.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_unicode\(\'⾛𐹧⾕\.\\u115F\?ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛𐹧⾕.\x{115F}󠗰σⴍ", %p)},	undef,	"to_unicode\(\'⾛𐹧⾕\.\\u115F\?σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛𐹧⾕.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_unicode\(\'⾛𐹧⾕\.\\u115F\?Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᢙ≯.솣-ᡴႠ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᢙ≯.솣-ᡴႠ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴႠ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴႠ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᢙ≯.솣-ᡴⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᢙ≯.솣-ᡴⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񯞜．𐿇\x{0FA2}\x{077D}\x{0600}", %p)},	undef,	"to_unicode\(\'\?．\?\\u0FA2\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񯞜．𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_unicode\(\'\?．\?\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񯞜.𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_unicode\(\'\?\.\?\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𣳔\x{0303}.𑓂", %p)},	undef,	"to_unicode\(\'𣳔\\u0303\.𑓂\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞤀𞥅񘐱。󠄌Ⴣꡥ", %p)},	undef,	"to_unicode\(\'\?\?\?\。\󠄌Ⴣꡥ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤀𞥅񘐱。󠄌ⴣꡥ", %p)},	undef,	"to_unicode\(\'\?\?\?\。\󠄌ⴣꡥ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_unicode\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。𞤍\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\?\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。𞤍\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\?\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("-\x{200D}。𞤍\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\?\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("-\x{200D}。𞤍\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。\?\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}򅎭.Ⴒ𑇀", %p)},	undef,	"to_unicode\(\'\\u200C\?\.Ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򅎭.Ⴒ𑇀", %p)},	undef,	"to_unicode\(\'\\u200C\?\.Ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򅎭.ⴒ𑇀", %p)},	undef,	"to_unicode\(\'\\u200C\?\.ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򅎭.ⴒ𑇀", %p)},	undef,	"to_unicode\(\'\\u200C\?\.ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱𑖿\x{200D}.８︒", %p)},	undef,	"to_unicode\(\'繱𑖿\\u200D\.８︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("繱𑖿\x{200D}.8。", %p)},	"繱𑖿\x{200D}.8.",	"to_unicode\(\'繱𑖿\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("繱𑖿\x{200D}.8。", %p)},	"繱𑖿\x{200D}.8.",	"to_unicode\(\'繱𑖿\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:523\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--gl0as212a.8.", %p)},	"繱𑖿.8.",	"to_unicode\(\'xn\-\-gl0as212a\.8\.\'\)\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("繱𑖿.8.", %p)},	"繱𑖿.8.",	"to_unicode\(\'繱𑖿\.8\.\'\)\ \[data\/IdnaTest\.txt\:525\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--1ug6928ac48e.8.", %p)},	"繱𑖿\x{200D}.8.",	"to_unicode\(\'xn\-\-1ug6928ac48e\.8\.\'\)\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("繱𑖿\x{200D}.8.", %p)},	"繱𑖿\x{200D}.8.",	"to_unicode\(\'繱𑖿\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("繱𑖿\x{200D}.8.", %p)},	"繱𑖿\x{200D}.8.",	"to_unicode\(\'繱𑖿\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("󠆾．𞀈", %p)},	undef,	"to_unicode\(\'\󠆾．\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("󠆾.𞀈", %p)},	undef,	"to_unicode\(\'\󠆾\.\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{06EB}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u06EB\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ss-59d.", %p)},	"ss\x{06EB}.",	"to_unicode\(\'xn\-\-ss\-59d\.\'\)\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{06EB}.", %p)},	"ss\x{06EB}.",	"to_unicode\(\'ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{06EB}.", %p)},	"ss\x{06EB}.",	"to_unicode\(\'SS\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{06EB}.", %p)},	"ss\x{06EB}.",	"to_unicode\(\'Ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠐵\x{200C}⒈．󠎇", %p)},	undef,	"to_unicode\(\'\?\\u200C⒈．\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠐵\x{200C}⒈．󠎇", %p)},	undef,	"to_unicode\(\'\?\\u200C⒈．\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠐵\x{200C}1..󠎇", %p)},	undef,	"to_unicode\(\'\?\\u200C1\.\.\?\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠐵\x{200C}1..󠎇", %p)},	undef,	"to_unicode\(\'\?\\u200C1\.\.\?\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟈣\x{065F}\x{AAB2}ß。󌓧", %p)},	undef,	"to_unicode\(\'\?\\u065F\\uAAB2ß\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟈣\x{065F}\x{AAB2}SS。󌓧", %p)},	undef,	"to_unicode\(\'\?\\u065F\\uAAB2SS\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟈣\x{065F}\x{AAB2}ss。󌓧", %p)},	undef,	"to_unicode\(\'\?\\u065F\\uAAB2ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟈣\x{065F}\x{AAB2}Ss。󌓧", %p)},	undef,	"to_unicode\(\'\?\\u065F\\uAAB2Ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0774}\x{200C}𞤿。𽘐䉜\x{200D}񿤼", %p)},	undef,	"to_unicode\(\'\\u0774\\u200C\?\。\?䉜\\u200D\?\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0774}\x{200C}𞤿。𽘐䉜\x{200D}񿤼", %p)},	undef,	"to_unicode\(\'\\u0774\\u200C\?\。\?䉜\\u200D\?\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜ςᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?ςᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜ςᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?ςᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜ςᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?ςᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜ςᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?ςᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜Σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?Σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜Σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?Σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜Σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?Σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜Σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?Σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔭜σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_unicode\(\'\?σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("❣\x{200D}．\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_unicode\(\'\❣\\u200D．\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("❣\x{200D}．\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_unicode\(\'\❣\\u200D．\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("❣\x{200D}.\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_unicode\(\'\❣\\u200D\.\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("❣\x{200D}.\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_unicode\(\'\❣\\u200D\.\\u09CD\?\\u0612\\uA929\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮𐳺𐹄.≯񪮸ꡅ", %p)},	undef,	"to_unicode\(\'\≮𐳺\?\.\≯\?ꡅ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𐳺𐹄.>\x{0338}񪮸ꡅ", %p)},	undef,	"to_unicode\(\'\<\\u0338𐳺\?\.\>\\u0338\?ꡅ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCC}𐧅𐳏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_unicode\(\'\\u0CCC𐧅𐳏\?｡\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCC}𐧅𐳏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_unicode\(\'\\u0CCC𐧅𐳏\?\。\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCC}𐧅𐲏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_unicode\(\'\\u0CCC𐧅𐲏\?\。\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCC}𐧅𐲏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_unicode\(\'\\u0CCC𐧅𐲏\?｡\\u0CCDᠦ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0349}。𧡫", %p)},	undef,	"to_unicode\(\'\\u0349\。𧡫\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰿󠅦．\x{1160}", %p)},	undef,	"to_unicode\(\'\?\󠅦．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰿󠅦.\x{1160}", %p)},	undef,	"to_unicode\(\'\?\󠅦\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞤆\x{200D}。󸼄𞳒", %p)},	undef,	"to_unicode\(\'\-\?\\u200D\。\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞤆\x{200D}。󸼄𞳒", %p)},	undef,	"to_unicode\(\'\-\?\\u200D\。\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ󠇶≯𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_unicode\(\'ꡏ\?\≯\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_unicode\(\'ꡏ\?\>\\u0338\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ󠇶≯𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_unicode\(\'ꡏ\?\≯\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_unicode\(\'ꡏ\?\>\\u0338\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("蔏｡𑰺", %p)},	undef,	"to_unicode\(\'蔏｡\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("蔏。𑰺", %p)},	undef,	"to_unicode\(\'蔏\。\?\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟿𐮋。󠄊", %p)},	undef,	"to_unicode\(\'𝟿𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("9𐮋。󠄊", %p)},	undef,	"to_unicode\(\'9𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󟇇-䟖F。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_unicode\(\'\?\-䟖F\。\\u07CB⒈\\u0662\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟇇-䟖F。\x{07CB}1.\x{0662}", %p)},	undef,	"to_unicode\(\'\?\-䟖F\。\\u07CB1\.\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟇇-䟖f。\x{07CB}1.\x{0662}", %p)},	undef,	"to_unicode\(\'\?\-䟖f\。\\u07CB1\.\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󟇇-䟖f。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_unicode\(\'\?\-䟖f\。\\u07CB⒈\\u0662\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡𐹺", %p)},	undef,	"to_unicode\(\'\\u200C｡𐹺\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡𐹺", %p)},	undef,	"to_unicode\(\'\\u200C｡𐹺\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:597\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。𐹺", %p)},	undef,	"to_unicode\(\'\\u200C\。𐹺\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。𐹺", %p)},	undef,	"to_unicode\(\'\\u200C\。𐹺\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:599\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐡆.≯\x{200C}-𞥀", %p)},	undef,	"to_unicode\(\'𐡆\.\≯\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡆.≯\x{200C}-𞥀", %p)},	undef,	"to_unicode\(\'𐡆\.\≯\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡆.>\x{0338}\x{200C}-𞥀", %p)},	undef,	"to_unicode\(\'𐡆\.\>\\u0338\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡆.>\x{0338}\x{200C}-𞥀", %p)},	undef,	"to_unicode\(\'𐡆\.\>\\u0338\\u200C\-\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁀-。≠\x{FCD7}", %p)},	undef,	"to_unicode\(\'\?\-\。\≠\\uFCD7\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁀-。=\x{0338}\x{FCD7}", %p)},	undef,	"to_unicode\(\'\?\-\。\=\\u0338\\uFCD7\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁀-。≠\x{0647}\x{062C}", %p)},	undef,	"to_unicode\(\'\?\-\。\≠\\u0647\\u062C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁀-。=\x{0338}\x{0647}\x{062C}", %p)},	undef,	"to_unicode\(\'\?\-\。\=\\u0338\\u0647\\u062C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻬹𑈵。\x{200D}𞨶", %p)},	undef,	"to_unicode\(\'\?𑈵\。\\u200D\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻬹𑈵。\x{200D}𞨶", %p)},	undef,	"to_unicode\(\'\?𑈵\。\\u200D\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋧\x{A9C0}2｡㧉򒖄", %p)},	undef,	"to_unicode\(\'𑋧\\uA9C02｡㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋧\x{A9C0}2。㧉򒖄", %p)},	undef,	"to_unicode\(\'𑋧\\uA9C02\。㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𽬄𐹴𞩥。≯6", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹴\?\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𽬄𐹴𞩥。≯6", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹴\?\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𽬄𐹴𞩥。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹴\?\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𽬄𐹴𞩥。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹴\?\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑁿．𐹦𻞵-\x{200D}", %p)},	undef,	"to_unicode\(\'𑁿．𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑁿．𐹦𻞵-\x{200D}", %p)},	undef,	"to_unicode\(\'𑁿．𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑁿.𐹦𻞵-\x{200D}", %p)},	undef,	"to_unicode\(\'𑁿\.𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑁿.𐹦𻞵-\x{200D}", %p)},	undef,	"to_unicode\(\'𑁿\.𐹦\?\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸ς𺱀｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\⤸ς\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸ς𺱀。\x{1160}", %p)},	undef,	"to_unicode\(\'\⤸ς\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸Σ𺱀。\x{1160}", %p)},	undef,	"to_unicode\(\'\⤸Σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸σ𺱀。\x{1160}", %p)},	undef,	"to_unicode\(\'\⤸σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸Σ𺱀｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\⤸Σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤸σ𺱀｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\⤸σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪Ⴃ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪ⴃ", %p)},	undef,	"to_unicode\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪ⴃ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}≯", %p)},	undef,	"to_unicode\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{06C2}\x{0604}򅖡𑓂", %p)},	undef,	"to_unicode\(\'\-\。\\u06C2\\u0604\?𑓂\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{06C1}\x{0654}\x{0604}򅖡𑓂", %p)},	undef,	"to_unicode\(\'\-\。\\u06C1\\u0654\\u0604\?𑓂\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󯑖󠁐．\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\?\?．\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󯑖󠁐．\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\?\?．\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󯑖󠁐.\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\.\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󯑖󠁐.\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\.\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒􃈵ς񀠇｡𐮈", %p)},	undef,	"to_unicode\(\'︒\?ς\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。􃈵ς񀠇。𐮈", %p)},	undef,	"to_unicode\(\'\。\?ς\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。􃈵Σ񀠇。𐮈", %p)},	undef,	"to_unicode\(\'\。\?Σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。􃈵σ񀠇。𐮈", %p)},	undef,	"to_unicode\(\'\。\?σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒􃈵Σ񀠇｡𐮈", %p)},	undef,	"to_unicode\(\'︒\?Σ\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒􃈵σ񀠇｡𐮈", %p)},	undef,	"to_unicode\(\'︒\?σ\?｡𐮈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D9}．\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_unicode\(\'\\u07D9．\\u06EE\?\≯\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D9}．\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_unicode\(\'\\u07D9．\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D9}.\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_unicode\(\'\\u07D9\.\\u06EE\?\≯\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D9}.\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_unicode\(\'\\u07D9\.\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}󚙸.𐭍", %p)},	undef,	"to_unicode\(\'\\u1A73\?\.𐭍\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉󠊓≠｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_unicode\(\'⒉\?\≠｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉󠊓=\x{0338}｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_unicode\(\'⒉\?\=\\u0338｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.󠊓≠。Ⴟ⬣Ⴈ", %p)},	undef,	"to_unicode\(\'2\.\?\≠\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.󠊓=\x{0338}。Ⴟ⬣Ⴈ", %p)},	undef,	"to_unicode\(\'2\.\?\=\\u0338\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.󠊓=\x{0338}。ⴟ⬣ⴈ", %p)},	undef,	"to_unicode\(\'2\.\?\=\\u0338\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.󠊓≠。ⴟ⬣ⴈ", %p)},	undef,	"to_unicode\(\'2\.\?\≠\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉󠊓=\x{0338}｡ⴟ⬣ⴈ", %p)},	undef,	"to_unicode\(\'⒉\?\=\\u0338｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉󠊓≠｡ⴟ⬣ⴈ", %p)},	undef,	"to_unicode\(\'⒉\?\≠｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠉱\x{0FB8}Ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_unicode\(\'\-\?\\u0FB8Ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠉱\x{0FB8}ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_unicode\(\'\-\?\\u0FB8ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0659}。𑄴︒\x{0627}\x{07DD}", %p)},	undef,	"to_unicode\(\'\\u0659\。𑄴︒\\u0627\\u07DD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0659}。𑄴。\x{0627}\x{07DD}", %p)},	undef,	"to_unicode\(\'\\u0659\。𑄴\。\\u0627\\u07DD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:660\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠆸｡₆０𐺧\x{0756}", %p)},	undef,	"to_unicode\(\'\󠆸｡₆０\?\\u0756\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆸。60𐺧\x{0756}", %p)},	undef,	"to_unicode\(\'\󠆸\。60\?\\u0756\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("6\x{084F}｡-𑈴", %p)},	undef,	"to_unicode\(\'6\\u084F｡\-𑈴\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("6\x{084F}。-𑈴", %p)},	undef,	"to_unicode\(\'6\\u084F\。\-𑈴\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDς\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰。\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰\。\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񋌿𐹰｡\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_unicode\(\'\\u200D\?𐹰｡\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈񟄜Ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_unicode\(\'⒈\?Ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񟄜Ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_unicode\(\'1\.\?Ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񟄜ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_unicode\(\'1\.\?ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񟄜Ⴓ(O).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_unicode\(\'1\.\?Ⴓ\(O\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈񟄜ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_unicode\(\'⒈\?ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤷.𐮐𞢁𐹠\x{0624}", %p)},	"𞤷.𐮐𞢁𐹠\x{0624}",	"to_unicode\(\'\?\.𐮐𞢁𐹠\\u0624\'\)\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤷.𐮐𞢁𐹠\x{0648}\x{0654}", %p)},	"𞤷.𐮐𞢁𐹠\x{0624}",	"to_unicode\(\'\?\.𐮐𞢁𐹠\\u0648\\u0654\'\)\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--ve6h.xn--jgb1694kz0b2176a", %p)},	"𞤷.𐮐𞢁𐹠\x{0624}",	"to_unicode\(\'xn\-\-ve6h\.xn\-\-jgb1694kz0b2176a\'\)\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐲈-｡𑄳񢌻", %p)},	undef,	"to_unicode\(\'𐲈\-｡𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐲈-。𑄳񢌻", %p)},	undef,	"to_unicode\(\'𐲈\-\。𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳈-。𑄳񢌻", %p)},	undef,	"to_unicode\(\'𐳈\-\。𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳈-｡𑄳񢌻", %p)},	undef,	"to_unicode\(\'𐳈\-｡𑄳\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠉖ꡧ．󠊂񇆃🄉", %p)},	undef,	"to_unicode\(\'\-\?ꡧ．\?\?🄉\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠉖ꡧ.󠊂񇆃8,", %p)},	undef,	"to_unicode\(\'\-\?ꡧ\.\?\?8\,\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾛󠈴臯𧔤.\x{0768}𝟝", %p)},	undef,	"to_unicode\(\'\?\?臯𧔤\.\\u0768𝟝\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾛󠈴臯𧔤.\x{0768}5", %p)},	undef,	"to_unicode\(\'\?\?臯𧔤\.\\u07685\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𐹣．𝨿", %p)},	undef,	"to_unicode\(\'\≮𐹣．𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𐹣．𝨿", %p)},	undef,	"to_unicode\(\'\<\\u0338𐹣．𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𐹣.𝨿", %p)},	undef,	"to_unicode\(\'\≮𐹣\.𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𐹣.𝨿", %p)},	undef,	"to_unicode\(\'\<\\u0338𐹣\.𝨿\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹯ᯛ\x{0A4D}｡脥", %p)},	undef,	"to_unicode\(\'𐹯ᯛ\\u0A4D｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹯ᯛ\x{0A4D}。脥", %p)},	undef,	"to_unicode\(\'𐹯ᯛ\\u0A4D\。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1B44}\x{115F}𞷿򃀍.-", %p)},	undef,	"to_unicode\(\'\\u1B44\\u115F\?\?\.\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡\x{0354}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\u0354\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡\x{0354}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\u0354\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{0354}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u0354\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{0354}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u0354\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤥󠅮．ᡄႮ", %p)},	undef,	"to_unicode\(\'\?\󠅮．ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤥󠅮.ᡄႮ", %p)},	undef,	"to_unicode\(\'\?\󠅮\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤥󠅮.ᡄⴎ", %p)},	"𞤥.ᡄⴎ",	"to_unicode\(\'\?\󠅮\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--de6h.xn--37e857h", %p)},	"𞤥.ᡄⴎ",	"to_unicode\(\'xn\-\-de6h\.xn\-\-37e857h\'\)\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤥.ᡄⴎ", %p)},	"𞤥.ᡄⴎ",	"to_unicode\(\'\?\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞤥.ᡄႮ", %p)},	undef,	"to_unicode\(\'\?\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤥󠅮．ᡄⴎ", %p)},	"𞤥.ᡄⴎ",	"to_unicode\(\'\?\󠅮．ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤧𝨨Ξ．𪺏㛨❸", %p)},	undef,	"to_unicode\(\'\?𝨨Ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤧𝨨Ξ.𪺏㛨❸", %p)},	undef,	"to_unicode\(\'\?𝨨Ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤧𝨨ξ.𪺏㛨❸", %p)},	undef,	"to_unicode\(\'\?𝨨ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤧𝨨ξ．𪺏㛨❸", %p)},	undef,	"to_unicode\(\'\?𝨨ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾳.︒⥱\x{200C}𐹬", %p)},	undef,	"to_unicode\(\'\?\.︒\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾳.︒⥱\x{200C}𐹬", %p)},	undef,	"to_unicode\(\'\?\.︒\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾳.。⥱\x{200C}𐹬", %p)},	undef,	"to_unicode\(\'\?\.\。\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾳.。⥱\x{200C}𐹬", %p)},	undef,	"to_unicode\(\'\?\.\。\⥱\\u200C𐹬\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯖.𐹠Ⴑ񚇜𐫊", %p)},	undef,	"to_unicode\(\'\?\.𐹠Ⴑ\?𐫊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯖.𐹠ⴑ񚇜𐫊", %p)},	undef,	"to_unicode\(\'\?\.𐹠ⴑ\?𐫊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA4}񱤯．𝟭Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0FA4\?．𝟭Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA4}񱤯.1Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0FA4\?\.1Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA4}񱤯.1ⴛ", %p)},	undef,	"to_unicode\(\'\\u0FA4\?\.1ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA4}񱤯．𝟭ⴛ", %p)},	undef,	"to_unicode\(\'\\u0FA4\?．𝟭ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_unicode\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_unicode\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．-\x{0708}--", %p)},	undef,	"to_unicode\(\'\≮．\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．-\x{0708}--", %p)},	undef,	"to_unicode\(\'\<\\u0338．\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.-\x{0708}--", %p)},	undef,	"to_unicode\(\'\≮\.\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.-\x{0708}--", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\-\\u0708\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dς𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dς𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dς7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dς7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200DΣ7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200DΣ7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dσ7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dσ7\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200DΣ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200DΣ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dσ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹸󠋳。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'𐹸\?\。\\u200Dσ𝟩\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς򅜌８.𞭤", %p)},	undef,	"to_unicode\(\'ς\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς򅜌8.𞭤", %p)},	undef,	"to_unicode\(\'ς\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ򅜌8.𞭤", %p)},	undef,	"to_unicode\(\'Σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ򅜌8.𞭤", %p)},	undef,	"to_unicode\(\'σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ򅜌８.𞭤", %p)},	undef,	"to_unicode\(\'Σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ򅜌８.𞭤", %p)},	undef,	"to_unicode\(\'σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡑ🄀\x{0684}．-𐫄𑲤", %p)},	undef,	"to_unicode\(\'\\u200Cᡑ🄀\\u0684．\-𐫄\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ᡑ🄀\x{0684}．-𐫄𑲤", %p)},	undef,	"to_unicode\(\'\\u200Cᡑ🄀\\u0684．\-𐫄\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:772\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}ᡑ0.\x{0684}.-𐫄𑲤", %p)},	undef,	"to_unicode\(\'\\u200Cᡑ0\.\\u0684\.\-𐫄\?\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}ᡑ0.\x{0684}.-𐫄𑲤", %p)},	undef,	"to_unicode\(\'\\u200Cᡑ0\.\\u0684\.\-𐫄\?\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:774\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𖠍。𐪿넯򞵲", %p)},	undef,	"to_unicode\(\'𖠍\。\?넯\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𖠍。𐪿넯򞵲", %p)},	undef,	"to_unicode\(\'𖠍\。\?넯\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠇Ⴘ。\x{0603}Ⴈ𝆊", %p)},	undef,	"to_unicode\(\'᠇Ⴘ\。\\u0603Ⴈ𝆊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠇ⴘ。\x{0603}ⴈ𝆊", %p)},	undef,	"to_unicode\(\'᠇ⴘ\。\\u0603ⴈ𝆊\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚\?\?\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.\?\?\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.\?\?\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚\?\?\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𐰽⒈.Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𐰽⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𐰽1..Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𐰽1\.\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𐋱𐰽1..ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𐰽1\.\.ⴓ\'\)\ throws\ error\ V3\ B1\ A4_2\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-𐋱𐰽⒈.ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𐰽⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.榶-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.榶-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.榶-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.榶-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ß｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ß｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ß｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ß｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ß。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ß\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ß。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ß\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴SS。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴SS\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴SS。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴SS\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴Ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴Ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴Ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴Ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴SS｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴SS｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴SS｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴SS｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴Ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴Ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹴Ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_unicode\(\'\\u200D𐹴Ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}．\x{1BAA}-≮≠", %p)},	undef,	"to_unicode\(\'\\u1B44．\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}．\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u1B44．\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}.\x{1BAA}-≮≠", %p)},	undef,	"to_unicode\(\'\\u1B44\.\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}.\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u1B44\.\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}Ⴑ\x{115F}．𑄴Ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3Ⴑ\\u115F．𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}Ⴑ\x{115F}.𑄴Ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3Ⴑ\\u115F\.𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}Ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3Ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}Ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_unicode\(\'\\u1BF3Ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_unicode\(\'\?\。Ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_unicode\(\'\?\。Ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_unicode\(\'\?\。ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_unicode\(\'\?\。ⴃ\?𐹹똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫀｡⳻󠙾󠄷\x{3164}", %p)},	undef,	"to_unicode\(\'𐫀｡⳻\?\󠄷\\u3164\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫀。⳻󠙾󠄷\x{1160}", %p)},	undef,	"to_unicode\(\'𐫀\。⳻\?\󠄷\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{079A}⾇．\x{071E}-𐋰", %p)},	undef,	"to_unicode\(\'\\u079A⾇．\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{079A}舛.\x{071E}-𐋰", %p)},	undef,	"to_unicode\(\'\\u079A舛\.\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴉ猕󹛫≮．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󹛫≮.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󹛫≮.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󹛫≮．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("🏮｡\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_unicode\(\'🏮｡\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:835\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("🏮。\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_unicode\(\'🏮\。\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹶。ß", %p)},	undef,	"to_unicode\(\'\\u200D𐹶\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:837\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹶。ß", %p)},	undef,	"to_unicode\(\'\\u200D𐹶\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹶。SS", %p)},	undef,	"to_unicode\(\'\\u200D𐹶\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹶。SS", %p)},	undef,	"to_unicode\(\'\\u200D𐹶\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:840\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3099}򬎑\x{1DD7}𞤀.򱲢-\x{0953}", %p)},	undef,	"to_unicode\(\'\\u3099\?\\u1DD7\?\.\?\-\\u0953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'ς\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.SS񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'Σ\.SS\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'Σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'Σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_unicode\(\'σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:863\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ꡀ𞀟｡\x{066B}\x{0599}", %p)},	undef,	"to_unicode\(\'ꡀ\?｡\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ꡀ𞀟。\x{066B}\x{0599}", %p)},	undef,	"to_unicode\(\'ꡀ\?\。\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:865\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򈛉\x{200C}\x{08A9}｡⧅񘘡-𐭡", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u08A9｡\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈛉\x{200C}\x{08A9}｡⧅񘘡-𐭡", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u08A9｡\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈛉\x{200C}\x{08A9}。⧅񘘡-𐭡", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u08A9\。\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈛉\x{200C}\x{08A9}。⧅񘘡-𐭡", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u08A9\。\⧅\?\-𐭡\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_unicode\(\'룱\\u200D\?\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V6\ V5\ C2\ C1\ \[data\/IdnaTest\.txt\:877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{1CDC}⒈ß", %p)},	undef,	"to_unicode\(\'🄄．\\u1CDC⒈ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{1CDC}1.ß", %p)},	undef,	"to_unicode\(\'3\,\.\\u1CDC1\.ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{1CDC}1.SS", %p)},	undef,	"to_unicode\(\'3\,\.\\u1CDC1\.SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{1CDC}⒈SS", %p)},	undef,	"to_unicode\(\'🄄．\\u1CDC⒈SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{1CDC}⒈ss", %p)},	undef,	"to_unicode\(\'🄄．\\u1CDC⒈ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{1CDC}⒈Ss", %p)},	undef,	"to_unicode\(\'🄄．\\u1CDC⒈Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񇌍\x{2D7F}｡𞼓򡄨𑐺", %p)},	undef,	"to_unicode\(\'\?\\u2D7F｡\?\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񇌍\x{2D7F}。𞼓򡄨𑐺", %p)},	undef,	"to_unicode\(\'\?\\u2D7F\。\?\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFD}\x{103A}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1DFD\\u103A\\u094D．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFD}\x{103A}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1DFD\\u103A\\u094D．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{094D}\x{1DFD}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u103A\\u094D\\u1DFD\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:897\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:899\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_unicode\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}SS", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6SS\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ss", %p)},	undef,	"to_unicode\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ss\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}Ss", %p)},	undef,	"to_unicode\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6Ss\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_unicode\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}SS", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ss", %p)},	undef,	"to_unicode\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}Ss", %p)},	undef,	"to_unicode\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{066B}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{066B}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{066B}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{066B}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}۱｡󠳶𞠁\x{0665}", %p)},	undef,	"to_unicode\(\'\\u0660۱｡\?𞠁\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}۱。󠳶𞠁\x{0665}", %p)},	undef,	"to_unicode\(\'\\u0660۱\。\?𞠁\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0663}⒖。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0663⒖\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0663}⒖。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0663⒖\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0663}15.。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066315\.\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0663}15.。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066315\.\。\?\?\\u1BF3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF3}.-逋񳦭󙙮", %p)},	undef,	"to_unicode\(\'\\u1BF3\.\-逋\?\?\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0756}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0756\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆႣ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆႣ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆႣ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆႣ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆႣ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆႣ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆႣ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆႣ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆⴃ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆⴃ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆⴃ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆⴃ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆⴃ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆⴃ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆⴃ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡆⴃ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:940\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:942\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:944\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:946\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵.σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵\.σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:948\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:950\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("㭄\x{200D}\x{084F}𑚵．σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200D\\u084F𑚵．σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:952\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{17B5}。𞯸ꡀ🄋", %p)},	undef,	"to_unicode\(\'\\u17B5\。\?ꡀ🄋\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󐪺暑．⾑\x{0668}", %p)},	undef,	"to_unicode\(\'\?暑．⾑\\u0668\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󐪺暑.襾\x{0668}", %p)},	undef,	"to_unicode\(\'\?暑\.襾\\u0668\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄚≯ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_unicode\(\'\󠄚\≯ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄚>\x{0338}ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_unicode\(\'\󠄚\>\\u0338ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_unicode\(\'\\uFDC3\?\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_unicode\(\'\\u0643\\u0645\\u0645\?\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_unicode\(\'\\u0643\\u0645\\u0645\?\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_unicode\(\'\\uFDC3\?\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞀨｡\x{1B44}򡛨𞎇", %p)},	undef,	"to_unicode\(\'\?｡\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞀨。\x{1B44}򡛨𞎇", %p)},	undef,	"to_unicode\(\'\?\。\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣼\x{200C}．𐺰\x{200C}ᡟ", %p)},	undef,	"to_unicode\(\'\?\\u200C．\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣼\x{200C}．𐺰\x{200C}ᡟ", %p)},	undef,	"to_unicode\(\'\?\\u200C．\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣼\x{200C}.𐺰\x{200C}ᡟ", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣼\x{200C}.𐺰\x{200C}ᡟ", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\?\\u200Cᡟ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ󨅟ß.ጧ", %p)},	undef,	"to_unicode\(\'ᢛ\?ß\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ󨅟SS.ጧ", %p)},	undef,	"to_unicode\(\'ᢛ\?SS\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ󨅟ss.ጧ", %p)},	undef,	"to_unicode\(\'ᢛ\?ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ󨅟Ss.ጧ", %p)},	undef,	"to_unicode\(\'ᢛ\?Ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮒\x{200C}.񒚗\x{200C}", %p)},	undef,	"to_unicode\(\'\⮒\\u200C\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮒\x{200C}.񒚗\x{200C}", %p)},	undef,	"to_unicode\(\'\⮒\\u200C\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤂񹞁𐹯。Ⴜ", %p)},	undef,	"to_unicode\(\'\?\?𐹯\。Ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤂񹞁𐹯。ⴜ", %p)},	undef,	"to_unicode\(\'\?\?𐹯\。ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹵⮣\x{200C}𑄰｡񷴿\x{FCB7}", %p)},	undef,	"to_unicode\(\'𐹵\⮣\\u200C𑄰｡\?\\uFCB7\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹵⮣\x{200C}𑄰｡񷴿\x{FCB7}", %p)},	undef,	"to_unicode\(\'𐹵\⮣\\u200C𑄰｡\?\\uFCB7\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹵⮣\x{200C}𑄰。񷴿\x{0636}\x{0645}", %p)},	undef,	"to_unicode\(\'𐹵\⮣\\u200C𑄰\。\?\\u0636\\u0645\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹵⮣\x{200C}𑄰。񷴿\x{0636}\x{0645}", %p)},	undef,	"to_unicode\(\'𐹵\⮣\\u200C𑄰\。\?\\u0636\\u0645\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デß\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099ß\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'ⴒ\。テ\\u3099ß\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'ⴒ\。デß\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSS𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSS\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}SS𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099SS\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ss𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'ⴒ\。テ\\u3099ss\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴒ。デss𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'ⴒ\。デss\?\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSs𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSs\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}Ss𞤵\x{0C4D}", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099Ss\?\\u0C4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑁿\x{0D4D}．７-\x{07D2}", %p)},	undef,	"to_unicode\(\'𑁿\\u0D4D．７\-\\u07D2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑁿\x{0D4D}.7-\x{07D2}", %p)},	undef,	"to_unicode\(\'𑁿\\u0D4D\.7\-\\u07D2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_unicode\(\'\≯𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_unicode\(\'\>\\u0338𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_unicode\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_unicode\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_unicode\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_unicode\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_unicode\(\'ß｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_unicode\(\'ß\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1001\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_unicode\(\'SS\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1002\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss。𐋳ⴌ\x{0FB8}", %p)},	"ss.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ss\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.xn--lgd921mvv0m", %p)},	"ss.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ss\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1004\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.𐋳ⴌ\x{0FB8}", %p)},	"ss.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ss\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS.𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_unicode\(\'SS\.𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1006\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--zca.xn--lgd921mvv0m", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'xn\-\-zca\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1008\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1009\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1010\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{0FB8}", %p)},	"ß.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ß｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1011\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_unicode\(\'SS｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1012\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss｡𐋳ⴌ\x{0FB8}", %p)},	"ss.𐋳ⴌ\x{0FB8}",	"to_unicode\(\'ss｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{069E}𐶡.\x{200C}⾝\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\\u069E\?\.\\u200C⾝\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{069E}𐶡.\x{200C}⾝\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\\u069E\?\.\\u200C⾝\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{069E}𐶡.\x{200C}身\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\\u069E\?\.\\u200C身\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{069E}𐶡.\x{200C}身\x{09CD}", %p)},	undef,	"to_unicode\(\'\-\\u069E\?\.\\u200C身\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1017\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_unicode\(\'😮\\u0764\?𑈵\.💅\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_unicode\(\'😮\\u0764\?𑈵\.💅\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1019\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_unicode\(\'😮\\u0764𑈵\?\.💅\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1020\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_unicode\(\'😮\\u0764𑈵\?\.💅\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1021\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08F2}\x{200D}꙳\x{0712}.ᢏ\x{200C}󠍄", %p)},	undef,	"to_unicode\(\'\\u08F2\\u200D꙳\\u0712\.ᢏ\\u200C\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08F2}\x{200D}꙳\x{0712}.ᢏ\x{200C}󠍄", %p)},	undef,	"to_unicode\(\'\\u08F2\\u200D꙳\\u0712\.ᢏ\\u200C\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:1023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_unicode\(\'Ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_unicode\(\'Ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_unicode\(\'ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_unicode\(\'ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A5A}𛦝\x{0C4D}。𚝬𝟵", %p)},	undef,	"to_unicode\(\'\\u1A5A\?\\u0C4D\。\?𝟵\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A5A}𛦝\x{0C4D}。𚝬9", %p)},	undef,	"to_unicode\(\'\\u1A5A\?\\u0C4D\。\?9\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆𝟗｡Ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?𝟗｡Ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆𝟗｡Ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?𝟗｡Ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆9。Ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?9\。Ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆9。Ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?9\。Ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆9。ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?9\。ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆9。ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?9\。ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆𝟗｡ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?𝟗｡ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06A0}𿺆𝟗｡ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_unicode\(\'\\u200C\\u06A0\?𝟗｡ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ｡\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_unicode\(\'ᡖ｡\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ。\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_unicode\(\'ᡖ\。\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞠠浘。絧𞀀", %p)},	undef,	"to_unicode\(\'𞠠浘\。絧\?\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0596}Ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596Ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}Ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596Ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}Ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596Ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}Ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596Ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0596}ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_unicode\(\'\\u0596ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200DF𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200DF𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200DF𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200DF𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200Df𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200Df𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200Df𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_unicode\(\'\\u200Df𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}🄇𐼗︒｡𐹻𑜫", %p)},	undef,	"to_unicode\(\'\\u0845🄇\?︒｡𐹻𑜫\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}6,𐼗。。𐹻𑜫", %p)},	undef,	"to_unicode\(\'\\u08456\,\?\。\。𐹻𑜫\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹈.\x{1DC0}𑈱𐦭", %p)},	undef,	"to_unicode\(\'\?\.\\u1DC0𑈱𐦭\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_unicode\(\'Ⴂ䠺\。\?\?\?\\u0693\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_unicode\(\'ⴂ䠺\。\?\?\?\\u0693\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄇伐︒.𜙚\x{A8C4}", %p)},	undef,	"to_unicode\(\'🄇伐︒\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6,伐。.𜙚\x{A8C4}", %p)},	undef,	"to_unicode\(\'6\,伐\。\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓Ⴚ𑂹", %p)},	undef,	"to_unicode\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓Ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓Ⴚ𑂹", %p)},	undef,	"to_unicode\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓Ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓ⴚ𑂹", %p)},	undef,	"to_unicode\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓ⴚ𑂹", %p)},	undef,	"to_unicode\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓ⴚ𑂹\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆠．񷐴󌟈", %p)},	undef,	"to_unicode\(\'\󠆠．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆠.񷐴󌟈", %p)},	undef,	"to_unicode\(\'\󠆠\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}Ⴆ.≠𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200CႦ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}Ⴆ.≠𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200CႦ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}Ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200CႦ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}Ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200CႦ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200Cⴆ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200Cⴆ\.\=\\u0338\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}ⴆ.≠𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200Cⴆ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫃\x{200C}ⴆ.≠𞷙", %p)},	undef,	"to_unicode\(\'𐫃\\u200Cⴆ\.\≠\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁲𙩢𝟥ꘌ．\x{0841}", %p)},	undef,	"to_unicode\(\'\?\?𝟥ꘌ．\\u0841\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁲𙩢3ꘌ.\x{0841}", %p)},	undef,	"to_unicode\(\'\?\?3ꘌ\.\\u0841\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{1886}󡲣-", %p)},	undef,	"to_unicode\(\'\-\.\\u1886\?\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆ς", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆ς", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆ς", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆ς", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆Σ", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆Σ", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆σ", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}。\x{200C}𞰆σ", %p)},	undef,	"to_unicode\(\'\?\\u200C\。\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆Σ", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆Σ", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆σ", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲚗\x{200C}｡\x{200C}𞰆σ", %p)},	undef,	"to_unicode\(\'\?\\u200C｡\\u200C\?σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1092\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("堕𑓂\x{1B02}。𐮇𞤽\x{200C}-", %p)},	undef,	"to_unicode\(\'堕𑓂\\u1B02\。𐮇\?\\u200C\-\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("堕𑓂\x{1B02}。𐮇𞤽\x{200C}-", %p)},	undef,	"to_unicode\(\'堕𑓂\\u1B02\。𐮇\?\\u200C\-\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥς\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥς\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}Σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?\。ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}Σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹶𑁆ᡕ\?｡ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󏒰．-𝟻ß", %p)},	undef,	"to_unicode\(\'\?．\-𝟻ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󏒰.-5ß", %p)},	undef,	"to_unicode\(\'\?\.\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󏒰.-5SS", %p)},	undef,	"to_unicode\(\'\?\.\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󏒰．-𝟻SS", %p)},	undef,	"to_unicode\(\'\?．\-𝟻SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󏒰．-𝟻ss", %p)},	undef,	"to_unicode\(\'\?．\-𝟻ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󏒰．-𝟻Ss", %p)},	undef,	"to_unicode\(\'\?．\-𝟻Ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐨿.🤒Ⴥ򑮶", %p)},	undef,	"to_unicode\(\'\\u200D𐨿\.🤒Ⴥ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐨿.🤒Ⴥ򑮶", %p)},	undef,	"to_unicode\(\'\\u200D𐨿\.🤒Ⴥ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐨿.🤒ⴥ򑮶", %p)},	undef,	"to_unicode\(\'\\u200D𐨿\.🤒ⴥ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐨿.🤒ⴥ򑮶", %p)},	undef,	"to_unicode\(\'\\u200D𐨿\.🤒ⴥ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。ß𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ß𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。ß𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ß𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。SS𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。SS𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。SS𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。SS𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。ss𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。ss𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。Ss𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𵋅。Ss𬵩\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𭉝。\x{07F1}\x{0301}𞹻", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\u07F1\\u0301𞹻\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𭉝。\x{07F1}\x{0301}𞹻", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\u07F1\\u0301𞹻\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𭉝。\x{07F1}\x{0301}\x{063A}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\u07F1\\u0301\\u063A\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𭉝。\x{07F1}\x{0301}\x{063A}", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\\u07F1\\u0301\\u063A\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼌\x{200C}𑈶。𐹡", %p)},	undef,	"to_unicode\(\'\?\\u200C𑈶\。𐹡\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼌\x{200C}𑈶。𐹡", %p)},	undef,	"to_unicode\(\'\?\\u200C𑈶\。𐹡\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ≠", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}򳴢", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}򳴢", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}򳴢", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D\?\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}򳴢", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D\?\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ß｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ß｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ß｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ß｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ß。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ß\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}SS。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644SS\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ss\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}Ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644Ss\。\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}SS｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644SS｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ss｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}Ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644Ss｡\\u1A60𐇽\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}SS｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644SS｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644ss｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}Ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_unicode\(\'\\u0644Ss｡𐇽\\u1A60\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹽𑄳񼜲.\x{1DDF}\x{17B8}\x{A806}𑜫", %p)},	undef,	"to_unicode\(\'𐹽𑄳\?\.\\u1DDF\\u17B8\\uA806𑜫\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_unicode\(\'Ⴓ𑜫\\u200D\?．\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_unicode\(\'Ⴓ𑜫\\u200D\?\.\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_unicode\(\'ⴓ𑜫\\u200D\?\.\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_unicode\(\'ⴓ𑜫\\u200D\?．\\u06A7\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐨿.🄆—", %p)},	undef,	"to_unicode\(\'𐨿\.🄆\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐨿.5,—", %p)},	undef,	"to_unicode\(\'𐨿\.5\,\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔊱񁦮۸。󠾭-", %p)},	undef,	"to_unicode\(\'\?\?۸\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼗸\x{07CD}𐹮。\x{06DD}ᡎᠴ", %p)},	undef,	"to_unicode\(\'\?\\u07CD𐹮\。\\u06DDᡎᠴ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮႾ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᠮႾ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮႾ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᠮႾ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮႾ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᠮႾ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮႾ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᠮႾ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮⴞ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᠮⴞ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮⴞ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᠮⴞ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮⴞ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᠮⴞ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ᠮⴞ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᠮⴞ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}\x{0697}．𑚶񼡷⾆", %p)},	undef,	"to_unicode\(\'\\u0601\\u0697．𑚶\?⾆\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}\x{0697}.𑚶񼡷舌", %p)},	undef,	"to_unicode\(\'\\u0601\\u0697\.𑚶\?舌\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🞅󠳡󜍙.񲖷", %p)},	undef,	"to_unicode\(\'🞅\?\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20E7}񯡎-򫣝.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u20E7\?\-\?\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20E7}񯡎-򫣝.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u20E7\?\-\?\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20E7}񯡎-򫣝.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u20E7\?\-\?\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20E7}񯡎-򫣝.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u20E7\?\-\?\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1194\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ｡𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ｡𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1195\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ｡𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ｡𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1196\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ。𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ\。𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ。𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ\。𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1198\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ。𝌠SS𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\。𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ。𝌠ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\。𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ。𝌠Ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\。𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--hwe.xn--ss-ci1ub261a", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'xn\-\-hwe\.xn\-\-ss\-ci1ub261a\'\)\ \[data\/IdnaTest\.txt\:1202\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ.𝌠ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\.𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ.𝌠SS𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\.𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ.𝌠Ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ\.𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--hwe.xn--zca4946pblnc", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'xn\-\-hwe\.xn\-\-zca4946pblnc\'\)\ \[data\/IdnaTest\.txt\:1206\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ.𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ\.𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ.𝌠ß𖫱", %p)},	"ᚭ.𝌠ß𖫱",	"to_unicode\(\'ᚭ\.𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1208\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ｡𝌠SS𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ｡𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ｡𝌠ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ｡𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1210\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᚭ｡𝌠Ss𖫱", %p)},	"ᚭ.𝌠ss𖫱",	"to_unicode\(\'ᚭ｡𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("₁｡𞤫ꡪ", %p)},	undef,	"to_unicode\(\'₁｡\?ꡪ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1。𞤫ꡪ", %p)},	undef,	"to_unicode\(\'1\。\?ꡪ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𯻼\x{200C}.𞶞򻙤񥘇", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\?\?\?\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𯻼\x{200C}.𞶞򻙤񥘇", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\?\?\?\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑄≯｡𑜤", %p)},	undef,	"to_unicode\(\'\?\≯｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑄>\x{0338}｡𑜤", %p)},	undef,	"to_unicode\(\'\?\>\\u0338｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑄≯。𑜤", %p)},	undef,	"to_unicode\(\'\?\≯\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑄>\x{0338}。𑜤", %p)},	undef,	"to_unicode\(\'\?\>\\u0338\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮\?\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17D2}.򆽒≯", %p)},	undef,	"to_unicode\(\'\\u17D2\.\?\≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17D2}.򆽒>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u17D2\.\?\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}．𐨺É⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734．𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}．𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734．𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}.𐨺É⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734\.𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}.𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734\.𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}.𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734\.𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}.𐨺é⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734\.𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}．𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734．𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񏁇\x{1734}．𐨺é⬓𑄴", %p)},	undef,	"to_unicode\(\'\?\\u1734．𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇ\x{200D}\x{A8C4}｡︒𞤺", %p)},	undef,	"to_unicode\(\'ᢇ\\u200D\\uA8C4｡︒\?\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇ\x{200D}\x{A8C4}｡︒𞤺", %p)},	undef,	"to_unicode\(\'ᢇ\\u200D\\uA8C4｡︒\?\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1239\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ᢇ\x{200D}\x{A8C4}。。𞤺", %p)},	undef,	"to_unicode\(\'ᢇ\\u200D\\uA8C4\。\。\?\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ᢇ\x{200D}\x{A8C4}。。𞤺", %p)},	undef,	"to_unicode\(\'ᢇ\\u200D\\uA8C4\。\。\?\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1241\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}≮", %p)},	undef,	"to_unicode\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_unicode\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}≮", %p)},	undef,	"to_unicode\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_unicode\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_unicode\(\'Ⴣ．\\u0653ᢤ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_unicode\(\'Ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_unicode\(\'ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1248\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_unicode\(\'ⴣ．\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_unicode\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA2C}𑲫≮．⤂", %p)},	undef,	"to_unicode\(\'\\uAA2C\?\≮．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA2C}𑲫<\x{0338}．⤂", %p)},	undef,	"to_unicode\(\'\\uAA2C\?\<\\u0338．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA2C}𑲫≮.⤂", %p)},	undef,	"to_unicode\(\'\\uAA2C\?\≮\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AA2C}𑲫<\x{0338}.⤂", %p)},	undef,	"to_unicode\(\'\\uAA2C\?\<\\u0338\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔≮Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\≮Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}𐩔<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\u0604𐩔\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1273\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𑁅。-", %p)},	undef,	"to_unicode\(\'𑁅\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0DCA}򕸽󠧱｡饈≠\x{0664}", %p)},	undef,	"to_unicode\(\'\\u0DCA\?\?｡饈\≠\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}򕸽󠧱｡饈=\x{0338}\x{0664}", %p)},	undef,	"to_unicode\(\'\\u0DCA\?\?｡饈\=\\u0338\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}򕸽󠧱。饈≠\x{0664}", %p)},	undef,	"to_unicode\(\'\\u0DCA\?\?\。饈\≠\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}򕸽󠧱。饈=\x{0338}\x{0664}", %p)},	undef,	"to_unicode\(\'\\u0DCA\?\?\。饈\=\\u0338\\u0664\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥃ᠠ⁷｡≯邅⬻4", %p)},	undef,	"to_unicode\(\'\?ᠠ⁷｡\≯邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥃ᠠ⁷｡>\x{0338}邅⬻4", %p)},	undef,	"to_unicode\(\'\?ᠠ⁷｡\>\\u0338邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥃ᠠ7。≯邅⬻4", %p)},	undef,	"to_unicode\(\'\?ᠠ7\。\≯邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥃ᠠ7。>\x{0338}邅⬻4", %p)},	undef,	"to_unicode\(\'\?ᠠ7\。\>\\u0338邅\⬻4\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠿯ᡳ-𑐻.𐹴𐋫\x{0605}󑎳", %p)},	undef,	"to_unicode\(\'\?ᡳ\-\?\.𐹴𐋫\\u0605\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡦᡑ\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'ꡦᡑ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡦᡑ\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'ꡦᡑ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1287\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ꡦᡑ\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'ꡦᡑ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ꡦᡑ\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'ꡦᡑ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1289\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_unicode\(\'Ⴌ\。\?\\uFB69\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ。􍼠\x{0679}", %p)},	undef,	"to_unicode\(\'Ⴌ\。\?\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ。􍼠\x{0679}", %p)},	undef,	"to_unicode\(\'ⴌ\。\?\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_unicode\(\'ⴌ\。\?\\uFB69\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮁𐭱.\x{0F84}\x{135E}-\x{1CFA}", %p)},	undef,	"to_unicode\(\'𐮁𐭱\.\\u0F84\\u135E\-\\u1CFA\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.䰹\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("て。\x{200C}󠳽\x{07F3}", %p)},	undef,	"to_unicode\(\'て\。\\u200C\?\\u07F3\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("て。\x{200C}󠳽\x{07F3}", %p)},	undef,	"to_unicode\(\'て\。\\u200C\?\\u07F3\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1304\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'ς｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς。\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'ς\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'Σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'Σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_unicode\(\'σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0BCD}󥫅򌉑.ႢႵ", %p)},	undef,	"to_unicode\(\'\\u0BCD\?\?\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}󥫅򌉑.ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\u0BCD\?\?\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}󥫅򌉑.Ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\u0BCD\?\?\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C32}🄈⾛\x{05A6}．\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_unicode\(\'\\u1C32🄈⾛\\u05A6．\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C32}🄈⾛\x{05A6}．\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_unicode\(\'\\u1C32🄈⾛\\u05A6．\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C32}7,走\x{05A6}.\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_unicode\(\'\\u1C327\,走\\u05A6\.\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C32}7,走\x{05A6}.\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_unicode\(\'\\u1C327\,走\\u05A6\.\\u200D\?\\u07FD\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢗ｡Ӏ񝄻", %p)},	undef,	"to_unicode\(\'ᢗ｡Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢗ。Ӏ񝄻", %p)},	undef,	"to_unicode\(\'ᢗ\。Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢗ。ӏ񝄻", %p)},	undef,	"to_unicode\(\'ᢗ\。ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢗ｡ӏ񝄻", %p)},	undef,	"to_unicode\(\'ᢗ｡ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0668}-。񠏇🝆ᄾ", %p)},	undef,	"to_unicode\(\'\\u0668\-\。\?🝆ᄾ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1322\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𐋷𖾑。󠆬", %p)},	undef,	"to_unicode\(\'\-𐋷𖾑\。\󠆬\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_unicode\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_unicode\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_unicode\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_unicode\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{0769}\x{0603}", %p)},	undef,	"to_unicode\(\'\≮\.\\u0769\\u0603\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{0769}\x{0603}", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u0769\\u0603\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐶭⾆｡\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_unicode\(\'\?⾆｡\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐶭⾆｡\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_unicode\(\'\?⾆｡\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐶭舌。\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_unicode\(\'\?舌\。\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐶭舌。\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_unicode\(\'\?舌\。\\u200C𑚶\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ𞴺Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ𞴺Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ𞴺σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ𞴺σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς\?ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ𞴺Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ𞴺Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ\?Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ𞴺σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ𞴺σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ\?σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑲘󠄒𓑡｡𝟪Ⴜ", %p)},	undef,	"to_unicode\(\'\?\󠄒\?｡𝟪Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑲘󠄒𓑡。8Ⴜ", %p)},	undef,	"to_unicode\(\'\?\󠄒\?\。8Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑲘󠄒𓑡。8ⴜ", %p)},	undef,	"to_unicode\(\'\?\󠄒\?\。8ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑲘󠄒𓑡｡𝟪ⴜ", %p)},	undef,	"to_unicode\(\'\?\󠄒\?｡𝟪ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_unicode\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1354\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_unicode\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_unicode\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_unicode\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BAB}｡🂉󠁰", %p)},	undef,	"to_unicode\(\'\\u1BAB｡🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAB}。🂉󠁰", %p)},	undef,	"to_unicode\(\'\\u1BAB\。🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。ς\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。ς\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。ς\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。ς\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。Σ\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。Σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。Σ\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。Σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。σ\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󩎃\x{0AC4}。σ\x{200D}𐹮𑈵", %p)},	undef,	"to_unicode\(\'\?\\u0AC4\。σ\\u200D𐹮𑈵\'\)\ throws\ error\ P1\ V6\ B5\ C2\ \[data\/IdnaTest\.txt\:1365\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𐫀ᡂ𑜫．𑘿", %p)},	undef,	"to_unicode\(\'𐫀ᡂ𑜫．𑘿\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1366\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𐫀ᡂ𑜫.𑘿", %p)},	undef,	"to_unicode\(\'𐫀ᡂ𑜫\.𑘿\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󬚶󸋖򖩰-。\x{200C}", %p)},	undef,	"to_unicode\(\'\?\?\?\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󬚶󸋖򖩰-。\x{200C}", %p)},	undef,	"to_unicode\(\'\?\?\?\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1369\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣．\x{07C2}", %p)},	undef,	"to_unicode\(\'𐹣．\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣.\x{07C2}", %p)},	undef,	"to_unicode\(\'𐹣\.\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{07E1}｡Ↄ", %p)},	undef,	"to_unicode\(\'\-\\u07E1｡Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{07E1}。Ↄ", %p)},	undef,	"to_unicode\(\'\-\\u07E1\。Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1373\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-\x{07E1}。ↄ", %p)},	undef,	"to_unicode\(\'\-\\u07E1\。ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-\x{07E1}｡ↄ", %p)},	undef,	"to_unicode\(\'\-\\u07E1｡ↄ\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1375\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．\x{FE2F}𑑂", %p)},	undef,	"to_unicode\(\'︒．\\uFE2F\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．𑑂\x{FE2F}", %p)},	undef,	"to_unicode\(\'︒．\?\\uFE2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("。.𑑂\x{FE2F}", %p)},	undef,	"to_unicode\(\'\。\.\?\\uFE2F\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1394\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A92C}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA92C\。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A92C}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA92C\。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1396\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}󠸡｡\x{FCD7}", %p)},	undef,	"to_unicode\(\'\\u200D\?｡\\uFCD7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠸡｡\x{FCD7}", %p)},	undef,	"to_unicode\(\'\\u200D\?｡\\uFCD7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠸡。\x{0647}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u200D\?\。\\u0647\\u062C\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠸡。\x{0647}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u200D\?\。\\u0647\\u062C\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ0\x{0663}.𑍴Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0663\.𑍴Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-ⴄ0\x{0663}.𑍴σ", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0663\.𑍴σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0663}．𑍴Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0663．𑍴Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1407\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0663}．𑍴σ", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0663．𑍴σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󦈄。-", %p)},	undef,	"to_unicode\(\'\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．򶈮\x{0F18}ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.򶈮\x{0F18}ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.򶈮\x{0F18}SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.򶈮\x{0F18}ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.򶈮\x{0F18}Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．򶈮\x{0F18}SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．򶈮\x{0F18}ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．򶈮\x{0F18}Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0664}｡󠢮\x{FBA4}񷝊", %p)},	undef,	"to_unicode\(\'1𐋸\\u0664｡\?\\uFBA4\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0664}。󠢮\x{06C0}񷝊", %p)},	undef,	"to_unicode\(\'1𐋸\\u0664\。\?\\u06C0\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0664}。󠢮\x{06D5}\x{0654}񷝊", %p)},	undef,	"to_unicode\(\'1𐋸\\u0664\。\?\\u06D5\\u0654\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡𐹴ⴢ\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟺𐋷\x{06B9}．𞤭򿍡", %p)},	undef,	"to_unicode\(\'𝟺𐋷\\u06B9．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4𐋷\x{06B9}.𞤭򿍡", %p)},	undef,	"to_unicode\(\'4𐋷\\u06B9\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_unicode\(\'\≯\-ꡋ\?\.⒈𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_unicode\(\'\>\\u0338\-ꡋ\?\.⒈𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_unicode\(\'\≯\-ꡋ\?\.1\.𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_unicode\(\'\>\\u0338\-ꡋ\?\.1\.𐹭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0330}．󰜱蚀", %p)},	undef,	"to_unicode\(\'\\u0330．\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0330}.󰜱蚀", %p)},	undef,	"to_unicode\(\'\\u0330\.\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB39}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_unicode\(\'\\uFB39Ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_unicode\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_unicode\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_unicode\(\'\\u05D9\\u05BCႸ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_unicode\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_unicode\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{FB39}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_unicode\(\'\\uFB39ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FB39}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_unicode\(\'\\uFB39Ⴘ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{FB39}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_unicode\(\'\\uFB39ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FB39}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_unicode\(\'\\uFB39Ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA3}𐹰򁱓｡凬", %p)},	undef,	"to_unicode\(\'\\u1BA3𐹰\?｡凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA3}𐹰򁱓。凬", %p)},	undef,	"to_unicode\(\'\\u1BA3𐹰\?\。凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🢟🄈\x{200D}ꡎ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'🢟🄈\\u200Dꡎ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🢟🄈\x{200D}ꡎ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'🢟🄈\\u200Dꡎ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🢟7,\x{200D}ꡎ。\x{0F84}", %p)},	undef,	"to_unicode\(\'🢟7\,\\u200Dꡎ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🢟7,\x{200D}ꡎ。\x{0F84}", %p)},	undef,	"to_unicode\(\'🢟7\,\\u200Dꡎ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1460\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡔ。\x{1039}ᢇ", %p)},	undef,	"to_unicode\(\'ꡔ\。\\u1039ᢇ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20EB}≮.𝨖", %p)},	undef,	"to_unicode\(\'\\u20EB\≮\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20EB}<\x{0338}.𝨖", %p)},	undef,	"to_unicode\(\'\\u20EB\<\\u0338\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򊉆󠆒\x{200C}\x{A953}。𞤙\x{067B}ꡘ", %p)},	undef,	"to_unicode\(\'\?\󠆒\\u200C\\uA953\。\?\\u067Bꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򊉆󠆒\x{200C}\x{A953}。𞤙\x{067B}ꡘ", %p)},	undef,	"to_unicode\(\'\?\󠆒\\u200C\\uA953\。\?\\u067Bꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𰅧񣩠-．\x{ABED}-悜", %p)},	undef,	"to_unicode\(\'\?\?\-．\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𰅧񣩠-.\x{ABED}-悜", %p)},	undef,	"to_unicode\(\'\?\?\-\.\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ𶓧⬞ᢜ.-\x{200D}𞣑\x{202E}", %p)},	undef,	"to_unicode\(\'ᡉ\?\⬞ᢜ\.\-\\u200D𞣑\\u202E\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ𶓧⬞ᢜ.-\x{200D}𞣑\x{202E}", %p)},	undef,	"to_unicode\(\'ᡉ\?\⬞ᢜ\.\-\\u200D𞣑\\u202E\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1485\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1487\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1493\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{07E1}\x{200C}。--⸬", %p)},	undef,	"to_unicode\(\'\\u07E1\\u200C\。\-\-\⸬\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{07E1}\x{200C}。--⸬", %p)},	undef,	"to_unicode\(\'\\u07E1\\u200C\。\-\-\⸬\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1495\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞥓．\x{0718}", %p)},	"𞥓.\x{0718}",	"to_unicode\(\'\?．\\u0718\'\)\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞥓.\x{0718}", %p)},	"𞥓.\x{0718}",	"to_unicode\(\'\?\.\\u0718\'\)\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--of6h.xn--inb", %p)},	"𞥓.\x{0718}",	"to_unicode\(\'xn\-\-of6h\.xn\-\-inb\'\)\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠄽-．-\x{0DCA}", %p)},	undef,	"to_unicode\(\'\󠄽\-．\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄽-.-\x{0DCA}", %p)},	undef,	"to_unicode\(\'\󠄽\-\.\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("󠇝\x{075B}-.\x{1927}", %p)},	undef,	"to_unicode\(\'\󠇝\\u075B\-\.\\u1927\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞤴󠆹⦉𐹺.\x{A806}⒌󘤸", %p)},	undef,	"to_unicode\(\'\?\󠆹\⦉𐹺\.\\uA806⒌\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴󠆹⦉𐹺.\x{A806}5.󘤸", %p)},	undef,	"to_unicode\(\'\?\󠆹\⦉𐹺\.\\uA8065\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠄸₀。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_unicode\(\'\󠄸₀\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1504\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠄸₀。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_unicode\(\'\󠄸₀\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1505\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠄸0。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_unicode\(\'\󠄸0\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1506\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠄸0。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_unicode\(\'\󠄸0\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1507\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	"ⴚ𐋸.5ퟶ\x{103A}",	"to_unicode\(\'ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--ilj2659d.xn--5-dug9054m", %p)},	"ⴚ𐋸.5ퟶ\x{103A}",	"to_unicode\(\'xn\-\-ilj2659d\.xn\-\-5\-dug9054m\'\)\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴚ𐋸.5ퟶ\x{103A}", %p)},	"ⴚ𐋸.5ퟶ\x{103A}",	"to_unicode\(\'ⴚ𐋸\.5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1512\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ𐋸.5ퟶ\x{103A}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\.5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	"ⴚ𐋸.5ퟶ\x{103A}",	"to_unicode\(\'ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-ᠹ﹪.\x{1DE1}\x{1922}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠹ﹪\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-ᠹ﹪.\x{1DE1}\x{1922}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠹ﹪\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-ᠹ%.\x{1DE1}\x{1922}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠹ\%\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-ᠹ%.\x{1DE1}\x{1922}", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠹ\%\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.ᠿ", %p)},	undef,	"to_unicode\(\'\≠\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.ᠿ", %p)},	undef,	"to_unicode\(\'\=\\u0338\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0723}\x{05A3}｡㌪", %p)},	"\x{0723}\x{05A3}.ハイツ",	"to_unicode\(\'\\u0723\\u05A3｡㌪\'\)\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0723}\x{05A3}。ハイツ", %p)},	"\x{0723}\x{05A3}.ハイツ",	"to_unicode\(\'\\u0723\\u05A3\。ハイツ\'\)\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ucb18e.xn--eck4c5a", %p)},	"\x{0723}\x{05A3}.ハイツ",	"to_unicode\(\'xn\-\-ucb18e\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0723}\x{05A3}.ハイツ", %p)},	"\x{0723}\x{05A3}.ハイツ",	"to_unicode\(\'\\u0723\\u05A3\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞷥󠆀≮.\x{2D7F}-", %p)},	undef,	"to_unicode\(\'\?\󠆀\≮\.\\u2D7F\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞷥󠆀<\x{0338}.\x{2D7F}-", %p)},	undef,	"to_unicode\(\'\?\󠆀\<\\u0338\.\\u2D7F\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆榎򦖎\x{0D4D}｡𞤅\x{06ED}\x{FC5A}󠮨", %p)},	undef,	"to_unicode\(\'₆榎\?\\u0D4D｡\?\\u06ED\\uFC5A\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6榎򦖎\x{0D4D}。𞤅\x{06ED}\x{064A}\x{064A}󠮨", %p)},	undef,	"to_unicode\(\'6榎\?\\u0D4D\。\?\\u06ED\\u064A\\u064A\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𣩫．򌑲", %p)},	undef,	"to_unicode\(\'𣩫．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𣩫.򌑲", %p)},	undef,	"to_unicode\(\'𣩫\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡\x{06B9}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u06B9\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡\x{06B9}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u06B9\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。\x{06B9}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。\\u06B9\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。\x{06B9}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。\\u06B9\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--skb", %p)},	"\x{06B9}",	"to_unicode\(\'xn\-\-skb\'\)\ \[data\/IdnaTest\.txt\:1535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B9}", %p)},	"\x{06B9}",	"to_unicode\(\'\\u06B9\'\)\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦\x{200C}𐹶。\x{206D}", %p)},	undef,	"to_unicode\(\'𐹦\\u200C𐹶\。\\u206D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦\x{200C}𐹶。\x{206D}", %p)},	undef,	"to_unicode\(\'𐹦\\u200C𐹶\。\\u206D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1538\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("\x{0C4D}𝨾\x{05A9}𝟭。-𑜨", %p)},	undef,	"to_unicode\(\'\\u0C4D𝨾\\u05A9𝟭\。\-𑜨\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1539\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("\x{0C4D}𝨾\x{05A9}1。-𑜨", %p)},	undef,	"to_unicode\(\'\\u0C4D𝨾\\u05A91\。\-𑜨\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򣿈。뙏", %p)},	undef,	"to_unicode\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򣿈。뙏", %p)},	undef,	"to_unicode\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񕨚󠄌󑽀ᡀ.\x{08B6}", %p)},	undef,	"to_unicode\(\'\?\󠄌\?ᡀ\.\\u08B6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡񅁛", %p)},	undef,	"to_unicode\(\'\\u200D｡\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡񅁛", %p)},	undef,	"to_unicode\(\'\\u200D｡\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。񅁛", %p)},	undef,	"to_unicode\(\'\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。񅁛", %p)},	undef,	"to_unicode\(\'\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1547\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084B}皥．-", %p)},	undef,	"to_unicode\(\'\\u084B皥．\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{084B}皥.-", %p)},	undef,	"to_unicode\(\'\\u084B皥\.\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐣸\x{0315}𐮇．⒈ꡦ", %p)},	undef,	"to_unicode\(\'\?\\u0315𐮇．⒈ꡦ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐣸\x{0315}𐮇.1.ꡦ", %p)},	undef,	"to_unicode\(\'\?\\u0315𐮇\.1\.ꡦ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}Ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160Ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}Ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160Ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}A\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}A\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}Ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0Ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}Ā𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0Ā𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}A\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}A\x{0304}𐹦", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0A\\u0304𐹦\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FFF9}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFFF9\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。ß", %p)},	undef,	"to_unicode\(\'\≯⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。ß", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。ß", %p)},	undef,	"to_unicode\(\'\≯1\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。ß", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。SS", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。SS", %p)},	undef,	"to_unicode\(\'\≯1\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。SS", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。SS", %p)},	undef,	"to_unicode\(\'\≯⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1595\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6ⴙ\'\)\ throws\ error\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6ⴙ\'\)\ throws\ error\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1597\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆ⴙ\'\)\ throws\ error\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆ⴙ\'\)\ throws\ error\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1599\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1607\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𑖿𝨔.ᡟ𑖿\x{1B42}\x{200C}", %p)},	undef,	"to_unicode\(\'𑖿𝨔\.ᡟ𑖿\\u1B42\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𑖿𝨔.ᡟ𑖿\x{1B42}\x{200C}", %p)},	undef,	"to_unicode\(\'𑖿𝨔\.ᡟ𑖿\\u1B42\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:1609\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴Ↄ≠-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴Ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴Ↄ≠-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴Ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴ↄ≠-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򔣳\x{200D}򑝱.𖬴ↄ≠-", %p)},	undef,	"to_unicode\(\'\?\\u200D\?\.𖬴ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}ς\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2ς\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}ς\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2ς\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}ς\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2ς\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}ς\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2ς\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}Σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2Σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}Σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2Σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2σ\\u200D7\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}Σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2Σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}Σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2Σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E2}σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_unicode\(\'\\u07E2σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹰.\x{0600}", %p)},	undef,	"to_unicode\(\'𐹰\.\\u0600\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{08A8}.𱠖", %p)},	undef,	"to_unicode\(\'\-\\u08A8\.\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𞱸󠇀。誆⒈", %p)},	undef,	"to_unicode\(\'\≯\?\󠇀\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𞱸󠇀。誆⒈", %p)},	undef,	"to_unicode\(\'\>\\u0338\?\󠇀\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𞱸󠇀。誆1.", %p)},	undef,	"to_unicode\(\'\≯\?\󠇀\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𞱸󠇀。誆1.", %p)},	undef,	"to_unicode\(\'\>\\u0338\?\󠇀\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0616}𞥙䐊\x{0650}．︒\x{0645}↺\x{069C}", %p)},	undef,	"to_unicode\(\'\\u0616\?䐊\\u0650．︒\\u0645\↺\\u069C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1636\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{0616}𞥙䐊\x{0650}.。\x{0645}↺\x{069C}", %p)},	undef,	"to_unicode\(\'\\u0616\?䐊\\u0650\.\。\\u0645\↺\\u069C\'\)\ throws\ error\ V5\ B1\ A4_2\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_unicode\(\'Ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_unicode\(\'Ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_unicode\(\'ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_unicode\(\'ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񧞿╏。𞩕󠁾", %p)},	undef,	"to_unicode\(\'\?\╏\。\?\?\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}┮󠇐．\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\┮\󠇐．\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}┮󠇐．\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\┮\󠇐．\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1648\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}┮󠇐.\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\┮\󠇐\.\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}┮󠇐.\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\┮\󠇐\.\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1650\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򹚪｡🄂", %p)},	undef,	"to_unicode\(\'\?｡🄂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򹚪。1,", %p)},	undef,	"to_unicode\(\'\?\。1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑍨刍.🛦", %p)},	undef,	"to_unicode\(\'𑍨刍\.🛦\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠌏3｡\x{1BF1}𝟒", %p)},	undef,	"to_unicode\(\'\?3｡\\u1BF1𝟒\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠌏3。\x{1BF1}4", %p)},	undef,	"to_unicode\(\'\?3\。\\u1BF14\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0687}６Ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0687６Ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0687}６Ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0687６Ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0687}6Ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06876Ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0687}6Ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06876Ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1659\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0687}6ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06876ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1660\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0687}6ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06876ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1661\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0687}６ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0687６ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1662\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0687}６ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0687６ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1663\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠄍.𐮭𞰬򻫞۹", %p)},	undef,	"to_unicode\(\'\󠄍\.𐮭\?\?۹\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯．򻲀򒳄", %p)},	undef,	"to_unicode\(\'\\uA87D\≯．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}．򻲀򒳄", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯.򻲀򒳄", %p)},	undef,	"to_unicode\(\'\\uA87D\≯\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}.򻲀򒳄", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςო\x{067B}.ς\x{0714}", %p)},	undef,	"to_unicode\(\'ςო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{067B}.Σ\x{0714}", %p)},	undef,	"to_unicode\(\'Σო\\u067B\.Σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_unicode\(\'σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_unicode\(\'Σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_unicode\(\'Σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_unicode\(\'σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򄖚\x{0748}𠄯\x{075F}｡󠛩", %p)},	undef,	"to_unicode\(\'\?\\u0748𠄯\\u075F｡\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򄖚\x{0748}𠄯\x{075F}。󠛩", %p)},	undef,	"to_unicode\(\'\?\\u0748𠄯\\u075F\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\?\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳛．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\?．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐽘𑈵．𐹣🕥", %p)},	undef,	"to_unicode\(\'\?𑈵．𐹣🕥\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐽘𑈵.𐹣🕥", %p)},	undef,	"to_unicode\(\'\?𑈵\.𐹣🕥\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒊⒈𑁄。9", %p)},	undef,	"to_unicode\(\'⒊⒈𑁄\。9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("3.1.𑁄。9", %p)},	undef,	"to_unicode\(\'3\.1\.𑁄\。9\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1696\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}≮．𐹱򭏴4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\≮．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}≮．𐹱򭏴4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\≮．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}<\x{0338}．𐹱򭏴4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\<\\u0338．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}<\x{0338}．𐹱򭏴4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\<\\u0338．𐹱\?4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}≮.𐹱򭏴49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\≮\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}≮.𐹱򭏴49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\≮\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}<\x{0338}.𐹱򭏴49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\<\\u0338\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}\x{2DF1}<\x{0338}.𐹱򭏴49", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u2DF1\<\\u0338\.𐹱\?49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾｡\x{0847}", %p)},	undef,	"to_unicode\(\'\-\≯딾｡\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾｡\x{0847}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾｡\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾。\x{0847}", %p)},	undef,	"to_unicode\(\'\-\≯딾\。\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾。\x{0847}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾\。\\u0847\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑙢⒈𐹠-｡󠗐\x{200C}", %p)},	undef,	"to_unicode\(\'\?⒈𐹠\-｡\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑙢⒈𐹠-｡󠗐\x{200C}", %p)},	undef,	"to_unicode\(\'\?⒈𐹠\-｡\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑙢1.𐹠-。󠗐\x{200C}", %p)},	undef,	"to_unicode\(\'\?1\.𐹠\-\。\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑙢1.𐹠-。󠗐\x{200C}", %p)},	undef,	"to_unicode\(\'\?1\.𐹠\-\。\?\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1712\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{034A}．𐨎", %p)},	undef,	"to_unicode\(\'\\u034A．𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{034A}.𐨎", %p)},	undef,	"to_unicode\(\'\\u034A\.𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1714\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("훉≮｡\x{0E34}", %p)},	undef,	"to_unicode\(\'훉\≮｡\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}｡\x{0E34}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338｡\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉≮。\x{0E34}", %p)},	undef,	"to_unicode\(\'훉\≮\。\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}。\x{0E34}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338\。\\u0E34\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF7}򞣉🃘．𴈇𝟸\x{0659}𞤯", %p)},	undef,	"to_unicode\(\'\\u2DF7\?🃘．\?𝟸\\u0659\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF7}򞣉🃘.𴈇2\x{0659}𞤯", %p)},	undef,	"to_unicode\(\'\\u2DF7\?🃘\.\?2\\u0659\?\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?ßᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?ßᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?ßᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?ßᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?SSᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?SSᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?Ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_unicode\(\'\?Ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?SSᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?SSᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?Ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_unicode\(\'\?Ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:1736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_unicode\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_unicode\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_unicode\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1739\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_unicode\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FDAD}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_unicode\(\'\\uFDAD\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDAD}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_unicode\(\'\\uFDAD\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0645}\x{064A}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0645\\u064A\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0645}\x{064A}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0645\\u064A\\u200D\.\?\\u06A9\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1C2F}𐲒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1C2F𐲒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{1C2F}𐲒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_unicode\(\'Ⴜ\\u1C2F𐲒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋵。\x{FCEC}", %p)},	"𐋵.\x{0643}\x{0645}",	"to_unicode\(\'𐋵\。\\uFCEC\'\)\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋵。\x{0643}\x{0645}", %p)},	"𐋵.\x{0643}\x{0645}",	"to_unicode\(\'𐋵\。\\u0643\\u0645\'\)\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--p97c.xn--fhbe", %p)},	"𐋵.\x{0643}\x{0645}",	"to_unicode\(\'xn\-\-p97c\.xn\-\-fhbe\'\)\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋵.\x{0643}\x{0645}", %p)},	"𐋵.\x{0643}\x{0645}",	"to_unicode\(\'𐋵\.\\u0643\\u0645\'\)\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮𝅶．񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_unicode\(\'\≮\?．\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝅶．񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_unicode\(\'\<\\u0338\?．\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝅶.񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_unicode\(\'\≮\?\.\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝅶.񱲁\x{AAEC}\x{2E48}󰥭", %p)},	undef,	"to_unicode\(\'\<\\u0338\?\.\?\\uAAEC\\u2E48\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF0}\x{0358}ᢕ．\x{0361}𐹷󠴍", %p)},	undef,	"to_unicode\(\'\\u2DF0\\u0358ᢕ．\\u0361𐹷\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF0}\x{0358}ᢕ.\x{0361}𐹷󠴍", %p)},	undef,	"to_unicode\(\'\\u2DF0\\u0358ᢕ\.\\u0361𐹷\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{FD79}ᡐ\x{200C}\x{06AD}．𑋪\x{05C7}", %p)},	undef,	"to_unicode\(\'\\uFD79ᡐ\\u200C\\u06AD．𑋪\\u05C7\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:1761\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{063A}\x{0645}\x{0645}ᡐ\x{200C}\x{06AD}.𑋪\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u063A\\u0645\\u0645ᡐ\\u200C\\u06AD\.𑋪\\u05C7\'\)\ throws\ error\ V5\ B2\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑑂｡\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_unicode\(\'\?｡\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑂｡\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_unicode\(\'\?｡\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑂。\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_unicode\(\'\?\。\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑑂。\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_unicode\(\'\?\。\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{05E9}。⒚", %p)},	undef,	"to_unicode\(\'\-\\u05E9\。⒚\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{05E9}。19.", %p)},	undef,	"to_unicode\(\'\-\\u05E9\。19\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􊾻\x{0845}\x{200C}｡ᢎ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u200C｡ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􊾻\x{0845}\x{200C}｡ᢎ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u200C｡ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􊾻\x{0845}\x{200C}。ᢎ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u200C\。ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􊾻\x{0845}\x{200C}。ᢎ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u0845\\u200C\。ᢎ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1772\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1774\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}。\x{0620}85", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}。\x{0620}85", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1776\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{09C1}\x{1DED}。\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'SS\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1778\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'Ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--ss-e2f077r.xn--85-psd", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'xn\-\-ss\-e2f077r\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:1780\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{09C1}\x{1DED}.\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'SS\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'Ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--zca266bwrr.xn--85-psd", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'xn\-\-zca266bwrr\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}.\x{0620}85", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{09C1}\x{1DED}.\x{0620}85", %p)},	"ß\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ß\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:1786\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'SS\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1788\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"ss\x{09C1}\x{1DED}.\x{0620}85",	"to_unicode\(\'Ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅𝟣．₃𐹥ß", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅1.3𐹥ß", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅1\.3𐹥ß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅1.3𐹥SS", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅1\.3𐹥SS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅1.3𐹥ss", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅1\.3𐹥ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅1.3𐹥Ss", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅1\.3𐹥Ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅𝟣．₃𐹥SS", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅𝟣．₃𐹥SS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅𝟣．₃𐹥ss", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0ACD}\x{0484}魅𝟣．₃𐹥Ss", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u0484魅𝟣．₃𐹥Ss\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{072B}｡𑓂⒈𑜫󠿻", %p)},	undef,	"to_unicode\(\'\\u072B｡𑓂⒈𑜫\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}。𑓂1.𑜫󠿻", %p)},	undef,	"to_unicode\(\'\\u072B\。𑓂1\.𑜫\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE0D}છ。嵨", %p)},	"છ.嵨",	"to_unicode\(\'\\uFE0Dછ\。嵨\'\)\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--6dc.xn--tot", %p)},	"છ.嵨",	"to_unicode\(\'xn\-\-6dc\.xn\-\-tot\'\)\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("છ.嵨", %p)},	"છ.嵨",	"to_unicode\(\'છ\.嵨\'\)\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ≠Ⴀ.𐹥𐹰", %p)},	undef,	"to_unicode\(\'Ⴔ\≠Ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ=\x{0338}Ⴀ.𐹥𐹰", %p)},	undef,	"to_unicode\(\'Ⴔ\=\\u0338Ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ=\x{0338}ⴀ.𐹥𐹰", %p)},	undef,	"to_unicode\(\'ⴔ\=\\u0338ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ≠ⴀ.𐹥𐹰", %p)},	undef,	"to_unicode\(\'ⴔ\≠ⴀ\.𐹥𐹰\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙𐫥｡𝨵", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙𐫥｡𝨵\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙𐫥｡𝨵", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙𐫥｡𝨵\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1808\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("-\x{200C}18.𐫥。𝨵", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.𐫥\。𝨵\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("-\x{200C}18.𐫥。𝨵", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.𐫥\。𝨵\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1810\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒.ʌᠣ-𐹽", %p)},	undef,	"to_unicode\(\'︒\.ʌᠣ\-𐹽\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.ʌᠣ-𐹽", %p)},	undef,	"to_unicode\(\'\。\.ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.Ʌᠣ-𐹽", %p)},	undef,	"to_unicode\(\'\。\.Ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒.Ʌᠣ-𐹽", %p)},	undef,	"to_unicode\(\'︒\.Ʌᠣ\-𐹽\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE05}︒。𦀾\x{1CE0}", %p)},	undef,	"to_unicode\(\'\\uFE05︒\。𦀾\\u1CE0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{FE05}。。𦀾\x{1CE0}", %p)},	"𦀾\x{1CE0}",	"to_unicode\(\'\\uFE05\。\。𦀾\\u1CE0\'\)\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--t6f5138v", %p)},	"𦀾\x{1CE0}",	"to_unicode\(\'xn\-\-t6f5138v\'\)\ \[data\/IdnaTest\.txt\:1817\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𦀾\x{1CE0}", %p)},	"𦀾\x{1CE0}",	"to_unicode\(\'𦀾\\u1CE0\'\)\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞮑ß􏞞。ᡁ", %p)},	undef,	"to_unicode\(\'\?ß\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞮑SS􏞞。ᡁ", %p)},	undef,	"to_unicode\(\'\?SS\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞮑ss􏞞。ᡁ", %p)},	undef,	"to_unicode\(\'\?ss\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞮑Ss􏞞。ᡁ", %p)},	undef,	"to_unicode\(\'\?Ss\?\。ᡁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}\x{200D}\x{062C}\x{066C}。𱆎󻡟\x{200C}󠅆", %p)},	undef,	"to_unicode\(\'\\uA953\\u200D\\u062C\\u066C\。\?\?\\u200C\󠅆\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}\x{200D}\x{062C}\x{066C}。𱆎󻡟\x{200C}󠅆", %p)},	undef,	"to_unicode\(\'\\uA953\\u200D\\u062C\\u066C\。\?\?\\u200C\󠅆\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕏．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\?．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'ᡙ\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹧𞲄󠁭񆼩。\x{034E}🄀", %p)},	undef,	"to_unicode\(\'𐹧\?\?\?\。\\u034E🄀\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹧𞲄󠁭񆼩。\x{034E}0.", %p)},	undef,	"to_unicode\(\'𐹧\?\?\?\。\\u034E0\.\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0721\?Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0721\?σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򮵛\x{0613}.Ⴕ", %p)},	undef,	"to_unicode\(\'\?\\u0613\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򮵛\x{0613}.ⴕ", %p)},	undef,	"to_unicode\(\'\?\\u0613\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u1DF3\?\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠄷｡򒑁", %p)},	undef,	"to_unicode\(\'\\u200C\󠄷｡\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠄷｡򒑁", %p)},	undef,	"to_unicode\(\'\\u200C\󠄷｡\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠄷。򒑁", %p)},	undef,	"to_unicode\(\'\\u200C\󠄷\。\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠄷。򒑁", %p)},	undef,	"to_unicode\(\'\\u200C\󠄷\。\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_unicode\(\'⒈\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_unicode\(\'⒈\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_unicode\(\'1\.\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_unicode\(\'1\.\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}ς≮.ς𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDς\≮\.ς𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}ς<\x{0338}.ς𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDς\<\\u0338\.ς𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}Σ<\x{0338}.Σ𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDΣ\<\\u0338\.Σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}Σ≮.Σ𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDΣ\≮\.Σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}σ≮.σ𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDσ\≮\.σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}σ<\x{0338}.σ𝪦𞤕0", %p)},	undef,	"to_unicode\(\'\\u1DCDσ\<\\u0338\.σ𝪦\?0\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢦾ß\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_unicode\(\'\?ß\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢦾SS\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_unicode\(\'\?SS\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢦾ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_unicode\(\'\?ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢦾Ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_unicode\(\'\?Ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞣄｡⒈", %p)},	undef,	"to_unicode\(\'\-𞣄｡⒈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𞣄。1.", %p)},	undef,	"to_unicode\(\'\-𞣄\。1\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񈠢𐫖𝟡。\x{063E}𑘿", %p)},	undef,	"to_unicode\(\'\?𐫖𝟡\。\\u063E𑘿\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񈠢𐫖9。\x{063E}𑘿", %p)},	undef,	"to_unicode\(\'\?𐫖9\。\\u063E𑘿\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0668}\x{FC8C}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0668\\uFC8C\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0668}\x{FC8C}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0668\\uFC8C\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1912\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0668}\x{0646}\x{0645}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0668\\u0646\\u0645\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0668}\x{0646}\x{0645}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0668\\u0646\\u0645\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1914\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟘．Ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_unicode\(\'𝟘．Ⴇ\?\\uFD50\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_unicode\(\'0\.Ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_unicode\(\'0\.ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟘．ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_unicode\(\'𝟘．ⴇ\?\\uFD50\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𑇀▍.⁞ᠰ", %p)},	undef,	"to_unicode\(\'𑇀\▍\.\⁞ᠰ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-\x{067A}.򏯩", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u067A\.\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-\x{067A}.򏯩", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u067A\.\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐｡\x{200C}≯✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐｡\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐｡\x{200C}≯✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐｡\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐｡\x{200C}>\x{0338}✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐｡\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐｡\x{200C}>\x{0338}✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐｡\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐。\x{200C}≯✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐\。\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐。\x{200C}≯✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐\。\\u200C\≯\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐。\x{200C}>\x{0338}✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐\。\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠢ𐮂𐫘寐。\x{200C}>\x{0338}✳", %p)},	undef,	"to_unicode\(\'ᠢ𐮂𐫘寐\。\\u200C\>\\u0338\✳\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜ႺႴ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜ႺႴ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜ႺႴ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜ႺႴ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?ႺႴ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D\。\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_unicode\(\'\\u200D｡\?Ⴚⴔ\?\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-3.\x{200D}ヌᢕ", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌᢕ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-3.\x{200D}ヌᢕ", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌᢕ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}ß\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666ß\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}ß\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666ß\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}SS\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666SS\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}SS\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666SS\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}Ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666Ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂃\x{0666}Ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_unicode\(\'🂃\\u0666Ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-𐾺\x{069F}。򰀺\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\?\\u069F\。\?\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-𐾺\x{069F}。򰀺\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\?\\u069F\。\?\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}.\x{0484}𐨗𝩋𴤃", %p)},	undef,	"to_unicode\(\'\\u0665\.\\u0484𐨗𝩋\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.񱼓\x{0649}𐨿", %p)},	undef,	"to_unicode\(\'\-\.\?\\u0649𐨿\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨ς.𞶙녫ß", %p)},	undef,	"to_unicode\(\'\?ς\.\?녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨ς.𞶙녫ß", %p)},	undef,	"to_unicode\(\'\?ς\.\?녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_unicode\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_unicode\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨σ.𞶙녫ss", %p)},	undef,	"to_unicode\(\'\?σ\.\?녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨σ.𞶙녫ss", %p)},	undef,	"to_unicode\(\'\?σ\.\?녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_unicode\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_unicode\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{AAF6}\x{A953}󧦉．\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_unicode\(\'𐋺\\uAAF6\\uA953\?．\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{AAF6}\x{A953}󧦉．\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_unicode\(\'𐋺\\uAAF6\\uA953\?．\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{AAF6}\x{A953}󧦉.\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_unicode\(\'𐋺\\uAAF6\\uA953\?\.\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{AAF6}\x{A953}󧦉.\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_unicode\(\'𐋺\\uAAF6\\uA953\?\.\\u200C\\u1714\\u068F\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񺔯\x{0FA8}．≯", %p)},	undef,	"to_unicode\(\'\?\\u0FA8．\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񺔯\x{0FA8}．>\x{0338}", %p)},	undef,	"to_unicode\(\'\?\\u0FA8．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񺔯\x{0FA8}.≯", %p)},	undef,	"to_unicode\(\'\?\\u0FA8\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񺔯\x{0FA8}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\?\\u0FA8\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𞡄Ⴓ．𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄Ⴓ．𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𞡄Ⴓ．𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄Ⴓ．𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𞡄Ⴓ.𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄Ⴓ\.𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𞡄Ⴓ.𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄Ⴓ\.𐇽\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1991\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𞡄ⴓ.𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄ⴓ\.𐇽\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𞡄ⴓ.𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄ⴓ\.𐇽\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1993\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𞡄ⴓ．𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄ⴓ．𐇽\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𞡄ⴓ．𐇽", %p)},	undef,	"to_unicode\(\'\\u200D𞡄ⴓ．𐇽\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1995\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒ß\x{A8EA}．ᡤ", %p)},	undef,	"to_unicode\(\'𐪒ß\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒ß\x{A8EA}.ᡤ", %p)},	undef,	"to_unicode\(\'𐪒ß\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1997\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒SS\x{A8EA}.ᡤ", %p)},	undef,	"to_unicode\(\'𐪒SS\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒ss\x{A8EA}.ᡤ", %p)},	undef,	"to_unicode\(\'𐪒ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒Ss\x{A8EA}.ᡤ", %p)},	undef,	"to_unicode\(\'𐪒Ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒SS\x{A8EA}．ᡤ", %p)},	undef,	"to_unicode\(\'𐪒SS\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2001\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒ss\x{A8EA}．ᡤ", %p)},	undef,	"to_unicode\(\'𐪒ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪒Ss\x{A8EA}．ᡤ", %p)},	undef,	"to_unicode\(\'𐪒Ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2003\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐨿󠆌鸮𑚶.ς", %p)},	undef,	"to_unicode\(\'𐨿\󠆌鸮𑚶\.ς\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐨿󠆌鸮𑚶.Σ", %p)},	undef,	"to_unicode\(\'𐨿\󠆌鸮𑚶\.Σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2005\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐨿󠆌鸮𑚶.σ", %p)},	undef,	"to_unicode\(\'𐨿\󠆌鸮𑚶\.σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒗𞤬。-𑚶", %p)},	undef,	"to_unicode\(\'⒗\?\。\-𑚶\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2007\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("16.𞤬。-𑚶", %p)},	undef,	"to_unicode\(\'16\.\?\。\-𑚶\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08B3}𞤿⾫｡𐹣\x{068F}⒈", %p)},	undef,	"to_unicode\(\'\\u08B3\?⾫｡𐹣\\u068F⒈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2009\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08B3}𞤿隹。𐹣\x{068F}1.", %p)},	undef,	"to_unicode\(\'\\u08B3\?隹\。𐹣\\u068F1\.\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2433}𚎛𝟧\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_unicode\(\'\\u2433\?𝟧\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2433}𚎛5\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_unicode\(\'\\u2433\?5\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠.🄀⒒-󨰈", %p)},	undef,	"to_unicode\(\'𐹠\.🄀⒒\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠.0.11.-󨰈", %p)},	undef,	"to_unicode\(\'𐹠\.0\.11\.\-\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}-\x{0CE2}．󠄩Ⴄ", %p)},	undef,	"to_unicode\(\'\\u1734\-\\u0CE2．\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}-\x{0CE2}.󠄩Ⴄ", %p)},	undef,	"to_unicode\(\'\\u1734\-\\u0CE2\.\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{1734}-\x{0CE2}.󠄩ⴄ", %p)},	undef,	"to_unicode\(\'\\u1734\-\\u0CE2\.\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{1734}-\x{0CE2}．󠄩ⴄ", %p)},	undef,	"to_unicode\(\'\\u1734\-\\u0CE2．\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򭈗♋\x{06BB}𐦥｡\x{0954}⒈", %p)},	undef,	"to_unicode\(\'\?\♋\\u06BB𐦥｡\\u0954⒈\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򭈗♋\x{06BB}𐦥。\x{0954}1.", %p)},	undef,	"to_unicode\(\'\?\♋\\u06BB𐦥\。\\u09541\.\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05A4}．\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05A4．\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05A4}．\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05A4．\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2034\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05A4}.\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05A4\.\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{05A4}.\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05A4\.\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2036\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񢭏\x{0846}≮\x{0ACD}．𞦊", %p)},	undef,	"to_unicode\(\'\?\\u0846\≮\\u0ACD．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񢭏\x{0846}<\x{0338}\x{0ACD}．𞦊", %p)},	undef,	"to_unicode\(\'\?\\u0846\<\\u0338\\u0ACD．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񢭏\x{0846}≮\x{0ACD}.𞦊", %p)},	undef,	"to_unicode\(\'\?\\u0846\≮\\u0ACD\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񢭏\x{0846}<\x{0338}\x{0ACD}.𞦊", %p)},	undef,	"to_unicode\(\'\?\\u0846\<\\u0338\\u0ACD\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𞀘⒈ꡍ擉", %p)},	undef,	"to_unicode\(\'\\u200D\。\?⒈ꡍ擉\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𞀘⒈ꡍ擉", %p)},	undef,	"to_unicode\(\'\\u200D\。\?⒈ꡍ擉\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2042\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}。𞀘1.ꡍ擉", %p)},	undef,	"to_unicode\(\'\\u200D\。\?1\.ꡍ擉\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}。𞀘1.ꡍ擉", %p)},	undef,	"to_unicode\(\'\\u200D\。\?1\.ꡍ擉\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2044\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₈\x{07CB}．\x{FB64}≠", %p)},	undef,	"to_unicode\(\'₈\\u07CB．\\uFB64\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₈\x{07CB}．\x{FB64}=\x{0338}", %p)},	undef,	"to_unicode\(\'₈\\u07CB．\\uFB64\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{07CB}.\x{067F}≠", %p)},	undef,	"to_unicode\(\'8\\u07CB\.\\u067F\≠\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{07CB}.\x{067F}=\x{0338}", %p)},	undef,	"to_unicode\(\'8\\u07CB\.\\u067F\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢡ\x{07DE}򹐣.⒒\x{0642}𑍦", %p)},	undef,	"to_unicode\(\'ᢡ\\u07DE\?\.⒒\\u0642𑍦\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:2049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢡ\x{07DE}򹐣.11.\x{0642}𑍦", %p)},	undef,	"to_unicode\(\'ᢡ\\u07DE\?\.11\.\\u0642𑍦\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E48}-𐹺𝟜.\x{0363}\x{06E1}⒏", %p)},	undef,	"to_unicode\(\'\\u0E48\-𐹺𝟜\.\\u0363\\u06E1⒏\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0E48}-𐹺4.\x{0363}\x{06E1}8.", %p)},	undef,	"to_unicode\(\'\\u0E48\-𐹺4\.\\u0363\\u06E18\.\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⫐｡Ⴠ-󃐢", %p)},	undef,	"to_unicode\(\'\⫐｡Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。Ⴠ-󃐢", %p)},	undef,	"to_unicode\(\'\⫐\。Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。ⴠ-󃐢", %p)},	undef,	"to_unicode\(\'\⫐\。ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐｡ⴠ-󃐢", %p)},	undef,	"to_unicode\(\'\⫐｡ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𑑂◊．⦟∠", %p)},	undef,	"to_unicode\(\'\?\◊．\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𑑂◊.⦟∠", %p)},	undef,	"to_unicode\(\'\?\◊\.\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𿌰-\x{0662}。󋸛ꡂ", %p)},	undef,	"to_unicode\(\'\?\-\\u0662\。\?ꡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0678}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_unicode\(\'\\u0678\。\?\\u0741\?𐹪\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0674}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_unicode\(\'\\u064A\\u0674\。\?\\u0741\?𐹪\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫆ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'𐫆ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2062\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫆ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'𐫆ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2063\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫆ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'𐫆ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2064\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫆ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'𐫆ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2065\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₀\x{0662}。󅪞≯-", %p)},	undef,	"to_unicode\(\'₀\\u0662\。\?\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₀\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_unicode\(\'₀\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{0662}。󅪞≯-", %p)},	undef,	"to_unicode\(\'0\\u0662\。\?\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_unicode\(\'0\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{031C}𐹫-𞯃.𐋤\x{0845}", %p)},	undef,	"to_unicode\(\'\\u031C𐹫\-\?\.𐋤\\u0845\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\≠｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\≠\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\≠\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_unicode\(\'\≠｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𖫳≠.Ⴀ𐮀", %p)},	undef,	"to_unicode\(\'𖫳\≠\.Ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𖫳=\x{0338}.Ⴀ𐮀", %p)},	undef,	"to_unicode\(\'𖫳\=\\u0338\.Ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𖫳=\x{0338}.ⴀ𐮀", %p)},	undef,	"to_unicode\(\'𖫳\=\\u0338\.ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𖫳≠.ⴀ𐮀", %p)},	undef,	"to_unicode\(\'𖫳\≠\.ⴀ𐮀\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅾\x{0736}\x{0726}．ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_unicode\(\'\󠅾\\u0736\\u0726．ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅾\x{0736}\x{0726}.ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_unicode\(\'\󠅾\\u0736\\u0726\.ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}󠇜\x{06CB}\x{A8E9}｡\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠇜\\u06CB\\uA8E9｡\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}󠇜\x{06CB}\x{A8E9}｡\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠇜\\u06CB\\uA8E9｡\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2086\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}󠇜\x{06CB}\x{A8E9}。\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠇜\\u06CB\\uA8E9\。\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}󠇜\x{06CB}\x{A8E9}。\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠇜\\u06CB\\uA8E9\。\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2088\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_unicode\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_unicode\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_unicode\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_unicode\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭｡󃱂\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹭｡\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭｡󃱂\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹭｡\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭。󃱂\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹭\。\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭。󃱂\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹭\。\?\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭。󃱂\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹭\。\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭。󃱂\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹭\。\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭｡󃱂\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹭｡\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹭｡󃱂\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹭｡\?\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}.\x{033D}𑂽馋", %p)},	undef,	"to_unicode\(\'\\uA953\.\\u033D\?馋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󈫝򪛸\x{200D}｡䜖", %p)},	undef,	"to_unicode\(\'\?\?\\u200D｡䜖\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󈫝򪛸\x{200D}｡䜖", %p)},	undef,	"to_unicode\(\'\?\?\\u200D｡䜖\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󈫝򪛸\x{200D}。䜖", %p)},	undef,	"to_unicode\(\'\?\?\\u200D\。䜖\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󈫝򪛸\x{200D}。䜖", %p)},	undef,	"to_unicode\(\'\?\?\\u200D\。䜖\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡯ⚉姶🄉．۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_unicode\(\'ᡯ\⚉姶🄉．۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡯ⚉姶🄉．۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_unicode\(\'ᡯ\⚉姶🄉．۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡯ⚉姶8,.۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_unicode\(\'ᡯ\⚉姶8\,\.۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡯ⚉姶8,.۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_unicode\(\'ᡯ\⚉姶8\,\.۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞽀.𐹸🚖\x{0E3A}", %p)},	undef,	"to_unicode\(\'\?\.𐹸🚖\\u0E3A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_unicode\(\'Ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_unicode\(\'Ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_unicode\(\'ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_unicode\(\'ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{135F}ᡈ\x{200C}．︒-𖾐-", %p)},	undef,	"to_unicode\(\'\\u135Fᡈ\\u200C．︒\-𖾐\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{135F}ᡈ\x{200C}．︒-𖾐-", %p)},	undef,	"to_unicode\(\'\\u135Fᡈ\\u200C．︒\-𖾐\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2116\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{135F}ᡈ\x{200C}.。-𖾐-", %p)},	undef,	"to_unicode\(\'\\u135Fᡈ\\u200C\.\。\-𖾐\-\'\)\ throws\ error\ V5\ V3\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2117\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{135F}ᡈ\x{200C}.。-𖾐-", %p)},	undef,	"to_unicode\(\'\\u135Fᡈ\\u200C\.\。\-𖾐\-\'\)\ throws\ error\ V5\ V3\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2118\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒈\x{0601}⒖\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_unicode\(\'⒈\\u0601⒖\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0601}⒖\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_unicode\(\'⒈\\u0601⒖\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0601}15.\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_unicode\(\'1\.\\u060115\.\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0601}15.\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_unicode\(\'1\.\\u060115\.\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩜。-\x{0B4D}Ⴋ", %p)},	undef,	"to_unicode\(\'𝩜\。\-\\u0B4DႫ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:2123\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝩜。-\x{0B4D}ⴋ", %p)},	undef,	"to_unicode\(\'𝩜\。\-\\u0B4Dⴋ\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ßჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_unicode\(\'ßჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ßⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_unicode\(\'ßⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SSჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_unicode\(\'SSჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ssⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_unicode\(\'ssⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ssⴠ.\x{0620}刯Ⴝ", %p)},	undef,	"to_unicode\(\'Ssⴠ\.\\u0620刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_unicode\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{06EC}.\x{08A2}𐹫\x{067C}", %p)},	undef,	"to_unicode\(\'\\u06EC\.\\u08A2𐹫\\u067C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06B6}\x{06DF}。₇\x{A806}", %p)},	"\x{06B6}\x{06DF}.7\x{A806}",	"to_unicode\(\'\\u06B6\\u06DF\。₇\\uA806\'\)\ \[data\/IdnaTest\.txt\:2143\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06B6}\x{06DF}。7\x{A806}", %p)},	"\x{06B6}\x{06DF}.7\x{A806}",	"to_unicode\(\'\\u06B6\\u06DF\。7\\uA806\'\)\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--pkb6f.xn--7-x93e", %p)},	"\x{06B6}\x{06DF}.7\x{A806}",	"to_unicode\(\'xn\-\-pkb6f\.xn\-\-7\-x93e\'\)\ \[data\/IdnaTest\.txt\:2145\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06B6}\x{06DF}.7\x{A806}", %p)},	"\x{06B6}\x{06DF}.7\x{A806}",	"to_unicode\(\'\\u06B6\\u06DF\.7\\uA806\'\)\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_unicode\(\'Ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_unicode\(\'Ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_unicode\(\'Ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_unicode\(\'Ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_unicode\(\'ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_unicode\(\'ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_unicode\(\'ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_unicode\(\'ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2154\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝟵隁⯮．\x{180D}\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁\⯮．\\u180D\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝟵隁⯮．\x{180D}\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁\⯮．\\u180D\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2156\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("9隁⯮.\x{180D}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁\⯮\.\\u180D\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("9隁⯮.\x{180D}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁\⯮\.\\u180D\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2158\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("xn--9-mfs8024b.", %p)},	"9隁⯮.",	"to_unicode\(\'xn\-\-9\-mfs8024b\.\'\)\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("9隁⯮.", %p)},	"9隁⯮.",	"to_unicode\(\'9隁\⯮\.\'\)\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏𐹧｡Ⴣ\x{0F84}彦", %p)},	undef,	"to_unicode\(\'⒏𐹧｡Ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8.𐹧。Ⴣ\x{0F84}彦", %p)},	undef,	"to_unicode\(\'8\.𐹧\。Ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("8.𐹧。ⴣ\x{0F84}彦", %p)},	undef,	"to_unicode\(\'8\.𐹧\。ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏𐹧｡ⴣ\x{0F84}彦", %p)},	undef,	"to_unicode\(\'⒏𐹧｡ⴣ\\u0F84彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问񬰔⒛。\x{0604}-񜗉橬", %p)},	undef,	"to_unicode\(\'\-问\?⒛\。\\u0604\-\?橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问񬰔20.。\x{0604}-񜗉橬", %p)},	undef,	"to_unicode\(\'\-问\?20\.\。\\u0604\-\?橬\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAC}Ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_unicode\(\'\\u1BACႬ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAC}Ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_unicode\(\'\\u1BACႬ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAC}Ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_unicode\(\'\\u1BACႬ\\u200C\\u0325\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAC}Ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_unicode\(\'\\u1BACႬ\\u200C\\u0325\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2170\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1BAC}ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_unicode\(\'\\u1BACⴌ\\u200C\\u0325\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2171\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1BAC}ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_unicode\(\'\\u1BACⴌ\\u200C\\u0325\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2172\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1BAC}ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_unicode\(\'\\u1BACⴌ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2173\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{1BAC}ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_unicode\(\'\\u1BACⴌ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2174\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{DC5F}。\x{A806}\x{0669}󠒩", %p)},	undef,	"to_unicode\(\'\\uDC5F\。\\uA806\\u0669\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄁\x{035F}⾶｡₇︒눇≮", %p)},	undef,	"to_unicode\(\'\󠄁\\u035F⾶｡₇︒눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄁\x{035F}⾶｡₇︒눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\󠄁\\u035F⾶｡₇︒눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄁\x{035F}飛。7。눇≮", %p)},	undef,	"to_unicode\(\'\󠄁\\u035F飛\。7\。눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄁\x{035F}飛。7。눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\󠄁\\u035F飛\。7\。눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{FE09}𐹴\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE09𐹴\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{FE09}𐹴\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE09𐹴\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2181\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{FE09}𐹴\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE09𐹴\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2182\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{FE09}𐹴\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE09𐹴\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2183\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🍮．\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_unicode\(\'🍮．\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🍮．\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_unicode\(\'🍮．\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🍮.\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_unicode\(\'🍮\.\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🍮.\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_unicode\(\'🍮\.\\u200D\?𐦁𝨝\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2187\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{067D}\x{0943}.𞤓\x{200D}", %p)},	undef,	"to_unicode\(\'\\u067D\\u0943\.\?\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{067D}\x{0943}.𞤓\x{200D}", %p)},	undef,	"to_unicode\(\'\\u067D\\u0943\.\?\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:2189\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--2ib43l.xn--te6h", %p)},	"\x{067D}\x{0943}.𞤵",	"to_unicode\(\'xn\-\-2ib43l\.xn\-\-te6h\'\)\ \[data\/IdnaTest\.txt\:2190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{067D}\x{0943}.𞤵", %p)},	"\x{067D}\x{0943}.𞤵",	"to_unicode\(\'\\u067D\\u0943\.\?\'\)\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0664}\x{0A4D}-．󥜽\x{1039}񦦐", %p)},	undef,	"to_unicode\(\'\\u0664\\u0A4D\-．\?\\u1039\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0664}\x{0A4D}-.󥜽\x{1039}񦦐", %p)},	undef,	"to_unicode\(\'\\u0664\\u0A4D\-\.\?\\u1039\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{0F84}\x{0F96}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{0F84}\x{0F96}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{0F84}\x{0F96}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{0F84}\x{0F96}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\≯\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\≯\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\>\\u0338\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\>\\u0338\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\≯\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\≯\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\>\\u0338\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_unicode\(\'\>\\u0338\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2213\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}ß𐰯｡𝟕𐫫", %p)},	undef,	"to_unicode\(\'\\u0641ß𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}ß𐰯。7𐫫", %p)},	undef,	"to_unicode\(\'\\u0641ß𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2215\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}SS𐰯。7𐫫", %p)},	undef,	"to_unicode\(\'\\u0641SS𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}ss𐰯。7𐫫", %p)},	undef,	"to_unicode\(\'\\u0641ss𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}Ss𐰯。7𐫫", %p)},	undef,	"to_unicode\(\'\\u0641Ss𐰯\。7𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}SS𐰯｡𝟕𐫫", %p)},	undef,	"to_unicode\(\'\\u0641SS𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2219\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}ss𐰯｡𝟕𐫫", %p)},	undef,	"to_unicode\(\'\\u0641ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0641}Ss𐰯｡𝟕𐫫", %p)},	undef,	"to_unicode\(\'\\u0641Ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B2\ B1\ \[data\/IdnaTest\.txt\:2221\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_unicode\(\'ß\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_unicode\(\'SS\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_unicode\(\'ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_unicode\(\'Ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡󠉗⒌𞯛", %p)},	undef,	"to_unicode\(\'\-｡\?⒌\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。󠉗5.𞯛", %p)},	undef,	"to_unicode\(\'\-\。\?5\.\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏ς．-≮\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?ς．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏ς．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?ς．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏ς.-≮\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?ς\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏ς.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?ς\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏Σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?Σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏Σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?Σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_unicode\(\'\?σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏Σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?Σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏Σ．-≮\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?Σ．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏σ．-≮\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?σ．\-\≮\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𼎏σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_unicode\(\'\?σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡗ\x{08B8}\x{0719}．񔤔󠛙\x{0C4D}\x{FC3E}", %p)},	undef,	"to_unicode\(\'ꡗ\\u08B8\\u0719．\?\?\\u0C4D\\uFC3E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡗ\x{08B8}\x{0719}.񔤔󠛙\x{0C4D}\x{0643}\x{064A}", %p)},	undef,	"to_unicode\(\'ꡗ\\u08B8\\u0719\.\?\?\\u0C4D\\u0643\\u064A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐠰\x{08B7}𞤌𐫭。𐋦\x{17CD}𝩃", %p)},	"𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃",	"to_unicode\(\'𐠰\\u08B7\?𐫭\。𐋦\\u17CD𝩃\'\)\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", %p)},	"𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃",	"to_unicode\(\'xn\-\-dzb5191kezbrw47a\.xn\-\-p4e3841jz9tf\'\)\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃", %p)},	"𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃",	"to_unicode\(\'𐠰\\u08B7\?𐫭\.𐋦\\u17CD𝩃\'\)\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("₂㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'₂㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("₂㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'₂㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2246\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("₂㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'₂㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("₂㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'₂㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2248\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("2㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'2㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("2㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'2㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2250\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("2㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'2㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("2㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_unicode\(\'2㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ V2\ V3\ C1\ \[data\/IdnaTest\.txt\:2252\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("-𘊻．ᡮ\x{062D}-", %p)},	undef,	"to_unicode\(\'\-\?．ᡮ\\u062D\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("-𘊻.ᡮ\x{062D}-", %p)},	undef,	"to_unicode\(\'\-\?\.ᡮ\\u062D\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2256\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2258\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2260\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2262\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2264\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2266\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2268\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2270\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2274\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"꧐ӏ\x{1BAA}\x{08F6}.눵",	"to_unicode\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"꧐ӏ\x{1BAA}\x{08F6}.눵",	"to_unicode\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:2276\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--s5a04sn4u297k.xn--2e1b", %p)},	"꧐ӏ\x{1BAA}\x{08F6}.눵",	"to_unicode\(\'xn\-\-s5a04sn4u297k\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"꧐ӏ\x{1BAA}\x{08F6}.눵",	"to_unicode\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"꧐ӏ\x{1BAA}\x{08F6}.눵",	"to_unicode\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A8EA}｡𖄿𑆾󠇗", %p)},	undef,	"to_unicode\(\'\\uA8EA｡\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8EA}。𖄿𑆾󠇗", %p)},	undef,	"to_unicode\(\'\\uA8EA\。\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󇓓𑚳。񐷿≯⾇", %p)},	undef,	"to_unicode\(\'\?𑚳\。\?\≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󇓓𑚳。񐷿>\x{0338}⾇", %p)},	undef,	"to_unicode\(\'\?𑚳\。\?\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󇓓𑚳。񐷿≯舛", %p)},	undef,	"to_unicode\(\'\?𑚳\。\?\≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󇓓𑚳。񐷿>\x{0338}舛", %p)},	undef,	"to_unicode\(\'\?𑚳\。\?\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫇\x{0661}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐫇\\u0661\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫇\x{0661}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐫇\\u0661\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2287\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫇\x{0661}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐫇\\u0661\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2288\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫇\x{0661}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐫇\\u0661\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2289\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--9hb7344k.", %p)},	"𐫇\x{0661}.",	"to_unicode\(\'xn\-\-9hb7344k\.\'\)\ \[data\/IdnaTest\.txt\:2290\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫇\x{0661}.", %p)},	"𐫇\x{0661}.",	"to_unicode\(\'𐫇\\u0661\.\'\)\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񡅈砪≯ᢑ｡≯𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\≯ᢑ｡\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪≯ᢑ｡≯𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\≯ᢑ｡\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪>\x{0338}ᢑ｡>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\>\\u0338ᢑ｡\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪>\x{0338}ᢑ｡>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\>\\u0338ᢑ｡\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪≯ᢑ。≯𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\≯ᢑ\。\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪≯ᢑ。≯𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\≯ᢑ\。\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪>\x{0338}ᢑ。>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\>\\u0338ᢑ\。\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񡅈砪>\x{0338}ᢑ。>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_unicode\(\'\?砪\>\\u0338ᢑ\。\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.𑄳㊸", %p)},	undef,	"to_unicode\(\'Ⴥ\.𑄳㊸\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.𑄳43", %p)},	undef,	"to_unicode\(\'Ⴥ\.𑄳43\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ⴥ.𑄳43", %p)},	undef,	"to_unicode\(\'ⴥ\.𑄳43\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ⴥ.𑄳㊸", %p)},	undef,	"to_unicode\(\'ⴥ\.𑄳㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟎\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_unicode\(\'𝟎\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_unicode\(\'0\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("0\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_unicode\(\'0\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𝟎\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_unicode\(\'𝟎\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񗪨󠄉\x{FFA0}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_unicode\(\'\?\󠄉\\uFFA0\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗪨󠄉\x{1160}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_unicode\(\'\?\󠄉\\u1160\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0618}.۳\x{200C}\x{A953}", %p)},	undef,	"to_unicode\(\'\\u0618\.۳\\u200C\\uA953\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0618}.۳\x{200C}\x{A953}", %p)},	undef,	"to_unicode\(\'\\u0618\.۳\\u200C\\uA953\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2311\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡌ．︒ᢑ", %p)},	undef,	"to_unicode\(\'ᡌ．︒ᢑ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡌ.。ᢑ", %p)},	undef,	"to_unicode\(\'ᡌ\.\。ᢑ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪\x{1073}｡𞽧", %p)},	undef,	"to_unicode\(\'𑋪\\u1073｡\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪\x{1073}。𞽧", %p)},	undef,	"to_unicode\(\'𑋪\\u1073\。\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞷏。ᠢ򓘆", %p)},	undef,	"to_unicode\(\'\?\。ᠢ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄳㴼．\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_unicode\(\'𑄳㴼．\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄳㴼．\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_unicode\(\'𑄳㴼．\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄳㴼.\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_unicode\(\'𑄳㴼\.\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄳㴼.\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_unicode\(\'𑄳㴼\.\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񠻟𐹳𑈯｡\x{031D}", %p)},	undef,	"to_unicode\(\'\?𐹳𑈯｡\\u031D\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񠻟𐹳𑈯。\x{031D}", %p)},	undef,	"to_unicode\(\'\?𐹳𑈯\。\\u031D\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_unicode\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_unicode\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥≠｡𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\≠｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥≠｡𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\≠｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥=\x{0338}｡𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\=\\u0338｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥=\x{0338}｡𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\=\\u0338｡𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥≠。𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\≠\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥≠。𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\≠\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥=\x{0338}。𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\=\\u0338\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥=\x{0338}。𐋲󠧠\x{200C}", %p)},	undef,	"to_unicode\(\'𐹥\=\\u0338\。𐋲\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}񙯠\x{094D}．\x{200D}\x{A953}𐪤", %p)},	undef,	"to_unicode\(\'\\u115F\?\\u094D．\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}񙯠\x{094D}．\x{200D}\x{A953}𐪤", %p)},	undef,	"to_unicode\(\'\\u115F\?\\u094D．\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}񙯠\x{094D}.\x{200D}\x{A953}𐪤", %p)},	undef,	"to_unicode\(\'\\u115F\?\\u094D\.\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}񙯠\x{094D}.\x{200D}\x{A953}𐪤", %p)},	undef,	"to_unicode\(\'\\u115F\?\\u094D\.\\u200D\\uA953\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򌋔󠆎󠆗𑲕。≮", %p)},	undef,	"to_unicode\(\'\?\󠆎\󠆗\?\。\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򌋔󠆎󠆗𑲕。<\x{0338}", %p)},	undef,	"to_unicode\(\'\?\󠆎\󠆗\?\。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆦.\x{08E3}暀≠", %p)},	undef,	"to_unicode\(\'\󠆦\.\\u08E3暀\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆦.\x{08E3}暀=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠆦\.\\u08E3暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡤\x{ABED}｡\x{FD30}򜖅\x{1DF0}", %p)},	undef,	"to_unicode\(\'𐡤\\uABED｡\\uFD30\?\\u1DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡤\x{ABED}。\x{0634}\x{0645}򜖅\x{1DF0}", %p)},	undef,	"to_unicode\(\'𐡤\\uABED\。\\u0634\\u0645\?\\u1DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}⒈｡Ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D⒈｡Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}⒈｡Ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D⒈｡Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}1.。Ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D1\.\。Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}1.。Ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D1\.\。Ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}1.。ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D1\.\。ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}1.。ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D1\.\。ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}⒈｡ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D⒈｡ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝉃\x{200D}⒈｡ⴌ𞱓", %p)},	undef,	"to_unicode\(\'𝉃\\u200D⒈｡ⴌ\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣙\x{0A4D}𱫘𞤸.ς񵯞􈰔", %p)},	undef,	"to_unicode\(\'\?\\u0A4D\?\?\.ς\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣙\x{0A4D}𱫘𞤸.Σ񵯞􈰔", %p)},	undef,	"to_unicode\(\'\?\\u0A4D\?\?\.Σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣙\x{0A4D}𱫘𞤸.σ񵯞􈰔", %p)},	undef,	"to_unicode\(\'\?\\u0A4D\?\?\.σ\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D3}。\x{200C}𐫀򞭱", %p)},	undef,	"to_unicode\(\'\\u07D3\。\\u200C𐫀\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D3}。\x{200C}𐫀򞭱", %p)},	undef,	"to_unicode\(\'\\u07D3\。\\u200C𐫀\?\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2355\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{1C2E}𞀝.\x{05A6}ꡟ𞤕󠆖", %p)},	undef,	"to_unicode\(\'\\u1C2E\?\.\\u05A6ꡟ\?\󠆖\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䂹󾖅𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\?𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹󾖅𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\?𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹󾖅𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\?𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹󾖅𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\?𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}𐹲\x{200C}｡\x{0767}🄉", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C𐹲\\u200C｡\\u0767🄉\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}𐹲\x{200C}｡\x{0767}🄉", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C𐹲\\u200C｡\\u0767🄉\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}𐹲\x{200C}。\x{0767}8,", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C𐹲\\u200C\。\\u07678\,\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ B3\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200C}𐹲\x{200C}。\x{0767}8,", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200C𐹲\\u200C\。\\u07678\,\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ B3\ \[data\/IdnaTest\.txt\:2364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮｡󠢼\x{200D}", %p)},	undef,	"to_unicode\(\'𐹮｡\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮｡󠢼\x{200D}", %p)},	undef,	"to_unicode\(\'𐹮｡\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮。󠢼\x{200D}", %p)},	undef,	"to_unicode\(\'𐹮\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮。󠢼\x{200D}", %p)},	undef,	"to_unicode\(\'𐹮\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹨｡︒\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹨｡︒\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹨｡︒\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹨｡︒\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹨。。\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹨\。\。\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹨。。\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹨\。\。\\u077D\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2380\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴞ𐹨。。\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹨\。\。\\u077D\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2381\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴞ𐹨。。\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹨\。\。\\u077D\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2382\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ⴞ𐹨｡︒\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹨｡︒\\u077D\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𐹨｡︒\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹨｡︒\\u077D\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2388\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2390\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2391\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2392\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("箃Ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07E5}.\x{06B5}", %p)},	"\x{07E5}.\x{06B5}",	"to_unicode\(\'\\u07E5\.\\u06B5\'\)\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--dtb.xn--okb", %p)},	"\x{07E5}.\x{06B5}",	"to_unicode\(\'xn\-\-dtb\.xn\-\-okb\'\)\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}\x{200D}.𞤿", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.\?\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}\x{200D}.𞤿", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.\?\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2404\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--3e6h", %p)},	"𞤿",	"to_unicode\(\'xn\-\-3e6h\'\)\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤿", %p)},	"𞤿",	"to_unicode\(\'\?\'\)\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🜑𐹧\x{0639}.ς𑍍蜹", %p)},	undef,	"to_unicode\(\'🜑𐹧\\u0639\.ς𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🜑𐹧\x{0639}.Σ𑍍蜹", %p)},	undef,	"to_unicode\(\'🜑𐹧\\u0639\.Σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🜑𐹧\x{0639}.σ𑍍蜹", %p)},	undef,	"to_unicode\(\'🜑𐹧\\u0639\.σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򫠐ス􆟤\x{0669}．󚃟", %p)},	undef,	"to_unicode\(\'\?ス\?\\u0669．\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򫠐ス􆟤\x{0669}.󚃟", %p)},	undef,	"to_unicode\(\'\?ス\?\\u0669\.\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪣򕡝．\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_unicode\(\'𝪣\?．\\u059A\\uD850\\u06C2\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪣򕡝．\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_unicode\(\'𝪣\?．\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪣򕡝.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_unicode\(\'𝪣\?\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪣򕡝.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_unicode\(\'𝪣\?\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}򪓵\x{200C}。\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0660\?\\u200C\。\\u0757\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}򪓵\x{200C}。\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0660\?\\u200C\。\\u0757\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2417\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{103A}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u103A\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{103A}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u103A\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2419\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒｡\x{1B44}ᡉ", %p)},	undef,	"to_unicode\(\'︒｡\\u1B44ᡉ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("。。\x{1B44}ᡉ", %p)},	undef,	"to_unicode\(\'\。\。\\u1B44ᡉ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2421\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}ß。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_unicode\(\'\\u0758ß\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}ß。ጫᢊ\x{0768}2", %p)},	undef,	"to_unicode\(\'\\u0758ß\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2423\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}SS。ጫᢊ\x{0768}2", %p)},	undef,	"to_unicode\(\'\\u0758SS\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_unicode\(\'\\u0758ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2425\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}Ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_unicode\(\'\\u0758Ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}SS。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_unicode\(\'\\u0758SS\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2427\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_unicode\(\'\\u0758ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0758}Ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_unicode\(\'\\u0758Ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2429\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}𝟚\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u07C3\?ᚲ\.\\u0902\\u0353𝟚\\u09CD\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}2\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u07C3\?ᚲ\.\\u0902\\u03532\\u09CD\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1BAB}︒\x{200D}.񒶈񥹓", %p)},	undef,	"to_unicode\(\'\-\\u1BAB︒\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1BAB}︒\x{200D}.񒶈񥹓", %p)},	undef,	"to_unicode\(\'\-\\u1BAB︒\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1BAB}。\x{200D}.񒶈񥹓", %p)},	undef,	"to_unicode\(\'\-\\u1BAB\。\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1BAB}。\x{200D}.񒶈񥹓", %p)},	undef,	"to_unicode\(\'\-\\u1BAB\。\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠦮.≯𞀆", %p)},	undef,	"to_unicode\(\'\?\.\≯\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠦮.>\x{0338}𞀆", %p)},	undef,	"to_unicode\(\'\?\.\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𑄳󠊗𐹩。𞮱", %p)},	undef,	"to_unicode\(\'\-𑄳\?𐹩\。\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B9}．ᡳ\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06B9．ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B9}.ᡳ\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06B9\.ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛𘱎.︒𝟕\x{0D01}", %p)},	undef,	"to_unicode\(\'㨛\?\.︒𝟕\\u0D01\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛𘱎.。7\x{0D01}", %p)},	undef,	"to_unicode\(\'㨛\?\.\。7\\u0D01\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06DD}𻱧-｡𞷁\x{2064}𞤣≮", %p)},	undef,	"to_unicode\(\'\\u06DD\?\-｡\?\\u2064\?\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06DD}𻱧-｡𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u06DD\?\-｡\?\\u2064\?\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06DD}𻱧-。𞷁\x{2064}𞤣≮", %p)},	undef,	"to_unicode\(\'\\u06DD\?\-\。\?\\u2064\?\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06DD}𻱧-。𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u06DD\?\-\。\?\\u2064\?\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2450\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2451\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2452\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2454\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ss\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2455\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ss\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2456\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ss\x{200C}\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2458\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--ss-4epx629f.xn--ifh802b6a", %p)},	"ss\x{AAF6}ᢥ.⊶ⴡⴖ",	"to_unicode\(\'xn\-\-ss\-4epx629f\.xn\-\-ifh802b6a\'\)\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ss\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"ss\x{AAF6}ᢥ.⊶ⴡⴖ",	"to_unicode\(\'ss\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:2460\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2462\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ß\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2464\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2466\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ss\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ss\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2468\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ss\x{200C}\x{AAF6}ᢥ．⊶Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uAAF6ᢥ．\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{AAF6}ᢥ．⊶Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uAAF6ᢥ．\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ󠁉", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑ß.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?ß\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑ß.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?ß\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑SS.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?SS\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑SS.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?SS\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑Ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?Ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵑Ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_unicode\(\'\?Ss\.\\u0751\\u200D\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑘽\x{200D}𞤧．𐹧󡦪-", %p)},	undef,	"to_unicode\(\'𑘽\\u200D\?．𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑘽\x{200D}𞤧．𐹧󡦪-", %p)},	undef,	"to_unicode\(\'𑘽\\u200D\?．𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑘽\x{200D}𞤧.𐹧󡦪-", %p)},	undef,	"to_unicode\(\'𑘽\\u200D\?\.𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑘽\x{200D}𞤧.𐹧󡦪-", %p)},	undef,	"to_unicode\(\'𑘽\\u200D\?\.𐹧\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒒򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_unicode\(\'⒒\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("11.򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_unicode\(\'11\.\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ򔠼񁗶｡𐨬𝟠", %p)},	undef,	"to_unicode\(\'ቬ\?\?｡𐨬𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ򔠼񁗶。𐨬8", %p)},	undef,	"to_unicode\(\'ቬ\?\?\。𐨬8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱲。蔫\x{0766}", %p)},	undef,	"to_unicode\(\'\?\。蔫\\u0766\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒲧₃｡ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_unicode\(\'\?₃｡ꡚ\?\󠄳\\u0647\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒲧3。ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_unicode\(\'\?3\。ꡚ\?\󠄳\\u0647\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蓸\x{0642}≠.ß", %p)},	undef,	"to_unicode\(\'蓸\\u0642\≠\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蓸\x{0642}=\x{0338}.ß", %p)},	undef,	"to_unicode\(\'蓸\\u0642\=\\u0338\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蓸\x{0642}=\x{0338}.SS", %p)},	undef,	"to_unicode\(\'蓸\\u0642\=\\u0338\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蓸\x{0642}≠.SS", %p)},	undef,	"to_unicode\(\'蓸\\u0642\≠\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}\x{067A}\x{0DD3}⒊.𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_unicode\(\'\\u084E\\u067A\\u0DD3⒊\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}\x{067A}\x{0DD3}⒊.𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_unicode\(\'\\u084E\\u067A\\u0DD3⒊\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}\x{067A}\x{0DD3}3..𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_unicode\(\'\\u084E\\u067A\\u0DD33\.\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{084E}\x{067A}\x{0DD3}3..𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_unicode\(\'\\u084E\\u067A\\u0DD33\.\.𐹹\?\?\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2521\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2523\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2525\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2527\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠。🞳𝟲", %p)},	undef,	"to_unicode\(\'\≠\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。🞳𝟲", %p)},	undef,	"to_unicode\(\'\=\\u0338\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。🞳6", %p)},	undef,	"to_unicode\(\'\≠\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。🞳6", %p)},	undef,	"to_unicode\(\'\=\\u0338\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󅬽.蠔", %p)},	undef,	"to_unicode\(\'\?\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2534\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2536\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2538\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2540\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₇\x{0BCD}􃂷\x{06D2}。👖\x{0675}-𞪑", %p)},	undef,	"to_unicode\(\'₇\\u0BCD\?\\u06D2\。👖\\u0675\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7\x{0BCD}􃂷\x{06D2}。👖\x{0627}\x{0674}-𞪑", %p)},	undef,	"to_unicode\(\'7\\u0BCD\?\\u06D2\。👖\\u0627\\u0674\-\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-｡\x{077B}", %p)},	undef,	"to_unicode\(\'\-｡\\u077B\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-。\x{077B}", %p)},	undef,	"to_unicode\(\'\-\。\\u077B\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2544\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑇌𵛓｡-⒈ꡏ\x{072B}", %p)},	undef,	"to_unicode\(\'𑇌\?｡\-⒈ꡏ\\u072B\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑇌𵛓。-1.ꡏ\x{072B}", %p)},	undef,	"to_unicode\(\'𑇌\?\。\-1\.ꡏ\\u072B\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璛\x{1734}\x{06AF}.-", %p)},	undef,	"to_unicode\(\'璛\\u1734\\u06AF\.\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_unicode\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_unicode\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_unicode\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_unicode\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񍨽．񋸕", %p)},	undef,	"to_unicode\(\'\?．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񍨽.񋸕", %p)},	undef,	"to_unicode\(\'\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067D}𞥕｡𑑂𞤶Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u067D\?｡\?\?Ⴍ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067D}𞥕。𑑂𞤶Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u067D\?\。\?\?Ⴍ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2555\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{067D}𞥕。𑑂𞤶ⴍ-", %p)},	undef,	"to_unicode\(\'\\u067D\?\。\?\?ⴍ\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{067D}𞥕｡𑑂𞤶ⴍ-", %p)},	undef,	"to_unicode\(\'\\u067D\?｡\?\?ⴍ\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2557\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐯀𐸉𞧏。񢚧₄Ⴋ񂹫", %p)},	undef,	"to_unicode\(\'\?\?\?\。\?₄Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯀𐸉𞧏。񢚧4Ⴋ񂹫", %p)},	undef,	"to_unicode\(\'\?\?\?\。\?4Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯀𐸉𞧏。񢚧4ⴋ񂹫", %p)},	undef,	"to_unicode\(\'\?\?\?\。\?4ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯀𐸉𞧏。񢚧₄ⴋ񂹫", %p)},	undef,	"to_unicode\(\'\?\?\?\。\?₄ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{06BD}︒󠑥.≠", %p)},	undef,	"to_unicode\(\'4\\u06BD︒\?\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{06BD}︒󠑥.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u06BD︒\?\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{06BD}。󠑥.≠", %p)},	undef,	"to_unicode\(\'4\\u06BD\。\?\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{06BD}。󠑥.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u06BD\。\?\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓。\x{06D7}", %p)},	undef,	"to_unicode\(\'𝟓\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5。\x{06D7}", %p)},	undef,	"to_unicode\(\'5\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򺸩.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\?\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򺸩.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\?\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򺸩.谷", %p)},	undef,	"to_unicode\(\'\\u200C\?\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򺸩.谷", %p)},	undef,	"to_unicode\(\'\\u200C\?\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_unicode\(\'\。\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_unicode\(\'\。\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𞤟。ᡨ", %p)},	undef,	"to_unicode\(\'\≯\?\。ᡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𞤟。ᡨ", %p)},	undef,	"to_unicode\(\'\>\\u0338\?\。ᡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("\x{0F74}𫫰𝨄。\x{0713}𐹦", %p)},	undef,	"to_unicode\(\'\\u0F74𫫰𝨄\。\\u0713𐹦\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{033C}\x{07DB}⁷𝟹｡𝟬", %p)},	undef,	"to_unicode\(\'\\u033C\\u07DB⁷𝟹｡𝟬\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{033C}\x{07DB}73。0", %p)},	undef,	"to_unicode\(\'\\u033C\\u07DB73\。0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2580\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9", %p)},	"9",	"to_unicode\(\'9\'\)\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{0779}ᡭ𪕈。\x{06B6}\x{08D9}", %p)},	undef,	"to_unicode\(\'\\u0779ᡭ𪕈\。\\u06B6\\u08D9\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2586\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_unicode\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_unicode\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_unicode\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_unicode\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ𿣍ꡨ\x{05AE}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\?ꡨ\\u05AE\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ𿣍ꡨ\x{05AE}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\?ꡨ\\u05AE\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ𿣍ꡨ\x{05AE}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\?ꡨ\\u05AE\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ𿣍ꡨ\x{05AE}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\?ꡨ\\u05AE\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋰。󑓱", %p)},	undef,	"to_unicode\(\'𐋰\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󡎦\x{17B4}\x{0B4D}.𐹾", %p)},	undef,	"to_unicode\(\'\?\\u17B4\\u0B4D\.𐹾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_unicode\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0784}．𞡝\x{0601}", %p)},	undef,	"to_unicode\(\'\\u0784．𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0784}.𞡝\x{0601}", %p)},	undef,	"to_unicode\(\'\\u0784\.𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0ACD}₃.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_unicode\(\'\\u0ACD₃\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0ACD}3.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_unicode\(\'\\u0ACD3\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("℻⩷𝆆。𞤠󠆁\x{180C}", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'℻\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("FAX⩷𝆆。𞤠󠆁\x{180C}", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'FAX\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'fax\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("Fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'Fax\⩷𝆆\。\?\󠆁\\u180C\'\)\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--fax-4c9a1676t.xn--6e6h", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'xn\-\-fax\-4c9a1676t\.xn\-\-6e6h\'\)\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("fax⩷𝆆.𞥂", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'fax\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("FAX⩷𝆆.𞥂", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'FAX\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("Fax⩷𝆆.𞥂", %p)},	"fax⩷𝆆.𞥂",	"to_unicode\(\'Fax\⩷𝆆\.\?\'\)\ \[data\/IdnaTest\.txt\:2616\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡕ≠\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡕ\≠\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ=\x{0338}\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡕ\=\\u0338\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ≠\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_unicode\(\'ꡕ\≠\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ=\x{0338}\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_unicode\(\'ꡕ\=\\u0338\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--rt6a.", %p)},	"鱊.",	"to_unicode\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊.", %p)},	"鱊.",	"to_unicode\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:2624\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("8𐹣．𑍨", %p)},	undef,	"to_unicode\(\'8𐹣．𑍨\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("8𐹣.𑍨", %p)},	undef,	"to_unicode\(\'8𐹣\.𑍨\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("⏹𐧀．𐫯", %p)},	undef,	"to_unicode\(\'\⏹𐧀．𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("⏹𐧀.𐫯", %p)},	undef,	"to_unicode\(\'\⏹𐧀\.𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺\x{07CC}4．\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CC4．\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2629\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺\x{07CC}4．\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CC4．\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2630\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺\x{07CC}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CC4\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2631\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺\x{07CC}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CC4\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2632\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--4-0bd15808a.", %p)},	"𞤺\x{07CC}4.",	"to_unicode\(\'xn\-\-4\-0bd15808a\.\'\)\ \[data\/IdnaTest\.txt\:2633\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺\x{07CC}4.", %p)},	"𞤺\x{07CC}4.",	"to_unicode\(\'\?\\u07CC4\.\'\)\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒗\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_unicode\(\'⒗\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("16.\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_unicode\(\'16\.\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡䏛", %p)},	undef,	"to_unicode\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。䏛", %p)},	undef,	"to_unicode\(\'\-\。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񒃠．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񒃠．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񒃠.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񒃠.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈⓰󥣇｡𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_unicode\(\'⒈⓰\?｡𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈⓰󥣇｡𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_unicode\(\'⒈⓰\?｡𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.⓰󥣇。𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_unicode\(\'1\.⓰\?\。𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.⓰󥣇。𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_unicode\(\'1\.⓰\?\。𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.⓰󥣇。𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_unicode\(\'1\.⓰\?\。𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.⓰󥣇。𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_unicode\(\'1\.⓰\?\。𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈⓰󥣇｡𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_unicode\(\'⒈⓰\?｡𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈⓰󥣇｡𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_unicode\(\'⒈⓰\?｡𐹠\\u200D\?ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-ß｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-ß｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-ß。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-ß\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-SS。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-SS\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-Ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-Ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-SS｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-SS｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠊ᠮ-Ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_unicode\(\'𞠊ᠮ\-Ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑇀.󠨱", %p)},	undef,	"to_unicode\(\'𑇀\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("␒3\x{FB88}｡𝟘𐨿𐹆", %p)},	undef,	"to_unicode\(\'\␒3\\uFB88｡𝟘𐨿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("␒3\x{0688}。0𐨿𐹆", %p)},	undef,	"to_unicode\(\'\␒3\\u0688\。0𐨿\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{076B}６\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_unicode\(\'\\u076B６\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{076B}6\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_unicode\(\'\\u076B6\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0605}-𽤞Ⴂ。򅤶\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0605\-\?Ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0605}-𽤞Ⴂ。򅤶\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0605\-\?Ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0605}-𽤞ⴂ。򅤶\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0605\-\?ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0605}-𽤞ⴂ。򅤶\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0605\-\?ⴂ\。\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５≯ß", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５>\x{0338}ß", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5≯ß", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5>\x{0338}ß", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5>\x{0338}SS", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5≯SS", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5≯ss", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5>\x{0338}ss", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.ꡈ5≯Ss", %p)},	undef,	"to_unicode\(\'舌\.ꡈ5\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５>\x{0338}SS", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５≯SS", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５≯ss", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５>\x{0338}ss", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．ꡈ５≯Ss", %p)},	undef,	"to_unicode\(\'⾆．ꡈ５\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}8\x{200D}．򾂈\x{075C}", %p)},	undef,	"to_unicode\(\'\\u0ACD8\\u200D．\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}8\x{200D}．򾂈\x{075C}", %p)},	undef,	"to_unicode\(\'\\u0ACD8\\u200D．\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}8\x{200D}.򾂈\x{075C}", %p)},	undef,	"to_unicode\(\'\\u0ACD8\\u200D\.\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}8\x{200D}.򾂈\x{075C}", %p)},	undef,	"to_unicode\(\'\\u0ACD8\\u200D\.\?\\u075C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸷆\x{0A70}≮򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_unicode\(\'\?\\u0A70\≮\?．\?⁷\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸷆\x{0A70}<\x{0338}򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_unicode\(\'\?\\u0A70\<\\u0338\?．\?⁷\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸷆\x{0A70}≮򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_unicode\(\'\?\\u0A70\≮\?\.\?7\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸷆\x{0A70}<\x{0338}򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_unicode\(\'\?\\u0A70\<\\u0338\?\.\?7\?\\u06B6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2691\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤪.ς", %p)},	"𞤪.ς",	"to_unicode\(\'\?\.ς\'\)\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤪.ς", %p)},	"𞤪.ς",	"to_unicode\(\'\?\.ς\'\)\ \[data\/IdnaTest\.txt\:2693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤪.Σ", %p)},	"𞤪.σ",	"to_unicode\(\'\?\.Σ\'\)\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤪.σ", %p)},	"𞤪.σ",	"to_unicode\(\'\?\.σ\'\)\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--ie6h.xn--4xa", %p)},	"𞤪.σ",	"to_unicode\(\'xn\-\-ie6h\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--ie6h.xn--3xa", %p)},	"𞤪.ς",	"to_unicode\(\'xn\-\-ie6h\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2701\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2703\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2705\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2706\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--4xa", %p)},	"ⴚ.σ",	"to_unicode\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2708\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.σ", %p)},	"ⴚ.σ",	"to_unicode\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.Σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2712\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.ς", %p)},	undef,	"to_unicode\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--3xa", %p)},	"ⴚ.ς",	"to_unicode\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2717\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2719\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2721\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤃．𐹦", %p)},	undef,	"to_unicode\(\'\?．𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤃.𐹦", %p)},	undef,	"to_unicode\(\'\?\.𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0310}\x{A953}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0310\\uA953ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0310}\x{A953}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0310\\uA953ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2725\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2727\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2729\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2731\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔．\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2733\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2735\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06AA\-뉔\.\?\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2737\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񔲵５ᦛς.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_unicode\(\'\?５ᦛς\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵５ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?５ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵5ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?5ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵5ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?5ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵5ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?5ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_unicode\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_unicode\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_unicode\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("淽。ᠾ", %p)},	"淽.ᠾ",	"to_unicode\(\'淽\。ᠾ\'\)\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--34w.xn--x7e", %p)},	"淽.ᠾ",	"to_unicode\(\'xn\-\-34w\.xn\-\-x7e\'\)\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("淽.ᠾ", %p)},	"淽.ᠾ",	"to_unicode\(\'淽\.ᠾ\'\)\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐹴𑘷。-", %p)},	undef,	"to_unicode\(\'𐹴𑘷\。\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򬨩Ⴓ❓｡𑄨", %p)},	undef,	"to_unicode\(\'\?Ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򬨩Ⴓ❓。𑄨", %p)},	undef,	"to_unicode\(\'\?Ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򬨩ⴓ❓。𑄨", %p)},	undef,	"to_unicode\(\'\?ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򬨩ⴓ❓｡𑄨", %p)},	undef,	"to_unicode\(\'\?ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2758\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2760\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2762\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2764\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2766\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2768\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2770\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200C}𐹡𞤌ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2772\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹡𞤌Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C𐹡\?Ⴇ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17FF}｡𞬳", %p)},	undef,	"to_unicode\(\'\\u17FF｡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17FF}。𞬳", %p)},	undef,	"to_unicode\(\'\\u17FF\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2776\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0652}\x{200D}｡\x{0CCD}𑚳", %p)},	undef,	"to_unicode\(\'\\u0652\\u200D｡\\u0CCD𑚳\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0652}\x{200D}｡\x{0CCD}𑚳", %p)},	undef,	"to_unicode\(\'\\u0652\\u200D｡\\u0CCD𑚳\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2778\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0652}\x{200D}。\x{0CCD}𑚳", %p)},	undef,	"to_unicode\(\'\\u0652\\u200D\。\\u0CCD𑚳\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0652}\x{200D}。\x{0CCD}𑚳", %p)},	undef,	"to_unicode\(\'\\u0652\\u200D\。\\u0CCD𑚳\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2780\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-≠ᠻ．\x{076D}𞥃≮󟷺", %p)},	undef,	"to_unicode\(\'\-\≠ᠻ．\\u076D\?\≮\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}ᠻ．\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_unicode\(\'\-\=\\u0338ᠻ．\\u076D\?\<\\u0338\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠ᠻ.\x{076D}𞥃≮󟷺", %p)},	undef,	"to_unicode\(\'\-\≠ᠻ\.\\u076D\?\≮\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}ᠻ.\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_unicode\(\'\-\=\\u0338ᠻ\.\\u076D\?\<\\u0338\?\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠰆≯\x{07B5}𐻪．򊥕≮𑁆\x{084C}", %p)},	undef,	"to_unicode\(\'\?\≯\\u07B5\?．\?\≮𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠰆>\x{0338}\x{07B5}𐻪．򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_unicode\(\'\?\>\\u0338\\u07B5\?．\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠰆≯\x{07B5}𐻪.򊥕≮𑁆\x{084C}", %p)},	undef,	"to_unicode\(\'\?\≯\\u07B5\?\.\?\≮𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠰆>\x{0338}\x{07B5}𐻪.򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_unicode\(\'\?\>\\u0338\\u07B5\?\.\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_unicode\(\'\≠\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_unicode\(\'\=\\u0338\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17DD}󠁣≠｡𐹼𐋤", %p)},	undef,	"to_unicode\(\'\\u17DD\?\≠｡𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17DD}󠁣=\x{0338}｡𐹼𐋤", %p)},	undef,	"to_unicode\(\'\\u17DD\?\=\\u0338｡𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17DD}󠁣≠。𐹼𐋤", %p)},	undef,	"to_unicode\(\'\\u17DD\?\≠\。𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17DD}󠁣=\x{0338}。𐹼𐋤", %p)},	undef,	"to_unicode\(\'\\u17DD\?\=\\u0338\。𐹼𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𰀻񆬗｡𝩨🕮ß", %p)},	undef,	"to_unicode\(\'ß\?\?｡𝩨🕮ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𰀻񆬗。𝩨🕮ß", %p)},	undef,	"to_unicode\(\'ß\?\?\。𝩨🕮ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𰀻񆬗。𝩨🕮SS", %p)},	undef,	"to_unicode\(\'SS\?\?\。𝩨🕮SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𰀻񆬗。𝩨🕮ss", %p)},	undef,	"to_unicode\(\'ss\?\?\。𝩨🕮ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𰀻񆬗。𝩨🕮Ss", %p)},	undef,	"to_unicode\(\'Ss\?\?\。𝩨🕮Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𰀻񆬗｡𝩨🕮SS", %p)},	undef,	"to_unicode\(\'SS\?\?｡𝩨🕮SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𰀻񆬗｡𝩨🕮ss", %p)},	undef,	"to_unicode\(\'ss\?\?｡𝩨🕮ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𰀻񆬗｡𝩨🕮Ss", %p)},	undef,	"to_unicode\(\'Ss\?\?｡𝩨🕮Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0483}𐭞\x{200D}.\x{17B9}𞯌򟩚", %p)},	undef,	"to_unicode\(\'\\u0483𐭞\\u200D\.\\u17B9\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0483}𐭞\x{200D}.\x{17B9}𞯌򟩚", %p)},	undef,	"to_unicode\(\'\\u0483𐭞\\u200D\.\\u17B9\?\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐠨\x{200C}临。ꡢ򄷞ⶏ𐹣", %p)},	undef,	"to_unicode\(\'\\u200C𐠨\\u200C临\。ꡢ\?ⶏ𐹣\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐠨\x{200C}临。ꡢ򄷞ⶏ𐹣", %p)},	undef,	"to_unicode\(\'\\u200C𐠨\\u200C临\。ꡢ\?ⶏ𐹣\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠑘．󠄮", %p)},	undef,	"to_unicode\(\'\?．\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠑘.󠄮", %p)},	undef,	"to_unicode\(\'\?\.\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫄\x{0D4D}．\x{AAF6}", %p)},	undef,	"to_unicode\(\'𐫄\\u0D4D．\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2811\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫄\x{0D4D}.\x{AAF6}", %p)},	undef,	"to_unicode\(\'𐫄\\u0D4D\.\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_unicode\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_unicode\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_unicode\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_unicode\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_unicode\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_unicode\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_unicode\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_unicode\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_unicode\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_unicode\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_unicode\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_unicode\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{076D}．₄", %p)},	undef,	"to_unicode\(\'\≯\\u076D．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{076D}．₄", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u076D．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{076D}.4", %p)},	undef,	"to_unicode\(\'\≯\\u076D\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{076D}.4", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u076D\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡲ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡲ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FD08}𝟦\x{0647}󎊯｡Ӏ", %p)},	undef,	"to_unicode\(\'\\uFD08𝟦\\u0647\?｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0636}\x{064A}4\x{0647}󎊯。Ӏ", %p)},	undef,	"to_unicode\(\'\\u0636\\u064A4\\u0647\?\。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0636}\x{064A}4\x{0647}󎊯。ӏ", %p)},	undef,	"to_unicode\(\'\\u0636\\u064A4\\u0647\?\。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FD08}𝟦\x{0647}󎊯｡ӏ", %p)},	undef,	"to_unicode\(\'\\uFD08𝟦\\u0647\?｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{0602}\x{0622}𑆾🐹", %p)},	undef,	"to_unicode\(\'\-\.\\u0602\\u0622𑆾🐹\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{0602}\x{0627}\x{0653}𑆾🐹", %p)},	undef,	"to_unicode\(\'\-\.\\u0602\\u0627\\u0653𑆾🐹\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙶜ᢘ。\x{1A7F}⺢", %p)},	undef,	"to_unicode\(\'\?ᢘ\。\\u1A7F⺢\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0667}.𐥨", %p)},	undef,	"to_unicode\(\'\\u0667\.\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}𝟯｡\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uA9C0𝟯｡\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}𝟯｡\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uA9C0𝟯｡\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}3。\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uA9C03\。\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}3。\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\uA9C03\。\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򣕄4񠖽.≯\x{0664}𑀾󠸌", %p)},	undef,	"to_unicode\(\'\?4\?\.\≯\\u0664𑀾\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򣕄4񠖽.>\x{0338}\x{0664}𑀾󠸌", %p)},	undef,	"to_unicode\(\'\?4\?\.\>\\u0338\\u0664𑀾\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗆧𝟯。⒈\x{1A76}𝟚򠘌", %p)},	undef,	"to_unicode\(\'\?𝟯\。⒈\\u1A76𝟚\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗆧3。1.\x{1A76}2򠘌", %p)},	undef,	"to_unicode\(\'\?3\。1\.\\u1A762\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}．򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086．\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}．򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086．\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}．򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086．\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}．򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086．\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}.򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086\.\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}.򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086\.\?\\u072F\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}.򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086\.\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ\x{0697}\x{1086}.򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'ꡰ\\u0697\\u1086\.\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄱｡򪌿𐹵", %p)},	undef,	"to_unicode\(\'𑄱｡\?𐹵\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄱。򪌿𐹵", %p)},	undef,	"to_unicode\(\'𑄱\。\?𐹵\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟥\x{0600}。\x{073D}", %p)},	undef,	"to_unicode\(\'𝟥\\u0600\。\\u073D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3\x{0600}。\x{073D}", %p)},	undef,	"to_unicode\(\'3\\u0600\。\\u073D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_unicode\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_unicode\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒Ↄ\x{2DE7}򾀃．Ⴗ𐣞", %p)},	undef,	"to_unicode\(\'︒Ↄ\\u2DE7\?．Ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ↄ\x{2DE7}򾀃.Ⴗ𐣞", %p)},	undef,	"to_unicode\(\'\。Ↄ\\u2DE7\?\.Ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ↄ\x{2DE7}򾀃.ⴗ𐣞", %p)},	undef,	"to_unicode\(\'\。ↄ\\u2DE7\?\.ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ↄ\x{2DE7}򾀃．ⴗ𐣞", %p)},	undef,	"to_unicode\(\'︒ↄ\\u2DE7\?．ⴗ\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}.\x{05B1}", %p)},	undef,	"to_unicode\(\'\\u0600\.\\u05B1\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯｡𐹽", %p)},	undef,	"to_unicode\(\'ς\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}｡𐹽", %p)},	undef,	"to_unicode\(\'ς\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯。𐹽", %p)},	undef,	"to_unicode\(\'ς\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}。𐹽", %p)},	undef,	"to_unicode\(\'ς\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}。𐹽", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯。𐹽", %p)},	undef,	"to_unicode\(\'Σ\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯。𐹽", %p)},	undef,	"to_unicode\(\'σ\≯\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}。𐹽", %p)},	undef,	"to_unicode\(\'σ\>\\u0338\。𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}｡𐹽", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯｡𐹽", %p)},	undef,	"to_unicode\(\'Σ\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯｡𐹽", %p)},	undef,	"to_unicode\(\'σ\≯｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}｡𐹽", %p)},	undef,	"to_unicode\(\'σ\>\\u0338｡𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2915\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{17D2}\x{200D}\x{075F}。𐹶", %p)},	undef,	"to_unicode\(\'\\u17D2\\u200D\\u075F\。𐹶\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𾷂\x{0A42}Ⴊ񂂟.≮", %p)},	undef,	"to_unicode\(\'\?\\u0A42Ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾷂\x{0A42}Ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_unicode\(\'\?\\u0A42Ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾷂\x{0A42}ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_unicode\(\'\?\\u0A42ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾷂\x{0A42}ⴊ񂂟.≮", %p)},	undef,	"to_unicode\(\'\?\\u0A42ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡠ．۲", %p)},	"ꡠ.۲",	"to_unicode\(\'ꡠ．۲\'\)\ \[data\/IdnaTest\.txt\:2921\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡠ.۲", %p)},	"ꡠ.۲",	"to_unicode\(\'ꡠ\.۲\'\)\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--5c9a.xn--fmb", %p)},	"ꡠ.۲",	"to_unicode\(\'xn\-\-5c9a\.xn\-\-fmb\'\)\ \[data\/IdnaTest\.txt\:2923\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹣񄷄｡ꡬ🄄", %p)},	undef,	"to_unicode\(\'𐹣\?｡ꡬ🄄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹣񄷄。ꡬ3,", %p)},	undef,	"to_unicode\(\'𐹣\?\。ꡬ3\,\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0C4D}𞾀𑲓｡\x{200D}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\-\\u0C4D\?\?｡\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0C4D}𞾀𑲓｡\x{200D}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\-\\u0C4D\?\?｡\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0C4D}𞾀𑲓。\x{200D}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\-\\u0C4D\?\?\。\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0C4D}𞾀𑲓。\x{200D}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\-\\u0C4D\?\?\。\\u200D\\u0D4D\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣5,。\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣5\,\。\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A67D}\x{200C}霣5,。\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_unicode\(\'\\uA67D\\u200C霣5\,\。\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("兎｡ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_unicode\(\'兎｡ᠼ\?𑚶\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("兎。ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_unicode\(\'兎\。ᠼ\?𑚶\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.27", %p)},	"1.27",	"to_unicode\(\'1\.27\'\)\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡨ-｡󠻋𝟷", %p)},	undef,	"to_unicode\(\'ᡨ\-｡\?𝟷\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡨ-。󠻋1", %p)},	undef,	"to_unicode\(\'ᡨ\-\。\?1\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰻񵀐𐫚．\x{0668}⁹", %p)},	undef,	"to_unicode\(\'\?\?𐫚．\\u0668⁹\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰻񵀐𐫚.\x{0668}9", %p)},	undef,	"to_unicode\(\'\?\?𐫚\.\\u06689\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ򈷭\x{0F80}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\?\\u0F80⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ򈷭\x{0F80}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\?\\u0F80⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ򈷭\x{0F80}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\?\\u0F80舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ򈷭\x{0F80}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ\?\\u0F80舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ򈷭\x{0F80}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\?\\u0F80舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ򈷭\x{0F80}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\?\\u0F80舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ򈷭\x{0F80}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\?\\u0F80⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ򈷭\x{0F80}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ\?\\u0F80⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2954\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𑁆𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'𑁆𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𑁆𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'𑁆𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2956\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𑁆4.\x{200D}", %p)},	undef,	"to_unicode\(\'𑁆4\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𑁆4.\x{200D}", %p)},	undef,	"to_unicode\(\'𑁆4\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2958\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󚀅-\x{0BCD}。\x{06B9}", %p)},	undef,	"to_unicode\(\'\?\-\\u0BCD\。\\u06B9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡃ𝟧≯ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_unicode\(\'ᡃ𝟧\≯ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡃ𝟧>\x{0338}ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_unicode\(\'ᡃ𝟧\>\\u0338ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡃ5≯ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_unicode\(\'ᡃ5\≯ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡃ5>\x{0338}ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_unicode\(\'ᡃ5\>\\u0338ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𐹬𝩇．\x{0F76}", %p)},	undef,	"to_unicode\(\'𐹬𝩇．\\u0F76\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𐹬𝩇．\x{0FB2}\x{0F80}", %p)},	undef,	"to_unicode\(\'𐹬𝩇．\\u0FB2\\u0F80\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𐹬𝩇.\x{0FB2}\x{0F80}", %p)},	undef,	"to_unicode\(\'𐹬𝩇\.\\u0FB2\\u0F80\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2982\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-𑈶⒏．⒎𰛢󠎭", %p)},	undef,	"to_unicode\(\'\-𑈶⒏．⒎\?\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𑈶8..7.𰛢󠎭", %p)},	undef,	"to_unicode\(\'\-𑈶8\.\.7\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡𐹻≯󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡𐹻≯󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。𐹻≯󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。𐹻≯󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。𐹻\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ECB}\x{200D}．鎁󠰑", %p)},	undef,	"to_unicode\(\'\\u0ECB\\u200D．鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ECB}\x{200D}．鎁󠰑", %p)},	undef,	"to_unicode\(\'\\u0ECB\\u200D．鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ECB}\x{200D}.鎁󠰑", %p)},	undef,	"to_unicode\(\'\\u0ECB\\u200D\.鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ECB}\x{200D}.鎁󠰑", %p)},	undef,	"to_unicode\(\'\\u0ECB\\u200D\.鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}𞤀｡𱘅𐶃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\?｡\?\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}𞤀｡𱘅𐶃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\?｡\?\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}𞤀。𱘅𐶃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\?\。\?\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}𞤀。𱘅𐶃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\?\。\?\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠𝟫-.ς⒍𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠𝟫\-\.ς⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}𝟫-.ς⒍𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u0338𝟫\-\.ς⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠9-.ς6.𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠9\-\.ς6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}9-.ς6.𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u03389\-\.ς6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}9-.Σ6.𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u03389\-\.Σ6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠9-.Σ6.𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠9\-\.Σ6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠9-.σ6.𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠9\-\.σ6\.𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}9-.σ6.𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u03389\-\.σ6\.𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}𝟫-.Σ⒍𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u0338𝟫\-\.Σ⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠𝟫-.Σ⒍𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠𝟫\-\.Σ⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}≠𝟫-.σ⒍𐹦≠", %p)},	undef,	"to_unicode\(\'\\u0628\≠𝟫\-\.σ⒍𐹦\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0628}=\x{0338}𝟫-.σ⒍𐹦=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0628\=\\u0338𝟫\-\.σ⒍𐹦\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򉛴.-ᡢ\x{0592}𝨠", %p)},	undef,	"to_unicode\(\'\?\.\-ᡢ\\u0592𝨠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}⒈ß󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB⒈ß\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}1.ß󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB1\.ß\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}1.SS󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB1\.SS\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}1.ss󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB1\.ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}1.Ss󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB1\.Ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}⒈SS󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB⒈SS\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}⒈ss󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB⒈ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CB}⒈Ss󠄽。񷋍-", %p)},	undef,	"to_unicode\(\'\\u06CB⒈Ss\󠄽\。\?\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫.\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?\.\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𿀫．\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\?．\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆\x{08E2}.𝈴", %p)},	undef,	"to_unicode\(\'⾆\\u08E2\.𝈴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌\x{08E2}.𝈴", %p)},	undef,	"to_unicode\(\'舌\\u08E2\.𝈴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫞𐹶𖫴。⭠⒈", %p)},	undef,	"to_unicode\(\'\⫞𐹶𖫴\。\⭠⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⫞𐹶𖫴。⭠1.", %p)},	undef,	"to_unicode\(\'\⫞𐹶𖫴\。\⭠1\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒈\x{200C}\x{AAEC}︒．\x{0ACD}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\uAAEC︒．\\u0ACD\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{AAEC}︒．\x{0ACD}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\uAAEC︒．\\u0ACD\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3063\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("1.\x{200C}\x{AAEC}。.\x{0ACD}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\uAAEC\。\.\\u0ACD\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("1.\x{200C}\x{AAEC}。.\x{0ACD}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\uAAEC\。\.\\u0ACD\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3065\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0C46}。䰀\x{0668}𞭅󠅼", %p)},	undef,	"to_unicode\(\'\\u0C46\。䰀\\u0668\?\󠅼\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂\x{200C}≮.≮", %p)},	undef,	"to_unicode\(\'𑓂\\u200C\≮\.\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_unicode\(\'𑓂\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕼．\x{FFA0}", %p)},	undef,	"to_unicode\(\'🕼．\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕼.\x{1160}", %p)},	undef,	"to_unicode\(\'🕼\.\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡔ\x{FD82}。񷘎", %p)},	undef,	"to_unicode\(\'ᡔ\\uFD82\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡔ\x{0644}\x{062D}\x{0649}。񷘎", %p)},	undef,	"to_unicode\(\'ᡔ\\u0644\\u062D\\u0649\。\?\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕򳙑．𝟰気", %p)},	undef,	"to_unicode\(\'爕\?．𝟰気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕򳙑.4気", %p)},	undef,	"to_unicode\(\'爕\?\.4気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋𑍍Ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_unicode\(\'⒋𑍍Ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.𑍍Ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_unicode\(\'4\.𑍍Ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.𑍍ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_unicode\(\'4\.𑍍ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋𑍍ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_unicode\(\'⒋𑍍ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󞝃。򑆃񉢗--", %p)},	undef,	"to_unicode\(\'\?\。\?\?\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{07DF}｡\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u07DF｡\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{07DF}｡\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u07DF｡\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3089\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{07DF}。\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u07DF\。\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3090\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{07DF}。\x{200C}\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200D\\u07DF\。\\u200C\\uABED\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3091\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞮽\x{07FF}\x{084E}｡ᢍ򝹁𐫘", %p)},	undef,	"to_unicode\(\'\?\\u07FF\\u084E｡ᢍ\?𐫘\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞮽\x{07FF}\x{084E}。ᢍ򝹁𐫘", %p)},	undef,	"to_unicode\(\'\?\\u07FF\\u084E\。ᢍ\?𐫘\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06ED}𞺌𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_unicode\(\'\\u06ED𞺌𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ V5\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06ED}\x{0645}𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_unicode\(\'\\u06ED\\u0645𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ V5\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_unicode\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蔰。󠁹\x{08DD}-𑈵", %p)},	undef,	"to_unicode\(\'蔰\。\?\\u08DD\-𑈵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςჅ。\x{075A}", %p)},	undef,	"to_unicode\(\'ςჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ。\x{075A}", %p)},	"ςⴥ.\x{075A}",	"to_unicode\(\'ςⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ。\x{075A}", %p)},	"ςⴥ.\x{075A}",	"to_unicode\(\'ςⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3123\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ。\x{075A}", %p)},	undef,	"to_unicode\(\'ΣჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σⴥ。\x{075A}", %p)},	"σⴥ.\x{075A}",	"to_unicode\(\'σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3125\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("Σⴥ。\x{075A}", %p)},	"σⴥ.\x{075A}",	"to_unicode\(\'Σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--4xa203s.xn--epb", %p)},	"σⴥ.\x{075A}",	"to_unicode\(\'xn\-\-4xa203s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:3127\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("σⴥ.\x{075A}", %p)},	"σⴥ.\x{075A}",	"to_unicode\(\'σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ.\x{075A}", %p)},	undef,	"to_unicode\(\'ΣჅ\.\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("Σⴥ.\x{075A}", %p)},	"σⴥ.\x{075A}",	"to_unicode\(\'Σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--3xa403s.xn--epb", %p)},	"ςⴥ.\x{075A}",	"to_unicode\(\'xn\-\-3xa403s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ.\x{075A}", %p)},	"ςⴥ.\x{075A}",	"to_unicode\(\'ςⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ςⴥ.\x{075A}", %p)},	"ςⴥ.\x{075A}",	"to_unicode\(\'ςⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:3133\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0C4D}Ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_unicode\(\'\\u0C4DႩ\?．\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}Ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_unicode\(\'\\u0C4DႩ\?\.\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_unicode\(\'\\u0C4Dⴉ\?\.\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_unicode\(\'\\u0C4Dⴉ\?．\\u1B72\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮷≮񎈴󠄟。𐠄", %p)},	undef,	"to_unicode\(\'\⮷\≮\?\󠄟\。𐠄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮷<\x{0338}񎈴󠄟。𐠄", %p)},	undef,	"to_unicode\(\'\⮷\<\\u0338\?\󠄟\。𐠄\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200Dẏ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200Dẏ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200Dy\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200Dy\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200Dẏ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200Dẏ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200Dy\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200Dy\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200DY\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200DY\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}Ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200DẎ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}。\x{200D}Ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC\。\\u200DẎ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--vkb.xn--08e172a", %p)},	"\x{06BC}.ẏᡤ",	"to_unicode\(\'xn\-\-vkb\.xn\-\-08e172a\'\)\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}.ẏᡤ", %p)},	"\x{06BC}.ẏᡤ",	"to_unicode\(\'\\u06BC\.ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}.y\x{0307}ᡤ", %p)},	"\x{06BC}.ẏᡤ",	"to_unicode\(\'\\u06BC\.y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}.Y\x{0307}ᡤ", %p)},	"\x{06BC}.ẏᡤ",	"to_unicode\(\'\\u06BC\.Y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}.Ẏᡤ", %p)},	"\x{06BC}.ẏᡤ",	"to_unicode\(\'\\u06BC\.Ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200DY\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200DY\\u0307\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}Ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200DẎ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BC}｡\x{200D}Ẏ\x{200C}ᡤ", %p)},	undef,	"to_unicode\(\'\\u06BC｡\\u200DẎ\\u200Cᡤ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹹𑲛。񑂐\x{0DCA}", %p)},	undef,	"to_unicode\(\'𐹹\?\。\?\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_unicode\(\'\-\≠𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_unicode\(\'\-\≠𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_unicode\(\'\≮．\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_unicode\(\'\<\\u0338．\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_unicode\(\'\≮\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3181\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐩗\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3182\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐩗\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3183\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐩗\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3185\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--pt9c.xn--0kjya", %p)},	"𐩗.ⴉⴕ",	"to_unicode\(\'xn\-\-pt9c\.xn\-\-0kjya\'\)\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐩗.ⴉⴕ", %p)},	"𐩗.ⴉⴕ",	"to_unicode\(\'𐩗\.ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐩗.ႩႵ", %p)},	undef,	"to_unicode\(\'𐩗\.ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗.Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\.Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐩗\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐩗\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3191\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐩗\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐩗\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𐩗\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3201\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}𐫄ⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}𐫄ⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3203\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}𐫄ⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}𐫄ⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200C𐫄ⴗ\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3205\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🙑𐷺．≠\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺．≠\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺.≠\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺.≠\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🙑𐷺.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🙑\?\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064C}\x{1CD2}｡𞮞\x{2D7F}⧎", %p)},	undef,	"to_unicode\(\'\\u064C\\u1CD2｡\?\\u2D7F\⧎\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:3214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064C}\x{1CD2}。𞮞\x{2D7F}⧎", %p)},	undef,	"to_unicode\(\'\\u064C\\u1CD2\。\?\\u2D7F\⧎\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_unicode\(\'Ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_unicode\(\'Ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_unicode\(\'ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_unicode\(\'ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈񱢕", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈񱢕", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.񱢕", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.񱢕", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3223\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("１\x{AAF6}ß𑲥｡\x{1DD8}", %p)},	undef,	"to_unicode\(\'１\\uAAF6ß\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3224\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1\x{AAF6}ß𑲥。\x{1DD8}", %p)},	undef,	"to_unicode\(\'1\\uAAF6ß\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1\x{AAF6}SS𑲥。\x{1DD8}", %p)},	undef,	"to_unicode\(\'1\\uAAF6SS\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3226\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1\x{AAF6}ss𑲥。\x{1DD8}", %p)},	undef,	"to_unicode\(\'1\\uAAF6ss\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1\x{AAF6}Ss𑲥。\x{1DD8}", %p)},	undef,	"to_unicode\(\'1\\uAAF6Ss\?\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("１\x{AAF6}SS𑲥｡\x{1DD8}", %p)},	undef,	"to_unicode\(\'１\\uAAF6SS\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("１\x{AAF6}ss𑲥｡\x{1DD8}", %p)},	undef,	"to_unicode\(\'１\\uAAF6ss\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("１\x{AAF6}Ss𑲥｡\x{1DD8}", %p)},	undef,	"to_unicode\(\'１\\uAAF6Ss\?｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}񫶩𞪯\x{0CCD}｡\x{077C}⒈", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\\u0CCD｡\\u077C⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񫶩𞪯\x{0CCD}｡\x{077C}⒈", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\\u0CCD｡\\u077C⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񫶩𞪯\x{0CCD}。\x{077C}1.", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\\u0CCD\。\\u077C1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}񫶩𞪯\x{0CCD}。\x{077C}1.", %p)},	undef,	"to_unicode\(\'\\u200D\?\?\\u0CCD\。\\u077C1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB6}．𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_unicode\(\'\\u1AB6．\?\?\?\\u07D7\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB6}.𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_unicode\(\'\\u1AB6\.\?\?\?\\u07D7\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0842}𞩚⒈．󠬌８򏳏\x{0770}", %p)},	undef,	"to_unicode\(\'\\u0842\?⒈．\?８\?\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0842}𞩚1..󠬌8򏳏\x{0770}", %p)},	undef,	"to_unicode\(\'\\u0842\?1\.\.\?8\?\\u0770\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0361}𐫫\x{0369}ᡷ。-󠰛鞰", %p)},	undef,	"to_unicode\(\'\\u0361𐫫\\u0369ᡷ\。\-\?鞰\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-.\x{0ACD}剘ß𐫃", %p)},	undef,	"to_unicode\(\'\-\.\\u0ACD剘ß𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-.\x{0ACD}剘SS𐫃", %p)},	undef,	"to_unicode\(\'\-\.\\u0ACD剘SS𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-.\x{0ACD}剘ss𐫃", %p)},	undef,	"to_unicode\(\'\-\.\\u0ACD剘ss𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-.\x{0ACD}剘Ss𐫃", %p)},	undef,	"to_unicode\(\'\-\.\\u0ACD剘Ss𐫃\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08FB}𞵸｡-", %p)},	undef,	"to_unicode\(\'\\u08FB\?｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08FB}𞵸。-", %p)},	undef,	"to_unicode\(\'\\u08FB\?\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󠈻𐹲｡≠\x{0603}𐹽", %p)},	undef,	"to_unicode\(\'⒈\?𐹲｡\≠\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󠈻𐹲｡=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_unicode\(\'⒈\?𐹲｡\=\\u0338\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󠈻𐹲。≠\x{0603}𐹽", %p)},	undef,	"to_unicode\(\'1\.\?𐹲\。\≠\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󠈻𐹲。=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_unicode\(\'1\.\?𐹲\。\=\\u0338\\u0603𐹽\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹢󠈚Ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_unicode\(\'𐹢\?Ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹢󠈚Ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_unicode\(\'𐹢\?Ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹢󠈚ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_unicode\(\'𐹢\?ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹢󠈚ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_unicode\(\'𐹢\?ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗．\x{07C7}ᡖႳႧ", %p)},	undef,	"to_unicode\(\'\?．\\u07C7ᡖႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗.\x{07C7}ᡖႳႧ", %p)},	undef,	"to_unicode\(\'\?\.\\u07C7ᡖႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗.\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_unicode\(\'\?\.\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗.\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_unicode\(\'\?\.\\u07C7ᡖႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗．\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_unicode\(\'\?．\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩼗．\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_unicode\(\'\?．\\u07C7ᡖႳⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}􅍉.\x{06B3}\x{0775}", %p)},	undef,	"to_unicode\(\'\\u200D\?\.\\u06B3\\u0775\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}􅍉.\x{06B3}\x{0775}", %p)},	undef,	"to_unicode\(\'\\u200D\?\.\\u06B3\\u0775\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲤱⒛⾳．ꡦ⒈", %p)},	undef,	"to_unicode\(\'\?⒛⾳．ꡦ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲤱20.音.ꡦ1.", %p)},	undef,	"to_unicode\(\'\?20\.音\.ꡦ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DC}８񳦓-｡򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u07DC８\?\-｡\?𑁿𐩥\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DC}8񳦓-。򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u07DC8\?\-\。\?𑁿𐩥\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮SS\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}SS\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ss\x{0745}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ss\x{0745}", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮Ss\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}Ss\x{0745}", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("\x{07E9}-.𝨗꒱\x{1B72}", %p)},	undef,	"to_unicode\(\'\\u07E9\-\.𝨗꒱\\u1B72\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞼸\x{200C}.≯䕵⫧", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\≯䕵\⫧\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼸\x{200C}.≯䕵⫧", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\≯䕵\⫧\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼸\x{200C}.>\x{0338}䕵⫧", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\>\\u0338䕵\⫧\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼸\x{200C}.>\x{0338}䕵⫧", %p)},	undef,	"to_unicode\(\'\?\\u200C\.\>\\u0338䕵\⫧\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐨅ß\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_unicode\(\'𐨅ß\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐨅ß\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_unicode\(\'𐨅ß\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐨅SS\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_unicode\(\'𐨅SS\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐨅ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_unicode\(\'𐨅ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𐨅Ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_unicode\(\'𐨅Ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐨅SS\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_unicode\(\'𐨅SS\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐨅ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_unicode\(\'𐨅ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐨅Ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_unicode\(\'𐨅Ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_unicode\(\'\-\≮🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_unicode\(\'\-\<\\u0338🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_unicode\(\'\-\<\\u0338🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_unicode\(\'\-\≮🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤨｡ꡏ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\?｡ꡏ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤨｡ꡏ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\?｡ꡏ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3295\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤨。ꡏ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\?\。ꡏ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤨。ꡏ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\?\。ꡏ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3297\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--ge6h.xn--oc9a", %p)},	"𞤨.ꡏ",	"to_unicode\(\'xn\-\-ge6h\.xn\-\-oc9a\'\)\ \[data\/IdnaTest\.txt\:3298\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤨.ꡏ", %p)},	"𞤨.ꡏ",	"to_unicode\(\'\?\.ꡏ\'\)\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅹𑂶．ᢌ𑂹\x{0669}", %p)},	undef,	"to_unicode\(\'\󠅹𑂶．ᢌ𑂹\\u0669\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅹𑂶.ᢌ𑂹\x{0669}", %p)},	undef,	"to_unicode\(\'\󠅹𑂶\.ᢌ𑂹\\u0669\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_unicode\(\'Ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'Ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_unicode\(\'ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_unicode\(\'ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3323\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3324\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3325\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3327\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3329\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3331\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󍭲𐫍㓱。⾑", %p)},	undef,	"to_unicode\(\'\?𐫍㓱\。⾑\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󍭲𐫍㓱。襾", %p)},	undef,	"to_unicode\(\'\?𐫍㓱\。襾\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A0}𐮋𐹰≮。≯󠦗\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06A0𐮋𐹰\≮\。\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A0}𐮋𐹰≮。≯󠦗\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06A0𐮋𐹰\≮\。\≯\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A0}𐮋𐹰<\x{0338}。>\x{0338}󠦗\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06A0𐮋𐹰\<\\u0338\。\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A0}𐮋𐹰<\x{0338}。>\x{0338}󠦗\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06A0𐮋𐹰\<\\u0338\。\>\\u0338\?\\u200D\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟞｡񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_unicode\(\'𝟞｡\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6。񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_unicode\(\'6\。\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3339\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_unicode\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_unicode\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{0634}\x{0649}。𑇀𑍴", %p)},	undef,	"to_unicode\(\'\-\\u0634\\u0649\。𑇀𑍴\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}󠊶𝟏.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_unicode\(\'\\u200C\?𝟏\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠊶𝟏.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_unicode\(\'\\u200C\?𝟏\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠊶1.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_unicode\(\'\\u200C\?1\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠊶1.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_unicode\(\'\\u200C\?1\.\\u0D43\?𐹬\?\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-4\.SS\'\)\ \[data\/IdnaTest\.txt\:3351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.ss", %p)},	"齙--4.ss",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.ss\'\)\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.xn--zca", %p)},	"齙--4.ß",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:3353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-𝟰\.SS\'\)\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{1BF2}.𐹢𞀖\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1BF2\.𐹢\?\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3355\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{1BF2}.𐹢𞀖\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1BF2\.𐹢\?\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3356\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󃲙󠋘｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\?｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󃲙󠋘｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\?｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󃲙󠋘。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\?\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󃲙󠋘。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\?\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}．𞵷-𝪩悎", %p)},	undef,	"to_unicode\(\'\\u1A60．\?\-𝪩悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}.𞵷-𝪩悎", %p)},	undef,	"to_unicode\(\'\\u1A60\.\?\-𝪩悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𛜯󠊛．𞤳񏥾", %p)},	undef,	"to_unicode\(\'\?\?．\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𛜯󠊛.𞤳񏥾", %p)},	undef,	"to_unicode\(\'\?\?\.\?\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{071C}𐫒\x{062E}.𐋲", %p)},	"\x{071C}𐫒\x{062E}.𐋲",	"to_unicode\(\'\\u071C𐫒\\u062E\.𐋲\'\)\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--tgb98b8643d.xn--m97c", %p)},	"\x{071C}𐫒\x{062E}.𐋲",	"to_unicode\(\'xn\-\-tgb98b8643d\.xn\-\-m97c\'\)\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐼑𞤓\x{0637}\x{08E2}.\x{DF56}", %p)},	undef,	"to_unicode\(\'\?\?\\u0637\\u08E2\.\\uDF56\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_unicode\(\'Ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_unicode\(\'Ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_unicode\(\'ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_unicode\(\'ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠪢-。򛂏≮𑜫", %p)},	undef,	"to_unicode\(\'\?\-\。\?\≮𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠪢-。򛂏<\x{0338}𑜫", %p)},	undef,	"to_unicode\(\'\?\-\。\?\<\\u0338𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠉹\x{200D}。򌿧≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\?\\u200D\。\?\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹯-𑄴\x{08BC}。︒䖐⾆", %p)},	undef,	"to_unicode\(\'𐹯\-𑄴\\u08BC\。︒䖐⾆\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𐹯-𑄴\x{08BC}。。䖐舌", %p)},	undef,	"to_unicode\(\'𐹯\-𑄴\\u08BC\。\。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝪞Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪞Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪞Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪞Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝪞ⴐ。쪡", %p)},	undef,	"to_unicode\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3388\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝪞ⴐ。쪡", %p)},	undef,	"to_unicode\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝪞ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3390\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝪞ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_unicode\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_unicode\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡅ０\x{200C}｡⎢󤨄", %p)},	undef,	"to_unicode\(\'ᡅ０\\u200C｡\⎢\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡅ０\x{200C}｡⎢󤨄", %p)},	undef,	"to_unicode\(\'ᡅ０\\u200C｡\⎢\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡅ0\x{200C}。⎢󤨄", %p)},	undef,	"to_unicode\(\'ᡅ0\\u200C\。\⎢\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡅ0\x{200C}。⎢󤨄", %p)},	undef,	"to_unicode\(\'ᡅ0\\u200C\。\⎢\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚9ꍩ\x{17D3}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\?9ꍩ\\u17D3\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200DSS\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200Dss\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲮚９ꍩ\x{17D3}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'\?９ꍩ\\u17D3．\\u200DSs\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3413\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ꗷ𑆀.\x{075D}𐩒", %p)},	"ꗷ𑆀.\x{075D}𐩒",	"to_unicode\(\'ꗷ𑆀\.\\u075D𐩒\'\)\ \[data\/IdnaTest\.txt\:3414\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--ju8a625r.xn--hpb0073k", %p)},	"ꗷ𑆀.\x{075D}𐩒",	"to_unicode\(\'xn\-\-ju8a625r\.xn\-\-hpb0073k\'\)\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒐≯-。︒򩑣-񞛠", %p)},	undef,	"to_unicode\(\'⒐\≯\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐>\x{0338}-。︒򩑣-񞛠", %p)},	undef,	"to_unicode\(\'⒐\>\\u0338\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.≯-。。򩑣-񞛠", %p)},	undef,	"to_unicode\(\'9\.\≯\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.>\x{0338}-。。򩑣-񞛠", %p)},	undef,	"to_unicode\(\'9\.\>\\u0338\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈪚\x{0CE3}Ⴡ󠢏．\x{061D}", %p)},	undef,	"to_unicode\(\'\?\\u0CE3Ⴡ\?．\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈪚\x{0CE3}Ⴡ󠢏.\x{061D}", %p)},	undef,	"to_unicode\(\'\?\\u0CE3Ⴡ\?\.\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈪚\x{0CE3}ⴡ󠢏.\x{061D}", %p)},	undef,	"to_unicode\(\'\?\\u0CE3ⴡ\?\.\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈪚\x{0CE3}ⴡ󠢏．\x{061D}", %p)},	undef,	"to_unicode\(\'\?\\u0CE3ⴡ\?．\\u061D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3423\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DEB}。𐋩\x{0638}-𐫮", %p)},	undef,	"to_unicode\(\'\\u1DEB\。𐋩\\u0638\-𐫮\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐳋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐳋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。舛𐳋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3429\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。舛𐳋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("싇。舛𐲋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐲋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。舛𐲋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。舛𐲋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。⾇𐳋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。⾇𐳋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3436\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3438\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。⾇𐲋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("싇。⾇𐲋ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:3440\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹠ς。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹠ς\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠ς。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹠ς\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3442\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹠ς。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_unicode\(\'𐹠ς\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹠ς。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_unicode\(\'𐹠ς\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3444\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹠Σ。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹠Σ\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠Σ。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹠Σ\。\\u200C\\u06BFჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3446\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹠σ。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_unicode\(\'𐹠σ\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹠σ。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_unicode\(\'𐹠σ\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3448\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-ß", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-ß", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-SS", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-SS", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-ss", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-ss", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-Ss", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇒐\x{200C}\x{0604}.\x{069A}-Ss", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0604\.\\u069A\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{FBB0}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\uFBB0\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{FBB0}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\uFBB0\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D3}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D3\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D3}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D3\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D2}\x{0654}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D2\\u0654\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D2}\x{0654}󅄞𐸚", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D2\\u0654\?\?\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡶱｡𐮬≠", %p)},	undef,	"to_unicode\(\'\?｡𐮬\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡶱｡𐮬=\x{0338}", %p)},	undef,	"to_unicode\(\'\?｡𐮬\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡶱。𐮬≠", %p)},	undef,	"to_unicode\(\'\?\。𐮬\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡶱。𐮬=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\。𐮬\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_unicode\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_unicode\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_unicode\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_unicode\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠅋-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠅋\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠅋-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠅋\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠅋-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠅋\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠅋-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠅋\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3474\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠅋-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠅋\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠅋-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠅋\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3476\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠅋-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠅋\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠅋-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠅋\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3478\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⇧𐨏󠾈󯶅。\x{0600}󠈵󠆉", %p)},	undef,	"to_unicode\(\'\⇧𐨏\?\?\。\\u0600\?\󠆉\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠𐮂.↑🄇⒈", %p)},	undef,	"to_unicode\(\'\≠𐮂\.\↑🄇⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}𐮂.↑🄇⒈", %p)},	undef,	"to_unicode\(\'\=\\u0338𐮂\.\↑🄇⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠𐮂.↑6,1.", %p)},	undef,	"to_unicode\(\'\≠𐮂\.\↑6\,1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}𐮂.↑6,1.", %p)},	undef,	"to_unicode\(\'\=\\u0338𐮂\.\↑6\,1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉ß.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?ß\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉ß.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?ß\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉SS.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?SS\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉SS.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?SS\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉Ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?Ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩏󠲉Ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_unicode\(\'𝩏\?Ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_unicode\(\'ß\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_unicode\(\'ß\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_unicode\(\'ß\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_unicode\(\'SS\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_unicode\(\'ss\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_unicode\(\'Ss\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_unicode\(\'ß\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_unicode\(\'SS\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_unicode\(\'ss\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_unicode\(\'Ss\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1714}。󠆣-𑋪", %p)},	undef,	"to_unicode\(\'\\u1714\。\󠆣\-𑋪\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{ABE8}-．򨏜\x{05BD}ß", %p)},	undef,	"to_unicode\(\'\\uABE8\-．\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-.򨏜\x{05BD}ß", %p)},	undef,	"to_unicode\(\'\\uABE8\-\.\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-.򨏜\x{05BD}SS", %p)},	undef,	"to_unicode\(\'\\uABE8\-\.\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-.򨏜\x{05BD}ss", %p)},	undef,	"to_unicode\(\'\\uABE8\-\.\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-.򨏜\x{05BD}Ss", %p)},	undef,	"to_unicode\(\'\\uABE8\-\.\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-．򨏜\x{05BD}SS", %p)},	undef,	"to_unicode\(\'\\uABE8\-．\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-．򨏜\x{05BD}ss", %p)},	undef,	"to_unicode\(\'\\uABE8\-．\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABE8}-．򨏜\x{05BD}Ss", %p)},	undef,	"to_unicode\(\'\\uABE8\-．\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡓ-≮。\x{066B}󠅱ᡄ", %p)},	undef,	"to_unicode\(\'ᡓ\-\≮\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡓ-<\x{0338}。\x{066B}󠅱ᡄ", %p)},	undef,	"to_unicode\(\'ᡓ\-\<\\u0338\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝟥♮𑜫\x{08ED}．\x{17D2}𑜫8󠆏", %p)},	undef,	"to_unicode\(\'𝟥\♮𑜫\\u08ED．\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("3♮𑜫\x{08ED}.\x{17D2}𑜫8󠆏", %p)},	undef,	"to_unicode\(\'3\♮𑜫\\u08ED\.\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡򕌀\x{200D}❡", %p)},	undef,	"to_unicode\(\'\-｡\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡򕌀\x{200D}❡", %p)},	undef,	"to_unicode\(\'\-｡\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。򕌀\x{200D}❡", %p)},	undef,	"to_unicode\(\'\-\。\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。򕌀\x{200D}❡", %p)},	undef,	"to_unicode\(\'\-\。\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓☱𝟐򥰵｡𝪮񐡳", %p)},	undef,	"to_unicode\(\'𝟓\☱𝟐\?｡𝪮\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5☱2򥰵。𝪮񐡳", %p)},	undef,	"to_unicode\(\'5\☱2\?\。𝪮\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.-├򖦣", %p)},	undef,	"to_unicode\(\'\-\.\-\├\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05A5}\x{076D}｡\x{200D}󠀘", %p)},	undef,	"to_unicode\(\'\\u05A5\\u076D｡\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05A5}\x{076D}｡\x{200D}󠀘", %p)},	undef,	"to_unicode\(\'\\u05A5\\u076D｡\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05A5}\x{076D}。\x{200D}󠀘", %p)},	undef,	"to_unicode\(\'\\u05A5\\u076D\。\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05A5}\x{076D}。\x{200D}󠀘", %p)},	undef,	"to_unicode\(\'\\u05A5\\u076D\。\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_unicode\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3541\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0827}𝟶\x{06A0}-。𑄳", %p)},	undef,	"to_unicode\(\'\\u0827𝟶\\u06A0\-\。𑄳\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0827}0\x{06A0}-。𑄳", %p)},	undef,	"to_unicode\(\'\\u08270\\u06A0\-\。𑄳\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3543\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς．\x{FDC1}🞛⒈", %p)},	undef,	"to_unicode\(\'ς．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"ς.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'ς\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3545\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"ς.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'ς\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3546\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"σ.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'Σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3547\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"σ.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--4xa.xn--1-gocmu97674d.", %p)},	"σ.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'xn\-\-4xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--3xa.xn--1-gocmu97674d.", %p)},	"ς.\x{0641}\x{0645}\x{064A}🞛1.",	"to_unicode\(\'xn\-\-3xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_unicode\(\'Σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_unicode\(\'σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🗩-｡𐹻󐞆񥉮", %p)},	undef,	"to_unicode\(\'🗩\-｡𐹻\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🗩-。𐹻󐞆񥉮", %p)},	undef,	"to_unicode\(\'🗩\-\。𐹻\?\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡜-🔪｡𝟻\x{200C}𐿀", %p)},	undef,	"to_unicode\(\'𐡜\-🔪｡𝟻\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡜-🔪｡𝟻\x{200C}𐿀", %p)},	undef,	"to_unicode\(\'𐡜\-🔪｡𝟻\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡜-🔪。5\x{200C}𐿀", %p)},	undef,	"to_unicode\(\'𐡜\-🔪\。5\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐡜-🔪。5\x{200C}𐿀", %p)},	undef,	"to_unicode\(\'𐡜\-🔪\。5\\u200C\?\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3558\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3559\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3560\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3562\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3564\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3565\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3566\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3568\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3572\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3574\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3576\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3578\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3580\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3582\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3584\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3586\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3588\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_unicode\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3590\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9󠇥．󪴴ᢓ", %p)},	undef,	"to_unicode\(\'9\󠇥．\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9󠇥.󪴴ᢓ", %p)},	undef,	"to_unicode\(\'9\󠇥\.\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗ß⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗ß⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗ß⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗ß⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗ß玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗ß玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗ß玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗ß玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗SS玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗SS玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗SS玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗SS玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗ss玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗ss玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗ss玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗ss玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗Ss玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗Ss玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐫭🠗Ss玉", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐫭🠗Ss玉\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗SS⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗SS⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗SS⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗SS⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗ss⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗ss⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗ss⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗ss⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗Ss⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗Ss⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐫭🠗Ss⽟", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐫭🠗Ss⽟\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3612\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("。ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("。ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3614\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--hva754s.", %p)},	"ⴖ\x{0366}.",	"to_unicode\(\'xn\-\-hva754s\.\'\)\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴖ\x{0366}.", %p)},	"ⴖ\x{0366}.",	"to_unicode\(\'ⴖ\\u0366\.\'\)\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴖ\x{0366}.", %p)},	undef,	"to_unicode\(\'Ⴖ\\u0366\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08BB}．\x{200C}Ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB．\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08BB}．\x{200C}Ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB．\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08BB}.\x{200C}Ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB\.\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08BB}.\x{200C}Ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB\.\\u200CႣ\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3623\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08BB}.\x{200C}ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB\.\\u200Cⴃ\?\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3624\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08BB}.\x{200C}ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB\.\\u200Cⴃ\?\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3625\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--hzb.xn--ukj4430l", %p)},	"\x{08BB}.ⴃ𞀒",	"to_unicode\(\'xn\-\-hzb\.xn\-\-ukj4430l\'\)\ \[data\/IdnaTest\.txt\:3626\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08BB}.ⴃ𞀒", %p)},	"\x{08BB}.ⴃ𞀒",	"to_unicode\(\'\\u08BB\.ⴃ\?\'\)\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{08BB}.Ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB\.Ⴃ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3628\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08BB}．\x{200C}ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB．\\u200Cⴃ\?\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{08BB}．\x{200C}ⴃ𞀒", %p)},	undef,	"to_unicode\(\'\\u08BB．\\u200Cⴃ\?\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3630\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷󠧷", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\?\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷󠧷", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\?\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷󠧷", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\?\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷󠧷", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\?\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:3634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞀤󜠐。򈬖", %p)},	undef,	"to_unicode\(\'\-\?\?\。\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂︒\x{200C}㟀．\x{0624}⒈", %p)},	undef,	"to_unicode\(\'\?︒\\u200C㟀．\\u0624⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂︒\x{200C}㟀．\x{0624}⒈", %p)},	undef,	"to_unicode\(\'\?︒\\u200C㟀．\\u0624⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂︒\x{200C}㟀．\x{0648}\x{0654}⒈", %p)},	undef,	"to_unicode\(\'\?︒\\u200C㟀．\\u0648\\u0654⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂︒\x{200C}㟀．\x{0648}\x{0654}⒈", %p)},	undef,	"to_unicode\(\'\?︒\\u200C㟀．\\u0648\\u0654⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂。\x{200C}㟀.\x{0624}1.", %p)},	undef,	"to_unicode\(\'\?\。\\u200C㟀\.\\u06241\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂。\x{200C}㟀.\x{0624}1.", %p)},	undef,	"to_unicode\(\'\?\。\\u200C㟀\.\\u06241\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂。\x{200C}㟀.\x{0648}\x{0654}1.", %p)},	undef,	"to_unicode\(\'\?\。\\u200C㟀\.\\u0648\\u06541\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󳛂。\x{200C}㟀.\x{0648}\x{0654}1.", %p)},	undef,	"to_unicode\(\'\?\。\\u200C㟀\.\\u0648\\u06541\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3643\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𑲜\x{07CA}𝅼。-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CA𝅼\。\-\\u200D\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𑲜\x{07CA}𝅼。-\x{200D}", %p)},	undef,	"to_unicode\(\'\?\\u07CA𝅼\。\-\\u200D\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3645\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠𐫶", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠𐫶\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。≯ς", %p)},	undef,	"to_unicode\(\'\\u0750\。\≯ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。>\x{0338}ς", %p)},	undef,	"to_unicode\(\'\\u0750\。\>\\u0338ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。>\x{0338}Σ", %p)},	undef,	"to_unicode\(\'\\u0750\。\>\\u0338Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。≯Σ", %p)},	undef,	"to_unicode\(\'\\u0750\。\≯Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。≯σ", %p)},	undef,	"to_unicode\(\'\\u0750\。\≯σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0750}。>\x{0338}σ", %p)},	undef,	"to_unicode\(\'\\u0750\。\>\\u0338σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07FC}𐸆.𓖏︒񊨩Ⴐ", %p)},	undef,	"to_unicode\(\'\\u07FC\?\.\?︒\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07FC}𐸆.𓖏。񊨩Ⴐ", %p)},	undef,	"to_unicode\(\'\\u07FC\?\.\?\。\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07FC}𐸆.𓖏。񊨩ⴐ", %p)},	undef,	"to_unicode\(\'\\u07FC\?\.\?\。\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07FC}𐸆.𓖏︒񊨩ⴐ", %p)},	undef,	"to_unicode\(\'\\u07FC\?\.\?︒\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_unicode\(\'Ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_unicode\(\'Ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_unicode\(\'ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_unicode\(\'ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄈。󠷳\x{0844}", %p)},	undef,	"to_unicode\(\'🄈\。\?\\u0844\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7,。󠷳\x{0844}", %p)},	undef,	"to_unicode\(\'7\,\。\?\\u0844\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0846}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\≮\\u0846\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0846}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0846\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0846}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0846\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0846}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\≮\\u0846\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0846}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\≮\\u0846\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0846}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0846\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0846}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0846\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0846}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\≮\\u0846\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠆓⛏-。ꡒ", %p)},	undef,	"to_unicode\(\'\󠆓\⛏\-\。ꡒ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07BB}𐹳\x{0626}𑁆。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_unicode\(\'\\u07BB𐹳\\u0626𑁆\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07BB}𐹳\x{064A}𑁆\x{0654}。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_unicode\(\'\\u07BB𐹳\\u064A𑁆\\u0654\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0816}.𐨕𚚕", %p)},	undef,	"to_unicode\(\'\\u0816\.𐨕\?\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("--。𽊆\x{0767}𐽋𞠬", %p)},	undef,	"to_unicode\(\'\-\-\。\?\\u0767\?𞠬\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛭦𐋥𹸐.≯\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_unicode\(\'\?𐋥\?\.\≯\\u08B0\\u08A6\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛭦𐋥𹸐.>\x{0338}\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_unicode\(\'\?𐋥\?\.\>\\u0338\\u08B0\\u08A6\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛󠇒򤸞𐹧．-䤷", %p)},	undef,	"to_unicode\(\'䔛\󠇒\?𐹧．\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛󠇒򤸞𐹧.-䤷", %p)},	undef,	"to_unicode\(\'䔛\󠇒\?𐹧\.\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹩．\x{200D}-", %p)},	undef,	"to_unicode\(\'𐹩．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹩．\x{200D}-", %p)},	undef,	"to_unicode\(\'𐹩．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹩.\x{200D}-", %p)},	undef,	"to_unicode\(\'𐹩\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹩.\x{200D}-", %p)},	undef,	"to_unicode\(\'𐹩\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3698\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񂈦帷｡≯萺\x{1DC8}-", %p)},	undef,	"to_unicode\(\'\?帷｡\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񂈦帷｡>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_unicode\(\'\?帷｡\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񂈦帷。≯萺\x{1DC8}-", %p)},	undef,	"to_unicode\(\'\?帷\。\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񂈦帷。>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_unicode\(\'\?帷\。\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{ABED}。ᢖ-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uABED\。ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{ABED}。ᢖ-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uABED\。ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3704\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}攌\x{ABED}。ᢖ-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uABED\。ᢖ\-ⴘ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3705\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}攌\x{ABED}。ᢖ-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uABED\。ᢖ\-ⴘ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3706\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--p9ut19m.xn----mck373i", %p)},	"攌\x{ABED}.ᢖ-ⴘ",	"to_unicode\(\'xn\-\-p9ut19m\.xn\-\-\-\-mck373i\'\)\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("攌\x{ABED}.ᢖ-ⴘ", %p)},	"攌\x{ABED}.ᢖ-ⴘ",	"to_unicode\(\'攌\\uABED\.ᢖ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("攌\x{ABED}.ᢖ-Ⴘ", %p)},	undef,	"to_unicode\(\'攌\\uABED\.ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3713\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3툒۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3717\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--9r8a.16.xn--3-nyc0117m", %p)},	"ꖨ.16.3툒۳",	"to_unicode\(\'xn\-\-9r8a\.16\.xn\-\-3\-nyc0117m\'\)\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ꖨ.16.3툒۳", %p)},	"ꖨ.16.3툒۳",	"to_unicode\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ꖨ.16.3툒۳", %p)},	"ꖨ.16.3툒۳",	"to_unicode\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_unicode\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_unicode\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("1.걾6.𐱁\x{06D0}", %p)},	"1.걾6.𐱁\x{06D0}",	"to_unicode\(\'1\.걾6\.𐱁\\u06D0\'\)\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("1.걾6.𐱁\x{06D0}", %p)},	"1.걾6.𐱁\x{06D0}",	"to_unicode\(\'1\.걾6\.𐱁\\u06D0\'\)\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("1.xn--6-945e.xn--glb1794k", %p)},	"1.걾6.𐱁\x{06D0}",	"to_unicode\(\'1\.xn\-\-6\-945e\.xn\-\-glb1794k\'\)\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐲞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐲞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐲞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐲞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐲞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐲞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐲞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐲞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐳞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐳞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐳞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐳞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_unicode\(\'𐳞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0AE3}.𐹺\x{115F}", %p)},	undef,	"to_unicode\(\'\\u0AE3\.𐹺\\u115F\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3734\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝟏𝨙⸖.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏𝨙\⸖\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("𝟏𝨙⸖.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏𝨙\⸖\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3736\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("1𝨙⸖.\x{200D}", %p)},	undef,	"to_unicode\(\'1𝨙\⸖\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("1𝨙⸖.\x{200D}", %p)},	undef,	"to_unicode\(\'1𝨙\⸖\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3738\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("xn--1-5bt6845n.", %p)},	"1𝨙⸖.",	"to_unicode\(\'xn\-\-1\-5bt6845n\.\'\)\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("1𝨙⸖.", %p)},	"1𝨙⸖.",	"to_unicode\(\'1𝨙\⸖\.\'\)\ \[data\/IdnaTest\.txt\:3740\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞤐≠\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\≠\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐≠\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\≠\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐=\x{0338}\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\=\\u0338\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐=\x{0338}\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\=\\u0338\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐≠\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\≠\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐≠\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\≠\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐=\x{0338}\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\=\\u0338\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤐=\x{0338}\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_unicode\(\'\?\=\\u0338\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:3748\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹰\x{0368}-ꡧ｡\x{0675}", %p)},	undef,	"to_unicode\(\'𐹰\\u0368\-ꡧ｡\\u0675\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹰\x{0368}-ꡧ。\x{0627}\x{0674}", %p)},	undef,	"to_unicode\(\'𐹰\\u0368\-ꡧ\。\\u0627\\u0674\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("F󠅟｡򏗅♚", %p)},	undef,	"to_unicode\(\'F\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("F󠅟。򏗅♚", %p)},	undef,	"to_unicode\(\'F\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f󠅟。򏗅♚", %p)},	undef,	"to_unicode\(\'f\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f󠅟｡򏗅♚", %p)},	undef,	"to_unicode\(\'f\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}𑄴\x{1DE9}。𝟮Ⴘ𞀨񃥇", %p)},	undef,	"to_unicode\(\'\\u0B4D𑄴\\u1DE9\。𝟮Ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}𑄴\x{1DE9}。2Ⴘ𞀨񃥇", %p)},	undef,	"to_unicode\(\'\\u0B4D𑄴\\u1DE9\。2Ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}𑄴\x{1DE9}。2ⴘ𞀨񃥇", %p)},	undef,	"to_unicode\(\'\\u0B4D𑄴\\u1DE9\。2ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}𑄴\x{1DE9}。𝟮ⴘ𞀨񃥇", %p)},	undef,	"to_unicode\(\'\\u0B4D𑄴\\u1DE9\。𝟮ⴘ\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򓠭\x{200C}\x{200C}⒈。勉𑁅", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u200C⒈\。勉𑁅\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򓠭\x{200C}\x{200C}⒈。勉𑁅", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u200C⒈\。勉𑁅\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򓠭\x{200C}\x{200C}1.。勉𑁅", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u200C1\.\。勉𑁅\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򓠭\x{200C}\x{200C}1.。勉𑁅", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u200C1\.\。勉𑁅\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡃ.玿񫈜󕞐", %p)},	undef,	"to_unicode\(\'ᡃ\.玿\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{1DE0}򐀁.𺻆≯𐮁", %p)},	undef,	"to_unicode\(\'\\u115F\\u1DE0\?\.\?\≯𐮁\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}\x{1DE0}򐀁.𺻆>\x{0338}𐮁", %p)},	undef,	"to_unicode\(\'\\u115F\\u1DE0\?\.\?\>\\u0338𐮁\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄫𝩤\x{200D}\x{063E}.𝩩-\x{081E}󑼩", %p)},	undef,	"to_unicode\(\'\󠄫𝩤\\u200D\\u063E\.𝩩\-\\u081E\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄫𝩤\x{200D}\x{063E}.𝩩-\x{081E}󑼩", %p)},	undef,	"to_unicode\(\'\󠄫𝩤\\u200D\\u063E\.𝩩\-\\u081E\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3775\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{20DA}．𑘿-", %p)},	undef,	"to_unicode\(\'\\u20DA．𑘿\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3776\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{20DA}.𑘿-", %p)},	undef,	"to_unicode\(\'\\u20DA\.𑘿\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䮸ß.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_unicode\(\'䮸ß\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸SS.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_unicode\(\'䮸SS\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_unicode\(\'䮸ss\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸Ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_unicode\(\'䮸Ss\.\?\?紙\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_unicode\(\'\-Ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_unicode\(\'\-Ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("-ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_unicode\(\'\-ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("-ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_unicode\(\'\-ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:3785\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󧈯𐹯\x{0AC2}｡򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_unicode\(\'\?𐹯\\u0AC2｡\?𐮁\?ᡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧈯𐹯\x{0AC2}。򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_unicode\(\'\?𐹯\\u0AC2\。\?𐮁\?ᡂ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1082}-\x{200D}\x{A8EA}．ꡊ\x{200D}񼸳", %p)},	undef,	"to_unicode\(\'\\u1082\-\\u200D\\uA8EA．ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1082}-\x{200D}\x{A8EA}．ꡊ\x{200D}񼸳", %p)},	undef,	"to_unicode\(\'\\u1082\-\\u200D\\uA8EA．ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1082}-\x{200D}\x{A8EA}.ꡊ\x{200D}񼸳", %p)},	undef,	"to_unicode\(\'\\u1082\-\\u200D\\uA8EA\.ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1082}-\x{200D}\x{A8EA}.ꡊ\x{200D}񼸳", %p)},	undef,	"to_unicode\(\'\\u1082\-\\u200D\\uA8EA\.ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。≠\x{0668}", %p)},	undef,	"to_unicode\(\'۱\。\≠\\u0668\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。=\x{0338}\x{0668}", %p)},	undef,	"to_unicode\(\'۱\。\=\\u0338\\u0668\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3793\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑈵廊.𐠍", %p)},	undef,	"to_unicode\(\'𑈵廊\.𐠍\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{0356}-．-Ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-．\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0356}-．-Ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-．\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0356}-.-Ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-\.\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0356}-.-Ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-\.\-Ⴐ\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3798\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}\x{0356}-.-ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-\.\-ⴐ\\u0661\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}\x{0356}-.-ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-\.\-ⴐ\\u0661\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3800\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}\x{0356}-．-ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-．\-ⴐ\\u0661\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}\x{0356}-．-ⴐ\x{0661}", %p)},	undef,	"to_unicode\(\'\\u200D\\u0356\-．\-ⴐ\\u0661\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3802\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{063A}\x{0661}挏󾯐.-", %p)},	undef,	"to_unicode\(\'\\u063A\\u0661挏\?\.\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3803\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06EF}｡𐹧𞤽", %p)},	undef,	"to_unicode\(\'\\u06EF｡𐹧\?\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{06EF}。𐹧𞤽", %p)},	undef,	"to_unicode\(\'\\u06EF\。𐹧\?\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3805\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_unicode\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_unicode\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_unicode\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_unicode\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷｡≯\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷｡\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷｡≯\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷｡\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷｡>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷｡\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷｡>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷｡\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷。≯\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷\。\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷。≯\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷\。\≯\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷。>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷\。\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠎃󗭞\x{06B7}𐹷。>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_unicode\(\'\?\?\\u06B7𐹷\。\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ󠅍󠐕\x{200D}｡𐹾𐹪𐻝-", %p)},	undef,	"to_unicode\(\'ᛎ\󠅍\?\\u200D｡𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ󠅍󠐕\x{200D}｡𐹾𐹪𐻝-", %p)},	undef,	"to_unicode\(\'ᛎ\󠅍\?\\u200D｡𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ󠅍󠐕\x{200D}。𐹾𐹪𐻝-", %p)},	undef,	"to_unicode\(\'ᛎ\󠅍\?\\u200D\。𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᛎ󠅍󠐕\x{200D}。𐹾𐹪𐻝-", %p)},	undef,	"to_unicode\(\'ᛎ\󠅍\?\\u200D\。𐹾𐹪\?\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3825\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐹶.𐫂", %p)},	undef,	"to_unicode\(\'𐹶\.𐫂\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3828\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ß\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ß\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3830\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3832\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3834\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{200D}\x{103A}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u103A\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3836\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--ss-f4j.1.", %p)},	"ss\x{103A}.1.",	"to_unicode\(\'xn\-\-ss\-f4j\.1\.\'\)\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ss\x{103A}.1.", %p)},	"ss\x{103A}.1.",	"to_unicode\(\'ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("SS\x{103A}.1.", %p)},	"ss\x{103A}.1.",	"to_unicode\(\'SS\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Ss\x{103A}.1.", %p)},	"ss\x{103A}.1.",	"to_unicode\(\'Ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3840\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}\x{200C}𙶵𞻘。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0B4D\\u200C\?\?\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}\x{200C}𙶵𞻘。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0B4D\\u200C\?\?\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3848\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮅｡\x{06BC}🁕", %p)},	undef,	"to_unicode\(\'𐮅｡\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮅。\x{06BC}🁕", %p)},	undef,	"to_unicode\(\'𐮅\。\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0620}\x{17D2}。𐫔󠀧\x{200C}𑈵", %p)},	undef,	"to_unicode\(\'\\u0620\\u17D2\。𐫔\?\\u200C𑈵\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0620}\x{17D2}。𐫔󠀧\x{200C}𑈵", %p)},	undef,	"to_unicode\(\'\\u0620\\u17D2\。𐫔\?\\u200C𑈵\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񋉕.𞣕𞤊", %p)},	undef,	"to_unicode\(\'\?\.𞣕\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿．ß\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ß\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿．ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3854\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿．ß\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ß\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿．ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3855\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿.ß\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ß\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿\.ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿.ß\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ß\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿\.ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3857\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿.SS\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿\.SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿.ss\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿\.ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿.Ss\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿\.Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3860\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--clb2593k.xn--ss-toj6092t", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'xn\-\-clb2593k\.xn\-\-ss\-toj6092t\'\)\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--clb2593k.xn--zca216edt0r", %p)},	"\x{06CC}𐨿.ß\x{0F84}𑍬",	"to_unicode\(\'xn\-\-clb2593k\.xn\-\-zca216edt0r\'\)\ \[data\/IdnaTest\.txt\:3862\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿．SS\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿．SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿．ss\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿．ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06CC}𐨿．Ss\x{0F84}𑍬", %p)},	"\x{06CC}𐨿.ss\x{0F84}𑍬",	"to_unicode\(\'\\u06CC𐨿．Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ≯︒񄂯．Ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\≯︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ>\x{0338}︒񄂯．Ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\>\\u0338︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ≯。񄂯.Ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\≯\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ>\x{0338}。񄂯.Ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\>\\u0338\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ>\x{0338}。񄂯.ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\>\\u0338\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ≯。񄂯.ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\≯\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ>\x{0338}︒񄂯．ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\>\\u0338︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢕ≯︒񄂯．ⴀ", %p)},	undef,	"to_unicode\(\'ᢕ\≯︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3881\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0F9F}．-\x{082A}", %p)},	undef,	"to_unicode\(\'\\u0F9F．\-\\u082A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0F9F}.-\x{082A}", %p)},	undef,	"to_unicode\(\'\\u0F9F\.\-\\u082A\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3883\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_unicode\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_unicode\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_unicode\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_unicode\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3887\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς𑓂𐋢．\x{0668}", %p)},	undef,	"to_unicode\(\'ς𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς𑓂𐋢.\x{0668}", %p)},	undef,	"to_unicode\(\'ς𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_unicode\(\'Σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_unicode\(\'σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_unicode\(\'Σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_unicode\(\'σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A953}\x{200C}𐋻\x{200D}.\x{2DF8}𞿄𐹲", %p)},	undef,	"to_unicode\(\'\\uA953\\u200C𐋻\\u200D\.\\u2DF8\?𐹲\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}\x{200C}𐋻\x{200D}.\x{2DF8}𞿄𐹲", %p)},	undef,	"to_unicode\(\'\\uA953\\u200C𐋻\\u200D\.\\u2DF8\?𐹲\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⊼。񪧖\x{0695}", %p)},	undef,	"to_unicode\(\'\⊼\。\?\\u0695\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐯬񖋔。󜳥", %p)},	undef,	"to_unicode\(\'\?\?\。\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}𑍧\x{07DD}。ς򬍘🀞\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u0601𑍧\\u07DD\。ς\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}𑍧\x{07DD}。Σ򬍘🀞\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u0601𑍧\\u07DD\。Σ\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}𑍧\x{07DD}。σ򬍘🀞\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u0601𑍧\\u07DD\。σ\?🀞\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐳲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_unicode\(\'\-𐳲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐳲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_unicode\(\'\-𐳲\\u0646\?\。\\uABED3\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐲲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_unicode\(\'\-𐲲\\u0646\?\。\\uABED3\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐲲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_unicode\(\'\-𐲲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦｡񲨕≮𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?｡\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦｡񲨕≮𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?｡\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦｡񲨕<\x{0338}𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?｡\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦｡񲨕<\x{0338}𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?｡\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦。񲨕≮𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦。񲨕≮𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\?\≮𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦。񲨕<\x{0338}𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠴦。񲨕<\x{0338}𐦜", %p)},	undef,	"to_unicode\(\'\\u200C\?\。\?\<\\u0338𐦜\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈✌򟬟．𝟡񠱣", %p)},	undef,	"to_unicode\(\'⒈\✌\?．𝟡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.✌򟬟.9񠱣", %p)},	undef,	"to_unicode\(\'1\.\✌\?\.9\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𑆾𞤬𐮆.\x{0666}\x{1DD4}", %p)},	undef,	"to_unicode\(\'𑆾\?𐮆\.\\u0666\\u1DD4\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'ς．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'ς\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'Σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'Σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_unicode\(\'σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐳐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐳐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐳐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐳐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐳐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐳐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐳐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐳐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐳐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐳐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐲐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐲐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐲐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐲐.\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐲐\.\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐲐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}>\x{0338}𐲐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\>\\u0338𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐲐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰶\x{200C}≯𐲐．\x{085B}", %p)},	undef,	"to_unicode\(\'\?\\u200C\≯𐲐．\\u085B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡≯", %p)},	undef,	"to_unicode\(\'羚｡\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡>\x{0338}", %p)},	undef,	"to_unicode\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。≯", %p)},	undef,	"to_unicode\(\'羚\。\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。>\x{0338}", %p)},	undef,	"to_unicode\(\'羚\。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂\x{1759}．\x{08A8}", %p)},	undef,	"to_unicode\(\'𑓂\\u1759．\\u08A8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂\x{1759}.\x{08A8}", %p)},	undef,	"to_unicode\(\'𑓂\\u1759\.\\u08A8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}ҠჀ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}ҠჀ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}ҡⴠ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}ҡⴠ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}Ҡⴠ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}。\x{0663}Ҡⴠ3", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D\。\\u0663Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨣿󠇀\x{200D}｡\x{0663}Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'\?\󠇀\\u200D｡\\u0663Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3955\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ᡷ。𐹢\x{08E0}", %p)},	undef,	"to_unicode\(\'ᡷ\。𐹢\\u08E0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_unicode\(\'\?\\u1BF3｡\\u0666\?\\u17D2ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_unicode\(\'\?\\u1BF3\。\\u0666\?\\u17D2ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_unicode\(\'\?\\u1BF3\。\\u0666\?\\u17D2SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_unicode\(\'\?\\u1BF3\。\\u0666\?\\u17D2ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_unicode\(\'\?\\u1BF3\。\\u0666\?\\u17D2Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_unicode\(\'\?\\u1BF3｡\\u0666\?\\u17D2SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_unicode\(\'\?\\u1BF3｡\\u0666\?\\u17D2ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_unicode\(\'\?\\u1BF3｡\\u0666\?\\u17D2Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0664}򤽎𑲛.󠔢︒≠", %p)},	undef,	"to_unicode\(\'\\u0664\?\?\.\?︒\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0664}򤽎𑲛.󠔢︒=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0664\?\?\.\?︒\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0664}򤽎𑲛.󠔢。≠", %p)},	undef,	"to_unicode\(\'\\u0664\?\?\.\?\。\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0664}򤽎𑲛.󠔢。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0664\?\?\.\?\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕ỗ⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_unicode\(\'➆\?ỗ⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕o\x{0302}\x{0303}⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_unicode\(\'➆\?o\\u0302\\u0303⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕ỗ1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_unicode\(\'➆\?ỗ1\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕o\x{0302}\x{0303}1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_unicode\(\'➆\?o\\u0302\\u03031\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕O\x{0302}\x{0303}1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_unicode\(\'➆\?O\\u0302\\u03031\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕Ỗ1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_unicode\(\'➆\?Ỗ1\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕O\x{0302}\x{0303}⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_unicode\(\'➆\?O\\u0302\\u0303⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("➆񷧕Ỗ⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_unicode\(\'➆\?Ỗ⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3976\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}｡𞤘", %p)},	undef,	"to_unicode\(\'\\u200D｡\?\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3977\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}｡𞤘", %p)},	undef,	"to_unicode\(\'\\u200D｡\?\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3978\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}。𞤘", %p)},	undef,	"to_unicode\(\'\\u200D\。\?\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3979\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{200D}。𞤘", %p)},	undef,	"to_unicode\(\'\\u200D\。\?\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--ye6h", %p)},	"𞤺",	"to_unicode\(\'xn\-\-ye6h\'\)\ \[data\/IdnaTest\.txt\:3981\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤺", %p)},	"𞤺",	"to_unicode\(\'\?\'\)\ \[data\/IdnaTest\.txt\:3982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0829}\x{0724}.ᢣ", %p)},	undef,	"to_unicode\(\'\\u0829\\u0724\.ᢣ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3983\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾ß", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾ß", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾SS", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾SS", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾ss", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾ss", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾Ss", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073C}\x{200C}-。𓐾Ss", %p)},	undef,	"to_unicode\(\'\\u073C\\u200C\-\。\?Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cς🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cς🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3993\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ς🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cς🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3994\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ς🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cς🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3995\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}Σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}Σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3997\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}σ🃡16..\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🃡16\.\.\\u0CC6仧\\u0756\'\)\ throws\ error\ V5\ C1\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:3999\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:4000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:4001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:4002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🃡⒗.\x{0CC6}仧\x{0756}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🃡⒗\.\\u0CC6仧\\u0756\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:4003\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-.𞸚", %p)},	undef,	"to_unicode\(\'\-\.𞸚\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4004\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-.\x{0638}", %p)},	undef,	"to_unicode\(\'\-\.\\u0638\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򏛓\x{0683}.\x{0F7E}\x{0634}", %p)},	undef,	"to_unicode\(\'\?\\u0683\.\\u0F7E\\u0634\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FE6}\x{0843}񽶬.𐮏", %p)},	undef,	"to_unicode\(\'\\u0FE6\\u0843\?\.𐮏\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2񎨠\x{07CB}ß。ᠽ", %p)},	undef,	"to_unicode\(\'2\?\\u07CBß\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2񎨠\x{07CB}SS。ᠽ", %p)},	undef,	"to_unicode\(\'2\?\\u07CBSS\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2񎨠\x{07CB}ss。ᠽ", %p)},	undef,	"to_unicode\(\'2\?\\u07CBss\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2񎨠\x{07CB}Ss。ᠽ", %p)},	undef,	"to_unicode\(\'2\?\\u07CBSs\。ᠽ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CEß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮.\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮\.\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CESS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CEss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}<\x{0338}．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\<\\u0338．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{07CA}≮．\x{06CE}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u07CA\≮．\\u06CESs\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򷝬\x{135E}𑜧.\x{1DEB}-︒", %p)},	undef,	"to_unicode\(\'\-\?\\u135E𑜧\.\\u1DEB\-︒\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򷝬\x{135E}𑜧.\x{1DEB}-。", %p)},	undef,	"to_unicode\(\'\-\?\\u135E𑜧\.\\u1DEB\-\。\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.򚠡\x{1A59}", %p)},	undef,	"to_unicode\(\'︒\.\?\\u1A59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.򚠡\x{1A59}", %p)},	undef,	"to_unicode\(\'\。\.\?\\u1A59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4047\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0323}\x{2DE1}。\x{200C}⓾\x{200C}\x{06B9}", %p)},	undef,	"to_unicode\(\'\\u0323\\u2DE1\。\\u200C⓾\\u200C\\u06B9\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4048\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{0323}\x{2DE1}。\x{200C}⓾\x{200C}\x{06B9}", %p)},	undef,	"to_unicode\(\'\\u0323\\u2DE1\。\\u200C⓾\\u200C\\u06B9\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4049\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞠶ᠴ\x{06DD}｡\x{1074}𞤵󠅦", %p)},	undef,	"to_unicode\(\'𞠶ᠴ\\u06DD｡\\u1074\?\󠅦\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠶ᠴ\x{06DD}。\x{1074}𞤵󠅦", %p)},	undef,	"to_unicode\(\'𞠶ᠴ\\u06DD\。\\u1074\?\󠅦\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑰺.-򑟏", %p)},	undef,	"to_unicode\(\'\?\.\-\?\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:4052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠻩．赏", %p)},	undef,	"to_unicode\(\'\?．赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠻩.赏", %p)},	undef,	"to_unicode\(\'\?\.赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B0}ᠡ｡Ⴁ", %p)},	undef,	"to_unicode\(\'\\u06B0ᠡ｡Ⴁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B0}ᠡ。Ⴁ", %p)},	undef,	"to_unicode\(\'\\u06B0ᠡ\。Ⴁ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4056\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06B0}ᠡ。ⴁ", %p)},	undef,	"to_unicode\(\'\\u06B0ᠡ\。ⴁ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4057\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{06B0}ᠡ｡ⴁ", %p)},	undef,	"to_unicode\(\'\\u06B0ᠡ｡ⴁ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4058\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}ς｡-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBς｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}ς。-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBς\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{20DE}ⴊ\x{06BB}ς。-", %p)},	undef,	"to_unicode\(\'\\u20DEⴊ\\u06BBς\。\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4061\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}Σ。-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBΣ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4062\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{20DE}ⴊ\x{06BB}σ。-", %p)},	undef,	"to_unicode\(\'\\u20DEⴊ\\u06BBσ\。\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4063\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}σ。-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBσ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4064\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{20DE}ⴊ\x{06BB}ς｡-", %p)},	undef,	"to_unicode\(\'\\u20DEⴊ\\u06BBς｡\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4065\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}Σ｡-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBΣ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4066\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{20DE}ⴊ\x{06BB}σ｡-", %p)},	undef,	"to_unicode\(\'\\u20DEⴊ\\u06BBσ｡\-\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4067\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20DE}Ⴊ\x{06BB}σ｡-", %p)},	undef,	"to_unicode\(\'\\u20DEႪ\\u06BBσ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ.񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ.񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ．񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ．񍇦\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．\?\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򉟂󠵣.𐫫\x{1A60}󴺖\x{1B44}", %p)},	undef,	"to_unicode\(\'\?\?\.𐫫\\u1A60\?\\u1B44\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯❊ᠯ｡𐹱⺨", %p)},	undef,	"to_unicode\(\'\≯\❊ᠯ｡𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}❊ᠯ｡𐹱⺨", %p)},	undef,	"to_unicode\(\'\>\\u0338\❊ᠯ｡𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯❊ᠯ。𐹱⺨", %p)},	undef,	"to_unicode\(\'\≯\❊ᠯ\。𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}❊ᠯ。𐹱⺨", %p)},	undef,	"to_unicode\(\'\>\\u0338\❊ᠯ\。𐹱⺨\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􁕜𐹧𞭁𐹩。Ⴈ𐫮Ⴏ", %p)},	undef,	"to_unicode\(\'\?𐹧\?𐹩\。Ⴈ𐫮Ⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􁕜𐹧𞭁𐹩。ⴈ𐫮ⴏ", %p)},	undef,	"to_unicode\(\'\?𐹧\?𐹩\。ⴈ𐫮ⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4083\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠂。\x{A926}", %p)},	undef,	"to_unicode\(\'𞠂\。\\uA926\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4084\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟔𐹫．\x{0733}\x{1037}９ꡇ", %p)},	undef,	"to_unicode\(\'𝟔𐹫．\\u0733\\u1037９ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4085\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟔𐹫．\x{1037}\x{0733}９ꡇ", %p)},	undef,	"to_unicode\(\'𝟔𐹫．\\u1037\\u0733９ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4086\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("6𐹫.\x{1037}\x{0733}9ꡇ", %p)},	undef,	"to_unicode\(\'6𐹫\.\\u1037\\u07339ꡇ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4087\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0724}\x{0603}𞲶．\x{06D8}", %p)},	undef,	"to_unicode\(\'\\u0724\\u0603\?．\\u06D8\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0724}\x{0603}𞲶.\x{06D8}", %p)},	undef,	"to_unicode\(\'\\u0724\\u0603\?\.\\u06D8\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✆񱔩ꡋ．\x{0632}\x{200D}𞣴", %p)},	undef,	"to_unicode\(\'\✆\?ꡋ．\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✆񱔩ꡋ．\x{0632}\x{200D}𞣴", %p)},	undef,	"to_unicode\(\'\✆\?ꡋ．\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✆񱔩ꡋ.\x{0632}\x{200D}𞣴", %p)},	undef,	"to_unicode\(\'\✆\?ꡋ\.\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✆񱔩ꡋ.\x{0632}\x{200D}𞣴", %p)},	undef,	"to_unicode\(\'\✆\?ꡋ\.\\u0632\\u200D\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}񃾰𞸍-．≠򃁟𑋪", %p)},	undef,	"to_unicode\(\'\\u0845\?𞸍\-．\≠\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}񃾰𞸍-．=\x{0338}򃁟𑋪", %p)},	undef,	"to_unicode\(\'\\u0845\?𞸍\-．\=\\u0338\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}񃾰\x{0646}-.≠򃁟𑋪", %p)},	undef,	"to_unicode\(\'\\u0845\?\\u0646\-\.\≠\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0845}񃾰\x{0646}-.=\x{0338}򃁟𑋪", %p)},	undef,	"to_unicode\(\'\\u0845\?\\u0646\-\.\=\\u0338\?𑋪\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛．笠", %p)},	"3.笠",	"to_unicode\(\'𝟛．笠\'\)\ \[data\/IdnaTest\.txt\:4098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛．笠", %p)},	"3.笠",	"to_unicode\(\'𝟛．笠\'\)\ \[data\/IdnaTest\.txt\:4099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3.笠", %p)},	"3.笠",	"to_unicode\(\'3\.笠\'\)\ \[data\/IdnaTest\.txt\:4100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3.xn--6vz", %p)},	"3.笠",	"to_unicode\(\'3\.xn\-\-6vz\'\)\ \[data\/IdnaTest\.txt\:4101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4103\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4104\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4105\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}ςß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ςß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ςß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ςß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ΣSS\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ΣSS\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σss\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σß\x{0731}.\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u0731\.\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ΣSS\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ΣSS\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σss\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}Σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}σß\x{0731}．\x{0BCD}", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\u0731．\\u0BCD\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FC01}｡\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_unicode\(\'\\uFC01｡\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0626}\x{062D}。\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_unicode\(\'\\u0626\\u062D\。\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0654}\x{062D}。\x{0C81}ᠼ▗򒁋", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\\u062D\。\\u0C81ᠼ\▗\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}ς．ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDς．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}ς.ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDς\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ.Σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ\.Σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}σ.ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDσ\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}σ.σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDσ\.σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ.σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ\.σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ.ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ\.ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ．Σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ．Σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}σ．ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDσ．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}σ．σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDσ．σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ．σ𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ．σ𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧋵\x{09CD}Σ．ς𐨿", %p)},	undef,	"to_unicode\(\'\?\\u09CDΣ．ς𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫓\x{07D8}牅\x{08F8}｡𞦤\x{1A17}򱍰Ⴙ", %p)},	undef,	"to_unicode\(\'𐫓\\u07D8牅\\u08F8｡\?\\u1A17\?Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫓\x{07D8}牅\x{08F8}。𞦤\x{1A17}򱍰Ⴙ", %p)},	undef,	"to_unicode\(\'𐫓\\u07D8牅\\u08F8\。\?\\u1A17\?Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫓\x{07D8}牅\x{08F8}。𞦤\x{1A17}򱍰ⴙ", %p)},	undef,	"to_unicode\(\'𐫓\\u07D8牅\\u08F8\。\?\\u1A17\?ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫓\x{07D8}牅\x{08F8}｡𞦤\x{1A17}򱍰ⴙ", %p)},	undef,	"to_unicode\(\'𐫓\\u07D8牅\\u08F8｡\?\\u1A17\?ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣤒｡륧", %p)},	undef,	"to_unicode\(\'\?｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣤒｡륧", %p)},	undef,	"to_unicode\(\'\?｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣤒。륧", %p)},	undef,	"to_unicode\(\'\?\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣤒。륧", %p)},	undef,	"to_unicode\(\'\?\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷\x{200D}。󉵢", %p)},	undef,	"to_unicode\(\'𐹷\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷\x{200D}。󉵢", %p)},	undef,	"to_unicode\(\'𐹷\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{06C2}𑲭｡-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u06C2\?｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{06C1}\x{0654}𑲭｡-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u06C1\\u0654\?｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{06C2}𑲭。-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u06C2\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘ\x{06C1}\x{0654}𑲭。-", %p)},	undef,	"to_unicode\(\'Ⴘ\\u06C1\\u0654\?\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4166\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴘ\x{06C1}\x{0654}𑲭。-", %p)},	undef,	"to_unicode\(\'ⴘ\\u06C1\\u0654\?\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴘ\x{06C2}𑲭。-", %p)},	undef,	"to_unicode\(\'ⴘ\\u06C2\?\。\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4168\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴘ\x{06C1}\x{0654}𑲭｡-", %p)},	undef,	"to_unicode\(\'ⴘ\\u06C1\\u0654\?｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4169\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("ⴘ\x{06C2}𑲭｡-", %p)},	undef,	"to_unicode\(\'ⴘ\\u06C2\?｡\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A806}\x{067B}₆ᡐ。🛇\x{FCDD}", %p)},	undef,	"to_unicode\(\'\\uA806\\u067B₆ᡐ\。🛇\\uFCDD\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4171\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A806}\x{067B}6ᡐ。🛇\x{064A}\x{0645}", %p)},	undef,	"to_unicode\(\'\\uA806\\u067B6ᡐ\。🛇\\u064A\\u0645\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4172\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򸍂.㇄ᡟ𐫂\x{0622}", %p)},	undef,	"to_unicode\(\'\?\.㇄ᡟ𐫂\\u0622\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸍂.㇄ᡟ𐫂\x{0627}\x{0653}", %p)},	undef,	"to_unicode\(\'\?\.㇄ᡟ𐫂\\u0627\\u0653\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}򵚌。-\x{07E9}", %p)},	undef,	"to_unicode\(\'\\u07DF\?\。\-\\u07E9\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:4175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ς\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ς\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'ς\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'ς\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{0643}襾.\x{200C}ᢟ\x{200C}1.", %p)},	undef,	"to_unicode\(\'σ\\u0643襾\.\\u200Cᢟ\\u200C1\.\'\)\ throws\ error\ B5\ C1\ \[data\/IdnaTest\.txt\:4183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{0643}⾑．\x{200C}ᢟ\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σ\\u0643⾑．\\u200Cᢟ\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:4187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆ𑓝．𞵆", %p)},	undef,	"to_unicode\(\'ᡆ\?．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡆ𑓝.𞵆", %p)},	undef,	"to_unicode\(\'ᡆ\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}𦍓\x{1DEE}｡\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_unicode\(\'\\u0A4D𦍓\\u1DEE｡\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}𦍓\x{1DEE}｡\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_unicode\(\'\\u0A4D𦍓\\u1DEE｡\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}𦍓\x{1DEE}。\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_unicode\(\'\\u0A4D𦍓\\u1DEE\。\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}𦍓\x{1DEE}。\x{200C}\x{08BD}񝹲", %p)},	undef,	"to_unicode\(\'\\u0A4D𦍓\\u1DEE\。\\u200C\\u08BD\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062E}\x{0748}񅪪-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'\\u062E\\u0748\?\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􋿦｡ᠽ", %p)},	undef,	"to_unicode\(\'\?｡ᠽ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􋿦。ᠽ", %p)},	undef,	"to_unicode\(\'\?\。ᠽ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃𝍌．\x{200D}\x{0B44}", %p)},	undef,	"to_unicode\(\'嬃𝍌．\\u200D\\u0B44\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃𝍌．\x{200D}\x{0B44}", %p)},	undef,	"to_unicode\(\'嬃𝍌．\\u200D\\u0B44\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4205\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃𝍌.\x{200D}\x{0B44}", %p)},	undef,	"to_unicode\(\'嬃𝍌\.\\u200D\\u0B44\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4206\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("嬃𝍌.\x{200D}\x{0B44}", %p)},	undef,	"to_unicode\(\'嬃𝍌\.\\u200D\\u0B44\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4207\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0602}𝌪≯．𚋲򵁨", %p)},	undef,	"to_unicode\(\'\\u0602𝌪\≯．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0602}𝌪>\x{0338}．𚋲򵁨", %p)},	undef,	"to_unicode\(\'\\u0602𝌪\>\\u0338．\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0602}𝌪≯.𚋲򵁨", %p)},	undef,	"to_unicode\(\'\\u0602𝌪\≯\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0602}𝌪>\x{0338}.𚋲򵁨", %p)},	undef,	"to_unicode\(\'\\u0602𝌪\>\\u0338\.\?\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򫾥\x{08B7}\x{17CC}\x{A9C0}.𞼠", %p)},	undef,	"to_unicode\(\'\?\\u08B7\\u17CC\\uA9C0\.\?\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.񟛤", %p)},	undef,	"to_unicode\(\'\\u200C\.\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.񟛤", %p)},	undef,	"to_unicode\(\'\\u200C\.\?\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺛕Ⴃ䠅．𐸑", %p)},	undef,	"to_unicode\(\'\?Ⴃ䠅．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺛕Ⴃ䠅.𐸑", %p)},	undef,	"to_unicode\(\'\?Ⴃ䠅\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺛕ⴃ䠅.𐸑", %p)},	undef,	"to_unicode\(\'\?ⴃ䠅\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺛕ⴃ䠅．𐸑", %p)},	undef,	"to_unicode\(\'\?ⴃ䠅．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF1}𐹳𐹵𞤚｡𝟨Ⴅ", %p)},	undef,	"to_unicode\(\'\\u1BF1𐹳𐹵\?｡𝟨Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BF1}𐹳𐹵𞤚。6Ⴅ", %p)},	undef,	"to_unicode\(\'\\u1BF1𐹳𐹵\?\。6Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4220\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{1BF1}𐹳𐹵𞤚。6ⴅ", %p)},	undef,	"to_unicode\(\'\\u1BF1𐹳𐹵\?\。6ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4221\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("\x{1BF1}𐹳𐹵𞤚｡𝟨ⴅ", %p)},	undef,	"to_unicode\(\'\\u1BF1𐹳𐹵\?｡𝟨ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4222\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡︒", %p)},	undef,	"to_unicode\(\'\-｡︒\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。。", %p)},	undef,	"to_unicode\(\'\-\。\。\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:4224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DB}Ⴠ｡-⁵--", %p)},	undef,	"to_unicode\(\'\\u07DBჀ｡\-⁵\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DB}Ⴠ。-5--", %p)},	undef,	"to_unicode\(\'\\u07DBჀ\。\-5\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4226\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07DB}ⴠ。-5--", %p)},	undef,	"to_unicode\(\'\\u07DBⴠ\。\-5\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4227\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07DB}ⴠ｡-⁵--", %p)},	undef,	"to_unicode\(\'\\u07DBⴠ｡\-⁵\-\-\'\)\ throws\ error\ V2\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4228\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{D8DD}󠑕｡𐹷𐹻≯𐷒", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD\?｡𐹷𐹻\≯\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}󠑕｡𐹷𐹻>\x{0338}𐷒", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD\?｡𐹷𐹻\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{D8DD}󠑕。𐹷𐹻≯𐷒", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD\?\。𐹷𐹻\≯\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}󠑕。𐹷𐹻>\x{0338}𐷒", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD\?\。𐹷𐹻\>\\u0338\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'㍔\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'㍔\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'ルーブル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'ルーブル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{08E6}\x{077C}\x{200D}。\x{0346}򁳊𝅶\x{0604}", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\u08E6\\u077C\\u200D\。\\u0346\?\?\\u0604\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f", %p)},	"f",	"to_unicode\(\'f\'\)\ \[data\/IdnaTest\.txt\:4241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9bm.ss", %p)},	"㨲.ss",	"to_unicode\(\'xn\-\-9bm\.ss\'\)\ \[data\/IdnaTest\.txt\:4248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨲.ss", %p)},	"㨲.ss",	"to_unicode\(\'㨲\.ss\'\)\ \[data\/IdnaTest\.txt\:4249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0605}\x{067E}｡\x{08A8}", %p)},	undef,	"to_unicode\(\'\\u0605\\u067E｡\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0605}\x{067E}。\x{08A8}", %p)},	undef,	"to_unicode\(\'\\u0605\\u067E\。\\u08A8\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4253\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("⾑\x{0753}𞤁。𐹵\x{0682}", %p)},	undef,	"to_unicode\(\'⾑\\u0753\?\。𐹵\\u0682\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4254\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("襾\x{0753}𞤁。𐹵\x{0682}", %p)},	undef,	"to_unicode\(\'襾\\u0753\?\。𐹵\\u0682\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4255\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񦴻ς-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?ς\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦴻ς-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?ς\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦴻Σ-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?Σ\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦴻σ-\x{20EB}。\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?σ\-\\u20EB\。\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦴻Σ-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?Σ\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦴻σ-\x{20EB}｡\x{0754}-ꡛ", %p)},	undef,	"to_unicode\(\'\?σ\-\\u20EB｡\\u0754\-ꡛ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．􀸨", %p)},	undef,	"to_unicode\(\'\\u200D．\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．􀸨", %p)},	undef,	"to_unicode\(\'\\u200D．\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.􀸨", %p)},	undef,	"to_unicode\(\'\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.􀸨", %p)},	undef,	"to_unicode\(\'\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣭻񌥁｡≠𝟲", %p)},	undef,	"to_unicode\(\'\?\?｡\≠𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣭻񌥁｡=\x{0338}𝟲", %p)},	undef,	"to_unicode\(\'\?\?｡\=\\u0338𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣭻񌥁。≠6", %p)},	undef,	"to_unicode\(\'\?\?\。\≠6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񣭻񌥁。=\x{0338}6", %p)},	undef,	"to_unicode\(\'\?\?\。\=\\u03386\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅊ᡭ\x{200D}.𐥡", %p)},	undef,	"to_unicode\(\'\󠅊ᡭ\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅊ᡭ\x{200D}.𐥡", %p)},	undef,	"to_unicode\(\'\󠅊ᡭ\\u200D\.\?\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C40}\x{0855}𐥛𑄴．󭰵", %p)},	undef,	"to_unicode\(\'\\u0C40\\u0855\?𑄴．\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C40}\x{0855}𐥛𑄴.󭰵", %p)},	undef,	"to_unicode\(\'\\u0C40\\u0855\?𑄴\.\?\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤮。𑇊\x{200C}≯\x{1CE6}", %p)},	undef,	"to_unicode\(\'\?\。𑇊\\u200C\≯\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤮。𑇊\x{200C}≯\x{1CE6}", %p)},	undef,	"to_unicode\(\'\?\。𑇊\\u200C\≯\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤮。𑇊\x{200C}>\x{0338}\x{1CE6}", %p)},	undef,	"to_unicode\(\'\?\。𑇊\\u200C\>\\u0338\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤮。𑇊\x{200C}>\x{0338}\x{1CE6}", %p)},	undef,	"to_unicode\(\'\?\。𑇊\\u200C\>\\u0338\\u1CE6\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄀𝟕.𞤌񛗓Ⴉ", %p)},	undef,	"to_unicode\(\'\󠄀𝟕\.\?\?Ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄀7.𞤌񛗓Ⴉ", %p)},	undef,	"to_unicode\(\'\󠄀7\.\?\?Ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄀7.𞤌񛗓ⴉ", %p)},	undef,	"to_unicode\(\'\󠄀7\.\?\?ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄀𝟕.𞤌񛗓ⴉ", %p)},	undef,	"to_unicode\(\'\󠄀𝟕\.\?\?ⴉ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("閃9𝩍。Ↄ\x{0669}\x{08B1}\x{0B4D}", %p)},	undef,	"to_unicode\(\'閃9𝩍\。Ↄ\\u0669\\u08B1\\u0B4D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("閃9𝩍。ↄ\x{0669}\x{08B1}\x{0B4D}", %p)},	undef,	"to_unicode\(\'閃9𝩍\。ↄ\\u0669\\u08B1\\u0B4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4283\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{AAF6}ᢏ\x{0E3A}２.𐋢\x{0745}\x{0F9F}︒", %p)},	undef,	"to_unicode\(\'\\uAAF6ᢏ\\u0E3A２\.𐋢\\u0745\\u0F9F︒\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4284\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{AAF6}ᢏ\x{0E3A}2.𐋢\x{0745}\x{0F9F}。", %p)},	undef,	"to_unicode\(\'\\uAAF6ᢏ\\u0E3A2\.𐋢\\u0745\\u0F9F\。\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4285\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󅴧｡≠-󠙄⾛", %p)},	undef,	"to_unicode\(\'\?｡\≠\-\?⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󅴧｡=\x{0338}-󠙄⾛", %p)},	undef,	"to_unicode\(\'\?｡\=\\u0338\-\?⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󅴧。≠-󠙄走", %p)},	undef,	"to_unicode\(\'\?\。\≠\-\?走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󅴧。=\x{0338}-󠙄走", %p)},	undef,	"to_unicode\(\'\?\。\=\\u0338\-\?走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{0604}Ⴊ。-≠\x{1160}", %p)},	undef,	"to_unicode\(\'\\u076E\\u0604Ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{0604}Ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_unicode\(\'\\u076E\\u0604Ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{0604}ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_unicode\(\'\\u076E\\u0604ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{0604}ⴊ。-≠\x{1160}", %p)},	undef,	"to_unicode\(\'\\u076E\\u0604ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB4F}𐹧𝟒≯｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\uFB4F𐹧𝟒\≯｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB4F}𐹧𝟒≯｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\uFB4F𐹧𝟒\≯｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB4F}𐹧𝟒>\x{0338}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\uFB4F𐹧𝟒\>\\u0338｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB4F}𐹧𝟒>\x{0338}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\uFB4F𐹧𝟒\>\\u0338｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05DC}𐹧4≯。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05D0\\u05DC𐹧4\≯\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05DC}𐹧4≯。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05D0\\u05DC𐹧4\≯\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05DC}𐹧4>\x{0338}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05D0\\u05DC𐹧4\>\\u0338\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05DC}𐹧4>\x{0338}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05D0\\u05DC𐹧4\>\\u0338\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟎。甯", %p)},	"0.甯",	"to_unicode\(\'𝟎\。甯\'\)\ \[data\/IdnaTest\.txt\:4302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0。甯", %p)},	"0.甯",	"to_unicode\(\'0\。甯\'\)\ \[data\/IdnaTest\.txt\:4303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.xn--qny", %p)},	"0.甯",	"to_unicode\(\'0\.xn\-\-qny\'\)\ \[data\/IdnaTest\.txt\:4304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.甯", %p)},	"0.甯",	"to_unicode\(\'0\.甯\'\)\ \[data\/IdnaTest\.txt\:4305\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-⾆．\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-⾆．\\uAAF6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("-舌.\x{AAF6}", %p)},	undef,	"to_unicode\(\'\-舌\.\\uAAF6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4307\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡ᢘ", %p)},	undef,	"to_unicode\(\'\-｡ᢘ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。ᢘ", %p)},	undef,	"to_unicode\(\'\-\。ᢘ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂴Ⴋ.≮", %p)},	undef,	"to_unicode\(\'🂴Ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂴Ⴋ.<\x{0338}", %p)},	undef,	"to_unicode\(\'🂴Ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂴ⴋ.<\x{0338}", %p)},	undef,	"to_unicode\(\'🂴ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🂴ⴋ.≮", %p)},	undef,	"to_unicode\(\'🂴ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4313\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("璼𝨭｡\x{200C}󠇟", %p)},	undef,	"to_unicode\(\'璼𝨭｡\\u200C\󠇟\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4314\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("璼𝨭｡\x{200C}󠇟", %p)},	undef,	"to_unicode\(\'璼𝨭｡\\u200C\󠇟\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4315\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("璼𝨭。\x{200C}󠇟", %p)},	undef,	"to_unicode\(\'璼𝨭\。\\u200C\󠇟\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4316\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("璼𝨭。\x{200C}󠇟", %p)},	undef,	"to_unicode\(\'璼𝨭\。\\u200C\󠇟\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4317\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("xn--gky8837e.", %p)},	"璼𝨭.",	"to_unicode\(\'xn\-\-gky8837e\.\'\)\ \[data\/IdnaTest\.txt\:4318\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_unicode("璼𝨭.", %p)},	"璼𝨭.",	"to_unicode\(\'璼𝨭\.\'\)\ \[data\/IdnaTest\.txt\:4319\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0669}8񂍽｡-5🞥", %p)},	undef,	"to_unicode\(\'\\u06698\?｡\-5🞥\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0669}8񂍽。-5🞥", %p)},	undef,	"to_unicode\(\'\\u06698\?\。\-5🞥\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}튛.\x{0716}", %p)},	undef,	"to_unicode\(\'\\u200D튛\.\\u0716\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}튛.\x{0716}", %p)},	undef,	"to_unicode\(\'\\u200D튛\.\\u0716\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}튛.\x{0716}", %p)},	undef,	"to_unicode\(\'\\u200D튛\.\\u0716\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}튛.\x{0716}", %p)},	undef,	"to_unicode\(\'\\u200D튛\.\\u0716\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--157b.xn--gnb", %p)},	"튛.\x{0716}",	"to_unicode\(\'xn\-\-157b\.xn\-\-gnb\'\)\ \[data\/IdnaTest\.txt\:4328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("튛.\x{0716}", %p)},	"튛.\x{0716}",	"to_unicode\(\'튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("튛.\x{0716}", %p)},	"튛.\x{0716}",	"to_unicode\(\'튛\.\\u0716\'\)\ \[data\/IdnaTest\.txt\:4330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡋ𐹰𞽳.\x{0779}ⴞ", %p)},	undef,	"to_unicode\(\'ᡋ𐹰\?\.\\u0779ⴞ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡋ𐹰𞽳.\x{0779}Ⴞ", %p)},	undef,	"to_unicode\(\'ᡋ𐹰\?\.\\u0779Ⴞ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:4332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐷃\x{0662}𝅻𝟧．𐹮𐹬Ⴇ", %p)},	undef,	"to_unicode\(\'\?\\u0662𝅻𝟧．𐹮𐹬Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐷃\x{0662}𝅻5.𐹮𐹬Ⴇ", %p)},	undef,	"to_unicode\(\'\?\\u0662𝅻5\.𐹮𐹬Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐷃\x{0662}𝅻5.𐹮𐹬ⴇ", %p)},	undef,	"to_unicode\(\'\?\\u0662𝅻5\.𐹮𐹬ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐷃\x{0662}𝅻𝟧．𐹮𐹬ⴇ", %p)},	undef,	"to_unicode\(\'\?\\u0662𝅻𝟧．𐹮𐹬ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴗ．\x{05C2}𑄴\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'Ⴗ．\\u05C2𑄴\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴗ．𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'Ⴗ．𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴗ.𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'Ⴗ\.𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴗ.𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'ⴗ\.𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴗ．𑄴\x{05C2}\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'ⴗ．𑄴\\u05C2\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴗ．\x{05C2}𑄴\x{A9B7}񘃨", %p)},	undef,	"to_unicode\(\'ⴗ．\\u05C2𑄴\\uA9B7\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟾𾤘．򇕛\x{066C}", %p)},	undef,	"to_unicode\(\'𝟾\?．\?\\u066C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8𾤘.򇕛\x{066C}", %p)},	undef,	"to_unicode\(\'8\?\.\?\\u066C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈酫︒。\x{08D6}", %p)},	undef,	"to_unicode\(\'⒈酫︒\。\\u08D6\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4345\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("1.酫。。\x{08D6}", %p)},	undef,	"to_unicode\(\'1\.酫\。\。\\u08D6\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4346\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2DE3}\x{200C}≮\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u2DE3\\u200C\≮\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DE3}\x{200C}≮\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u2DE3\\u200C\≮\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DE3}\x{200C}<\x{0338}\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u2DE3\\u200C\<\\u0338\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DE3}\x{200C}<\x{0338}\x{1A6B}.\x{200C}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u2DE3\\u200C\<\\u0338\\u1A6B\.\\u200C\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ႷႽ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ႷႽ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ႷႽ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ႷႽ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ႷႽ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ႷႽ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ႷႽ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ႷႽ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。Ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。Ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。Ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞪂。Ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。Ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄴𑄳2.𞳿󠀳-", %p)},	undef,	"to_unicode\(\'𑄴𑄳2\.\?\?\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:4363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕲󟶶\x{0665}｡񀁁𑄳𞤃\x{0710}", %p)},	undef,	"to_unicode\(\'\?\?\\u0665｡\?𑄳\?\\u0710\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:4364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠕲󟶶\x{0665}。񀁁𑄳𞤃\x{0710}", %p)},	undef,	"to_unicode\(\'\?\?\\u0665\。\?𑄳\?\\u0710\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:4365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡ςᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡ςᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。ςᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。ςᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。ςᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。Σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。Σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}。σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB\。σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡Σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡Σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡Σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}򲠽𐹢\x{17BB}｡σᢈ🝭\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0720\?𐹢\\u17BB｡σᢈ🝭\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:4377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--≮。𐹧", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\≮\。𐹧\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--≮。𐹧", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\≮\。𐹧\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--<\x{0338}。𐹧", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\<\\u0338\。𐹧\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--<\x{0338}。𐹧", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\<\\u0338\。𐹧\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}。𻚏\x{0FB0}⒕", %p)},	undef,	"to_unicode\(\'\\uA806\。\?\\u0FB0⒕\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A806}。𻚏\x{0FB0}14.", %p)},	undef,	"to_unicode\(\'\\uA806\。\?\\u0FB014\.\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򮉂\x{06BC}．𑆺\x{0669}", %p)},	undef,	"to_unicode\(\'\?\\u06BC．𑆺\\u0669\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򮉂\x{06BC}.𑆺\x{0669}", %p)},	undef,	"to_unicode\(\'\?\\u06BC\.𑆺\\u0669\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁎\x{06D0}-。𞤴", %p)},	undef,	"to_unicode\(\'\?\\u06D0\-\。\?\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4386\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟠4󠇗𝈻．\x{200D}𐋵⛧\x{200D}", %p)},	undef,	"to_unicode\(\'𝟠4\󠇗𝈻．\\u200D𐋵\⛧\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4387\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟠4󠇗𝈻．\x{200D}𐋵⛧\x{200D}", %p)},	undef,	"to_unicode\(\'𝟠4\󠇗𝈻．\\u200D𐋵\⛧\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4388\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84󠇗𝈻.\x{200D}𐋵⛧\x{200D}", %p)},	undef,	"to_unicode\(\'84\󠇗𝈻\.\\u200D𐋵\⛧\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84󠇗𝈻.\x{200D}𐋵⛧\x{200D}", %p)},	undef,	"to_unicode\(\'84\󠇗𝈻\.\\u200D𐋵\⛧\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4390\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--84-s850a.xn--59h6326e", %p)},	"84𝈻.𐋵⛧",	"to_unicode\(\'xn\-\-84\-s850a\.xn\-\-59h6326e\'\)\ \[data\/IdnaTest\.txt\:4391\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84𝈻.𐋵⛧", %p)},	"84𝈻.𐋵⛧",	"to_unicode\(\'84𝈻\.𐋵\⛧\'\)\ \[data\/IdnaTest\.txt\:4392\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{0601}｡ᡪ", %p)},	undef,	"to_unicode\(\'\-\\u0601｡ᡪ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0601}。ᡪ", %p)},	undef,	"to_unicode\(\'\-\\u0601\。ᡪ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖ß≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖ß≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖SS≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖ss≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖Ss≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖SS≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖ss≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖Ss≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("朶Ⴉ𞪡.𝨽\x{0825}📻-", %p)},	undef,	"to_unicode\(\'朶Ⴉ\?\.𝨽\\u0825📻\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("朶ⴉ𞪡.𝨽\x{0825}📻-", %p)},	undef,	"to_unicode\(\'朶ⴉ\?\.𝨽\\u0825📻\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐤎。󑿰\x{200C}≮\x{200D}", %p)},	undef,	"to_unicode\(\'𐤎\。\?\\u200C\≮\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐤎。󑿰\x{200C}≮\x{200D}", %p)},	undef,	"to_unicode\(\'𐤎\。\?\\u200C\≮\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐤎。󑿰\x{200C}<\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'𐤎\。\?\\u200C\<\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐤎。󑿰\x{200C}<\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'𐤎\。\?\\u200C\<\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񭜎⒈｡\x{200C}𝟤", %p)},	undef,	"to_unicode\(\'\?⒈｡\\u200C𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񭜎⒈｡\x{200C}𝟤", %p)},	undef,	"to_unicode\(\'\?⒈｡\\u200C𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񭜎1.。\x{200C}2", %p)},	undef,	"to_unicode\(\'\?1\.\。\\u200C2\'\)\ throws\ error\ P1\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:4419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񭜎1.。\x{200C}2", %p)},	undef,	"to_unicode\(\'\?1\.\。\\u200C2\'\)\ throws\ error\ P1\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:4420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠟊𐹤\x{200D}．𐹳󙄵𐹶", %p)},	undef,	"to_unicode\(\'\?𐹤\\u200D．𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠟊𐹤\x{200D}．𐹳󙄵𐹶", %p)},	undef,	"to_unicode\(\'\?𐹤\\u200D．𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠟊𐹤\x{200D}.𐹳󙄵𐹶", %p)},	undef,	"to_unicode\(\'\?𐹤\\u200D\.𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠟊𐹤\x{200D}.𐹳󙄵𐹶", %p)},	undef,	"to_unicode\(\'\?𐹤\\u200D\.𐹳\?𐹶\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴𐹻𑓂𐭝．\x{094D}\x{FE07}􉛯", %p)},	undef,	"to_unicode\(\'\?𐹻𑓂𐭝．\\u094D\\uFE07\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴𐹻𑓂𐭝.\x{094D}\x{FE07}􉛯", %p)},	undef,	"to_unicode\(\'\?𐹻𑓂𐭝\.\\u094D\\uFE07\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0668}｡𐹠𐹽񗮶", %p)},	undef,	"to_unicode\(\'\\u0668｡𐹠𐹽\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0668}。𐹠𐹽񗮶", %p)},	undef,	"to_unicode\(\'\\u0668\。𐹠𐹽\?\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}񍀜.8򶾵\x{069C}", %p)},	undef,	"to_unicode\(\'\\u1160\?\.8\?\\u069C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4429\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡ß𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡ß𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4430\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡ß𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡ß𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4431\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。ß𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。ß𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4432\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。ß𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。ß𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。SS𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。SS𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4434\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。SS𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。SS𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4435\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4436\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4437\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。Ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。Ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4438\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪。Ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪\。Ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4439\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--ss-bh7o", %p)},	"ss𑓃",	"to_unicode\(\'xn\-\-ss\-bh7o\'\)\ \[data\/IdnaTest\.txt\:4440\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss𑓃", %p)},	"ss𑓃",	"to_unicode\(\'ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4441\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS𑓃", %p)},	"ss𑓃",	"to_unicode\(\'SS𑓃\'\)\ \[data\/IdnaTest\.txt\:4442\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss𑓃", %p)},	"ss𑓃",	"to_unicode\(\'Ss𑓃\'\)\ \[data\/IdnaTest\.txt\:4443\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡SS𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡SS𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4444\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡SS𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡SS𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4445\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4446\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4447\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡Ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡Ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4448\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}\x{200C}󠆪｡Ss𑓃", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\󠆪｡Ss𑓃\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4449\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒\x{200C}ヶ䒩.ꡪ", %p)},	undef,	"to_unicode\(\'︒\\u200Cヶ䒩\.ꡪ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{200C}ヶ䒩.ꡪ", %p)},	undef,	"to_unicode\(\'︒\\u200Cヶ䒩\.ꡪ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4451\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("。\x{200C}ヶ䒩.ꡪ", %p)},	undef,	"to_unicode\(\'\。\\u200Cヶ䒩\.ꡪ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4452\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("。\x{200C}ヶ䒩.ꡪ", %p)},	undef,	"to_unicode\(\'\。\\u200Cヶ䒩\.ꡪ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4453\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--qekw60d.xn--gd9a", %p)},	"ヶ䒩.ꡪ",	"to_unicode\(\'xn\-\-qekw60d\.xn\-\-gd9a\'\)\ \[data\/IdnaTest\.txt\:4454\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ヶ䒩.ꡪ", %p)},	"ヶ䒩.ꡪ",	"to_unicode\(\'ヶ䒩\.ꡪ\'\)\ \[data\/IdnaTest\.txt\:4455\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}⒈𤮍.󢓋\x{1A60}", %p)},	undef,	"to_unicode\(\'\\u200C⒈𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}⒈𤮍.󢓋\x{1A60}", %p)},	undef,	"to_unicode\(\'\\u200C⒈𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}1.𤮍.󢓋\x{1A60}", %p)},	undef,	"to_unicode\(\'\\u200C1\.𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}1.𤮍.󢓋\x{1A60}", %p)},	undef,	"to_unicode\(\'\\u200C1\.𤮍\.\?\\u1A60\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_unicode\(\'⒈\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_unicode\(\'⒈\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_unicode\(\'1\.\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}𐫓󠀺。\x{1A60}񤰵\x{200D}", %p)},	undef,	"to_unicode\(\'1\.\\u200C𐫓\?\。\\u1A60\?\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝅵｡𝟫𞀈䬺⒈", %p)},	undef,	"to_unicode\(\'\?｡𝟫\?䬺⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝅵。9𞀈䬺1.", %p)},	undef,	"to_unicode\(\'\?\。9\?䬺1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡼺≯。盚\x{0635}", %p)},	undef,	"to_unicode\(\'\?\≯\。盚\\u0635\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򡼺>\x{0338}。盚\x{0635}", %p)},	undef,	"to_unicode\(\'\?\>\\u0338\。盚\\u0635\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񿰭\x{05B4}。-󠁊𐢸≯", %p)},	undef,	"to_unicode\(\'\-\?\\u05B4\。\-\?\?\≯\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񿰭\x{05B4}。-󠁊𐢸>\x{0338}", %p)},	undef,	"to_unicode\(\'\-\?\\u05B4\。\-\?\?\>\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󿭓\x{1B44}\x{200C}\x{0A4D}．𐭛񳋔", %p)},	undef,	"to_unicode\(\'\?\\u1B44\\u200C\\u0A4D．𐭛\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󿭓\x{1B44}\x{200C}\x{0A4D}.𐭛񳋔", %p)},	undef,	"to_unicode\(\'\?\\u1B44\\u200C\\u0A4D\.𐭛\?\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4471\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("⾇.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	undef,	"to_unicode\(\'⾇\.\\u067D\?\\u06BB\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:4472\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("⾇.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	undef,	"to_unicode\(\'⾇\.\\u067D\?\\u06BB\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:4473\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("舛.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	undef,	"to_unicode\(\'舛\.\\u067D\?\\u06BB\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:4474\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("舛.\x{067D}𞤴\x{06BB}\x{200D}", %p)},	undef,	"to_unicode\(\'舛\.\\u067D\?\\u06BB\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:4475\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("xn--8c1a.xn--2ib8jn539l", %p)},	"舛.\x{067D}𞤴\x{06BB}",	"to_unicode\(\'xn\-\-8c1a\.xn\-\-2ib8jn539l\'\)\ \[data\/IdnaTest\.txt\:4476\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("舛.\x{067D}𞤴\x{06BB}", %p)},	"舛.\x{067D}𞤴\x{06BB}",	"to_unicode\(\'舛\.\\u067D\?\\u06BB\'\)\ \[data\/IdnaTest\.txt\:4477\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("4򭆥。\x{0767}≯", %p)},	undef,	"to_unicode\(\'4\?\。\\u0767\≯\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:4478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4򭆥。\x{0767}>\x{0338}", %p)},	undef,	"to_unicode\(\'4\?\。\\u0767\>\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:4479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲔏𞫨񺿂硲．\x{06AD}", %p)},	undef,	"to_unicode\(\'\?\?\?硲．\\u06AD\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲔏𞫨񺿂硲.\x{06AD}", %p)},	undef,	"to_unicode\(\'\?\?\?硲\.\\u06AD\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{FE08}\x{0666}Ⴆ℮", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uFE08\\u0666Ⴆ℮\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:4482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{FE08}\x{0666}Ⴆ℮", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uFE08\\u0666Ⴆ℮\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:4483\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.\x{FE08}\x{0666}ⴆ℮", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uFE08\\u0666ⴆ℮\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:4484\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.\x{FE08}\x{0666}ⴆ℮", %p)},	undef,	"to_unicode\(\'\\u200C\.\\uFE08\\u0666ⴆ℮\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:4485\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06A3}．\x{0D4D}\x{200D}Ϟ", %p)},	undef,	"to_unicode\(\'\\u06A3．\\u0D4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A3}.\x{0D4D}\x{200D}Ϟ", %p)},	undef,	"to_unicode\(\'\\u06A3\.\\u0D4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A3}.\x{0D4D}\x{200D}ϟ", %p)},	undef,	"to_unicode\(\'\\u06A3\.\\u0D4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A3}．\x{0D4D}\x{200D}ϟ", %p)},	undef,	"to_unicode\(\'\\u06A3．\\u0D4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4489\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𞸇𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C𞸇𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4490\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𞸇𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C𞸇𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4491\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𞸇𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C𞸇𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4492\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𞸇𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C𞸇𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4493\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{062D}𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u062D𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4494\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{062D}𑘿。\x{0623}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u062D𑘿\。\\u0623𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4495\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{062D}𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u062D𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4496\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{062D}𑘿。\x{0627}\x{0654}𐮂-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u062D𑘿\。\\u0627\\u0654𐮂\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4497\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-򭷙\x{066B}纛｡𝟛񭤇🄅", %p)},	undef,	"to_unicode\(\'\-\?\\u066B纛｡𝟛\?🄅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򭷙\x{066B}纛。3񭤇4,", %p)},	undef,	"to_unicode\(\'\-\?\\u066B纛\。3\?4\,\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔔．Ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_unicode\(\'🔔．Ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🔔.Ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_unicode\(\'🔔\.Ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4501\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🔔.ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_unicode\(\'🔔\.ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4502\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("🔔．ⴂ\x{07CC}\x{0BCD}𐋮", %p)},	undef,	"to_unicode\(\'🔔．ⴂ\\u07CC\\u0BCD𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4503\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("軥\x{06B3}.-𖬵", %p)},	undef,	"to_unicode\(\'軥\\u06B3\.\-𖬵\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4504\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹤\x{07CA}\x{06B6}.𐨂-", %p)},	undef,	"to_unicode\(\'𐹤\\u07CA\\u06B6\.𐨂\-\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:4505\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-󠅱0｡\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_unicode\(\'\-\󠅱0｡\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4506\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-󠅱0｡\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_unicode\(\'\-\󠅱0｡\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4507\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-󠅱0。\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_unicode\(\'\-\󠅱0\。\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4508\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-󠅱0。\x{17CF}\x{1DFD}톇십", %p)},	undef,	"to_unicode\(\'\-\󠅱0\。\\u17CF\\u1DFD톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4509\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡰ︒--｡\x{17CC}靈𐹢񘳮", %p)},	undef,	"to_unicode\(\'ꡰ︒\-\-｡\\u17CC靈𐹢\?\'\)\ throws\ error\ P1\ V2\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡰ。--。\x{17CC}靈𐹢񘳮", %p)},	undef,	"to_unicode\(\'ꡰ\。\-\-\。\\u17CC靈𐹢\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ႿႵრ｡\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115FႿႵრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ႿႵრ。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115FႿႵრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ⴟⴕრ。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115Fⴟⴕრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}Ⴟⴕრ。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115FႿⴕრ\。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ⴟⴕრ｡\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115Fⴟⴕრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}Ⴟⴕრ｡\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u115FႿⴕრ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄃𐹠.\x{0664}󠅇", %p)},	undef,	"to_unicode\(\'🄃𐹠\.\\u0664\󠅇\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2,𐹠.\x{0664}󠅇", %p)},	undef,	"to_unicode\(\'2\,𐹠\.\\u0664\󠅇\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻲼\x{200C}\x{FC5B}．\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\?\\u200C\\uFC5B．\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻲼\x{200C}\x{FC5B}．\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\?\\u200C\\uFC5B．\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻲼\x{200C}\x{0630}\x{0670}.\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0630\\u0670\.\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻲼\x{200C}\x{0630}\x{0670}.\x{07D2}\x{0848}\x{1BF3}", %p)},	undef,	"to_unicode\(\'\?\\u200C\\u0630\\u0670\.\\u07D2\\u0848\\u1BF3\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200D}𞵪\x{200C}。ᡘ𑲭\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200D\?\\u200C\。ᡘ\?\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:4524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200D}𞵪\x{200C}。ᡘ𑲭\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200D\?\\u200C\。ᡘ\?\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:4525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞷻。⚄񗑇𑁿", %p)},	undef,	"to_unicode\(\'\?\。\⚄\?𑁿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}≠．𞠨\x{0667}", %p)},	undef,	"to_unicode\(\'\\uA8C4\≠．𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}=\x{0338}．𞠨\x{0667}", %p)},	undef,	"to_unicode\(\'\\uA8C4\=\\u0338．𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}≠.𞠨\x{0667}", %p)},	undef,	"to_unicode\(\'\\uA8C4\≠\.𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8C4}=\x{0338}.𞠨\x{0667}", %p)},	undef,	"to_unicode\(\'\\uA8C4\=\\u0338\.𞠨\\u0667\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4530\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟛𝆪\x{A8C4}｡\x{A8EA}-", %p)},	undef,	"to_unicode\(\'𝟛𝆪\\uA8C4｡\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4531\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟛\x{A8C4}𝆪｡\x{A8EA}-", %p)},	undef,	"to_unicode\(\'𝟛\\uA8C4𝆪｡\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4532\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("3\x{A8C4}𝆪。\x{A8EA}-", %p)},	undef,	"to_unicode\(\'3\\uA8C4𝆪\。\\uA8EA\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4533\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{075F}\x{1BA2}\x{103A}Ⴇ.4", %p)},	undef,	"to_unicode\(\'\\u075F\\u1BA2\\u103AႧ\.4\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4534\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{075F}\x{1BA2}\x{103A}ⴇ.4", %p)},	undef,	"to_unicode\(\'\\u075F\\u1BA2\\u103Aⴇ\.4\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4535\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᄹ｡\x{0ECA}򠯤󠄞", %p)},	undef,	"to_unicode\(\'ᄹ｡\\u0ECA\?\󠄞\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᄹ。\x{0ECA}򠯤󠄞", %p)},	undef,	"to_unicode\(\'ᄹ\。\\u0ECA\?\󠄞\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴆ򻢩．󠆡\x{FE09}𞤍", %p)},	undef,	"to_unicode\(\'Ⴆ\?．\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴆ򻢩.󠆡\x{FE09}𞤍", %p)},	undef,	"to_unicode\(\'Ⴆ\?\.\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴆ򻢩.󠆡\x{FE09}𞤍", %p)},	undef,	"to_unicode\(\'ⴆ\?\.\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴆ򻢩．󠆡\x{FE09}𞤍", %p)},	undef,	"to_unicode\(\'ⴆ\?．\󠆡\\uFE09\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4543\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ß\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4544\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ß\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4545\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ß\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4546\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ß\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4547\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("SS\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'SS\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4548\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("SS\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'SS\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ss\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ss\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4550\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ss\x{080B}。\x{067B}.帼f∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'ss\\u080B\。\\u067B\.帼f\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4551\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Ss\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'Ss\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4552\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Ss\x{080B}。\x{067B}.帼F∫∫\x{200C}", %p)},	undef,	"to_unicode\(\'Ss\\u080B\。\\u067B\.帼F\∫\∫\\u200C\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4553\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_unicode\(\'ß\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'SS\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'SS\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_unicode\(\'ss\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{080B}︒\x{067B}．帼f∬\x{200C}", %p)},	undef,	"to_unicode\(\'ss\\u080B︒\\u067B．帼f\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'Ss\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{080B}︒\x{067B}．帼F∬\x{200C}", %p)},	undef,	"to_unicode\(\'Ss\\u080B︒\\u067B．帼F\∬\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󘪗｡𐹴𞨌\x{200D}", %p)},	undef,	"to_unicode\(\'\?｡𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󘪗｡𐹴𞨌\x{200D}", %p)},	undef,	"to_unicode\(\'\?｡𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󘪗。𐹴𞨌\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󘪗。𐹴𞨌\x{200D}", %p)},	undef,	"to_unicode\(\'\?\。𐹴\?\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗛨.򅟢𝟨\x{A8C4}", %p)},	undef,	"to_unicode\(\'\?\.\?𝟨\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗛨.򅟢6\x{A8C4}", %p)},	undef,	"to_unicode\(\'\?\.\?6\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB2}\x{FD8E}。-۹ႱႨ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\uFD8E\。\-۹ႱႨ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹ႱႨ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹ႱႨ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4569\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹ⴑⴈ\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4570\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1AB2}\x{0645}\x{062E}\x{062C}。-۹Ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\u0645\\u062E\\u062C\。\-۹Ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4571\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1AB2}\x{FD8E}。-۹ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\uFD8E\。\-۹ⴑⴈ\'\)\ throws\ error\ V5\ V3\ B1\ \[data\/IdnaTest\.txt\:4572\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1AB2}\x{FD8E}。-۹Ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u1AB2\\uFD8E\。\-۹Ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤤．-\x{08A3}︒", %p)},	undef,	"to_unicode\(\'\?．\-\\u08A3︒\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4574\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_unicode("𞤤.-\x{08A3}。", %p)},	undef,	"to_unicode\(\'\?\.\-\\u08A3\。\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4575\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐺨.\x{0859}--", %p)},	undef,	"to_unicode\(\'\\u200C\?\.\\u0859\-\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐺨.\x{0859}--", %p)},	undef,	"to_unicode\(\'\\u200C\?\.\\u0859\-\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋸󮘋Ⴢ.Ⴁ", %p)},	undef,	"to_unicode\(\'𐋸\?Ⴢ\.Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋸󮘋ⴢ.ⴁ", %p)},	undef,	"to_unicode\(\'𐋸\?ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋸󮘋Ⴢ.ⴁ", %p)},	undef,	"to_unicode\(\'𐋸\?Ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}₄򩞆｡𲩧󠒹ς", %p)},	undef,	"to_unicode\(\'\?\\uA806₄\?｡\?\?ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}4򩞆。𲩧󠒹ς", %p)},	undef,	"to_unicode\(\'\?\\uA8064\?\。\?\?ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}4򩞆。𲩧󠒹Σ", %p)},	undef,	"to_unicode\(\'\?\\uA8064\?\。\?\?Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}4򩞆。𲩧󠒹σ", %p)},	undef,	"to_unicode\(\'\?\\uA8064\?\。\?\?σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}₄򩞆｡𲩧󠒹Σ", %p)},	undef,	"to_unicode\(\'\?\\uA806₄\?｡\?\?Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񗑿\x{A806}₄򩞆｡𲩧󠒹σ", %p)},	undef,	"to_unicode\(\'\?\\uA806₄\?｡\?\?σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4586\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠆀\x{0723}。\x{1DF4}\x{0775}", %p)},	undef,	"to_unicode\(\'\󠆀\\u0723\。\\u1DF4\\u0775\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4587\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨｡𬼖Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨｡\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨｡𬼖Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨｡\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨。𬼖Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨\。\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨。𬼖Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨\。\?Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨。𬼖ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨\。\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨。𬼖ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨\。\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨｡𬼖ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨｡\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{0842}𝪨｡𬼖ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'𐹱\\u0842𝪨｡\?ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}𐭪󠙘\x{200D}｡-𐹴", %p)},	undef,	"to_unicode\(\'\\u1714𐭪\?\\u200D｡\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}𐭪󠙘\x{200D}｡-𐹴", %p)},	undef,	"to_unicode\(\'\\u1714𐭪\?\\u200D｡\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}𐭪󠙘\x{200D}。-𐹴", %p)},	undef,	"to_unicode\(\'\\u1714𐭪\?\\u200D\。\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}𐭪󠙘\x{200D}。-𐹴", %p)},	undef,	"to_unicode\(\'\\u1714𐭪\?\\u200D\。\-𐹴\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾢬｡\x{0729}︒쯙𝟧", %p)},	undef,	"to_unicode\(\'\?｡\\u0729︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾢬｡\x{0729}︒쯙𝟧", %p)},	undef,	"to_unicode\(\'\?｡\\u0729︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾢬。\x{0729}。쯙5", %p)},	undef,	"to_unicode\(\'\?\。\\u0729\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𾢬。\x{0729}。쯙5", %p)},	undef,	"to_unicode\(\'\?\。\\u0729\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤟-。\x{0762}≮뻐", %p)},	undef,	"to_unicode\(\'\?\-\。\\u0762\≮뻐\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B2\ \[data\/IdnaTest\.txt\:4604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤟-。\x{0762}<\x{0338}뻐", %p)},	undef,	"to_unicode\(\'\?\-\。\\u0762\<\\u0338뻐\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B2\ \[data\/IdnaTest\.txt\:4605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥩-򊫠．\x{08B4}≠", %p)},	undef,	"to_unicode\(\'\?\-\?．\\u08B4\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥩-򊫠．\x{08B4}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\-\?．\\u08B4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥩-򊫠.\x{08B4}≠", %p)},	undef,	"to_unicode\(\'\?\-\?\.\\u08B4\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞥩-򊫠.\x{08B4}=\x{0338}", %p)},	undef,	"to_unicode\(\'\?\-\?\.\\u08B4\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ςႼ．\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ςႼ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ςႼ.\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ςႼ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ςⴜ.\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ςⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ΣႼ.\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ΣႼ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏σⴜ.\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?σⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏Σⴜ.\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?Σⴜ\.\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ςⴜ．\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ςⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏ΣႼ．\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?ΣႼ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏σⴜ．\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?σⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񅂏Σⴜ．\x{0661}", %p)},	undef,	"to_unicode\(\'\-\?Σⴜ．\\u0661\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4619\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{17CA}.\x{200D}𝟮𑀿", %p)},	undef,	"to_unicode\(\'\\u17CA\.\\u200D𝟮𑀿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4620\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{17CA}.\x{200D}𝟮𑀿", %p)},	undef,	"to_unicode\(\'\\u17CA\.\\u200D𝟮𑀿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4621\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{17CA}.\x{200D}2𑀿", %p)},	undef,	"to_unicode\(\'\\u17CA\.\\u200D2𑀿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4622\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{17CA}.\x{200D}2𑀿", %p)},	undef,	"to_unicode\(\'\\u17CA\.\\u200D2𑀿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4623\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯𝟖｡\x{1A60}𐫓򟇑", %p)},	undef,	"to_unicode\(\'\≯𝟖｡\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𝟖｡\x{1A60}𐫓򟇑", %p)},	undef,	"to_unicode\(\'\>\\u0338𝟖｡\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯8。\x{1A60}𐫓򟇑", %p)},	undef,	"to_unicode\(\'\≯8\。\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}8。\x{1A60}𐫓򟇑", %p)},	undef,	"to_unicode\(\'\>\\u03388\。\\u1A60𐫓\?\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑲫Ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\?Ↄ\\u0664｡\\u200C\'\)\ throws\ 