package Finance::SE::IDX::Static;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-01-18'; # DATE
our $DIST = 'Finance-SE-IDX-Static'; # DIST
our $VERSION = '20210118.0.0'; # VERSION

use 5.010001;
use strict;
use warnings;

use Perinci::Sub::Gen::AccessTable::Simple qw(gen_read_table_func);
#use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                       list_idx_firms
                       list_idx_sectors
                       list_idx_boards
                       list_idx_brokers
               );
our %SPEC;

# BEGIN FRAGMENT id=meta-idx_stock varname=meta_stock
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idx_stock/meta.yaml
# src-revision: ebeb2ef4e9128c06461de95333d1d26e75360a7c (Mon Jan 18 15:58:33 2021 +0700)
# generate-date: Mon Jan 18 08:58:52 2021 UTC
# generated-by: update-fragments-in-perl-module
our $meta_stock = {
  _note => "Automatically generated by gen-meta-yaml-from-data-tsv on Mon Jan 18 08:57:24 2021 UTC",
  fields => {
    board        => { pos => 5, schema => "str*", sortable => 1, summary => "board", unique => 0 },
    code         => { pos => 0, schema => "str*", sortable => 1, summary => "code", unique => 1 },
    listing_date => {
                      pos      => 3,
                      schema   => "str*",
                      sortable => 1,
                      summary  => "listing_date",
                      unique   => 0,
                    },
    name         => { pos => 2, schema => "str*", sortable => 1, summary => "name", unique => 0 },
    sector       => { pos => 1, schema => "str*", sortable => 1, summary => "sector", unique => 0 },
    shares       => { pos => 4, schema => "str*", sortable => 1, summary => "shares", unique => 0 },
  },
  header => 1,
  pk => "code",
  summary => "(Summary here)",
};
# END FRAGMENT id=meta-idx_stock

# BEGIN FRAGMENT id=data-idx_stock mtime_varname=data_stock_mtime varname=data_stock
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idx_stock/data.tsv
# src-revision: ebeb2ef4e9128c06461de95333d1d26e75360a7c (Mon Jan 18 15:58:33 2021 +0700)
# generate-date: Mon Jan 18 08:58:52 2021 UTC
# generated-by: update-fragments-in-perl-module
our $data_stock = [
  [
    "AALI",
    "AGRI",
    "Astra Agro Lestari Tbk.",
    "1997-12-09",
    1924688333,
    "Utama",
  ],
  [
    "ABBA",
    "TRADE",
    "Mahaka Media Tbk.",
    "2002-04-03",
    2755125000,
    "Pengembangan",
  ],
  [
    "ABDA",
    "FINANCE",
    "Asuransi Bina Dana Arta Tbk.",
    "1989-07-06",
    620806680,
    "Pengembangan",
  ],
  [
    "ABMM",
    "TRADE",
    "ABM Investama Tbk.",
    "2011-12-06",
    2753165000,
    "Utama",
  ],
  [
    "ACES",
    "TRADE",
    "Ace Hardware Indonesia Tbk.",
    "2007-11-06",
    17150000000,
    "Utama",
  ],
  [
    "ACST",
    "PROPERTY",
    "Acset Indonusa Tbk.",
    "2013-06-24",
    6425160000,
    "Utama",
  ],
  [
    "ADES",
    "CONSUMER",
    "Akasha Wira International Tbk.",
    "1994-06-13",
    589896800,
    "Pengembangan",
  ],
  [
    "ADHI",
    "PROPERTY",
    "Adhi Karya (Persero) Tbk.",
    "2004-03-18",
    3560849376,
    "Utama",
  ],
  [
    "ADMF",
    "FINANCE",
    "Adira Dinamika Multi Finance T",
    "2004-03-31",
    1000000000,
    "Utama",
  ],
  [
    "ADMG",
    "BASIC-IND",
    "Polychem Indonesia Tbk",
    "1993-10-20",
    3889179559,
    "Utama",
  ],
  [
    "ADRO",
    "MINING",
    "Adaro Energy Tbk.",
    "2008-07-16",
    31985962000,
    "Utama",
  ],
  [
    "AGAR",
    "TRADE",
    "Asia Sejahtera Mina Tbk.",
    "2019-12-02",
    1000000000,
    "Pengembangan",
  ],
  [
    "AGII",
    "BASIC-IND",
    "Aneka Gas Industri Tbk.",
    "2016-09-28",
    3066660000,
    "Utama",
  ],
  [
    "AGRO",
    "FINANCE",
    "Bank Rakyat Indonesia Agroniag",
    "2003-08-08",
    21129857328,
    "Utama",
  ],
  [
    "AGRS",
    "FINANCE",
    "Bank IBK Indonesia Tbk.",
    "2014-12-22",
    11154923542,
    "Pengembangan",
  ],
  [
    "AHAP",
    "FINANCE",
    "Asuransi Harta Aman Pratama Tb",
    "1990-09-14",
    2940000000,
    "Pengembangan",
  ],
  [
    "AIMS",
    "TRADE",
    "Akbar Indo Makmur Stimec Tbk",
    "2001-07-20",
    220000000,
    "Pengembangan",
  ],
  [
    "AISA",
    "CONSUMER",
    "Tiga Pilar Sejahtera Food Tbk.",
    "1997-06-11",
    9311800000,
    "Utama",
  ],
  [
    "AKKU",
    "TRADE",
    "Anugerah Kagum Karya Utama Tbk",
    "2004-11-01",
    6449463636,
    "Pengembangan",
  ],
  [
    "AKPI",
    "BASIC-IND",
    "Argha Karya Prima Industry Tbk",
    "1992-12-18",
    680000000,
    "Pengembangan",
  ],
  [
    "AKRA",
    "TRADE",
    "AKR Corporindo Tbk.",
    "1994-10-03",
    4014694920,
    "Utama",
  ],
  [
    "AKSI",
    "INFRASTRUCT",
    "Maming Enam Sembilan Mineral T",
    "2001-07-13",
    720000000,
    "Pengembangan",
  ],
  [
    "ALDO",
    "BASIC-IND",
    "Alkindo Naratama Tbk.",
    "2011-07-12",
    1100000000,
    "Pengembangan",
  ],
  [
    "ALKA",
    "BASIC-IND",
    "Alakasa Industrindo Tbk",
    "1990-07-12",
    507665055,
    "Pengembangan",
  ],
  [
    "ALMI",
    "BASIC-IND",
    "Alumindo Light Metal Industry ",
    "1997-01-02",
    616000000,
    "Pengembangan",
  ],
  [
    "ALTO",
    "CONSUMER",
    "Tri Banyan Tirta Tbk.",
    "2012-07-10",
    2191870558,
    "Utama",
  ],
  [
    "AMAG",
    "FINANCE",
    "Asuransi Multi Artha Guna Tbk.",
    "2005-12-23",
    5001552516,
    "Pengembangan",
  ],
  [
    "AMAN",
    "PROPERTY",
    "Makmur Berkah Amanda Tbk.",
    "2020-03-13",
    3873500000,
    "Utama",
  ],
  [
    "AMAR",
    "FINANCE",
    "Bank Amar Indonesia Tbk.",
    "2020-01-09",
    7954749000,
    "Pengembangan",
  ],
  [
    "AMFG",
    "BASIC-IND",
    "Asahimas Flat Glass Tbk.",
    "1995-11-08",
    434000000,
    "Utama",
  ],
  [
    "AMIN",
    "MISC-IND",
    "Ateliers Mecaniques D Indonesi",
    "2015-12-10",
    1080000000,
    "Pengembangan",
  ],
  [
    "AMOR",
    "FINANCE",
    "Ashmore Asset Management Indon",
    "2020-01-14",
    1111111200,
    "Pengembangan",
  ],
  [
    "AMRT",
    "TRADE",
    "Sumber Alfaria Trijaya Tbk.",
    "2009-01-15",
    41524501700,
    "Utama",
  ],
  [
    "ANDI",
    "AGRI",
    "Andira Agro Tbk.",
    "2018-08-16",
    9350000000,
    "Pengembangan",
  ],
  [
    "ANJT",
    "AGRI",
    "Austindo Nusantara Jaya Tbk.",
    "2013-05-08",
    3354175000,
    "Utama",
  ],
  [
    "ANTM",
    "MINING",
    "Aneka Tambang Tbk.",
    "1997-11-27",
    24030764725,
    "Utama",
  ],
  [
    "APEX",
    "MINING",
    "Apexindo Pratama Duta Tbk.",
    "2002-07-10",
    2659850000,
    "Pengembangan",
  ],
  [
    "APIC",
    "FINANCE",
    "Pacific Strategic Financial Tb",
    "2002-12-18",
    11766313488,
    "Pengembangan",
  ],
  [
    "APII",
    "TRADE",
    "Arita Prima Indonesia Tbk.",
    "2013-10-29",
    1075760000,
    "Pengembangan",
  ],
  [
    "APLI",
    "BASIC-IND",
    "Asiaplast Industries Tbk.",
    "2000-05-01",
    1362671400,
    "Utama",
  ],
  [
    "APLN",
    "PROPERTY",
    "Agung Podomoro Land Tbk.",
    "2010-11-11",
    22699326779,
    "Utama",
  ],
  [
    "ARGO",
    "MISC-IND",
    "Argo Pantes Tbk",
    "1991-01-07",
    335557450,
    "Pengembangan",
  ],
  [
    "ARII",
    "MINING",
    "Atlas Resources Tbk.",
    "2011-11-08",
    3000000000,
    "Pengembangan",
  ],
  [
    "ARKA",
    "MISC-IND",
    "Arkha Jayanti Persada Tbk.",
    "2019-07-10",
    2000000000,
    "Pengembangan",
  ],
  [
    "ARMY",
    "PROPERTY",
    "Armidian Karyatama Tbk.",
    "2017-06-21",
    9006250000,
    "Pengembangan",
  ],
  [
    "ARNA",
    "BASIC-IND",
    "Arwana Citramulia Tbk.",
    "2001-07-17",
    7341430976,
    "Utama",
  ],
  [
    "ARTA",
    "TRADE",
    "Arthavest Tbk",
    "2002-11-05",
    446674175,
    "Pengembangan",
  ],
  [
    "ARTI",
    "MINING",
    "Ratu Prabu Energi Tbk",
    "2003-04-30",
    7840000000,
    "Utama",
  ],
  [
    "ARTO",
    "FINANCE",
    "Bank Jago Tbk.",
    "2016-01-12",
    10747687500,
    "Pengembangan",
  ],
  [
    "ASBI",
    "FINANCE",
    "Asuransi Bintang Tbk.",
    "1989-11-29",
    348386472,
    "Pengembangan",
  ],
  [
    "ASDM",
    "FINANCE",
    "Asuransi Dayin Mitra Tbk.",
    "1989-12-15",
    192000000,
    "Utama",
  ],
  [
    "ASGR",
    "TRADE",
    "Astra Graphia Tbk.",
    "1989-11-15",
    1348780500,
    "Utama",
  ],
  [
    "ASII",
    "MISC-IND",
    "Astra International Tbk.",
    "1990-04-04",
    40483553140,
    "Utama",
  ],
  [
    "ASJT",
    "FINANCE",
    "Asuransi Jasa Tania Tbk.",
    "2003-12-29",
    600000000,
    "Pengembangan",
  ],
  [
    "ASMI",
    "FINANCE",
    "Asuransi Kresna Mitra Tbk.",
    "2014-01-16",
    8958380460,
    "Utama",
  ],
  [
    "ASPI",
    "PROPERTY",
    "Andalan Sakti Primaindo Tbk.",
    "2020-02-17",
    681792805,
    "Pengembangan",
  ],
  [
    "ASRI",
    "PROPERTY",
    "Alam Sutera Realty Tbk.",
    "2007-12-18",
    19649411888,
    "Utama",
  ],
  [
    "ASRM",
    "FINANCE",
    "Asuransi Ramayana Tbk.",
    "1990-03-19",
    304283840,
    "Pengembangan",
  ],
  [
    "ASSA",
    "INFRASTRUCT",
    "Adi Sarana Armada Tbk.",
    "2012-11-12",
    3397500000,
    "Utama",
  ],
  [
    "ATAP",
    "PROPERTY",
    "Trimitra Prawara Goldland Tbk.",
    "2020-12-11",
    1250000000,
    "Pengembangan",
  ],
  [
    "ATIC",
    "TRADE",
    "Anabatic Technologies Tbk.",
    "2015-07-08",
    2315361355,
    "Utama",
  ],
  [
    "AUTO",
    "MISC-IND",
    "Astra Otoparts Tbk.",
    "1998-06-15",
    4819733000,
    "Utama",
  ],
  [
    "AYLS",
    "TRADE",
    "Agro Yasa Lestari Tbk.",
    "2020-02-12",
    853423205,
    "Pengembangan",
  ],
  [
    "BABP",
    "FINANCE",
    "Bank MNC Internasional Tbk.",
    "2002-07-15",
    25061670687,
    "Pengembangan",
  ],
  [
    "BACA",
    "FINANCE",
    "Bank Capital Indonesia Tbk.",
    "2007-10-04",
    7001042507,
    "Pengembangan",
  ],
  [
    "BAJA",
    "BASIC-IND",
    "Saranacentral Bajatama Tbk.",
    "2011-12-21",
    1800000000,
    "Pengembangan",
  ],
  [
    "BALI",
    "INFRASTRUCT",
    "Bali Towerindo Sentra Tbk.",
    "2014-03-13",
    3934592500,
    "Pengembangan",
  ],
  [
    "BAPA",
    "PROPERTY",
    "Bekasi Asri Pemula Tbk.",
    "2008-01-14",
    661784520,
    "Utama",
  ],
  [
    "BAPI",
    "PROPERTY",
    "Bhakti Agung Propertindo Tbk.",
    "2019-09-16",
    5591740006,
    "Pengembangan",
  ],
  [
    "BATA",
    "MISC-IND",
    "Sepatu Bata Tbk.",
    "1982-03-24",
    1300000000,
    "Utama",
  ],
  [
    "BAYU",
    "TRADE",
    "Bayu Buana Tbk",
    "1989-10-30",
    353220780,
    "Pengembangan",
  ],
  [
    "BBCA",
    "FINANCE",
    "Bank Central Asia Tbk.",
    "2000-05-31",
    24408459900,
    "Utama",
  ],
  [
    "BBHI",
    "FINANCE",
    "Bank Harda Internasional Tbk.",
    "2015-08-12",
    4142587477,
    "Pengembangan",
  ],
  [
    "BBKP",
    "FINANCE",
    "Bank Bukopin Tbk.",
    "2006-07-10",
    32510124471,
    "Utama",
  ],
  [
    "BBLD",
    "FINANCE",
    "Buana Finance Tbk.",
    "1990-05-07",
    1645796054,
    "Pengembangan",
  ],
  [
    "BBMD",
    "FINANCE",
    "Bank Mestika Dharma Tbk.",
    "2013-07-08",
    4049189100,
    "Utama",
  ],
  [
    "BBNI",
    "FINANCE",
    "Bank Negara Indonesia (Persero",
    "1996-11-25",
    18462169893,
    "Utama",
  ],
  [
    "BBRI",
    "FINANCE",
    "Bank Rakyat Indonesia (Persero",
    "2003-11-10",
    122112351900,
    "Utama",
  ],
  [
    "BBRM",
    "INFRASTRUCT",
    "Pelayaran Nasional Bina Buana ",
    "2013-01-09",
    5367076248,
    "Utama",
  ],
  [
    "BBSI",
    "FINANCE",
    "Bank Bisnis Internasional Tbk.",
    "2020-09-07",
    2996264110,
    "Pengembangan",
  ],
  [
    "BBSS",
    "PROPERTY",
    "Bumi Benowo Sukses Sejahtera T",
    "2020-04-15",
    4800000000,
    "Pengembangan",
  ],
  [
    "BBTN",
    "FINANCE",
    "Bank Tabungan Negara (Persero)",
    "2009-12-17",
    10484100000,
    "Utama",
  ],
  [
    "BBYB",
    "FINANCE",
    "Bank Neo Commerce Tbk.",
    "2015-01-13",
    6595177287,
    "Utama",
  ],
  [
    "BCAP",
    "FINANCE",
    "MNC Kapital Indonesia Tbk.",
    "2001-06-08",
    42618850927,
    "Utama",
  ],
  [
    "BCIC",
    "FINANCE",
    "Bank JTrust Indonesia Tbk.",
    "1997-06-25",
    9912003256,
    "Pengembangan",
  ],
  [
    "BCIP",
    "PROPERTY",
    "Bumi Citra Permai Tbk.",
    "2009-12-11",
    1429915525,
    "Pengembangan",
  ],
  [
    "BDMN",
    "FINANCE",
    "Bank Danamon Indonesia Tbk.",
    "1989-12-06",
    9675817341,
    "Utama",
  ],
  [
    "BEEF",
    "AGRI",
    "Estika Tata Tiara Tbk.",
    "2019-01-10",
    1884312595,
    "Pengembangan",
  ],
  [
    "BEKS",
    "FINANCE",
    "Bank Pembangunan Daerah Banten",
    "2001-07-13",
    43403920512,
    "Pengembangan",
  ],
  [
    "BELL",
    "MISC-IND",
    "Trisula Textile Industries Tbk",
    "2017-10-03",
    7250000000,
    "Pengembangan",
  ],
  [
    "BESS",
    "INFRASTRUCT",
    "Batulicin Nusantara Maritim Tb",
    "2020-03-09",
    3403720702,
    "Pengembangan",
  ],
  [
    "BEST",
    "PROPERTY",
    "Bekasi Fajar Industrial Estate",
    "2012-04-10",
    9647311150,
    "Utama",
  ],
  [
    "BFIN",
    "FINANCE",
    "BFI Finance  Indonesia Tbk.",
    "1990-05-16",
    15967115620,
    "Utama",
  ],
  [
    "BGTG",
    "FINANCE",
    "Bank Ganesha Tbk.",
    "2016-05-12",
    11063309400,
    "Pengembangan",
  ],
  [
    "BHAT",
    "FINANCE",
    "Bhakti Multi Artha Tbk.",
    "2020-04-15",
    5000000000,
    "Pengembangan",
  ],
  [
    "BHIT",
    "TRADE",
    "MNC Investama Tbk.",
    "1997-11-24",
    73766098834,
    "Utama",
  ],
  [
    "BIKA",
    "PROPERTY",
    "Binakarya Jaya Abadi Tbk.",
    "2015-07-14",
    592280000,
    "Pengembangan",
  ],
  [
    "BIMA",
    "MISC-IND",
    "Primarindo Asia Infrastructure",
    "1994-08-30",
    608175716,
    "Pengembangan",
  ],
  [
    "BINA",
    "FINANCE",
    "Bank Ina Perdana Tbk.",
    "2014-01-16",
    5597831250,
    "Utama",
  ],
  [
    "BIPI",
    "MINING",
    "Astrindo Nusantara Infrastrukt",
    "2010-02-11",
    44693066193,
    "Pengembangan",
  ],
  [
    "BIPP",
    "PROPERTY",
    "Bhuwanatala Indah Permai Tbk.",
    "1995-10-23",
    5028669366,
    "Pengembangan",
  ],
  [
    "BIRD",
    "INFRASTRUCT",
    "Blue Bird Tbk.",
    "2014-11-05",
    2502100000,
    "Utama",
  ],
  [
    "BISI",
    "AGRI",
    "BISI International Tbk.",
    "2007-05-28",
    3000000000,
    "Utama",
  ],
  [
    "BJBR",
    "FINANCE",
    "Bank Pembangunan Daerah Jawa B",
    "2010-07-08",
    9740399289,
    "Utama",
  ],
  [
    "BJTM",
    "FINANCE",
    "Bank Pembangunan Daerah Jawa T",
    "2012-07-12",
    14865343101,
    "Utama",
  ],
  [
    "BKDP",
    "PROPERTY",
    "Bukit Darmo Property Tbk",
    "2007-06-15",
    7513992252,
    "Pengembangan",
  ],
  [
    "BKSL",
    "PROPERTY",
    "Sentul City Tbk.",
    "1997-07-28",
    67083561082,
    "Utama",
  ],
  [
    "BKSW",
    "FINANCE",
    "Bank QNB Indonesia Tbk.",
    "2002-11-21",
    20232319124,
    "Pengembangan",
  ],
  [
    "BLTA",
    "INFRASTRUCT",
    "Berlian Laju Tanker Tbk",
    "1990-03-26",
    25940187103,
    "Utama",
  ],
  [
    "BLTZ",
    "TRADE",
    "Graha Layar Prima Tbk.",
    "2014-04-10",
    873937142,
    "Pengembangan",
  ],
  [
    "BLUE",
    "TRADE",
    "Berkah Prima Perkasa Tbk.",
    "2019-07-08",
    418000000,
    "Pengembangan",
  ],
  [
    "BMAS",
    "FINANCE",
    "Bank Maspion Indonesia Tbk.",
    "2013-07-11",
    4399026922,
    "Pengembangan",
  ],
  [
    "BMRI",
    "FINANCE",
    "Bank Mandiri (Persero) Tbk.",
    "2003-07-14",
    46199999998,
    "Utama",
  ],
  [
    "BMSR",
    "TRADE",
    "Bintang Mitra Semestaraya Tbk",
    "1999-12-29",
    1159200024,
    "Utama",
  ],
  [
    "BMTR",
    "TRADE",
    "Global Mediacom Tbk.",
    "1995-07-17",
    16583997586,
    "Utama",
  ],
  [
    "BNBA",
    "FINANCE",
    "Bank Bumi Arta Tbk.",
    "2006-06-01",
    2286900000,
    "Utama",
  ],
  [
    "BNBR",
    "TRADE",
    "Bakrie & Brothers Tbk",
    "1989-08-28",
    20863053480,
    "Pengembangan",
  ],
  [
    "BNGA",
    "FINANCE",
    "Bank CIMB Niaga Tbk.",
    "1989-11-29",
    24880290775,
    "Utama",
  ],
  [
    "BNII",
    "FINANCE",
    "Bank Maybank Indonesia Tbk.",
    "1989-11-21",
    75357433911,
    "Utama",
  ],
  [
    "BNLI",
    "FINANCE",
    "Bank Permata Tbk.",
    "1990-01-15",
    27762311813,
    "Utama",
  ],
  [
    "BOGA",
    "TRADE",
    "Bintang Oto Global Tbk.",
    "2016-12-19",
    3803526210,
    "Pengembangan",
  ],
  [
    "BOLA",
    "TRADE",
    "Bali Bintang Sejahtera Tbk.",
    "2019-06-17",
    6000000000,
    "Pengembangan",
  ],
  [
    "BOLT",
    "MISC-IND",
    "Garuda Metalindo Tbk.",
    "2015-07-07",
    2343750000,
    "Pengembangan",
  ],
  [
    "BOSS",
    "MINING",
    "Borneo Olah Sarana Sukses Tbk.",
    "2018-02-15",
    1400000000,
    "Pengembangan",
  ],
  [
    "BPFI",
    "FINANCE",
    "Batavia Prosperindo Finance Tb",
    "2009-06-01",
    1782663575,
    "Pengembangan",
  ],
  [
    "BPII",
    "FINANCE",
    "Batavia Prosperindo Internasio",
    "2014-07-08",
    562224662,
    "Pengembangan",
  ],
  [
    "BPTR",
    "INFRASTRUCT",
    "Batavia Prosperindo Trans Tbk.",
    "2018-07-09",
    1550000000,
    "Utama",
  ],
  [
    "BRAM",
    "MISC-IND",
    "Indo Kordsa Tbk.",
    "1990-09-05",
    450000000,
    "Utama",
  ],
  [
    "BRIS",
    "FINANCE",
    "Bank BRIsyariah Tbk.",
    "1911-01-01",
    9803347563,
    "Utama",
  ],
  [
    "BRMS",
    "MINING",
    "Bumi Resources Minerals Tbk.",
    "2010-12-09",
    71007759834,
    "Pengembangan",
  ],
  [
    "BRNA",
    "BASIC-IND",
    "Berlina Tbk.",
    "1989-11-06",
    979110000,
    "Pengembangan",
  ],
  [
    "BRPT",
    "BASIC-IND",
    "Barito Pacific Tbk.",
    "1993-10-01",
    93388804125,
    "Utama",
  ],
  [
    "BSDE",
    "PROPERTY",
    "Bumi Serpong Damai Tbk.",
    "2008-06-06",
    21171365812,
    "Utama",
  ],
  [
    "BSIM",
    "FINANCE",
    "Bank Sinarmas Tbk.",
    "2010-12-13",
    17263895026,
    "Utama",
  ],
  [
    "BSSR",
    "MINING",
    "Baramulti Suksessarana Tbk.",
    "2012-11-08",
    2616500000,
    "Pengembangan",
  ],
  [
    "BSWD",
    "FINANCE",
    "Bank Of India Indonesia Tbk.",
    "2002-05-01",
    1374912000,
    "Pengembangan",
  ],
  [
    "BTEK",
    "CONSUMER",
    "Bumi Teknokultura Unggul Tbk",
    "2004-05-14",
    46277496376,
    "Pengembangan",
  ],
  [
    "BTEL",
    "INFRASTRUCT",
    "Bakrie Telecom Tbk.",
    "2006-02-03",
    36822665755,
    "Utama",
  ],
  [
    "BTON",
    "BASIC-IND",
    "Betonjaya Manunggal Tbk.",
    "2001-07-18",
    720000000,
    "Pengembangan",
  ],
  [
    "BTPN",
    "FINANCE",
    "Bank BTPN Tbk.",
    "2008-03-12",
    8065984461,
    "Utama",
  ],
  [
    "BTPS",
    "FINANCE",
    "Bank BTPN Syariah Tbk.",
    "2018-05-08",
    7626663000,
    "Utama",
  ],
  [
    "BUDI",
    "CONSUMER",
    "Budi Starch & Sweetener Tbk.",
    "1995-05-08",
    4498997362,
    "Utama",
  ],
  [
    "BUKK",
    "INFRASTRUCT",
    "Bukaka Teknik Utama Tbk.",
    "1995-01-09",
    2640452000,
    "Pengembangan",
  ],
  [
    "BULL",
    "INFRASTRUCT",
    "Buana Lintas Lautan Tbk.",
    "2011-05-23",
    12912151996,
    "Utama",
  ],
  [
    "BUMI",
    "MINING",
    "Bumi Resources Tbk.",
    "1990-07-30",
    68228705555,
    "Pengembangan",
  ],
  [
    "BUVA",
    "TRADE",
    "Bukit Uluwatu Villa Tbk.",
    "2010-07-12",
    6811269200,
    "Pengembangan",
  ],
  [
    "BVIC",
    "FINANCE",
    "Bank Victoria International Tb",
    "1999-06-30",
    8862427568,
    "Utama",
  ],
  [
    "BWPT",
    "AGRI",
    "Eagle High Plantations Tbk.",
    "2009-10-27",
    31525291000,
    "Utama",
  ],
  [
    "BYAN",
    "MINING",
    "Bayan Resources Tbk.",
    "2008-08-12",
    3333333500,
    "Utama",
  ],
  [
    "CAKK",
    "BASIC-IND",
    "Cahayaputra Asa Keramik Tbk.",
    "2018-10-31",
    1203300219,
    "Pengembangan",
  ],
  [
    "CAMP",
    "CONSUMER",
    "Campina Ice Cream Industry Tbk",
    "2017-12-19",
    5885000000,
    "Utama",
  ],
  [
    "CANI",
    "INFRASTRUCT",
    "Capitol Nusantara Indonesia Tb",
    "2014-01-16",
    833440000,
    "Pengembangan",
  ],
  [
    "CARE",
    "TRADE",
    "Metro Healthcare Indonesia Tbk",
    "2020-03-13",
    33250000000,
    "Pengembangan",
  ],
  [
    "CARS",
    "TRADE",
    "Industri dan Perdagangan Bintr",
    "2017-04-10",
    15000000000,
    "Utama",
  ],
  [
    "CASA",
    "FINANCE",
    "Capital Financial Indonesia Tb",
    "2016-07-19",
    54476253593,
    "Pengembangan",
  ],
  [
    "CASH",
    "TRADE",
    "Cashlez Worldwide Indonesia Tb",
    "2020-05-04",
    1431108207,
    "Akselerasi",
  ],
  [
    "CASS",
    "INFRASTRUCT",
    "Cardig Aero Services Tbk.",
    "2011-12-05",
    2086950000,
    "Pengembangan",
  ],
  [
    "CBMF",
    "CONSUMER",
    "Cahaya Bintang Medan Tbk.",
    "2020-04-09",
    1875000000,
    "Pengembangan",
  ],
  [
    "CCSI",
    "MISC-IND",
    "Communication Cable Systems In",
    "2019-06-18",
    1000000000,
    "Pengembangan",
  ],
  [
    "CEKA",
    "CONSUMER",
    "Wilmar Cahaya Indonesia Tbk.",
    "1996-07-09",
    595000000,
    "Utama",
  ],
  [
    "CENT",
    "INFRASTRUCT",
    "Centratama Telekomunikasi Indo",
    "2001-11-01",
    31183464900,
    "Pengembangan",
  ],
  [
    "CFIN",
    "FINANCE",
    "Clipan Finance Indonesia Tbk.",
    "1990-08-27",
    3984520457,
    "Utama",
  ],
  [
    "CINT",
    "CONSUMER",
    "Chitose Internasional Tbk.",
    "2014-06-27",
    1000000000,
    "Pengembangan",
  ],
  [
    "CITA",
    "MINING",
    "Cita Mineral Investindo Tbk.",
    "2002-03-20",
    3960361250,
    "Pengembangan",
  ],
  [
    "CITY",
    "PROPERTY",
    "Natura City Developments Tbk.",
    "2018-09-28",
    5404694846,
    "Utama",
  ],
  [
    "CLAY",
    "TRADE",
    "Citra Putra Realty Tbk.",
    "2019-01-18",
    2570000000,
    "Pengembangan",
  ],
  [
    "CLEO",
    "CONSUMER",
    "Sariguna Primatirta Tbk.",
    "2017-05-05",
    12000000000,
    "Utama",
  ],
  [
    "CLPI",
    "TRADE",
    "Colorpak Indonesia Tbk.",
    "2001-11-30",
    306338500,
    "Pengembangan",
  ],
  [
    "CMNP",
    "INFRASTRUCT",
    "Citra Marga Nusaphala Persada ",
    "1995-01-10",
    5431247916,
    "Utama",
  ],
  [
    "CMPP",
    "INFRASTRUCT",
    "AirAsia Indonesia Tbk.",
    "1994-12-08",
    10685124441,
    "Pengembangan",
  ],
  [
    "CNKO",
    "TRADE",
    "Exploitasi Energi Indonesia Tb",
    "2001-11-21",
    8956361206,
    "Utama",
  ],
  [
    "CNTX",
    "MISC-IND",
    "Century Textile Industry Tbk.",
    "1979-05-22",
    70000000,
    "Pengembangan",
  ],
  [
    "COCO",
    "CONSUMER",
    "Wahana Interfood Nusantara Tbk",
    "2019-03-20",
    560285538,
    "Pengembangan",
  ],
  [
    "COWL",
    "PROPERTY",
    "Cowell Development Tbk.",
    "2007-12-19",
    4871214021,
    "Pengembangan",
  ],
  [
    "CPIN",
    "BASIC-IND",
    "Charoen Pokphand Indonesia Tbk",
    "1991-03-18",
    16398000000,
    "Utama",
  ],
  [
    "CPRI",
    "PROPERTY",
    "Capri Nusa Satu Properti Tbk.",
    "2019-04-11",
    2433375005,
    "Pengembangan",
  ],
  [
    "CPRO",
    "BASIC-IND",
    "Central Proteina Prima Tbk.",
    "2006-11-28",
    59572382787,
    "Utama",
  ],
  [
    "CSAP",
    "TRADE",
    "Catur Sentosa Adiprana Tbk.",
    "2007-12-12",
    4458352920,
    "Utama",
  ],
  [
    "CSIS",
    "PROPERTY",
    "Cahayasakti Investindo Sukses ",
    "2017-05-10",
    1307000000,
    "Pengembangan",
  ],
  [
    "CSMI",
    "TRADE",
    "Cipta Selera Murni Tbk.",
    "2020-04-09",
    816061500,
    "Pengembangan",
  ],
  [
    "CSRA",
    "AGRI",
    "Cisadane Sawit Raya Tbk.",
    "2020-01-09",
    2050000000,
    "Pengembangan",
  ],
  [
    "CTBN",
    "BASIC-IND",
    "Citra Tubindo Tbk.",
    "1989-11-28",
    800371500,
    "Utama",
  ],
  [
    "CTRA",
    "PROPERTY",
    "Ciputra Development Tbk.",
    "1994-03-28",
    18560303397,
    "Utama",
  ],
  [
    "CTTH",
    "MINING",
    "Citatah Tbk.",
    "1996-07-03",
    1230839821,
    "Pengembangan",
  ],
  [
    "DADA",
    "PROPERTY",
    "Diamond Citra Propertindo Tbk.",
    "2020-02-14",
    7177000307,
    "Pengembangan",
  ],
  [
    "DART",
    "PROPERTY",
    "Duta Anggada Realty Tbk.",
    "1990-05-08",
    3141390962,
    "Utama",
  ],
  [
    "DAYA",
    "TRADE",
    "Duta Intidaya Tbk.",
    "2016-06-28",
    2420547025,
    "Pengembangan",
  ],
  [
    "DCII",
    "TRADE",
    "DCI Indonesia Tbk.",
    "2021-01-06",
    2383745900,
    "Pengembangan",
  ],
  [
    "DEAL",
    "INFRASTRUCT",
    "Dewata Freightinternational Tb",
    "2018-11-09",
    1132748019,
    "Pengembangan",
  ],
  [
    "DEFI",
    "FINANCE",
    "Danasupra Erapacific Tbk.",
    "2001-07-06",
    687266666,
    "Pengembangan",
  ],
  [
    "DEWA",
    "MINING",
    "Darma Henwa Tbk",
    "2007-09-26",
    21853733792,
    "Utama",
  ],
  [
    "DFAM",
    "TRADE",
    "Dafam Property Indonesia Tbk.",
    "2018-04-27",
    1899599640,
    "Pengembangan",
  ],
  [
    "DGIK",
    "PROPERTY",
    "Nusa Konstruksi Enjiniring Tbk",
    "2007-12-19",
    5541165000,
    "Utama",
  ],
  [
    "DGNS",
    "TRADE",
    "Diagnos Laboratorium Utama Tbk",
    "2021-01-15",
    1250000000,
    "Pengembangan",
  ],
  [
    "DIGI",
    "TRADE",
    "Arkadia Digital Media Tbk.",
    "2018-09-18",
    1625000000,
    "Pengembangan",
  ],
  [
    "DILD",
    "PROPERTY",
    "Intiland Development Tbk.",
    "1991-09-04",
    10365854185,
    "Utama",
  ],
  [
    "DIVA",
    "TRADE",
    "Distribusi Voucher Nusantara T",
    "2018-11-27",
    714285700,
    "Pengembangan",
  ],
  [
    "DKFT",
    "MINING",
    "Central Omega Resources Tbk.",
    "1997-11-21",
    5638246600,
    "Pengembangan",
  ],
  [
    "DLTA",
    "CONSUMER",
    "Delta Djakarta Tbk.",
    "1984-02-27",
    800659050,
    "Utama",
  ],
  [
    "DMAS",
    "PROPERTY",
    "Puradelta Lestari Tbk.",
    "2015-05-29",
    48198111100,
    "Utama",
  ],
  [
    "DMMX",
    "TRADE",
    "Digital Mediatama Maxima Tbk.",
    "2019-10-21",
    7692307700,
    "Pengembangan",
  ],
  [
    "DMND",
    "CONSUMER",
    "Diamond Food Indonesia Tbk.",
    "2020-01-22",
    9468359000,
    "Utama",
  ],
  [
    "DNAR",
    "FINANCE",
    "Bank Oke Indonesia Tbk.",
    "2014-07-11",
    11447006258,
    "Utama",
  ],
  [
    "DNET",
    "TRADE",
    "Indoritel Makmur Internasional",
    "2000-12-11",
    14184000000,
    "Pengembangan",
  ],
  [
    "DOID",
    "MINING",
    "Delta Dunia Makmur Tbk.",
    "2001-06-15",
    8619817982,
    "Utama",
  ],
  [
    "DPNS",
    "BASIC-IND",
    "Duta Pertiwi Nusantara Tbk.",
    "1990-08-08",
    331129952,
    "Utama",
  ],
  [
    "DPUM",
    "TRADE",
    "Dua Putra Utama Makmur Tbk.",
    "2015-12-08",
    4175000000,
    "Utama",
  ],
  [
    "DSFI",
    "AGRI",
    "Dharma Samudera Fishing Indust",
    "2000-03-24",
    1857135500,
    "Utama",
  ],
  [
    "DSNG",
    "AGRI",
    "Dharma Satya Nusantara Tbk.",
    "2013-06-14",
    10599842400,
    "Utama",
  ],
  [
    "DSSA",
    "MINING",
    "Dian Swastatika Sentosa Tbk",
    "2009-12-10",
    770552320,
    "Utama",
  ],
  [
    "DUCK",
    "TRADE",
    "Jaya Bersama Indo Tbk.",
    "2018-10-10",
    1283330000,
    "UTAMA",
  ],
  [
    "DUTI",
    "PROPERTY",
    "Duta Pertiwi Tbk",
    "1994-11-02",
    1850000000,
    "Pengembangan",
  ],
  [
    "DVLA",
    "CONSUMER",
    "Darya-Varia Laboratoria Tbk.",
    "1994-11-11",
    1120000000,
    "Utama",
  ],
  [
    "DWGL",
    "TRADE",
    "Dwi Guna Laksana Tbk.",
    "2017-12-13",
    8711599831,
    "Pengembangan",
  ],
  [
    "DYAN",
    "TRADE",
    "Dyandra Media International Tb",
    "2013-03-25",
    4272964279,
    "Utama",
  ],
  [
    "EAST",
    "TRADE",
    "Eastparc Hotel Tbk.",
    "2019-07-09",
    4126366095,
    "Pengembangan",
  ],
  [
    "ECII",
    "TRADE",
    "Electronic City Indonesia Tbk.",
    "2013-07-03",
    1334333000,
    "Pengembangan",
  ],
  [
    "EKAD",
    "BASIC-IND",
    "Ekadharma International Tbk.",
    "1990-08-14",
    698775000,
    "Utama",
  ],
  [
    "ELSA",
    "MINING",
    "Elnusa Tbk.",
    "2008-02-06",
    7298500000,
    "Utama",
  ],
  [
    "ELTY",
    "PROPERTY",
    "Bakrieland Development Tbk.",
    "1995-10-30",
    43521913019,
    "Utama",
  ],
  [
    "EMDE",
    "PROPERTY",
    "Megapolitan Developments Tbk.",
    "2011-01-12",
    3350000000,
    "Pengembangan",
  ],
  [
    "EMTK",
    "TRADE",
    "Elang Mahkota Teknologi Tbk.",
    "2010-01-12",
    56439573420,
    "Utama",
  ],
  [
    "ENRG",
    "MINING",
    "Energi Mega Persada Tbk.",
    "2004-06-07",
    10342179272,
    "Pengembangan",
  ],
  [
    "ENVY",
    "TRADE",
    "Envy Technologies Indonesia Tb",
    "2019-07-08",
    1800000000,
    "Pengembangan",
  ],
  [
    "ENZO",
    "CONSUMER",
    "Morenzo Abadi Perkasa Tbk.",
    "2020-09-14",
    2162543000,
    "Pengembangan",
  ],
  [
    "EPAC",
    "BASIC-IND",
    "Megalestari Epack Sentosaraya ",
    "2020-07-01",
    3303400000,
    "Pengembangan",
  ],
  [
    "EPMT",
    "TRADE",
    "Enseval Putera Megatrading Tbk",
    "1994-08-01",
    2708640000,
    "Pengembangan",
  ],
  [
    "ERAA",
    "TRADE",
    "Erajaya Swasembada Tbk.",
    "2011-12-14",
    3190000000,
    "Utama",
  ],
  [
    "ERTX",
    "MISC-IND",
    "Eratex Djaja Tbk.",
    "1990-08-21",
    1286539792,
    "Pengembangan",
  ],
  [
    "ESIP",
    "BASIC-IND",
    "Sinergi Inti Plastindo Tbk.",
    "2019-11-14",
    640000005,
    "Pengembangan",
  ],
  [
    "ESSA",
    "BASIC-IND",
    "Surya Esa Perkasa Tbk.",
    "2012-02-01",
    15660887000,
    "Utama",
  ],
  [
    "ESTA",
    "TRADE",
    "Esta Multi Usaha Tbk.",
    "2020-03-09",
    630000000,
    "Pengembangan",
  ],
  [
    "ESTI",
    "MISC-IND",
    "Ever Shine Tex Tbk.",
    "1992-10-13",
    2015208720,
    "Utama",
  ],
  [
    "ETWA",
    "BASIC-IND",
    "Eterindo Wahanatama Tbk",
    "1997-05-16",
    968297000,
    "Utama",
  ],
  [
    "EXCL",
    "INFRASTRUCT",
    "XL Axiata Tbk.",
    "2005-09-29",
    10706012530,
    "Utama",
  ],
  [
    "FAPA",
    "AGRI",
    "FAP Agri Tbk.",
    "2021-01-04",
    3629411800,
    "Pengembangan",
  ],
  [
    "FAST",
    "TRADE",
    "Fast Food Indonesia Tbk.",
    "1993-05-11",
    3990277158,
    "Pengembangan",
  ],
  [
    "FASW",
    "BASIC-IND",
    "Fajar Surya Wisesa Tbk.",
    "1994-12-19",
    2477888787,
    "Utama",
  ],
  [
    "FILM",
    "TRADE",
    "MD Pictures Tbk.",
    "2018-08-07",
    9511217000,
    "Utama",
  ],
  [
    "FINN",
    "FINANCE",
    "First Indo American Leasing Tb",
    "2017-06-08",
    1860225000,
    "Pengembangan",
  ],
  [
    "FIRE",
    "MINING",
    "Alfa Energi Investama Tbk.",
    "2017-06-09",
    1475363179,
    "Pengembangan",
  ],
  [
    "FISH",
    "TRADE",
    "FKS Multi Agro Tbk.",
    "2002-01-18",
    480000000,
    "Pengembangan",
  ],
  [
    "FITT",
    "TRADE",
    "Hotel Fitra International Tbk.",
    "2019-06-11",
    600000005,
    "Pengembangan",
  ],
  [
    "FMII",
    "PROPERTY",
    "Fortune Mate Indonesia Tbk",
    "2000-06-30",
    2721000000,
    "Pengembangan",
  ],
  [
    "FOOD",
    "CONSUMER",
    "Sentra Food Indonesia Tbk.",
    "2019-01-08",
    650000000,
    "Pengembangan",
  ],
  [
    "FORU",
    "TRADE",
    "Fortune Indonesia Tbk",
    "2002-01-17",
    465224000,
    "Pengembangan",
  ],
  [
    "FORZ",
    "PROPERTY",
    "Forza Land Indonesia Tbk.",
    "2017-04-28",
    1984009887,
    "Utama",
  ],
  [
    "FPNI",
    "BASIC-IND",
    "Lotte Chemical Titan Tbk.",
    "2002-03-21",
    5566414000,
    "Pengembangan",
  ],
  [
    "FREN",
    "INFRASTRUCT",
    "Smartfren Telecom Tbk.",
    "2006-11-29",
    263262540820,
    "Utama",
  ],
  [
    "FUJI",
    "FINANCE",
    "Fuji Finance Indonesia Tbk.",
    "2019-07-09",
    1105000000,
    "Pengembangan",
  ],
  [
    "GAMA",
    "PROPERTY",
    "Aksara Global Development Tbk.",
    "2012-07-11",
    10011027656,
    "Utama",
  ],
  [
    "GDST",
    "BASIC-IND",
    "Gunawan Dianjaya Steel Tbk.",
    "2009-12-23",
    9242500000,
    "Pengembangan",
  ],
  [
    "GDYR",
    "MISC-IND",
    "Goodyear Indonesia Tbk.",
    "1980-12-22",
    410000000,
    "Utama",
  ],
  [
    "GEMA",
    "TRADE",
    "Gema Grahasarana Tbk.",
    "2002-08-12",
    1600000000,
    "Pengembangan",
  ],
  [
    "GEMS",
    "MINING",
    "Golden Energy Mines Tbk.",
    "2011-11-17",
    5882353000,
    "Utama",
  ],
  [
    "GGRM",
    "CONSUMER",
    "Gudang Garam Tbk.",
    "1990-08-27",
    1924088000,
    "Utama",
  ],
  [
    "GGRP",
    "BASIC-IND",
    "Gunung Raja Paksi Tbk.",
    "2019-09-19",
    12111376157,
    "Pengembangan",
  ],
  [
    "GHON",
    "INFRASTRUCT",
    "Gihon Telekomunikasi Indonesia",
    "2018-04-09",
    550000000,
    "Utama",
  ],
  [
    "GIAA",
    "INFRASTRUCT",
    "Garuda Indonesia (Persero) Tbk",
    "2011-02-11",
    25886576254,
    "Utama",
  ],
  [
    "GJTL",
    "MISC-IND",
    "Gajah Tunggal Tbk.",
    "1990-05-08",
    3484800000,
    "Utama",
  ],
  [
    "GLOB",
    "TRADE",
    "Global Teleshop Tbk.",
    "2012-07-10",
    1111112000,
    "Pengembangan",
  ],
  [
    "GLVA",
    "TRADE",
    "Galva Technologies Tbk.",
    "2019-12-23",
    1500000000,
    "Pengembangan",
  ],
  [
    "GMFI",
    "MISC-IND",
    "Garuda Maintenance Facility Ae",
    "2017-10-10",
    28233511500,
    "Utama",
  ],
  [
    "GMTD",
    "PROPERTY",
    "Gowa Makassar Tourism Developm",
    "2000-12-11",
    101538000,
    "Pengembangan",
  ],
  [
    "GOLD",
    "INFRASTRUCT",
    "Visi Telekomunikasi Infrastruk",
    "2010-07-07",
    1277276000,
    "Pengembangan",
  ],
  [
    "GOLL",
    "AGRI",
    "Golden Plantation Tbk.",
    "2014-12-23",
    3665000759,
    "Pengembangan",
  ],
  [
    "GOOD",
    "CONSUMER",
    "Garudafood Putra Putri Jaya Tb",
    "2018-10-10",
    7379580291,
    "Utama",
  ],
  [
    "GPRA",
    "PROPERTY",
    "Perdana Gapuraprima Tbk.",
    "2007-10-10",
    4276655336,
    "Utama",
  ],
  [
    "GSMF",
    "FINANCE",
    "Equity Development Investment ",
    "1989-10-23",
    7454723337,
    "Pengembangan",
  ],
  [
    "GTBO",
    "MINING",
    "Garda Tujuh Buana Tbk",
    "2009-07-09",
    2500000000,
    "Pengembangan",
  ],
  [
    "GWSA",
    "PROPERTY",
    "Greenwood Sejahtera Tbk.",
    "2011-12-23",
    7800760000,
    "Utama",
  ],
  [
    "GZCO",
    "AGRI",
    "Gozco Plantations Tbk.",
    "2008-05-15",
    6000000000,
    "Utama",
  ],
  [
    "HADE",
    "TRADE",
    "Himalaya Energi Perkasa Tbk.",
    "2004-04-12",
    2120000000,
    "Pengembangan",
  ],
  [
    "HDFA",
    "FINANCE",
    "Radana Bhaskara Finance Tbk.",
    "2011-05-10",
    6096972783,
    "Utama",
  ],
  [
    "HDIT",
    "TRADE",
    "Hensel Davest Indonesia Tbk.",
    "2019-07-12",
    1524680000,
    "Utama",
  ],
  [
    "HDTX",
    "MISC-IND",
    "Panasia Indo Resources Tbk.",
    "1990-06-06",
    3601462800,
    "Utama",
  ],
  [
    "HEAL",
    "TRADE",
    "Medikaloka Hermina Tbk.",
    "2018-05-16",
    2978000000,
    "Utama",
  ],
  [
    "HELI",
    "INFRASTRUCT",
    "Jaya Trishindo Tbk.",
    "2018-03-27",
    819000005,
    "Pengembangan",
  ],
  [
    "HERO",
    "TRADE",
    "Hero Supermarket Tbk.",
    "1989-08-21",
    4183634000,
    "Utama",
  ],
  [
    "HEXA",
    "TRADE",
    "Hexindo Adiperkasa Tbk.",
    "1995-02-13",
    840000000,
    "Utama",
  ],
  [
    "HITS",
    "INFRASTRUCT",
    "Humpuss Intermoda Transportasi",
    "1997-12-15",
    7101084801,
    "Utama",
  ],
  [
    "HKMU",
    "TRADE",
    "HK Metals Utama Tbk.",
    "2018-10-09",
    3221750000,
    "Utama",
  ],
  [
    "HMSP",
    "CONSUMER",
    "H.M. Sampoerna Tbk.",
    "1990-08-15",
    116318076900,
    "Utama",
  ],
  [
    "HOKI",
    "CONSUMER",
    "Buyung Poetra Sembada Tbk.",
    "2017-06-22",
    2419438170,
    "Utama",
  ],
  [
    "HOME",
    "TRADE",
    "Hotel Mandarine Regency Tbk.",
    "2008-07-17",
    22212194782,
    "Pengembangan",
  ],
  [
    "HOMI",
    "PROPERTY",
    "Grand House Mulia Tbk.",
    "2020-09-10",
    787500000,
    "Pengembangan",
  ],
  [
    "HOTL",
    "TRADE",
    "Saraswati Griya Lestari Tbk.",
    "2013-01-10",
    3550001452,
    "Utama",
  ],
  [
    "HRME",
    "TRADE",
    "Menteng Heritage Realty Tbk.",
    "2019-04-12",
    5958750000,
    "Pengembangan",
  ],
  [
    "HRTA",
    "CONSUMER",
    "Hartadinata Abadi Tbk.",
    "2017-06-21",
    4605262400,
    "Utama",
  ],
  [
    "HRUM",
    "MINING",
    "Harum Energy Tbk.",
    "2010-10-06",
    2703620000,
    "Utama",
  ],
  [
    "IATA",
    "INFRASTRUCT",
    "Indonesia Transport & Infrastr",
    "2006-09-13",
    10697665114,
    "Pengembangan",
  ],
  [
    "IBFN",
    "FINANCE",
    "Intan Baruprana Finance Tbk.",
    "2014-12-22",
    1517321249,
    "Pengembangan",
  ],
  [
    "IBST",
    "INFRASTRUCT",
    "Inti Bangun Sejahtera Tbk.",
    "2012-08-31",
    1350904927,
    "Utama",
  ],
  [
    "ICBP",
    "CONSUMER",
    "Indofood CBP Sukses Makmur Tbk",
    "2010-10-07",
    11661908000,
    "Utama",
  ],
  [
    "ICON",
    "TRADE",
    "Island Concepts Indonesia Tbk.",
    "2005-07-08",
    1089750000,
    "Pengembangan",
  ],
  [
    "IDPR",
    "PROPERTY",
    "Indonesia Pondasi Raya Tbk.",
    "2015-12-10",
    2003000000,
    "Utama",
  ],
  [
    "IFII",
    "BASIC-IND",
    "Indonesia Fibreboard Industry ",
    "2019-12-10",
    9412000000,
    "Utama",
  ],
  [
    "IFSH",
    "MINING",
    "Ifishdeco Tbk.",
    "2019-12-05",
    2125000000,
    "Pengembangan",
  ],
  [
    "IGAR",
    "BASIC-IND",
    "Champion Pacific Indonesia Tbk",
    "1990-11-05",
    972204500,
    "Utama",
  ],
  [
    "IIKP",
    "CONSUMER",
    "Inti Agri Resources Tbk",
    "2002-10-14",
    33600000000,
    "Pengembangan",
  ],
  [
    "IKAI",
    "TRADE",
    "Intikeramik Alamasri Industri ",
    "1997-06-04",
    13305799387,
    "Utama",
  ],
  [
    "IKAN",
    "CONSUMER",
    "Era Mandiri Cemerlang Tbk.",
    "2020-02-12",
    833333000,
    "Pengembangan",
  ],
  [
    "IKBI",
    "MISC-IND",
    "Sumi Indo Kabel Tbk.",
    "1991-01-21",
    1224000000,
    "Pengembangan",
  ],
  [
    "IMAS",
    "MISC-IND",
    "Indomobil Sukses Internasional",
    "1993-11-15",
    3994291039,
    "Utama",
  ],
  [
    "IMJS",
    "FINANCE",
    "Indomobil Multi Jasa Tbk.",
    "2013-12-10",
    8654325000,
    "Utama",
  ],
  [
    "IMPC",
    "BASIC-IND",
    "Impack Pratama Industri Tbk.",
    "2014-12-17",
    4833500000,
    "Pengembangan",
  ],
  [
    "INAF",
    "CONSUMER",
    "Indofarma Tbk.",
    "2001-04-17",
    3099267500,
    "Utama",
  ],
  [
    "INAI",
    "BASIC-IND",
    "Indal Aluminium Industry Tbk.",
    "1994-12-05",
    633600000,
    "Pengembangan",
  ],
  [
    "INCF",
    "BASIC-IND",
    "Indo Komoditi Korpora Tbk.",
    "1989-12-18",
    1438370465,
    "Pengembangan",
  ],
  [
    "INCI",
    "BASIC-IND",
    "Intanwijaya Internasional Tbk",
    "1990-07-24",
    196121237,
    "Utama",
  ],
  [
    "INCO",
    "MINING",
    "Vale Indonesia Tbk.",
    "1990-05-16",
    9936338720,
    "Utama",
  ],
  [
    "INDF",
    "CONSUMER",
    "Indofood Sukses Makmur Tbk.",
    "1994-07-14",
    8780426500,
    "Utama",
  ],
  [
    "INDO",
    "PROPERTY",
    "Royalindo Investa Wijaya Tbk.",
    "2020-01-13",
    4309161705,
    "Pengembangan",
  ],
  [
    "INDR",
    "MISC-IND",
    "Indo-Rama Synthetics Tbk.",
    "1990-08-03",
    654351707,
    "Utama",
  ],
  [
    "INDS",
    "MISC-IND",
    "Indospring Tbk.",
    "1990-08-10",
    656249710,
    "Utama",
  ],
  [
    "INDX",
    "TRADE",
    "Tanah Laut Tbk",
    "2001-05-17",
    437913588,
    "Pengembangan",
  ],
  [
    "INDY",
    "MINING",
    "Indika Energy Tbk.",
    "2008-06-11",
    5210192000,
    "Utama",
  ],
  [
    "INKP",
    "BASIC-IND",
    "Indah Kiat Pulp & Paper Tbk.",
    "1990-07-16",
    5470982941,
    "Utama",
  ],
  [
    "INOV",
    "BASIC-IND",
    "Inocycle Technology Group Tbk.",
    "2019-07-10",
    1808221900,
    "Pengembangan",
  ],
  [
    "INPC",
    "FINANCE",
    "Bank Artha Graha Internasional",
    "1990-08-23",
    15638233267,
    "Utama",
  ],
  [
    "INPP",
    "PROPERTY",
    "Indonesian Paradise Property T",
    "2004-12-01",
    11181971732,
    "Pengembangan",
  ],
  [
    "INPS",
    "TRADE",
    "Indah Prakasa Sentosa Tbk.",
    "2018-04-06",
    650000000,
    "Pengembangan",
  ],
  [
    "INRU",
    "BASIC-IND",
    "Toba Pulp Lestari Tbk.",
    "1990-06-18",
    1388883283,
    "Pengembangan",
  ],
  [
    "INTA",
    "TRADE",
    "Intraco Penta Tbk.",
    "1993-08-23",
    3343935022,
    "Pengembangan",
  ],
  [
    "INTD",
    "TRADE",
    "Inter Delta Tbk",
    "1989-12-18",
    591828000,
    "Pengembangan",
  ],
  [
    "INTP",
    "BASIC-IND",
    "Indocement Tunggal Prakarsa Tb",
    "1989-12-05",
    3681231699,
    "Utama",
  ],
  [
    "IPCC",
    "INFRASTRUCT",
    "Indonesia Kendaraan Terminal T",
    "2018-07-09",
    1818384820,
    "Utama",
  ],
  [
    "IPCM",
    "INFRASTRUCT",
    "Jasa Armada Indonesia Tbk.",
    "2017-12-22",
    5284811100,
    "Pengembangan",
  ],
  [
    "IPOL",
    "BASIC-IND",
    "Indopoly Swakarsa Industry Tbk",
    "2010-07-09",
    6443379509,
    "Utama",
  ],
  [
    "IPTV",
    "TRADE",
    "MNC Vision Networks Tbk.",
    "2019-07-08",
    41514046639,
    "Utama",
  ],
  [
    "IRRA",
    "TRADE",
    "Itama Ranoraya Tbk.",
    "2019-10-15",
    1600000000,
    "Pengembangan",
  ],
  [
    "ISAT",
    "INFRASTRUCT",
    "Indosat Tbk.",
    "1994-10-19",
    5433933500,
    "Utama",
  ],
  [
    "ISSP",
    "BASIC-IND",
    "Steel Pipe Industry of Indones",
    "2013-02-22",
    7185992035,
    "Utama",
  ],
  [
    "ITIC",
    "CONSUMER",
    "Indonesian Tobacco Tbk.",
    "2019-07-04",
    940720000,
    "Pengembangan",
  ],
  [
    "ITMA",
    "TRADE",
    "Sumber Energi Andalan Tbk.",
    "1990-12-10",
    870701000,
    "Pengembangan",
  ],
  [
    "ITMG",
    "MINING",
    "Indo Tambangraya Megah Tbk.",
    "2007-12-18",
    1129925000,
    "Utama",
  ],
  [
    "JAST",
    "INFRASTRUCT",
    "Jasnita Telekomindo Tbk.",
    "2019-05-16",
    813626700,
    "Pengembangan",
  ],
  [
    "JAWA",
    "AGRI",
    "Jaya Agra Wattie Tbk.",
    "2011-05-30",
    3774685500,
    "Utama",
  ],
  [
    "JAYA",
    "INFRASTRUCT",
    "Armada Berjaya Trans Tbk.",
    "2019-02-21",
    375000105,
    "Pengembangan",
  ],
  [
    "JECC",
    "MISC-IND",
    "Jembo Cable Company Tbk.",
    "1992-11-18",
    151200000,
    "Pengembangan",
  ],
  [
    "JGLE",
    "TRADE",
    "Graha Andrasentra Propertindo ",
    "2016-06-29",
    22581909405,
    "Pengembangan",
  ],
  [
    "JIHD",
    "TRADE",
    "Jakarta International Hotels &",
    "1984-02-29",
    2329040482,
    "Pengembangan",
  ],
  [
    "JKON",
    "PROPERTY",
    "Jaya Konstruksi Manggala Prata",
    "2007-12-04",
    16308519860,
    "Utama",
  ],
  [
    "JKSW",
    "BASIC-IND",
    "Jakarta Kyoei Steel Works Tbk.",
    "1997-08-06",
    150000000,
    "Pengembangan",
  ],
  [
    "JMAS",
    "FINANCE",
    "Asuransi Jiwa Syariah Jasa Mit",
    "2017-12-18",
    1000000000,
    "Pengembangan",
  ],
  [
    "JPFA",
    "BASIC-IND",
    "Japfa Comfeed Indonesia Tbk.",
    "1989-10-23",
    11726575201,
    "Utama",
  ],
  [
    "JRPT",
    "PROPERTY",
    "Jaya Real Property Tbk.",
    "1994-06-29",
    13750000000,
    "Utama",
  ],
  [
    "JSKY",
    "MISC-IND",
    "Sky Energy Indonesia Tbk.",
    "2018-03-28",
    2032540000,
    "Utama",
  ],
  [
    "JSMR",
    "INFRASTRUCT",
    "Jasa Marga (Persero) Tbk.",
    "2007-11-12",
    7257871200,
    "Utama",
  ],
  [
    "JSPT",
    "TRADE",
    "Jakarta Setiabudi Internasiona",
    "1998-01-12",
    2318736000,
    "Pengembangan",
  ],
  [
    "JTPE",
    "TRADE",
    "Jasuindo Tiga Perkasa Tbk.",
    "2002-04-16",
    1713012500,
    "Pengembangan",
  ],
  [
    "KAEF",
    "CONSUMER",
    "Kimia Farma Tbk.",
    "2001-07-04",
    5554000000,
    "Utama",
  ],
  [
    "KARW",
    "INFRASTRUCT",
    "ICTSI Jasa Prima Tbk.",
    "1994-12-20",
    587152700,
    "Pengembangan",
  ],
  [
    "KAYU",
    "TRADE",
    "Darmi Bersaudara Tbk.",
    "2019-07-04",
    665000000,
    "Pengembangan",
  ],
  [
    "KBAG",
    "PROPERTY",
    "Karya Bersama Anugerah Tbk.",
    "2020-04-08",
    7150000007,
    "Pengembangan",
  ],
  [
    "KBLI",
    "MISC-IND",
    "KMI Wire & Cable Tbk.",
    "1992-07-06",
    4007235107,
    "Utama",
  ],
  [
    "KBLM",
    "MISC-IND",
    "Kabelindo Murni Tbk.",
    "1992-06-01",
    1120000000,
    "Pengembangan",
  ],
  [
    "KBLV",
    "TRADE",
    "First Media Tbk.",
    "2000-02-25",
    1742167907,
    "Pengembangan",
  ],
  [
    "KBRI",
    "BASIC-IND",
    "Kertas Basuki Rachmat Indonesi",
    "2008-07-11",
    8687995734,
    "PENGEMBANGAN",
  ],
  [
    "KDSI",
    "BASIC-IND",
    "Kedawung Setia Industrial Tbk.",
    "1996-07-29",
    405000000,
    "Pengembangan",
  ],
  [
    "KEEN",
    "INFRASTRUCT",
    "Kencana Energi Lestari Tbk.",
    "2019-09-02",
    3666312500,
    "Utama",
  ],
  [
    "KEJU",
    "CONSUMER",
    "Mulia Boga Raya Tbk.",
    "2019-11-25",
    1500000000,
    "Pengembangan",
  ],
  [
    "KIAS",
    "BASIC-IND",
    "Keramika Indonesia Assosiasi T",
    "1994-12-08",
    14929100000,
    "Pengembangan",
  ],
  [
    "KICI",
    "CONSUMER",
    "Kedaung Indah Can Tbk",
    "1993-10-28",
    276000000,
    "Utama",
  ],
  [
    "KIJA",
    "PROPERTY",
    "Kawasan Industri Jababeka Tbk.",
    "1995-01-10",
    20824888369,
    "Utama",
  ],
  [
    "KINO",
    "CONSUMER",
    "Kino Indonesia Tbk.",
    "2015-12-11",
    1428571500,
    "Utama",
  ],
  [
    "KIOS",
    "TRADE",
    "Kioson Komersial Indonesia Tbk",
    "2017-10-05",
    717239900,
    "Pengembangan",
  ],
  [
    "KJEN",
    "INFRASTRUCT",
    "Krida Jaringan Nusantara Tbk.",
    "2019-07-01",
    500000000,
    "Pengembangan",
  ],
  [
    "KKGI",
    "MINING",
    "Resource Alam Indonesia Tbk.",
    "1991-07-01",
    5000000000,
    "Utama",
  ],
  [
    "KLBF",
    "CONSUMER",
    "Kalbe Farma Tbk.",
    "1991-07-30",
    46875122110,
    "Utama",
  ],
  [
    "KMDS",
    "TRADE",
    "Kurniamitra Duta Sentosa Tbk.",
    "2020-09-07",
    800000000,
    "Pengembangan",
  ],
  [
    "KMTR",
    "BASIC-IND",
    "Kirana Megatara Tbk.",
    "2017-06-19",
    8215366379,
    "Pengembangan",
  ],
  [
    "KOBX",
    "TRADE",
    "Kobexindo Tractors Tbk.",
    "2012-07-05",
    2272500000,
    "Utama",
  ],
  [
    "KOIN",
    "TRADE",
    "Kokoh Inti Arebama Tbk",
    "2008-04-09",
    980843732,
    "Pengembangan",
  ],
  [
    "KONI",
    "TRADE",
    "Perdana Bangun Pusaka Tbk",
    "1995-08-22",
    249005000,
    "Pengembangan",
  ],
  [
    "KOPI",
    "INFRASTRUCT",
    "Mitra Energi Persada Tbk.",
    "2001-04-23",
    697266668,
    "Pengembangan",
  ],
  [
    "KOTA",
    "PROPERTY",
    "DMS Propertindo Tbk.",
    "2019-07-09",
    10546043868,
    "Utama",
  ],
  [
    "KPAL",
    "MISC-IND",
    "Steadfast Marine Tbk.",
    "2018-06-08",
    1069009400,
    "Utama",
  ],
  [
    "KPAS",
    "CONSUMER",
    "Cottonindo Ariesta Tbk.",
    "2018-10-05",
    768042882,
    "Pengembangan",
  ],
  [
    "KPIG",
    "TRADE",
    "MNC Land Tbk.",
    "2000-03-30",
    80625726664,
    "Pengembangan",
  ],
  [
    "KRAH",
    "MISC-IND",
    "Grand Kartech Tbk.",
    "2013-11-08",
    971190000,
    "Pengembangan",
  ],
  [
    "KRAS",
    "BASIC-IND",
    "Krakatau Steel (Persero) Tbk.",
    "2010-11-10",
    19346396900,
    "Utama",
  ],
  [
    "KREN",
    "TRADE",
    "Kresna Graha Investama Tbk.",
    "2002-06-28",
    18208470100,
    "Utama",
  ],
  [
    "LAND",
    "PROPERTY",
    "Trimitra Propertindo Tbk.",
    "2018-08-23",
    2792620000,
    "Pengembangan",
  ],
  [
    "LAPD",
    "INFRASTRUCT",
    "Leyand International Tbk.",
    "2001-07-17",
    3966350139,
    "Pengembangan",
  ],
  [
    "LCGP",
    "PROPERTY",
    "Eureka Prima Jakarta Tbk.",
    "2007-07-13",
    5630000914,
    "Pengembangan",
  ],
  [
    "LCKM",
    "INFRASTRUCT",
    "LCK Global Kedaton Tbk.",
    "2018-01-16",
    1000000000,
    "Pengembangan",
  ],
  [
    "LEAD",
    "INFRASTRUCT",
    "Logindo Samudramakmur Tbk.",
    "2013-12-11",
    4049616328,
    "Utama",
  ],
  [
    "LIFE",
    "FINANCE",
    "Asuransi Jiwa Sinarmas MSIG Tb",
    "2019-07-09",
    2100000000,
    "Utama",
  ],
  [
    "LINK",
    "TRADE",
    "Link Net Tbk.",
    "2014-06-02",
    2863195484,
    "Utama",
  ],
  [
    "LION",
    "BASIC-IND",
    "Lion Metal Works Tbk.",
    "1993-08-20",
    520160000,
    "Utama",
  ],
  [
    "LMAS",
    "TRADE",
    "Limas Indonesia Makmur Tbk",
    "2001-12-28",
    787851525,
    "Pengembangan",
  ],
  [
    "LMPI",
    "CONSUMER",
    "Langgeng Makmur Industri Tbk.",
    "1994-10-17",
    1008517669,
    "Pengembangan",
  ],
  [
    "LMSH",
    "BASIC-IND",
    "Lionmesh Prima Tbk.",
    "1990-06-04",
    96000000,
    "Pengembangan",
  ],
  [
    "LPCK",
    "PROPERTY",
    "Lippo Cikarang Tbk",
    "1997-07-24",
    2679600000,
    "Utama",
  ],
  [
    "LPGI",
    "FINANCE",
    "Lippo General Insurance Tbk.",
    "1997-07-22",
    150000000,
    "Utama",
  ],
  [
    "LPIN",
    "MISC-IND",
    "Multi Prima Sejahtera Tbk",
    "1990-02-05",
    425000000,
    "Pengembangan",
  ],
  [
    "LPKR",
    "PROPERTY",
    "Lippo Karawaci Tbk.",
    "1996-06-28",
    70898018369,
    "Utama",
  ],
  [
    "LPLI",
    "TRADE",
    "Star Pacific Tbk",
    "1989-10-23",
    1170432803,
    "Pengembangan",
  ],
  [
    "LPPF",
    "TRADE",
    "Matahari Department Store Tbk.",
    "1989-10-10",
    2626148780,
    "Utama",
  ],
  [
    "LPPS",
    "FINANCE",
    "Lenox Pasifik Investama Tbk.",
    "1994-03-28",
    2588250000,
    "Pengembangan",
  ],
  [
    "LRNA",
    "INFRASTRUCT",
    "Eka Sari Lorena Transport Tbk.",
    "2014-04-15",
    350000022,
    "Pengembangan",
  ],
  [
    "LSIP",
    "AGRI",
    "PP London Sumatra Indonesia Tb",
    "1996-07-05",
    6822863965,
    "Utama",
  ],
  [
    "LTLS",
    "TRADE",
    "Lautan Luas Tbk.",
    "1997-07-21",
    1560000000,
    "Utama",
  ],
  [
    "LUCK",
    "TRADE",
    "Sentral Mitra Informatika Tbk.",
    "2018-11-28",
    715749640,
    "Pengembangan",
  ],
  [
    "MABA",
    "PROPERTY",
    "Marga Abhinaya Abadi Tbk.",
    "2017-06-22",
    15365229912,
    "PENGEMBANGAN",
  ],
  [
    "MAGP",
    "AGRI",
    "Multi Agro Gemilang Plantation",
    "2013-01-16",
    9000000004,
    "Pengembangan",
  ],
  [
    "MAIN",
    "BASIC-IND",
    "Malindo Feedmill Tbk.",
    "2006-02-10",
    2238750000,
    "Utama",
  ],
  [
    "MAMI",
    "TRADE",
    "Mas Murni Indonesia Tbk",
    "1994-02-09",
    12299116371,
    "Utama",
  ],
  [
    "MAPA",
    "TRADE",
    "Map Aktif Adiperkasa Tbk.",
    "2018-07-05",
    2850400000,
    "Pengembangan",
  ],
  [
    "MAPB",
    "TRADE",
    "MAP Boga Adiperkasa Tbk.",
    "2017-06-21",
    2170922900,
    "Pengembangan",
  ],
  [
    "MAPI",
    "TRADE",
    "Mitra Adiperkasa Tbk.",
    "2004-11-10",
    16600000000,
    "Utama",
  ],
  [
    "MARI",
    "TRADE",
    "Mahaka Radio Integra Tbk.",
    "2016-02-11",
    5252644000,
    "Pengembangan",
  ],
  [
    "MARK",
    "BASIC-IND",
    "Mark Dynamics Indonesia Tbk.",
    "2017-07-12",
    3800000310,
    "Utama",
  ],
  [
    "MASA",
    "MISC-IND",
    "Multistrada Arah Sarana Tbk.",
    "2005-06-09",
    9182946945,
    "Utama",
  ],
  [
    "MAYA",
    "FINANCE",
    "Bank Mayapada Internasional Tb",
    "1997-08-29",
    6764086593,
    "Utama",
  ],
  [
    "MBAP",
    "MINING",
    "Mitrabara Adiperdana Tbk.",
    "2014-07-10",
    1227271952,
    "Pengembangan",
  ],
  [
    "MBSS",
    "INFRASTRUCT",
    "Mitrabahtera Segara Sejati Tbk",
    "2011-04-06",
    1750026639,
    "Utama",
  ],
  [
    "MBTO",
    "CONSUMER",
    "Martina Berto Tbk.",
    "2011-01-13",
    1070000000,
    "Utama",
  ],
  [
    "MCAS",
    "TRADE",
    "M Cash Integrasi Tbk.",
    "2017-11-01",
    867933300,
    "Pengembangan",
  ],
  [
    "MCOR",
    "FINANCE",
    "Bank China Construction Bank I",
    "2007-07-03",
    37540533209,
    "Utama",
  ],
  [
    "MDIA",
    "TRADE",
    "Intermedia Capital Tbk.",
    "2014-04-11",
    39215538400,
    "Utama",
  ],
  [
    "MDKA",
    "MINING",
    "Merdeka Copper Gold Tbk.",
    "2015-06-19",
    21897591650,
    "Pengembangan",
  ],
  [
    "MDKI",
    "BASIC-IND",
    "Emdeki Utama Tbk.",
    "2017-09-25",
    2530150002,
    "Pengembangan",
  ],
  [
    "MDLN",
    "PROPERTY",
    "Modernland Realty Tbk.",
    "1993-01-18",
    12533067322,
    "Utama",
  ],
  [
    "MDRN",
    "TRADE",
    "Modern Internasional Tbk.",
    "1991-07-16",
    7632167798,
    "Utama",
  ],
  [
    "MEDC",
    "MINING",
    "Medco Energi Internasional Tbk",
    "1994-10-12",
    25136231252,
    "Utama",
  ],
  [
    "MEGA",
    "FINANCE",
    "Bank Mega Tbk.",
    "2000-04-17",
    6894138227,
    "Utama",
  ],
  [
    "MERK",
    "CONSUMER",
    "Merck Tbk.",
    "1981-07-23",
    448000000,
    "Pengembangan",
  ],
  [
    "META",
    "INFRASTRUCT",
    "Nusantara Infrastructure Tbk.",
    "2001-07-18",
    17710708194,
    "Utama",
  ],
  [
    "MFIN",
    "FINANCE",
    "Mandala Multifinance Tbk.",
    "2005-09-06",
    2650000000,
    "Pengembangan",
  ],
  [
    "MFMI",
    "TRADE",
    "Multifiling Mitra Indonesia Tb",
    "2010-12-29",
    757581000,
    "Pengembangan",
  ],
  [
    "MGNA",
    "TRADE",
    "Magna Investama Mandiri Tbk.",
    "2014-07-07",
    1003080977,
    "Pengembangan",
  ],
  [
    "MGRO",
    "AGRI",
    "Mahkota Group Tbk.",
    "2018-07-12",
    3554445700,
    "Utama",
  ],
  [
    "MICE",
    "TRADE",
    "Multi Indocitra Tbk.",
    "2005-12-21",
    600000000,
    "Pengembangan",
  ],
  [
    "MIDI",
    "TRADE",
    "Midi Utama Indonesia Tbk.",
    "2010-11-30",
    2882353000,
    "Pengembangan",
  ],
  [
    "MIKA",
    "TRADE",
    "Mitra Keluarga Karyasehat Tbk.",
    "2015-03-24",
    14246349500,
    "Utama",
  ],
  [
    "MINA",
    "TRADE",
    "Sanurhasta Mitra Tbk.",
    "2017-04-28",
    6562500000,
    "Pengembangan",
  ],
  [
    "MIRA",
    "INFRASTRUCT",
    "Mitra International Resources ",
    "1997-01-30",
    3961452039,
    "Pengembangan",
  ],
  [
    "MITI",
    "MINING",
    "Mitra Investindo Tbk.",
    "1997-07-16",
    564620320,
    "Pengembangan",
  ],
  [
    "MKNT",
    "TRADE",
    "Mitra Komunikasi Nusantara Tbk",
    "2015-10-26",
    5000000000,
    "Pengembangan",
  ],
  [
    "MKPI",
    "PROPERTY",
    "Metropolitan Kentjana Tbk.",
    "2009-07-10",
    948194000,
    "Pengembangan",
  ],
  [
    "MLBI",
    "CONSUMER",
    "Multi Bintang Indonesia Tbk.",
    "1981-12-15",
    2107000000,
    "Utama",
  ],
  [
    "MLIA",
    "BASIC-IND",
    "Mulia Industrindo Tbk",
    "1994-01-17",
    1323000000,
    "Pengembangan",
  ],
  [
    "MLPL",
    "TRADE",
    "Multipolar Tbk.",
    "1989-11-06",
    14639632470,
    "Utama",
  ],
  [
    "MLPT",
    "TRADE",
    "Multipolar Technology Tbk.",
    "2013-07-08",
    1875000000,
    "Utama",
  ],
  [
    "MMLP",
    "PROPERTY",
    "Mega Manunggal Property Tbk.",
    "2015-06-12",
    6889134608,
    "Pengembangan",
  ],
  [
    "MNCN",
    "TRADE",
    "Media Nusantara Citra Tbk.",
    "2007-06-22",
    15049787710,
    "Utama",
  ],
  [
    "MOLI",
    "BASIC-IND",
    "Madusari Murni Indah Tbk.",
    "2018-08-30",
    2334888498,
    "Pengembangan",
  ],
  [
    "MPMX",
    "TRADE",
    "Mitra Pinasthika Mustika Tbk.",
    "2013-05-29",
    4462963276,
    "Utama",
  ],
  [
    "MPOW",
    "INFRASTRUCT",
    "Megapower Makmur Tbk.",
    "2017-07-06",
    816997053,
    "Pengembangan",
  ],
  [
    "MPPA",
    "TRADE",
    "Matahari Putra Prima Tbk.",
    "1992-12-21",
    7529147920,
    "Utama",
  ],
  [
    "MPRO",
    "PROPERTY",
    "Maha Properti Indonesia Tbk.",
    "2018-10-09",
    9942500000,
    "Pengembangan",
  ],
  [
    "MRAT",
    "CONSUMER",
    "Mustika Ratu Tbk.",
    "1995-07-27",
    428000000,
    "Utama",
  ],
  [
    "MREI",
    "FINANCE",
    "Maskapai Reasuransi Indonesia ",
    "1989-09-04",
    517791681,
    "Pengembangan",
  ],
  [
    "MSIN",
    "TRADE",
    "MNC Studios International Tbk.",
    "2018-06-08",
    10404000000,
    "Utama",
  ],
  [
    "MSKY",
    "TRADE",
    "MNC Sky Vision Tbk.",
    "2012-07-09",
    1994370480,
    "Utama",
  ],
  [
    "MTDL",
    "TRADE",
    "Metrodata Electronics Tbk.",
    "1990-04-09",
    2455376917,
    "Utama",
  ],
  [
    "MTFN",
    "MINING",
    "Capitalinc Investment Tbk.",
    "1990-04-16",
    31842082852,
    "Pengembangan",
  ],
  [
    "MTLA",
    "PROPERTY",
    "Metropolitan Land Tbk.",
    "2011-06-20",
    7655126330,
    "Utama",
  ],
  [
    "MTPS",
    "INFRASTRUCT",
    "Meta Epsi Tbk.",
    "2019-04-10",
    2084850829,
    "Pengembangan",
  ],
  [
    "MTRA",
    "PROPERTY",
    "Mitra Pemuda Tbk.",
    "2016-02-10",
    770000000,
    "Pengembangan",
  ],
  [
    "MTSM",
    "PROPERTY",
    "Metro Realty Tbk.",
    "1992-01-08",
    232848000,
    "Pengembangan",
  ],
  [
    "MTWI",
    "FINANCE",
    "Malacca Trust Wuwungan Insuran",
    "2017-10-11",
    1525819116,
    "Pengembangan",
  ],
  [
    "MYOH",
    "MINING",
    "Samindo Resources Tbk.",
    "2000-07-27",
    2206312500,
    "Utama",
  ],
  [
    "MYOR",
    "CONSUMER",
    "Mayora Indah Tbk.",
    "1990-07-04",
    22358699725,
    "Utama",
  ],
  [
    "MYRX",
    "PROPERTY",
    "Hanson International Tbk.",
    "1990-10-31",
    86703220792,
    "Pengembangan",
  ],
  [
    "MYTX",
    "MISC-IND",
    "Asia Pacific Investama Tbk.",
    "1989-10-10",
    7747281949,
    "Utama",
  ],
  [
    "NASA",
    "TRADE",
    "Andalan Perkasa Abadi Tbk.",
    "2017-08-07",
    11004929322,
    "Pengembangan",
  ],
  [
    "NATO",
    "TRADE",
    "Surya Permata Andalan Tbk.",
    "2019-01-18",
    8001092904,
    "Pengembangan",
  ],
  [
    "NELY",
    "INFRASTRUCT",
    "Pelayaran Nelly Dwi Putri Tbk.",
    "2012-10-11",
    2350000000,
    "Pengembangan",
  ],
  [
    "NFCX",
    "TRADE",
    "NFC Indonesia Tbk.",
    "2018-07-12",
    666667500,
    "Pengembangan",
  ],
  [
    "NICK",
    "TRADE",
    "Charnic Capital Tbk.",
    "2018-05-02",
    651150000,
    "Pengembangan",
  ],
  [
    "NIKL",
    "BASIC-IND",
    "Pelat Timah Nusantara Tbk.",
    "2009-12-14",
    2523350000,
    "Utama",
  ],
  [
    "NIPS",
    "MISC-IND",
    "Nipress Tbk.",
    "1991-07-24",
    1635333332,
    "Pengembangan",
  ],
  [
    "NIRO",
    "PROPERTY",
    "City Retail Developments Tbk.",
    "2012-09-13",
    22198871804,
    "Pengembangan",
  ],
  [
    "NISP",
    "FINANCE",
    "Bank OCBC NISP Tbk.",
    "1994-10-20",
    22715776032,
    "Utama",
  ],
  [
    "NOBU",
    "FINANCE",
    "Bank Nationalnobu Tbk.",
    "2013-05-20",
    4393533177,
    "Utama",
  ],
  [
    "NRCA",
    "PROPERTY",
    "Nusa Raya Cipta Tbk.",
    "2013-06-27",
    2496258344,
    "Utama",
  ],
  [
    "NUSA",
    "TRADE",
    "Sinergi Megah Internusa Tbk.",
    "2018-07-12",
    7700000148,
    "Pengembangan",
  ],
  [
    "NZIA",
    "PROPERTY",
    "Nusantara Almazia Tbk.",
    "2019-09-25",
    2197540705,
    "Utama",
  ],
  [
    "OASA",
    "INFRASTRUCT",
    "Protech Mitra Perkasa Tbk.",
    "2016-07-18",
    358600000,
    "Pengembangan",
  ],
  [
    "OCAP",
    "TRADE",
    "Onix Capital Tbk.",
    "2003-11-10",
    273200000,
    "Pengembangan",
  ],
  [
    "OKAS",
    "TRADE",
    "Ancora Indonesia Resources Tbk",
    "2006-04-17",
    1765927777,
    "Pengembangan",
  ],
  [
    "OMRE",
    "PROPERTY",
    "Indonesia Prima Property Tbk",
    "1994-08-22",
    1745000000,
    "Pengembangan",
  ],
  [
    "OPMS",
    "TRADE",
    "Optima Prima Metal Sinergi Tbk",
    "2019-09-23",
    1000000000,
    "Pengembangan",
  ],
  [
    "PADI",
    "FINANCE",
    "Minna Padi Investama Sekuritas",
    "2012-01-09",
    11307246524,
    "Utama",
  ],
  [
    "PALM",
    "AGRI",
    "Provident Agro Tbk.",
    "2012-10-08",
    7119540356,
    "Pengembangan",
  ],
  [
    "PAMG",
    "PROPERTY",
    "Bima Sakti Pertiwi Tbk.",
    "2019-07-05",
    3125000000,
    "Utama",
  ],
  [
    "PANI",
    "CONSUMER",
    "Pratama Abadi Nusa Industri Tb",
    "2018-09-18",
    410000000,
    "Pengembangan",
  ],
  [
    "PANR",
    "TRADE",
    "Panorama Sentrawisata Tbk.",
    "2001-09-18",
    1200000000,
    "Utama",
  ],
  [
    "PANS",
    "FINANCE",
    "Panin Sekuritas Tbk.",
    "2000-05-31",
    720000000,
    "Utama",
  ],
  [
    "PBID",
    "BASIC-IND",
    "Panca Budi Idaman Tbk.",
    "2017-12-13",
    1875000000,
    "Utama",
  ],
  [
    "PBRX",
    "MISC-IND",
    "Pan Brothers Tbk.",
    "1990-08-16",
    6478295611,
    "Utama",
  ],
  [
    "PBSA",
    "PROPERTY",
    "Paramita Bangun Sarana Tbk.",
    "2016-09-28",
    1500000000,
    "Utama",
  ],
  [
    "PCAR",
    "CONSUMER",
    "Prima Cakrawala Abadi Tbk.",
    "2017-12-29",
    1166666700,
    "Pengembangan",
  ],
  [
    "PDES",
    "TRADE",
    "Destinasi Tirta Nusantara Tbk",
    "2008-07-08",
    715000000,
    "Pengembangan",
  ],
  [
    "PEGE",
    "TRADE",
    "Panca Global Kapital Tbk.",
    "2005-06-24",
    2833417056,
    "Pengembangan",
  ],
  [
    "PEHA",
    "CONSUMER",
    "Phapros Tbk.",
    "1911-01-01",
    840000000,
    "Utama",
  ],
  [
    "PGAS",
    "INFRASTRUCT",
    "Perusahaan Gas Negara Tbk.",
    "2003-12-15",
    24241508196,
    "Utama",
  ],
  [
    "PGJO",
    "TRADE",
    "Tourindo Guide Indonesia Tbk.",
    "2020-01-08",
    306250000,
    "Akselerasi",
  ],
  [
    "PGLI",
    "TRADE",
    "Pembangunan Graha Lestari Inda",
    "2000-05-11",
    488000000,
    "Pengembangan",
  ],
  [
    "PGUN",
    "AGRI",
    "Pradiksi Gunatama Tbk.",
    "2020-07-07",
    4998360000,
    "Utama",
  ],
  [
    "PICO",
    "BASIC-IND",
    "Pelangi Indah Canindo Tbk",
    "1996-09-23",
    568375000,
    "Pengembangan",
  ],
  [
    "PJAA",
    "TRADE",
    "Pembangunan Jaya Ancol Tbk.",
    "2004-07-02",
    1599999996,
    "Utama",
  ],
  [
    "PKPK",
    "MINING",
    "Perdana Karya Perkasa Tbk",
    "2007-07-11",
    600000000,
    "Pengembangan",
  ],
  [
    "PLAN",
    "TRADE",
    "Planet Properindo Jaya Tbk.",
    "2020-09-15",
    892856800,
    "Akselerasi",
  ],
  [
    "PLAS",
    "TRADE",
    "Polaris Investama Tbk",
    "2001-03-16",
    1184200000,
    "Pengembangan",
  ],
  [
    "PLIN",
    "PROPERTY",
    "Plaza Indonesia Realty Tbk.",
    "1992-06-15",
    3550000000,
    "Utama",
  ],
  [
    "PMJS",
    "TRADE",
    "Putra Mandiri Jembar Tbk.",
    "2019-12-18",
    13755600000,
    "Pengembangan",
  ],
  [
    "PMMP",
    "CONSUMER",
    "Panca Mitra Multiperdana Tbk.",
    "2020-12-18",
    2353000000,
    "Utama",
  ],
  [
    "PNBN",
    "FINANCE",
    "Bank Pan Indonesia Tbk",
    "1982-12-29",
    23837645998,
    "Utama",
  ],
  [
    "PNBS",
    "FINANCE",
    "Bank Panin Dubai Syariah Tbk.",
    "2014-01-15",
    38425504906,
    "Utama",
  ],
  [
    "PNGO",
    "AGRI",
    "Pinago Utama Tbk.",
    "2020-08-31",
    781250000,
    "Pengembangan",
  ],
  [
    "PNIN",
    "FINANCE",
    "Paninvest Tbk.",
    "1983-09-20",
    4068323920,
    "Utama",
  ],
  [
    "PNLF",
    "FINANCE",
    "Panin Financial Tbk.",
    "1983-06-14",
    32022073293,
    "Utama",
  ],
  [
    "PNSE",
    "TRADE",
    "Pudjiadi & Sons Tbk.",
    "1990-05-01",
    797813496,
    "Pengembangan",
  ],
  [
    "POLA",
    "FINANCE",
    "Pool Advista Finance Tbk.",
    "2018-11-16",
    2727886300,
    "Pengembangan",
  ],
  [
    "POLI",
    "PROPERTY",
    "Pollux Investasi Internasional",
    "2019-01-10",
    2010526400,
    "Pengembangan",
  ],
  [
    "POLL",
    "PROPERTY",
    "Pollux Properti Indonesia Tbk.",
    "2018-07-11",
    8318823600,
    "Utama",
  ],
  [
    "POLU",
    "MISC-IND",
    "Golden Flower Tbk.",
    "2019-06-26",
    750000000,
    "Pengembangan",
  ],
  [
    "POLY",
    "MISC-IND",
    "Asia Pacific Fibers Tbk",
    "1991-03-12",
    2495753334,
    "Pengembangan",
  ],
  [
    "POOL",
    "TRADE",
    "Pool Advista Indonesia Tbk.",
    "1991-05-20",
    2341366264,
    "Pengembangan",
  ],
  [
    "PORT",
    "INFRASTRUCT",
    "Nusantara Pelabuhan Handal Tbk",
    "2017-03-16",
    2813941985,
    "Pengembangan",
  ],
  [
    "POSA",
    "PROPERTY",
    "Bliss Properti Indonesia Tbk.",
    "2019-05-10",
    8388870106,
    "Pengembangan",
  ],
  [
    "POWR",
    "INFRASTRUCT",
    "Cikarang Listrindo Tbk.",
    "2016-06-14",
    16087156000,
    "Pengembangan",
  ],
  [
    "PPGL",
    "INFRASTRUCT",
    "Prima Globalindo Logistik Tbk.",
    "2020-07-20",
    750000000,
    "Akselerasi",
  ],
  [
    "PPRE",
    "INFRASTRUCT",
    "PP Presisi Tbk.",
    "2017-11-24",
    10224271000,
    "Utama",
  ],
  [
    "PPRO",
    "PROPERTY",
    "PP Properti Tbk.",
    "2015-05-19",
    61675671883,
    "Utama",
  ],
  [
    "PRAS",
    "MISC-IND",
    "Prima Alloy Steel Universal Tb",
    "1990-07-12",
    701043478,
    "Utama",
  ],
  [
    "PRDA",
    "TRADE",
    "Prodia Widyahusada Tbk.",
    "2016-12-07",
    937500000,
    "Utama",
  ],
  [
    "PRIM",
    "TRADE",
    "Royal Prima Tbk.",
    "2018-05-15",
    3393432705,
    "Pengembangan",
  ],
  [
    "PSAB",
    "MINING",
    "J Resources Asia Pasifik Tbk.",
    "2003-04-22",
    26460000000,
    "Pengembangan",
  ],
  [
    "PSDN",
    "CONSUMER",
    "Prasidha Aneka Niaga Tbk",
    "1994-10-18",
    1440000000,
    "Pengembangan",
  ],
  [
    "PSGO",
    "AGRI",
    "Palma Serasih Tbk.",
    "2019-11-25",
    18850000000,
    "Pengembangan",
  ],
  [
    "PSKT",
    "TRADE",
    "Red Planet Indonesia Tbk.",
    "1995-09-29",
    10351231636,
    "Pengembangan",
  ],
  [
    "PSSI",
    "INFRASTRUCT",
    "Pelita Samudera Shipping Tbk.",
    "2017-12-05",
    5417063153,
    "Utama",
  ],
  [
    "PTBA",
    "MINING",
    "Bukit Asam Tbk.",
    "2002-12-23",
    11520659250,
    "Utama",
  ],
  [
    "PTDU",
    "PROPERTY",
    "Djasa Ubersakti Tbk.",
    "2020-12-08",
    1500000000,
    "Pengembangan",
  ],
  [
    "PTIS",
    "INFRASTRUCT",
    "Indo Straits Tbk.",
    "2011-07-12",
    550165300,
    "Utama",
  ],
  [
    "PTPP",
    "PROPERTY",
    "PP (Persero) Tbk.",
    "2010-02-09",
    6199897354,
    "Utama",
  ],
  [
    "PTPW",
    "INFRASTRUCT",
    "Pratama Widya Tbk.",
    "2020-02-07",
    878187500,
    "Pengembangan",
  ],
  [
    "PTRO",
    "MINING",
    "Petrosea Tbk.",
    "1990-05-21",
    1008605000,
    "Utama",
  ],
  [
    "PTSN",
    "MISC-IND",
    "Sat Nusapersada Tbk",
    "2007-11-08",
    5314344000,
    "Utama",
  ],
  [
    "PTSP",
    "TRADE",
    "Pioneerindo Gourmet Internatio",
    "1994-05-30",
    220808000,
    "Pengembangan",
  ],
  [
    "PUDP",
    "PROPERTY",
    "Pudjiadi Prestige Tbk.",
    "1994-11-18",
    329560000,
    "Utama",
  ],
  [
    "PURA",
    "INFRASTRUCT",
    "Putra Rajawali Kencana Tbk.",
    "2020-01-29",
    5736328465,
    "Pengembangan",
  ],
  [
    "PURE",
    "BASIC-IND",
    "Trinitan Metals and Minerals T",
    "2019-10-09",
    1333333505,
    "Utama",
  ],
  [
    "PURI",
    "PROPERTY",
    "Puri Global Sukses Tbk.",
    "2020-09-08",
    1000000000,
    "Pengembangan",
  ],
  [
    "PWON",
    "PROPERTY",
    "Pakuwon Jati Tbk.",
    "1989-10-09",
    48159602400,
    "Utama",
  ],
  [
    "PYFA",
    "CONSUMER",
    "Pyridam Farma Tbk",
    "2001-10-16",
    535080000,
    "Pengembangan",
  ],
  [
    "PZZA",
    "TRADE",
    "Sarimelati Kencana Tbk.",
    "2018-05-23",
    3021875000,
    "Utama",
  ],
  [
    "RAJA",
    "INFRASTRUCT",
    "Rukun Raharja Tbk.",
    "2006-04-19",
    4227082500,
    "Utama",
  ],
  [
    "RALS",
    "TRADE",
    "Ramayana Lestari Sentosa Tbk.",
    "1996-07-24",
    7096000000,
    "Utama",
  ],
  [
    "RANC",
    "TRADE",
    "Supra Boga Lestari Tbk.",
    "2012-06-07",
    1564487500,
    "Utama",
  ],
  [
    "RBMS",
    "PROPERTY",
    "Ristia Bintang Mahkotasejati T",
    "1997-12-19",
    2656212826,
    "Utama",
  ],
  [
    "RDTX",
    "PROPERTY",
    "Roda Vivatex Tbk",
    "1990-05-14",
    268800000,
    "Utama",
  ],
  [
    "REAL",
    "PROPERTY",
    "Repower Asia Indonesia Tbk.",
    "2019-12-06",
    6633610151,
    "Pengembangan",
  ],
  [
    "RELI",
    "FINANCE",
    "Reliance Sekuritas Indonesia T",
    "2005-07-13",
    1800000000,
    "Utama",
  ],
  [
    "RICY",
    "MISC-IND",
    "Ricky Putra Globalindo Tbk",
    "1998-01-22",
    641717510,
    "Utama",
  ],
  [
    "RIGS",
    "INFRASTRUCT",
    "Rig Tenders Indonesia Tbk.",
    "1990-03-05",
    609130000,
    "Pengembangan",
  ],
  [
    "RIMO",
    "PROPERTY",
    "Rimo International Lestari Tbk",
    "2000-11-10",
    45080600000,
    "Pengembangan",
  ],
  [
    "RISE",
    "PROPERTY",
    "Jaya Sukses Makmur Sentosa Tbk",
    "2018-07-09",
    9950000000,
    "Utama",
  ],
  [
    "RMBA",
    "CONSUMER",
    "Bentoel Internasional Investam",
    "1990-03-05",
    36401136250,
    "Utama",
  ],
  [
    "ROCK",
    "PROPERTY",
    "Rockfields Properti Indonesia ",
    "2020-09-10",
    1435185100,
    "Pengembangan",
  ],
  [
    "RODA",
    "PROPERTY",
    "Pikko Land Development Tbk.",
    "2001-10-22",
    13592128209,
    "Pengembangan",
  ],
  [
    "RONY",
    "TRADE",
    "Aesler Grup Internasional Tbk.",
    "2020-04-09",
    1250000000,
    "Pengembangan",
  ],
  [
    "ROTI",
    "CONSUMER",
    "Nippon Indosari Corpindo Tbk.",
    "2010-06-28",
    6186488888,
    "Utama",
  ],
  [
    "RUIS",
    "MINING",
    "Radiant Utama Interinsco Tbk.",
    "2006-07-12",
    770000000,
    "Pengembangan",
  ],
  [
    "SAFE",
    "INFRASTRUCT",
    "Steady Safe Tbk",
    "1994-08-15",
    615145012,
    "Pengembangan",
  ],
  [
    "SAME",
    "TRADE",
    "Sarana Meditama Metropolitan T",
    "2013-01-11",
    5900000000,
    "Pengembangan",
  ],
  [
    "SAMF",
    "BASIC-IND",
    "Saraswanti Anugerah Makmur Tbk",
    "2020-03-31",
    5125000000,
    "Utama",
  ],
  [
    "SAPX",
    "INFRASTRUCT",
    "Satria Antaran Prima Tbk.",
    "2018-10-03",
    833333300,
    "Pengembangan",
  ],
  [
    "SATU",
    "PROPERTY",
    "Kota Satu Properti Tbk.",
    "2018-11-05",
    1375000000,
    "Pengembangan",
  ],
  [
    "SBAT",
    "MISC-IND",
    "Sejahtera Bintang Abadi Textil",
    "2020-04-08",
    2125166005,
    "Pengembangan",
  ],
  [
    "SCCO",
    "MISC-IND",
    "Supreme Cable Manufacturing & ",
    "1982-07-20",
    205583400,
    "Utama",
  ],
  [
    "SCMA",
    "TRADE",
    "Surya Citra Media Tbk.",
    "2002-07-16",
    14779091301,
    "Utama",
  ],
  [
    "SCNP",
    "MISC-IND",
    "Selaras Citra Nusantara Perkas",
    "2020-09-07",
    2500000000,
    "Pengembangan",
  ],
  [
    "SCPI",
    "CONSUMER",
    "Merck Sharp Dohme Pharma Tbk.",
    "1990-06-08",
    3600000,
    "Pengembangan",
  ],
  [
    "SDMU",
    "INFRASTRUCT",
    "Sidomulyo Selaras Tbk.",
    "2011-07-12",
    1135225000,
    "Pengembangan",
  ],
  [
    "SDPC",
    "TRADE",
    "Millennium Pharmacon Internati",
    "1990-05-07",
    1274000000,
    "Utama",
  ],
  [
    "SDRA",
    "FINANCE",
    "Bank Woori Saudara Indonesia 1",
    "2006-12-15",
    6515116991,
    "Utama",
  ],
  [
    "SFAN",
    "TRADE",
    "Surya Fajar Capital Tbk.",
    "2019-06-19",
    1359934021,
    "Pengembangan",
  ],
  [
    "SGER",
    "TRADE",
    "Sumber Global Energy Tbk.",
    "2020-08-10",
    1664000000,
    "Pengembangan",
  ],
  [
    "SGRO",
    "AGRI",
    "Sampoerna Agro Tbk.",
    "2007-06-18",
    1890000000,
    "Utama",
  ],
  [
    "SHID",
    "TRADE",
    "Hotel Sahid Jaya International",
    "1990-05-08",
    1119326168,
    "Pengembangan",
  ],
  [
    "SHIP",
    "INFRASTRUCT",
    "Sillo Maritime Perdana Tbk.",
    "2016-06-16",
    2719790000,
    "Pengembangan",
  ],
  [
    "SIDO",
    "CONSUMER",
    "Industri Jamu dan Farmasi Sido",
    "2013-12-18",
    30000000000,
    "Utama",
  ],
  [
    "SILO",
    "TRADE",
    "Siloam International Hospitals",
    "2013-09-12",
    1625765625,
    "Utama",
  ],
  [
    "SIMA",
    "TRADE",
    "Siwani Makmur Tbk",
    "1994-06-03",
    442589871,
    "PENGEMBANGAN",
  ],
  [
    "SIMP",
    "AGRI",
    "Salim Ivomas Pratama Tbk.",
    "2011-06-09",
    15816310000,
    "Utama",
  ],
  [
    "SINI",
    "BASIC-IND",
    "Singaraja Putra Tbk.",
    "2019-11-08",
    464806050,
    "Pengembangan",
  ],
  [
    "SIPD",
    "BASIC-IND",
    "Sreeya Sewu Indonesia Tbk.",
    "1996-12-27",
    1339102579,
    "Pengembangan",
  ],
  [
    "SKBM",
    "CONSUMER",
    "Sekar Bumi Tbk.",
    "1993-01-05",
    1726003217,
    "Pengembangan",
  ],
  [
    "SKLT",
    "CONSUMER",
    "Sekar Laut Tbk.",
    "1993-09-08",
    690740500,
    "Pengembangan",
  ],
  [
    "SKRN",
    "PROPERTY",
    "Superkrane Mitra Utama Tbk.",
    "2018-10-11",
    1500000000,
    "Pengembangan",
  ],
  [
    "SKYB",
    "TRADE",
    "Northcliff Citranusa Indonesia",
    "2010-07-07",
    585000000,
    "Pengembangan",
  ],
  [
    "SLIS",
    "MISC-IND",
    "Gaya Abadi Sempurna Tbk.",
    "2019-10-07",
    2000000000,
    "Pengembangan",
  ],
  [
    "SMAR",
    "AGRI",
    "Smart Tbk.",
    "1992-11-20",
    2872193366,
    "Pengembangan",
  ],
  [
    "SMBR",
    "BASIC-IND",
    "Semen Baturaja (Persero) Tbk.",
    "2013-06-28",
    9932534336,
    "Utama",
  ],
  [
    "SMCB",
    "BASIC-IND",
    "Solusi Bangun Indonesia Tbk.",
    "1977-08-10",
    7662900000,
    "Utama",
  ],
  [
    "SMDM",
    "PROPERTY",
    "Suryamas Dutamakmur Tbk.",
    "1995-10-12",
    4772138237,
    "Pengembangan",
  ],
  [
    "SMDR",
    "INFRASTRUCT",
    "Samudera Indonesia  Tbk.",
    "1999-12-05",
    3275120000,
    "Utama",
  ],
  [
    "SMGR",
    "BASIC-IND",
    "Semen Indonesia (Persero) Tbk.",
    "1991-07-08",
    5931520000,
    "Utama",
  ],
  [
    "SMKL",
    "BASIC-IND",
    "Satyamitra Kemas Lestari Tbk.",
    "2019-07-11",
    3400000005,
    "Utama",
  ],
  [
    "SMMA",
    "FINANCE",
    "Sinarmas Multiartha Tbk.",
    "1995-07-05",
    6367664717,
    "Utama",
  ],
  [
    "SMMT",
    "MINING",
    "Golden Eagle Energy Tbk.",
    "2000-02-29",
    3150000000,
    "Pengembangan",
  ],
  [
    "SMRA",
    "PROPERTY",
    "Summarecon Agung Tbk.",
    "1990-05-07",
    14426781680,
    "Utama",
  ],
  [
    "SMRU",
    "MINING",
    "SMR Utama Tbk.",
    "2011-10-10",
    12499385782,
    "Pengembangan",
  ],
  [
    "SMSM",
    "MISC-IND",
    "Selamat Sempurna Tbk.",
    "1996-09-09",
    5758675440,
    "Utama",
  ],
  [
    "SOCI",
    "INFRASTRUCT",
    "Soechi Lines Tbk.",
    "2014-12-03",
    7059000000,
    "Utama",
  ],
  [
    "SOFA",
    "CONSUMER",
    "Boston Furniture Industries Tb",
    "2020-07-07",
    1650000000,
    "Akselerasi",
  ],
  [
    "SOHO",
    "CONSUMER",
    "Soho Global Health Tbk.",
    "2020-09-08",
    1269168239,
    "Utama",
  ],
  [
    "SONA",
    "TRADE",
    "Sona Topas Tourism Industry Tb",
    "1992-07-21",
    331200000,
    "Utama",
  ],
  [
    "SOSS",
    "TRADE",
    "Shield On Service Tbk.",
    "2018-11-06",
    657018405,
    "Pengembangan",
  ],
  [
    "SOTS",
    "TRADE",
    "Satria Mega Kencana Tbk.",
    "2018-12-10",
    1000000005,
    "Pengembangan",
  ],
  [
    "SPMA",
    "BASIC-IND",
    "Suparma Tbk.",
    "1994-11-16",
    2114570958,
    "Utama",
  ],
  [
    "SPTO",
    "TRADE",
    "Surya Pertiwi Tbk.",
    "2018-05-14",
    2700000000,
    "Pengembangan",
  ],
  [
    "SQMI",
    "TRADE",
    "Wilton Makmur Indonesia Tbk.",
    "2004-07-15",
    15537591429,
    "Pengembangan",
  ],
  [
    "SRAJ",
    "TRADE",
    "Sejahteraraya Anugrahjaya Tbk.",
    "2011-04-11",
    12000705445,
    "Utama",
  ],
  [
    "SRIL",
    "MISC-IND",
    "Sri Rejeki Isman Tbk.",
    "2013-06-17",
    20452176844,
    "Utama",
  ],
  [
    "SRSN",
    "BASIC-IND",
    "Indo Acidatama Tbk",
    "1993-01-11",
    6020000000,
    "Utama",
  ],
  [
    "SRTG",
    "TRADE",
    "Saratoga Investama Sedaya Tbk.",
    "2013-06-26",
    2712967000,
    "Pengembangan",
  ],
  [
    "SSIA",
    "PROPERTY",
    "Surya Semesta Internusa Tbk.",
    "1997-03-27",
    4705249440,
    "Utama",
  ],
  [
    "SSMS",
    "AGRI",
    "Sawit Sumbermas Sarana Tbk.",
    "2013-12-12",
    9525000000,
    "Utama",
  ],
  [
    "SSTM",
    "MISC-IND",
    "Sunson Textile Manufacture Tbk",
    "1997-08-20",
    1170909181,
    "Pengembangan",
  ],
  [
    "STAR",
    "MISC-IND",
    "Buana Artha Anugerah Tbk.",
    "2011-07-13",
    4800000602,
    "Utama",
  ],
  [
    "STTP",
    "CONSUMER",
    "Siantar Top Tbk.",
    "1996-12-16",
    1310000000,
    "Pengembangan",
  ],
  [
    "SUGI",
    "TRADE",
    "Sugih Energy Tbk.",
    "2002-06-19",
    24811541414,
    "Pengembangan",
  ],
  [
    "SULI",
    "BASIC-IND",
    "SLJ Global Tbk.",
    "1994-03-21",
    3986916802,
    "Utama",
  ],
  [
    "SUPR",
    "INFRASTRUCT",
    "Solusi Tunas Pratama Tbk.",
    "2011-10-11",
    1137579698,
    "Pengembangan",
  ],
  [
    "SURE",
    "MINING",
    "Super Energy Tbk.",
    "2018-10-05",
    1497576771,
    "Pengembangan",
  ],
  [
    "SWAT",
    "BASIC-IND",
    "Sriwahana Adityakarta Tbk.",
    "2018-06-08",
    3019200000,
    "Pengembangan",
  ],
  [
    "TALF",
    "BASIC-IND",
    "Tunas Alfin Tbk.",
    "2001-02-12",
    1353435000,
    "Pengembangan",
  ],
  [
    "TAMA",
    "PROPERTY",
    "Lancartama Sejati Tbk.",
    "2020-02-10",
    1000000005,
    "Pengembangan",
  ],
  [
    "TAMU",
    "INFRASTRUCT",
    "Pelayaran Tamarin Samudra Tbk.",
    "2017-05-10",
    37500000000,
    "Pengembangan",
  ],
  [
    "TARA",
    "PROPERTY",
    "Agung Semesta Sejahtera Tbk.",
    "2014-07-11",
    10069645750,
    "Utama",
  ],
  [
    "TAXI",
    "INFRASTRUCT",
    "Express Transindo Utama Tbk.",
    "2012-11-02",
    6145600000,
    "Utama",
  ],
  [
    "TBIG",
    "INFRASTRUCT",
    "Tower Bersama Infrastructure T",
    "2010-10-26",
    22656999445,
    "Utama",
  ],
  [
    "TBLA",
    "CONSUMER",
    "Tunas Baru Lampung Tbk.",
    "2000-02-14",
    5342098939,
    "Utama",
  ],
  [
    "TBMS",
    "BASIC-IND",
    "Tembaga Mulia Semanan Tbk.",
    "1990-05-23",
    367340000,
    "Pengembangan",
  ],
  [
    "TCID",
    "CONSUMER",
    "Mandom Indonesia Tbk.",
    "1993-09-30",
    201066667,
    "Utama",
  ],
  [
    "TCPI",
    "INFRASTRUCT",
    "Transcoal Pacific Tbk.",
    "2018-07-06",
    5000000000,
    "Pengembangan",
  ],
  [
    "TDPM",
    "BASIC-IND",
    "Tridomain Performance Material",
    "2018-04-09",
    10485050500,
    "Utama",
  ],
  [
    "TEBE",
    "INFRASTRUCT",
    "Dana Brata Luhur Tbk.",
    "2019-11-18",
    1285000000,
    "Pengembangan",
  ],
  [
    "TECH",
    "TRADE",
    "Indosterling Technomedia Tbk.",
    "2020-06-04",
    1256300000,
    "Pengembangan",
  ],
  [
    "TELE",
    "TRADE",
    "Tiphone Mobile Indonesia Tbk.",
    "2012-01-12",
    7302194889,
    "Utama",
  ],
  [
    "TFAS",
    "TRADE",
    "Telefast Indonesia Tbk.",
    "2019-09-17",
    1666666500,
    "Pengembangan",
  ],
  [
    "TFCO",
    "MISC-IND",
    "Tifico Fiber Indonesia Tbk.",
    "1980-02-26",
    4823076400,
    "Pengembangan",
  ],
  [
    "TGKA",
    "TRADE",
    "Tigaraksa Satria Tbk.",
    "1990-06-11",
    918492750,
    "Pengembangan",
  ],
  [
    "TGRA",
    "INFRASTRUCT",
    "Terregra Asia Energy Tbk.",
    "2017-05-16",
    2750000000,
    "Utama",
  ],
  [
    "TIFA",
    "FINANCE",
    "KDB Tifa Finance Tbk.",
    "2011-07-08",
    1079700000,
    "Pengembangan",
  ],
  ["TINS", "MINING", "Timah Tbk.", "1995-10-19", 7447753454, "Utama"],
  [
    "TIRA",
    "TRADE",
    "Tira Austenite Tbk",
    "1993-07-27",
    588000000,
    "Pengembangan",
  ],
  [
    "TIRT",
    "BASIC-IND",
    "Tirta Mahakam Resources Tbk",
    "1999-12-13",
    1011774750,
    "Utama",
  ],
  [
    "TKIM",
    "BASIC-IND",
    "Pabrik Kertas Tjiwi Kimia Tbk.",
    "1990-04-03",
    3113223570,
    "Utama",
  ],
  [
    "TLKM",
    "INFRASTRUCT",
    "Telkom Indonesia (Persero) Tbk",
    "1995-11-14",
    99062216600,
    "Utama",
  ],
  [
    "TMAS",
    "INFRASTRUCT",
    "Temas Tbk.",
    "2003-07-09",
    5705150000,
    "Utama",
  ],
  [
    "TMPO",
    "TRADE",
    "Tempo Intimedia Tbk.",
    "2001-01-08",
    1058333250,
    "Pengembangan",
  ],
  [
    "TNCA",
    "INFRASTRUCT",
    "Trimuda Nuansa Citra Tbk.",
    "2018-06-28",
    421640000,
    "Pengembangan",
  ],
  [
    "TOBA",
    "MINING",
    "TBS Energi Utama Tbk.",
    "2012-07-06",
    8049964000,
    "Utama",
  ],
  [
    "TOPS",
    "PROPERTY",
    "Totalindo Eka Persada Tbk.",
    "2017-06-16",
    33330000000,
    "Utama",
  ],
  [
    "TOTL",
    "PROPERTY",
    "Total Bangun Persada Tbk.",
    "2006-07-25",
    3410000000,
    "Utama",
  ],
  [
    "TOTO",
    "BASIC-IND",
    "Surya Toto Indonesia Tbk.",
    "1990-10-30",
    10320000000,
    "Pengembangan",
  ],
  [
    "TOWR",
    "INFRASTRUCT",
    "Sarana Menara Nusantara Tbk.",
    "2010-03-08",
    51014625000,
    "Utama",
  ],
  [
    "TOYS",
    "CONSUMER",
    "Sunindo Adipersada Tbk.",
    "2020-08-06",
    1435000000,
    "Pengembangan",
  ],
  [
    "TPIA",
    "BASIC-IND",
    "Chandra Asri Petrochemical Tbk",
    "1996-06-24",
    17833520260,
    "Pengembangan",
  ],
  [
    "TPMA",
    "INFRASTRUCT",
    "Trans Power Marine Tbk.",
    "2013-02-20",
    2633300000,
    "Pengembangan",
  ],
  [
    "TRAM",
    "MINING",
    "Trada Alam Minera Tbk.",
    "2008-09-10",
    49643627934,
    "Utama",
  ],
  [
    "TRIL",
    "TRADE",
    "Triwira Insanlestari Tbk.",
    "2008-01-28",
    1200000000,
    "Pengembangan",
  ],
  [
    "TRIM",
    "FINANCE",
    "Trimegah Sekuritas Indonesia T",
    "2000-01-31",
    7109300000,
    "Utama",
  ],
  [
    "TRIN",
    "PROPERTY",
    "Perintis Triniti Properti Tbk.",
    "2020-01-15",
    4373363827,
    "Pengembangan",
  ],
  [
    "TRIO",
    "TRADE",
    "Trikomsel Oke Tbk.",
    "2009-04-14",
    26007494645,
    "Utama",
  ],
  [
    "TRIS",
    "MISC-IND",
    "Trisula International Tbk.",
    "2012-06-28",
    3141443806,
    "Pengembangan",
  ],
  [
    "TRJA",
    "INFRASTRUCT",
    "Transkon Jaya Tbk.",
    "2020-08-27",
    1510200000,
    "Pengembangan",
  ],
  [
    "TRST",
    "BASIC-IND",
    "Trias Sentosa Tbk.",
    "1990-07-02",
    2808000000,
    "Utama",
  ],
  [
    "TRUK",
    "INFRASTRUCT",
    "Guna Timur Raya Tbk.",
    "2018-05-23",
    435000000,
    "Pengembangan",
  ],
  [
    "TRUS",
    "FINANCE",
    "Trust Finance Indonesia Tbk",
    "2002-11-28",
    800000000,
    "Pengembangan",
  ],
  [
    "TSPC",
    "CONSUMER",
    "Tempo Scan Pacific Tbk.",
    "1994-06-17",
    4500000000,
    "Utama",
  ],
  [
    "TUGU",
    "FINANCE",
    "Asuransi Tugu Pratama Indonesi",
    "2018-05-28",
    1777777800,
    "Pengembangan",
  ],
  [
    "TURI",
    "TRADE",
    "Tunas Ridean Tbk.",
    "1995-05-16",
    5580000000,
    "Utama",
  ],
  [
    "UANG",
    "TRADE",
    "Pakuan Tbk.",
    "2020-07-06",
    1210000000,
    "Pengembangan",
  ],
  [
    "UCID",
    "MISC-IND",
    "Uni-Charm Indonesia Tbk.",
    "2019-12-20",
    4156572300,
    "Utama",
  ],
  [
    "ULTJ",
    "CONSUMER",
    "Ultra Jaya Milk Industry & Tra",
    "1990-07-02",
    11553528000,
    "Utama",
  ],
  [
    "UNIC",
    "BASIC-IND",
    "Unggul Indah Cahaya Tbk.",
    "1989-11-06",
    383331363,
    "Utama",
  ],
  [
    "UNIT",
    "MISC-IND",
    "Nusantara Inti Corpora Tbk",
    "2002-04-18",
    75422200,
    "Pengembangan",
  ],
  [
    "UNSP",
    "AGRI",
    "Bakrie Sumatera Plantations Tb",
    "1990-03-06",
    2500162344,
    "Utama",
  ],
  [
    "UNTR",
    "TRADE",
    "United Tractors Tbk.",
    "1989-09-19",
    3730135136,
    "Utama",
  ],
  [
    "UNVR",
    "CONSUMER",
    "Unilever Indonesia Tbk.",
    "1982-01-11",
    38150000000,
    "Utama",
  ],
  [
    "URBN",
    "PROPERTY",
    "Urban Jakarta Propertindo Tbk.",
    "2018-12-10",
    3232122588,
    "Pengembangan",
  ],
  [
    "VICI",
    "CONSUMER",
    "Victoria Care Indonesia Tbk.",
    "2020-12-17",
    6708000000,
    "Utama",
  ],
  [
    "VICO",
    "FINANCE",
    "Victoria Investama Tbk.",
    "2013-07-08",
    9150094680,
    "Utama",
  ],
  [
    "VINS",
    "FINANCE",
    "Victoria Insurance Tbk.",
    "2015-09-28",
    1460573616,
    "Pengembangan",
  ],
  [
    "VIVA",
    "TRADE",
    "Visi Media Asia Tbk.",
    "2011-11-21",
    16464270400,
    "Utama",
  ],
  [
    "VOKS",
    "MISC-IND",
    "Voksel Electric Tbk.",
    "1990-12-20",
    4155602595,
    "Utama",
  ],
  [
    "VRNA",
    "FINANCE",
    "Verena Multi Finance Tbk.",
    "2008-06-25",
    5687353997,
    "Pengembangan",
  ],
  [
    "WAPO",
    "TRADE",
    "Wahana Pronatural Tbk.",
    "2001-06-22",
    1240923111,
    "Pengembangan",
  ],
  [
    "WEGE",
    "PROPERTY",
    "Wijaya Karya Bangunan Gedung T",
    "2017-11-30",
    9572000000,
    "Utama",
  ],
  [
    "WEHA",
    "INFRASTRUCT",
    "WEHA Transportasi Indonesia Tb",
    "2007-05-31",
    886411265,
    "Utama",
  ],
  [
    "WICO",
    "TRADE",
    "Wicaksana Overseas Internation",
    "1994-08-08",
    1268950977,
    "Pengembangan",
  ],
  [
    "WIFI",
    "TRADE",
    "Solusi Sinergi Digital Tbk.",
    "2020-12-30",
    1947077000,
    "Pengembangan",
  ],
  [
    "WIIM",
    "CONSUMER",
    "Wismilak Inti Makmur Tbk.",
    "2012-12-18",
    2099873760,
    "Utama",
  ],
  [
    "WIKA",
    "PROPERTY",
    "Wijaya Karya (Persero) Tbk.",
    "2007-10-29",
    8969951372,
    "Utama",
  ],
  [
    "WINS",
    "INFRASTRUCT",
    "Wintermar Offshore Marine Tbk.",
    "2010-11-29",
    4243011640,
    "Utama",
  ],
  [
    "WOMF",
    "FINANCE",
    "Wahana Ottomitra Multiartha Tb",
    "2004-12-13",
    3481481480,
    "Utama",
  ],
  [
    "WOOD",
    "CONSUMER",
    "Integra Indocabinet Tbk.",
    "2017-06-21",
    6306250000,
    "Utama",
  ],
  [
    "WOWS",
    "MINING",
    "Ginting Jaya Energi Tbk.",
    "2019-11-08",
    2475720000,
    "Pengembangan",
  ],
  [
    "WSBP",
    "BASIC-IND",
    "Waskita Beton Precast Tbk.",
    "2016-09-20",
    26361157534,
    "Utama",
  ],
  [
    "WSKT",
    "PROPERTY",
    "Waskita Karya (Persero) Tbk.",
    "2012-12-19",
    13573951000,
    "Utama",
  ],
  [
    "WTON",
    "BASIC-IND",
    "Wijaya Karya Beton Tbk.",
    "2014-04-08",
    8715466600,
    "Utama",
  ],
  [
    "YELO",
    "TRADE",
    "Yelooo Integra Datanet Tbk.",
    "2018-10-29",
    380043597,
    "Pengembangan",
  ],
  [
    "YPAS",
    "BASIC-IND",
    "Yanaprima Hastapersada Tbk",
    "2008-03-05",
    668000089,
    "Pengembangan",
  ],
  [
    "YULE",
    "FINANCE",
    "Yulie Sekuritas Indonesia Tbk.",
    "2004-12-10",
    1785000000,
    "Pengembangan",
  ],
  [
    "ZBRA",
    "TRADE",
    "Zebra Nusantara Tbk",
    "1991-08-01",
    856133009,
    "Pengembangan",
  ],
  [
    "ZINC",
    "MINING",
    "Kapuas Prima Coal Tbk.",
    "2017-10-16",
    25250000000,
    "Pengembangan",
  ],
  [
    "ZONE",
    "MISC-IND",
    "Mega Perintis Tbk.",
    "2018-12-12",
    870171478,
    "Pengembangan",
  ],
];
our $data_stock_mtime = 1610960313; # Mon Jan 18 15:58:33 2021 +0700
# END FRAGMENT id=data-idx_stock

my $field_names_stock = [];
for my $fn (keys %{ $meta_stock->{fields} }) {
    my $f = $meta_stock->{fields}{$fn};
    $field_names_stock->[ $f->{pos} ] = $fn;
}

my $res = gen_read_table_func(
    name => 'list_idx_firms',
    summary => 'List firms listed on the IDX',
    table_data => $data_stock,
    field_names => $field_names_stock,
    filter_fields => ['sector', 'board'],
    case_insensitive_comparison => 1,
);
$res->[0] == 200 or die "Can't generate list_idx_firms function: $res->[0] - $res->[1]";

$SPEC{list_idx_boards} = {
    v => 1.1,
    summary => 'List boards on IDX',
};
sub list_idx_boards {
    state $res = do {
        my %seen;
        for (@$data_stock) { next unless $_->[5]; $seen{lc $_->[5]}++ }
        [200, "OK", [sort keys %seen]];
    };
    $res;
}

$SPEC{list_idx_sectors} = {
    v => 1.1,
    summary => 'List sectors on IDX',
};
sub list_idx_sectors {
    state $res = do {
        my %seen;
        for (@$data_stock) { $seen{$_->[1]}++ }
        [200, "OK", [sort keys %seen]];
    };
    $res;
}

# BEGIN FRAGMENT id=meta-idx_broker varname=meta_broker
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idx_broker/meta.yaml
# src-revision: ebeb2ef4e9128c06461de95333d1d26e75360a7c (Mon Jan 18 15:58:33 2021 +0700)
# generate-date: Mon Jan 18 08:58:52 2021 UTC
# generated-by: update-fragments-in-perl-module
our $meta_broker = {
  _note => "Automatically generated by gen-meta-yaml-from-data-tsv on Mon Jan 18 08:58:07 2021 UTC",
  fields => {
    city => { pos => 4, schema => "str*", sortable => 1, summary => "city", unique => 0 },
    code => { pos => 0, schema => "str*", sortable => 1, summary => "code", unique => 1 },
    license => { pos => 2, schema => "str*", sortable => 1, summary => "license", unique => 0 },
    name => { pos => 1, schema => "str*", sortable => 1, summary => "name", unique => 0 },
    status_name => {
      pos      => 3,
      schema   => "str*",
      sortable => 1,
      summary  => "status_name",
      unique   => 0,
    },
  },
  header => 1,
  pk => "code",
  summary => "(Summary here)",
};
# END FRAGMENT id=meta-idx_broker

# BEGIN FRAGMENT id=data-idx_broker mtime_varname=data_broker_mtime varname=data_broker
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idx_broker/data.tsv
# src-revision: ebeb2ef4e9128c06461de95333d1d26e75360a7c (Mon Jan 18 15:58:33 2021 +0700)
# generate-date: Mon Jan 18 08:58:52 2021 UTC
# generated-by: update-fragments-in-perl-module
our $data_broker = [
  [
    "AD",
    "OSO SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Suspend",
    "Jakarta Selatan",
  ],
  [
    "AF",
    "HARITA KENCANA SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "AG",
    "KIWOOM SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "AH",
    "SHINHAN SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "AI",
    "UOB KAY HIAN SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "AK",
    "UBS SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
  ],
  [
    "AN",
    "WANTEG SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "AO",
    "ERDIKHA ELIT SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "AP",
    "PACIFIC SEKURITAS INDONESIA",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "AR",
    "BINAARTHA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "AT",
    "PHINTRACO SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "AZ",
    "SUCOR SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BB",
    "VERDHANA SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BF",
    "INTI  FIKASA  SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BK",
    "J.P. MORGAN SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BQ",
    "KOREA INVESTMENT AND SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BR",
    "TRUST SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BS",
    "EQUITY SEKURITAS INDONESIA",
    "Manajer Investasi, Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "BZ",
    "BATAVIA PROSPERINDO SEKURITAS",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "CC",
    "MANDIRI SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "CD",
    "MEGA CAPITAL SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "CG",
    "CITIGROUP SEKURITAS INDONESIA",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "CP",
    "VALBURY SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "CS",
    "CREDIT SUISSE SEKURITAS INDONESIA",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "DD",
    "MAKINDO SEKURITAS",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "DH",
    "SINARMAS SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta ",
  ],
  [
    "DM",
    "MASINDO ARTHA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "DP",
    "DBS VICKERS SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "DR",
    "RHB SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "DU",
    "KAF SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
  ],
  [
    "DX",
    "BAHANA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "EL",
    "EVERGREEN SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "EP",
    "MNC SEKURITAS",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "ES",
    "EKOKAPITAL SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "FO",
    "FORTE GLOBAL SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Barat",
  ],
  [
    "FS",
    "YUANTA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "FZ",
    "WATERFRONT SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "GA",
    "BNC SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "GI",
    "MAHASTRA ANDALAN SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "GR",
    "PANIN SEKURITAS TBK.",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "GW",
    "HSBC SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "HD",
    "KGI SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "HP",
    "HENAN PUTIHRAI SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "ID",
    "ANUGERAH SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "IF",
    "SAMUEL SEKURITAS  INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "IH",
    "PACIFIC 2000 SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "II",
    "DANATAMA MAKMUR SEKURITAS",
    "Manajer Investasi, Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "IN",
    "INVESTINDO NUSANTARA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "IP",
    "INDOSURYA BERSINAR SEKURITAS",
    "Manajer Investasi, Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "IT",
    "INTI TELADAN SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Surabaya",
  ],
  [
    "IU",
    "INDO CAPITAL SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "KI",
    "CIPTADANA SEKURITAS ASIA",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "KK",
    "PHILLIP SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "KS",
    "Kresna Sekuritas",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Suspend",
    "Jakarta",
  ],
  [
    "KZ",
    "CLSA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "LG",
    "TRIMEGAH SEKURITAS INDONESIA TBK.",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "LH",
    "ROYAL INVESTIUM SEKURITAS ",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "LS",
    "RELIANCE SEKURITAS INDONESIA TBK.",
    "Penjamin Emisi Efek",
    "Aktif",
  ],
  [
    "MG",
    "SEMESTA INDOVEST SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Barat",
  ],
  [
    "MI",
    "VICTORIA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "MK",
    "EKUATOR SWARNA SEKURITAS",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "MS",
    "MORGAN STANLEY SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "MU",
    "MINNA PADI INVESTAMA SEKURITAS TBK",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "NI",
    "BNI SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "OD",
    "BRI DANAREKSA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "OK",
    "NET SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PC",
    "FAC SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "PD",
    "INDO PREMIER SEKURITAS",
    "Manajer Investasi, Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PF",
    "DANASAKTI SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PG",
    "PANCA GLOBAL SEKURITAS",
    "Penjamin Emisi Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PO",
    "PILARMAS INVESTINDO SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PP",
    "ALDIRACITA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "PS",
    "PARAMITRA ALFA SEKURITAS",
    "Manajer Investasi, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "RB",
    "NIKKO SEKURITAS INDONESIA",
    "Manajer Investasi, Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "RF",
    "BUANA CAPITAL SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "RG",
    "PROFINDO SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "RO",
    "NILAI INTI SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "RS",
    "YULIE SEKURITAS INDONESIA TBK.",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "RX",
    "MACQUARIE SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "SA",
    "BOSOWA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "SC",
    "IMG SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "SF",
    "SURYA FAJAR SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "SH",
    "ARTHA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Utara",
  ],
  [
    "SQ",
    "BCA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "SS",
    "SUPRA SEKURITAS INDONESIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "TF",
    "UNIVERSAL BROKER INDONESIA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "TP",
    "OCBC SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "TS",
    "DWIDANA SAKTI SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Barat",
  ],
  [
    "TX",
    "DHANAWIBAWA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
  ],
  [
    "XA",
    "NH KORINDO SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "XC",
    "AJAIB SEKURITAS ASIA",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Barat",
  ],
  [
    "XL",
    "MAHAKARYA ARTHA SEKURITAS",
    "Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "YB",
    "JASA UTAMA CAPITAL SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "YJ",
    "LOTUS ANDALAN SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "YO",
    "AMANTARA SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
  [
    "YP",
    "MIRAE ASSET SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "YU",
    "CGS-CIMB SEKURITAS INDONESIA",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Selatan",
  ],
  [
    "ZP",
    "MAYBANK KIM ENG SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta Pusat",
  ],
  [
    "ZR",
    "BUMIPUTERA SEKURITAS",
    "Penjamin Emisi Efek, Perantara Pedagang Efek",
    "Aktif",
    "Jakarta",
  ],
];
our $data_broker_mtime = 1610960313; # Mon Jan 18 15:58:33 2021 +0700
# END FRAGMENT id=data-idx_broker

my $field_names_broker = [];
for my $fn (keys %{ $meta_broker->{fields} }) {
    my $f = $meta_broker->{fields}{$fn};
    $field_names_broker->[ $f->{pos} ] = $fn;
}

$res = gen_read_table_func(
    name => 'list_idx_brokers',
    summary => 'List brokers listed on the IDX',
    table_data => $data_broker,
    field_names => $field_names_broker,
    case_insensitive_comparison => 1,
);
$res->[0] == 200 or die "Can't generate list_idx_brokers function: $res->[0] - $res->[1]";

1;
# ABSTRACT: Get information from Indonesian Stock Exchange (static version)

__END__

=pod

=encoding UTF-8

=head1 NAME

Finance::SE::IDX::Static - Get information from Indonesian Stock Exchange (static version)

=head1 VERSION

This document describes version 20210118.0.0 of Finance::SE::IDX::Static (from Perl distribution Finance-SE-IDX-Static), released on 2021-01-18.

=head1 SYNOPSIS

Use like you would use L<Finance::SE::IDX>.

=head1 DESCRIPTION

This module is the static (offline) version of L<Finance::SE::IDX>. It provides
the same functions and arguments, but the data is cached in the source code. It
is useful as a fallback when the source that Finance::SE::IDX uses is
unavailable. As a consequence, the data will be somewhat out of date.

=head1 FUNCTIONS


=head2 list_idx_boards

Usage:

 list_idx_boards() -> [status, msg, payload, meta]

List boards on IDX.

This function is not exported by default, but exportable.

No arguments.

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (payload) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)



=head2 list_idx_brokers

Usage:

 list_idx_brokers() -> [status, msg, payload, meta]

List brokers listed on the IDX.

REPLACE ME

This function is not exported by default, but exportable.

No arguments.

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (payload) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)



=head2 list_idx_firms

Usage:

 list_idx_firms(%args) -> [status, msg, payload, meta]

List firms listed on the IDX.

REPLACE ME

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<board> => I<str>

Filter by value of board.

=item * B<sector> => I<str>

Filter by value of sector.


=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (payload) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)



=head2 list_idx_sectors

Usage:

 list_idx_sectors() -> [status, msg, payload, meta]

List sectors on IDX.

This function is not exported by default, but exportable.

No arguments.

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (payload) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Finance-SE-IDX-Static>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Finance-SE-IDX-Static>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Finance-SE-IDX-Static/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Finance::SE::IDX>

L<Finance::SE::IDX::Any>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
