/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.BoardCollection;
import net.sourceforge.plantuml.graph.KenavoCostComputer;
import net.sourceforge.plantuml.graph.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardExplorer {
    private final BoardCollection all = new BoardCollection(new KenavoCostComputer());

    public BoardExplorer(Board board) {
        this.all.add(board);
    }

    public double getBestCost() {
        return this.all.getBestCost();
    }

    public Board getBestBoard() {
        return this.all.getBestBoard();
    }

    public int collectionSize() {
        return this.all.size();
    }

    public boolean onePass() {
        Board board = this.all.getAndSetExploredSmallest();
        if (board == null) {
            return true;
        }
        Set<Board> set = this.nextBoards(board);
        for (Board board2 : set) {
            if (this.all.contains(board2)) continue;
            this.all.add(board2);
        }
        return false;
    }

    public Set<Board> nextBoards(Board board) {
        HashSet<Board> hashSet = new HashSet<Board>();
        for (Move move : board.getAllPossibleMoves()) {
            Board board2 = board.copy();
            board2.applyMove(move);
            hashSet.add(board2);
        }
        return hashSet;
    }
}

