/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class CircleAndArrow
implements UDrawable {
    private final AffineTransform at;
    private final AffineTransform at2;
    private int radius;
    private final Point2D center;
    private final Point2D p1;
    private final Point2D p2;
    private Point2D p3;
    private Point2D p4;

    public CircleAndArrow(Point2D point2D, Point2D point2D2) {
        this.center = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        this.at = AffineTransform.getTranslateInstance(-this.center.getX(), -this.center.getY());
        this.at2 = AffineTransform.getTranslateInstance(this.center.getX(), this.center.getY());
        this.radius = (int)(point2D.distance(point2D2) / 2.0);
        if (this.radius % 2 == 0) {
            --this.radius;
        }
        this.p1 = this.putOnCircle(point2D);
        this.p2 = this.putOnCircle(point2D2);
        this.p3 = this.at.transform(this.p1, null);
        this.p3 = new Point2D.Double(this.p3.getY(), -this.p3.getX());
        this.p3 = this.at2.transform(this.p3, null);
        this.p4 = this.at.transform(this.p2, null);
        this.p4 = new Point2D.Double(this.p4.getY(), -this.p4.getX());
        this.p4 = this.at2.transform(this.p4, null);
    }

    private Point2D putOnCircle(Point2D point2D) {
        point2D = this.at.transform(point2D, null);
        double d = point2D.distance(new Point2D.Double()) / (double)this.radius;
        point2D = new Point2D.Double(point2D.getX() / d, point2D.getY() / d);
        return this.at2.transform(point2D, null);
    }

    public void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(this.radius * 2, this.radius * 2);
        uGraphic.apply(new UTranslate(this.center.getX() - (double)this.radius, this.center.getY() - (double)this.radius)).draw(uEllipse);
    }

    private static void drawLine(UGraphic uGraphic, double d, double d2, Point2D point2D, Point2D point2D2) {
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        uGraphic.apply(new UTranslate(d + point2D.getX(), d2 + point2D.getY())).draw(new ULine(d3, d4));
    }
}

