# This file is generated by Lemonldap::NG::Manager::Build. Don't modify it by hand
package Lemonldap::NG::Manager::Attributes;

our $VERSION = '2.22.0';

sub perlExpr {
    my ( $val, $conf ) = @_;
    my $cpt = 'Safe'->new;
    $cpt->share_from( 'MIME::Base64', ['&encode_base64'] );
    $cpt->share_from(
        'Lemonldap::NG::Handler::Main::Jail',
        [
            '&encrypt', '&token',
            @Lemonldap::NG::Handler::Main::Jail::builtCustomFunctions
        ]
    );
    $cpt->share_from( 'Lemonldap::NG::Common::Safelib',
        $Lemonldap::NG::Common::Safelib::functions );
    $cpt->reval("local *_;$val");
    my $err = join(
        '',
        grep( { $_ =~ /(?:Undefined subroutine|Devel::StackTrace)/ ? () : $_; }
            split( /\n/, $@, 0 ) )
    );
    return -1, "__badExpression__: $err" if $err and $conf->{'useSafeJail'};
    return $val =~ qr/(?<=[^=<!>\|\?])=(?![>=~])/
      && $conf->{'avoidAssignment'} ? ( 1, '__badExpressionAssignment__' ) : 1;
}

sub types {
    return {
        'array' => {
            'test' => sub {
                1;
            }
        },
        'authParamsText' => {
            'test' => sub {
                1;
            }
        },
        'blackWhiteList' => {
            'test' => sub {
                1;
            }
        },
        'bool' => {
            'msgFail' => '__notABoolean__',
            'test'    => qr/^[01]$/
        },
        'boolOrExpr' => {
            'msgFail' => '__notAValidPerlExpression__',
            'test'    => sub {
                return perlExpr(@_);
            }
        },
        'catAndAppList' => {
            'test' => sub {
                1;
            }
        },
        'EcOrRSAPrivateKey' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:(?:RSA|EC|ENCRYPTED)\s+)?PRIVATE\s+KEY\s*\-+\r?\n)?(?:Proc-Type:.*\r?\nDEK-Info:.*\r?\n[\r\n]*)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:(?:RSA|EC|ENCRYPTED)\s+)?PRIVATE\s+KEY\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
            }
        },
        'EcOrRSAPublicKeyOrCertificate' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
            }
        },
        'file' => {
            'test' => sub {
                1;
            }
        },
        'hostname' => {
            'form'    => 'text',
            'msgFail' => '__badHostname__',
            'test'    =>
qr/^(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))?$/
        },
        'int' => {
            'msgFail' => '__notAnInteger__',
            'test'    => qr/^\-?\d+$/
        },
        'intOrNull' => {
            'msgFail' => '__notAnInteger__',
            'test'    => qr/^\-?\d*$/
        },
        'keyText' => {
            'keyTest' => qr/^[a-zA-Z0-9_]+$/,
            'msgFail' => '__badValue__',
            'test'    => qr/^.*$/
        },
        'keyTextContainer' => {
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^\w[\w\.\-]*$/,
            'msgFail'    => '__emptyValueNotAllowed__',
            'test'       => qr/./
        },
        'lmAttrOrMacro' => {
            'form' => 'text',
            'test' => sub {
                my ( $val, $conf ) = @_;
                return 1 if defined $conf->{'macros'}{$val} or $val =~ /^_/;
                foreach $_ ( keys %$conf ) {
                    return 1
                      if $_ =~ /exportedvars$/i and defined $conf->{$_}{$val};
                }
                return 1, "__unknownAttrOrMacro__: $val";
            }
        },
        'longtext' => {
            'test' => sub {
                1;
            }
        },
        'menuApp' => {
            'test' => sub {
                1;
            }
        },
        'menuCat' => {
            'test' => sub {
                1;
            }
        },
        'oidcAttribute' => {
            'test' => sub {
                1;
            }
        },
        'oidcmetadatajson' => {
            'test' => sub {
                1;
            }
        },
        'oidcmetadatajwks' => {
            'test' => sub {
                1;
            }
        },
        'oidcOPMetaDataNode' => {
            'test' => sub {
                1;
            }
        },
        'oidcRPMetaDataNode' => {
            'test' => sub {
                1;
            }
        },
        'password' => {
            'msgFail' => '__malformedValue__',
            'test'    => sub {
                1;
            }
        },
        'pcre' => {
            'form' => 'text',
            'test' => sub {
                eval {
                    do {
                        qr/$_[0]/;
                    }
                };
                return $@ ? ( 0, "__badRegexp__: $@" ) : 1;
            }
        },
        'PerlModule' => {
            'form'    => 'text',
            'msgFail' => '__badPerlPackageName__',
            'test' => qr/^(?:[a-zA-Z][a-zA-Z0-9]*)*(?:::[a-zA-Z][a-zA-Z0-9]*)*$/
        },
        'portalskin' => {
            'test' => sub {
                1;
            }
        },
        'portalskinbackground' => {
            'test' => sub {
                1;
            }
        },
        'post' => {
            'test' => sub {
                1;
            }
        },
        'RSAPrivateKey' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:(?:RSA|ENCRYPTED)\s+)?PRIVATE\s+KEY\s*\-+\r?\n)?(?:Proc-Type:.*\r?\nDEK-Info:.*\r?\n[\r\n]*)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:(?:RSA|ENCRYPTED)\s+)?PRIVATE\s+KEY\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
            }
        },
        'RSAPublicKey' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+PUBLIC\s+KEY\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+PUBLIC\s+KEY\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
            }
        },
        'RSAPublicKeyOrCertificate' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
            }
        },
        'rule' => {
            'test' => sub {
                1;
            }
        },
        'samlAssertion' => {
            'test' => sub {
                1;
            }
        },
        'samlAttribute' => {
            'test' => sub {
                1;
            }
        },
        'samlIDPMetaDataNode' => {
            'test' => sub {
                1;
            }
        },
        'samlService' => {
            'test' => sub {
                1;
            }
        },
        'samlSPMetaDataNode' => {
            'test' => sub {
                1;
            }
        },
        'select' => {
            'test' => sub {
                return 0, 'Value is not a scalar' if ref $_[0];
                my $test = grep( { $_ eq $_[0]; }
                    map( { $_->{'k'}; } @{ $_[2]{'select'}; } ) );
                return $test
                  ? 1
                  : ( 1, "Invalid value '$_[0]' for this select" );
            }
        },
        'subContainer' => {
            'keyTest' => qr/\w/,
            'test'    => sub {
                1;
            }
        },
        'text' => {
            'msgFail' => '__malformedValue__',
            'test'    => sub {
                1;
            }
        },
        'trool' => {
            'msgFail' => '__authorizedValues__: -1, 0, 1',
            'test'    => qr/^(?:-1|0|1)$/
        },
        'url' => {
            'form'    => 'text',
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:^$|(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?))/
        }
    };
}

sub attributes {
    return {
        'activeTimer' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'adaptativeAuthenticationLevelRules' => {
            'keyTest' => sub {
                return perlExpr(@_);
            },
            'test' => sub {
                1;
            },
            'type' => 'keyTextContainer'
        },
        'adminLogoutServerSecret' => {
            'type' => 'text'
        },
        'ADPwdExpireWarning' => {
            'default' => 0,
            'type'    => 'int'
        },
        'ADPwdMaxAge' => {
            'default' => 0,
            'type'    => 'int'
        },
        'apacheAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'appAccessHistoryEnabled' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'applicationList' => {
            'default' => {
                'default' => {
                    'catname' => 'Default category',
                    'type'    => 'category'
                }
            },
            'keyTest' => qr/\w/,
            'type'    => 'catAndAppList'
        },
        'authChoiceAuthBasic' => {
            'type' => 'text'
        },
        'authChoiceFindUser' => {
            'type' => 'text'
        },
        'authChoiceModules' => {
            'keyMsgFail' => '__badChoiceKey__',
            'keyTest'    => qr/^(\d*)?[a-zA-Z0-9_]+$/,
            'select'     => [ [ {
                        'k' => 'Apache',
                        'v' => 'Apache'
                    },
                    {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'CAS',
                        'v' => 'Central Authentication Service (CAS)'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'Facebook',
                        'v' => 'Facebook'
                    },
                    {
                        'k' => 'GitHub',
                        'v' => 'GitHub'
                    },
                    {
                        'k' => 'GPG',
                        'v' => 'GPG'
                    },
                    {
                        'k' => 'Kerberos',
                        'v' => 'Kerberos'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'LinkedIn',
                        'v' => 'LinkedIn'
                    },
                    {
                        'k' => 'PAM',
                        'v' => 'PAM'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    },
                    {
                        'k' => 'OpenID',
                        'v' => 'OpenID 2.0 (deprecated)'
                    },
                    {
                        'k' => 'OpenIDConnect',
                        'v' => 'OpenID Connect'
                    },
                    {
                        'k' => 'Proxy',
                        'v' => 'Proxy'
                    },
                    {
                        'k' => 'Radius',
                        'v' => 'Radius'
                    },
                    {
                        'k' => 'REST',
                        'v' => 'REST'
                    },
                    {
                        'k' => 'Remote',
                        'v' => 'Remote'
                    },
                    {
                        'k' => 'SAML',
                        'v' => 'SAML v2'
                    },
                    {
                        'k' => 'Slave',
                        'v' => 'Slave'
                    },
                    {
                        'k' => 'SSL',
                        'v' => 'mTLS'
                    },
                    {
                        'k' => 'Twitter',
                        'v' => 'Twitter'
                    },
                    {
                        'k' => 'WebID',
                        'v' => 'WebID (deprecated)'
                    },
                    {
                        'k' => 'WebAuthn',
                        'v' => 'WebAuthn'
                    },
                    {
                        'k' => 'Custom',
                        'v' => 'customModule'
                    }
                ],
                [ {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'CAS',
                        'v' => 'Central Authentication Service (CAS)'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'Facebook',
                        'v' => 'Facebook'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    },
                    {
                        'k' => 'OpenID',
                        'v' => 'OpenID 2.0 (deprecated)'
                    },
                    {
                        'k' => 'OpenIDConnect',
                        'v' => 'OpenID Connect'
                    },
                    {
                        'k' => 'Proxy',
                        'v' => 'Proxy'
                    },
                    {
                        'k' => 'REST',
                        'v' => 'REST'
                    },
                    {
                        'k' => 'Remote',
                        'v' => 'Remote'
                    },
                    {
                        'k' => 'SAML',
                        'v' => 'SAML v2'
                    },
                    {
                        'k' => 'Slave',
                        'v' => 'Slave'
                    },
                    {
                        'k' => 'WebID',
                        'v' => 'WebID (deprecated)'
                    },
                    {
                        'k' => 'Custom',
                        'v' => 'customModule'
                    }
                ],
                [ {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'REST',
                        'v' => 'REST'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    },
                    {
                        'k' => 'Custom',
                        'v' => 'customModule'
                    }
                ]
            ],
            'test' => sub {
                1;
            },
            'type' => 'authChoiceContainer'
        },
        'authChoiceParam' => {
            'default' => 'lmAuth',
            'type'    => 'text'
        },
        'authChoiceSelectOnly' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'authentication' => {
            'default' => 'Demo',
            'select'  => [ {
                    'k' => 'Apache',
                    'v' => 'Apache'
                },
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Facebook',
                    'v' => 'Facebook'
                },
                {
                    'k' => 'GitHub',
                    'v' => 'GitHub'
                },
                {
                    'k' => 'GPG',
                    'v' => 'GPG'
                },
                {
                    'k' => 'Kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'LinkedIn',
                    'v' => 'LinkedIn'
                },
                {
                    'k' => 'PAM',
                    'v' => 'PAM'
                },
                {
                    'k' => 'Radius',
                    'v' => 'Radius'
                },
                {
                    'k' => 'REST',
                    'v' => 'REST'
                },
                {
                    'k' => 'SSL',
                    'v' => 'mTLS'
                },
                {
                    'k' => 'Twitter',
                    'v' => 'Twitter'
                },
                {
                    'k' => 'WebID',
                    'v' => 'WebID (deprecated)'
                },
                {
                    'k' => 'WebAuthn',
                    'v' => 'WebAuthn'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'Choice',
                    'v' => 'authChoice'
                },
                {
                    'k' => 'Combination',
                    'v' => 'combineMods'
                },
                {
                    'k' => 'CAS',
                    'v' => 'Central Authentication Service (CAS)'
                },
                {
                    'k' => 'OpenID',
                    'v' => 'OpenID 2.0 (deprecated)'
                },
                {
                    'k' => 'OpenIDConnect',
                    'v' => 'OpenID Connect'
                },
                {
                    'k' => 'SAML',
                    'v' => 'SAML v2'
                },
                {
                    'k' => 'Proxy',
                    'v' => 'Proxy'
                },
                {
                    'k' => 'Remote',
                    'v' => 'Remote'
                },
                {
                    'k' => 'Slave',
                    'v' => 'Slave'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'Custom',
                    'v' => 'customModule'
                }
            ],
            'type' => 'select'
        },
        'AuthLDAPFilter' => {
            'type' => 'text'
        },
        'autoSigninRules' => {
            'keyTest' => sub {
                return perlExpr(@_);
            },
            'test' => sub {
                1;
            },
            'type' => 'keyTextContainer'
        },
        'available2F' => {
            'default' =>
              'TOTP,REST,Mail2F,Ext2F,WebAuthn,Yubikey,Radius,Password,Okta',
            'type' => 'text'
        },
        'available2FSelfRegistration' => {
            'default' => 'Password,TOTP,WebAuthn,Yubikey',
            'type'    => 'text'
        },
        'avoidAssignment' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'browsersDontStorePassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'bruteForceProtection' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'bruteForceProtectionIncrementalTempo' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'bruteForceProtectionLockTimes' => {
            'default' => '15, 30, 60, 300, 600',
            'type'    => 'text'
        },
        'bruteForceProtectionMaxAge' => {
            'default' => 300,
            'type'    => 'int'
        },
        'bruteForceProtectionMaxFailed' => {
            'default' => 3,
            'type'    => 'int'
        },
        'bruteForceProtectionMaxLockTime' => {
            'default' => 900,
            'type'    => 'int'
        },
        'bruteForceProtectionTempo' => {
            'default' => 30,
            'type'    => 'int'
        },
        'cacheTagSalt' => {
            'type' => 'text'
        },
        'captcha' => {
            'type' => 'PerlModule'
        },
        'captcha_login_enabled' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'captcha_mail_enabled' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'captcha_register_enabled' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'captcha_size' => {
            'default' => 6,
            'type'    => 'int'
        },
        'captchaOptions' => {
            'type' => 'keyTextContainer'
        },
        'casAccessControlPolicy' => {
            'default' => 'none',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'error',
                    'v' => 'Display error on portal'
                },
                {
                    'k' => 'faketicket',
                    'v' => 'Send a fake service ticket'
                }
            ],
            'type' => 'select'
        },
        'casAppMetaDataExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'type' => 'keyTextContainer'
        },
        'casAppMetaDataMacros' => {
            'default' => {},
            'test'    => {
                'keyMsgFail' => '__badMacroName__',
                'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'casAppMetaDataNodes' => {
            'type' => 'casAppMetaDataNodeContainer'
        },
        'casAppMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'casAppMetaDataOptionsAllowProxy' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'casAppMetaDataOptionsAuthnLevel' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'casAppMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'casAppMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'casAppMetaDataOptionsLogout' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'casAppMetaDataOptionsRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'casAppMetaDataOptionsService' => {
            'type' => 'text'
        },
        'casAppMetaDataOptionsUserAttribute' => {
            'type' => 'text'
        },
        'casAttr' => {
            'type' => 'text'
        },
        'casAttributes' => {
            'type' => 'keyTextContainer'
        },
        'casAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'casBackChannelSingleLogout' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'casSrvMetaDataExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'type' => 'keyTextContainer'
        },
        'casSrvMetaDataNodes' => {
            'type' => 'casSrvMetaDataNodeContainer'
        },
        'casSrvMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'casSrvMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'casSrvMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'casSrvMetaDataOptionsGateway' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'casSrvMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'casSrvMetaDataOptionsProxiedServices' => {
            'keyMsgFail' => '__badCasProxyId__',
            'keyTest'    => qr/^\w/,
            'type'       => 'keyTextContainer'
        },
        'casSrvMetaDataOptionsRenew' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'casSrvMetaDataOptionsResolutionRule' => {
            'default' => '',
            'type'    => 'longtext'
        },
        'casSrvMetaDataOptionsSamlValidate' => {
            'type' => 'bool'
        },
        'casSrvMetaDataOptionsSortNumber' => {
            'type' => 'int'
        },
        'casSrvMetaDataOptionsTooltip' => {
            'type' => 'text'
        },
        'casSrvMetaDataOptionsUrl' => {
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'casStorage' => {
            'type' => 'PerlModule'
        },
        'casStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'casStrictMatching' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'casTicketExpiration' => {
            'default' => 0,
            'type'    => 'int'
        },
        'cda' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'certificateResetByMailCeaAttribute' => {
            'default' => 'description',
            'type'    => 'text'
        },
        'certificateResetByMailCertificateAttribute' => {
            'default' => 'userCertificate;binary',
            'type'    => 'text'
        },
        'certificateResetByMailStep1Body' => {
            'type' => 'longtext'
        },
        'certificateResetByMailStep1Subject' => {
            'type' => 'text'
        },
        'certificateResetByMailStep2Body' => {
            'type' => 'longtext'
        },
        'certificateResetByMailStep2Subject' => {
            'type' => 'text'
        },
        'certificateResetByMailURL' => {
            'type' => 'url'
        },
        'certificateResetByMailValidityDelay' => {
            'default' => 0,
            'type'    => 'int'
        },
        'cfgAuthor' => {
            'type' => 'text'
        },
        'cfgAuthorIP' => {
            'type' => 'text'
        },
        'cfgDate' => {
            'type' => 'int'
        },
        'cfgLog' => {
            'type' => 'longtext'
        },
        'cfgNum' => {
            'default' => 0,
            'type'    => 'int'
        },
        'cfgVersion' => {
            'type' => 'text'
        },
        'checkDevOps' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkDevOpsCheckSessionAttributes' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'checkDevOpsDisplayNormalizedHeaders' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'checkDevOpsDownload' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'checkEntropy' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkEntropyRequired' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkEntropyRequiredLevel' => {
            'type' => 'int'
        },
        'checkHIBP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkHIBPRequired' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'checkHIBPURL' => {
            'default' => 'https://api.pwnedpasswords.com/range/',
            'type'    => 'url'
        },
        'checkMsg' => {
            'default' => 5,
            'type'    => 'int'
        },
        'checkState' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkStateSecret' => {
            'type' => 'text'
        },
        'checkTime' => {
            'default' => 600,
            'type'    => 'int'
        },
        'checkUser' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'checkUserDisplayComputedSession' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayEmptyHeaders' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayEmptyValues' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayHiddenAttributes' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayHistory' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayNormalizedHeaders' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserDisplayPersistentInfo' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'checkUserHiddenAttributes' => {
            'default' => '_loginHistory, _session_id, hGroups',
            'type'    => 'text'
        },
        'checkUserHiddenHeaders' => {
            'keyMsgFail' => '__badHostname__',
            'keyTest'    => qr/^\S+$/,
            'test'       => {
                'keyMsgFail' => '__badHeaderName__',
                'keyTest'    => qr/^(?=[^\-])[\w\-\s]+(?<=[^-])$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'checkUserIdRule' => {
            'default' => 1,
            'test'    => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'checkUserSearchAttributes' => {
            'type' => 'text'
        },
        'checkUserUnrestrictedUsersRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'checkXSS' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'combination' => {
            'type' => 'text'
        },
        'combModules' => {
            'keyTest' => qr/^\w+$/,
            'select'  => [ {
                    'k' => 'Apache',
                    'v' => 'Apache'
                },
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Facebook',
                    'v' => 'Facebook'
                },
                {
                    'k' => 'GitHub',
                    'v' => 'GitHub'
                },
                {
                    'k' => 'GPG',
                    'v' => 'GPG'
                },
                {
                    'k' => 'Kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'LinkedIn',
                    'v' => 'LinkedIn'
                },
                {
                    'k' => 'PAM',
                    'v' => 'PAM'
                },
                {
                    'k' => 'Radius',
                    'v' => 'Radius'
                },
                {
                    'k' => 'REST',
                    'v' => 'REST'
                },
                {
                    'k' => 'SSL',
                    'v' => 'mTLS'
                },
                {
                    'k' => 'Twitter',
                    'v' => 'Twitter'
                },
                {
                    'k' => 'WebID',
                    'v' => 'WebID (deprecated)'
                },
                {
                    'k' => 'WebAuthn',
                    'v' => 'WebAuthn'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'CAS',
                    'v' => 'Central Authentication Service (CAS)'
                },
                {
                    'k' => 'OpenID',
                    'v' => 'OpenID 2.0 (deprecated)'
                },
                {
                    'k' => 'OpenIDConnect',
                    'v' => 'OpenID Connect'
                },
                {
                    'k' => 'SAML',
                    'v' => 'SAML v2'
                },
                {
                    'k' => 'Proxy',
                    'v' => 'Proxy'
                },
                {
                    'k' => 'Remote',
                    'v' => 'Remote'
                },
                {
                    'k' => 'Slave',
                    'v' => 'Slave'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'Custom',
                    'v' => 'customModule'
                }
            ],
            'test' => sub {
                1;
            },
            'type' => 'cmbModuleContainer'
        },
        'compactConf' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'configStorage' => {
            'type' => 'text'
        },
        'confirmFormMethod' => {
            'default' => 'post',
            'select'  => [ {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'contextSwitchingAllowed2fModifications' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'contextSwitchingIdRule' => {
            'default' => 1,
            'test'    => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'contextSwitchingPrefix' => {
            'default' => 'switching',
            'type'    => 'text'
        },
        'contextSwitchingRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'contextSwitchingStopWithLogout' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'contextSwitchingUnrestrictedUsersRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'cookieExpiration' => {
            'type' => 'intOrNull'
        },
        'cookieName' => {
            'default' => 'lemonldap',
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'corsAllow_Credentials' => {
            'default' => 'true',
            'type'    => 'text'
        },
        'corsAllow_Headers' => {
            'default' => '*',
            'type'    => 'text'
        },
        'corsAllow_Methods' => {
            'default' => 'POST,GET',
            'type'    => 'text'
        },
        'corsAllow_Origin' => {
            'default' => '*',
            'type'    => 'text'
        },
        'corsEnabled' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'corsExpose_Headers' => {
            'default' => '*',
            'type'    => 'text'
        },
        'corsMax_Age' => {
            'default' => '86400',
            'type'    => 'text'
        },
        'crowdsec' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'crowdsecAction' => {
            'default' => 'reject',
            'select'  => [ {
                    'k' => 'reject',
                    'v' => 'Reject'
                },
                {
                    'k' => 'warn',
                    'v' => 'Warn'
                }
            ],
            'type' => 'select'
        },
        'crowdsecAgent' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'crowdSecAgentResponseCode' => {
            'default' => 404,
            'type'    => 'int'
        },
        'crowdSecAgentResponseValue' => {
            'type' => 'text'
        },
        'crowdsecBlockDelay' => {
            'type' => 'int'
        },
        'crowdsecFilters' => {
            'type' => 'text'
        },
        'crowdsecIgnoreFailures' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'crowdsecKey' => {
            'type' => 'text'
        },
        'crowdsecMachineId' => {
            'type' => 'text'
        },
        'crowdsecMaxFailures' => {
            'type' => 'int'
        },
        'crowdsecPassword' => {
            'type' => 'text'
        },
        'crowdsecUrl' => {
            'type' => 'url'
        },
        'cspConnect' => {
            'default' => '\'self\'',
            'type'    => 'text'
        },
        'cspDefault' => {
            'default' => '\'self\'',
            'type'    => 'text'
        },
        'cspFont' => {
            'default' => '\'self\'',
            'type'    => 'text'
        },
        'cspFormAction' => {
            'default' => '*',
            'type'    => 'text'
        },
        'cspFrameAncestors' => {
            'default' => '',
            'type'    => 'text'
        },
        'cspImg' => {
            'default' => '\'self\' data:',
            'type'    => 'text'
        },
        'cspScript' => {
            'default' => '\'self\'',
            'type'    => 'text'
        },
        'cspStyle' => {
            'default' => '\'self\'',
            'type'    => 'text'
        },
        'customAddParams' => {
            'type' => 'keyTextContainer'
        },
        'customAuth' => {
            'type' => 'text'
        },
        'customFunctions' => {
            'msgFail' => '__badCustomFuncName__',
            'test'    => qr/^(?:\w+(?:::\w+)*(?:\s+\w+(?:::\w+)*)*)?$/,
            'type'    => 'text'
        },
        'customPassword' => {
            'type' => 'text'
        },
        'customPlugins' => {
            'type' => 'text'
        },
        'customPluginsParams' => {
            'type' => 'keyTextContainer'
        },
        'customRegister' => {
            'type' => 'text'
        },
        'customResetCertByMail' => {
            'type' => 'text'
        },
        'customToTrace' => {
            'type' => 'lmAttrOrMacro'
        },
        'customUserDB' => {
            'type' => 'text'
        },
        'dbiAuthChain' => {
            'type' => 'text'
        },
        'dbiAuthLoginCol' => {
            'type' => 'text'
        },
        'dbiAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'dbiAuthPassword' => {
            'type' => 'password'
        },
        'dbiAuthPasswordCol' => {
            'type' => 'text'
        },
        'dbiAuthPasswordHash' => {
            'type' => 'text'
        },
        'dbiAuthTable' => {
            'type' => 'text'
        },
        'dbiAuthUser' => {
            'type' => 'text'
        },
        'dbiDynamicHashEnabled' => {
            'type' => 'bool'
        },
        'dbiDynamicHashNewPasswordScheme' => {
            'type' => 'text'
        },
        'dbiDynamicHashValidSaltedSchemes' => {
            'type' => 'text'
        },
        'dbiDynamicHashValidSchemes' => {
            'type' => 'text'
        },
        'dbiExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'dbiPasswordMailCol' => {
            'type' => 'text'
        },
        'dbiUserTable' => {
            'type' => 'text'
        },
        'decryptValueFunctions' => {
            'msgFail' => '__badCustomFuncName__',
            'test'    => qr/^(?:\w+(?:::\w+)*(?:\s+\w+(?:::\w+)*)*)?$/,
            'type'    => 'text'
        },
        'decryptValueRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'defaultNewKeySize' => {
            'default' => 2048,
            'type'    => 'int'
        },
        'demoExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'disabledPlugins' => {
            'type' => 'text'
        },
        'disablePersistentStorage' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'displaySessionId' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'domain' => {
            'default' => 'example.com',
            'msgFail' => '__badDomainName__',
            'test'    =>
qr/^(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|#\w+#))?$/,
            'type' => 'text'
        },
        'eventQueueName' => {
            'default' => 'llng_events',
            'type'    => 'text'
        },
        'eventStatus' => {
            'type' => 'bool'
        },
        'exportedAttr' => {
            'type' => 'text'
        },
        'exportedHeaders' => {
            'keyMsgFail' => '__badHostname__',
            'keyTest'    => qr/^\S+$/,
            'test'       => {
                'keyMsgFail' => '__badHeaderName__',
                'keyTest'    => qr/^(?=[^\-])[\w\-]+(?<=[^-])$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'exportedVars' => {
            'default' => {
                'UA' => 'HTTP_USER_AGENT'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[_a-zA-Z][a-zA-Z0-9_]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[_a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'ext2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'ext2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'ext2fCodeActivation' => {
            'default' => '\\d{6}',
            'type'    => 'pcre'
        },
        'ext2fLabel' => {
            'type' => 'text'
        },
        'ext2fLogo' => {
            'type' => 'text'
        },
        'ext2fResendInterval' => {
            'type' => 'text'
        },
        'ext2FSendCommand' => {
            'type' => 'text'
        },
        'ext2FValidateCommand' => {
            'type' => 'text'
        },
        'facebookAppId' => {
            'type' => 'text'
        },
        'facebookAppSecret' => {
            'type' => 'text'
        },
        'facebookAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'facebookExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'facebookUserField' => {
            'default' => 'id',
            'type'    => 'text'
        },
        'failedLoginNumber' => {
            'default' => 5,
            'type'    => 'int'
        },
        'findUser' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'findUserControl' => {
            'default' => '^[*\\w]+$',
            'type'    => 'pcre'
        },
        'findUserExcludingAttributes' => {
            'keyTest' => qr/^\S+$/,
            'type'    => 'keyTextContainer'
        },
        'findUserSearchingAttributes' => {
            'keyTest' => qr/^\S+$/,
            'type'    => 'keyTextContainer'
        },
        'findUserWildcard' => {
            'default' => '*',
            'type'    => 'text'
        },
        'floatingCategoryName' => {
            'type' => 'text'
        },
        'forceGlobalStorageIssuerOTT' => {
            'type' => 'bool'
        },
        'forceGlobalStorageUpgradeOTT' => {
            'type' => 'bool'
        },
        'formTimeout' => {
            'default' => 120,
            'type'    => 'int'
        },
        'githubAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'githubClientID' => {
            'type' => 'text'
        },
        'githubClientSecret' => {
            'type' => 'password'
        },
        'githubScope' => {
            'default' => 'user:email',
            'type'    => 'text'
        },
        'githubUserField' => {
            'default' => 'login',
            'type'    => 'text'
        },
        'globalLogoutCustomParam' => {
            'type' => 'text'
        },
        'globalLogoutRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'globalLogoutTimer' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'globalStorage' => {
            'default' => 'Apache::Session::File',
            'type'    => 'PerlModule'
        },
        'globalStorageOptions' => {
            'default' => {
                'Directory'      => '/var/lib/lemonldap-ng/sessions/',
                'generateModule' =>
                  'Lemonldap::NG::Common::Apache::Session::Generate::SHA256',
                'LockDirectory' => '/var/lib/lemonldap-ng/sessions/lock/'
            },
            'type' => 'keyTextContainer'
        },
        'gpgAuthnLevel' => {
            'default' => 5,
            'type'    => 'int'
        },
        'gpgDb' => {
            'default' => '',
            'type'    => 'text'
        },
        'grantSessionRules' => {
            'default' => {},
            'keyTest' => sub {
                return perlExpr(@_);
            },
            'test' => sub {
                1;
            },
            'type' => 'grantContainer'
        },
        'groupLDAPFilter' => {
            'type' => 'text'
        },
        'groups' => {
            'default' => {},
            'test'    => sub {
                return perlExpr(@_);
            },
            'type' => 'keyTextContainer'
        },
        'groupsBeforeMacros' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'handlerInternalCache' => {
            'default' => 15,
            'type'    => 'int'
        },
        'handlerServiceTokenTTL' => {
            'default' => 30,
            'type'    => 'int'
        },
        'hashedSessionStore' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'hiddenAttributes' => {
            'default' => '_password _2fDevices',
            'type'    => 'text'
        },
        'hideOldPassword' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'httpOnly' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'https' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'impersonationHiddenAttributes' => {
            'default' => '_2fDevices, _loginHistory',
            'type'    => 'text'
        },
        'impersonationIdRule' => {
            'default' => 1,
            'test'    => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'impersonationMergeSSOgroups' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'impersonationPrefix' => {
            'default' => 'real_',
            'type'    => 'text'
        },
        'impersonationRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'impersonationSkipEmptyValues' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'impersonationUnrestrictedUsersRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'infoFormMethod' => {
            'default' => 'get',
            'select'  => [ {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'initializePasswordReset' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'initializePasswordResetSecret' => {
            'type' => 'password'
        },
        'issuerDBCASActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBCASPath' => {
            'default' => '^/cas/',
            'type'    => 'pcre'
        },
        'issuerDBCASRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBGetActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBGetParameters' => {
            'default'    => {},
            'keyMsgFail' => '__badHostname__',
            'keyTest'    =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'test' => {
                'keyMsgFail' => '__badKeyName__',
                'keyTest'    => qr/^(?=[^\-])[\w\-]+(?<=[^-])$/,
                'test'       => sub {
                    my ( $val, $conf ) = @_;
                    return 1
                      if defined $conf->{'macros'}{$val} or $val eq '_timezone';
                    foreach $_ ( keys %$conf ) {
                        return 1
                          if $_ =~ /exportedvars$/i
                          and defined $conf->{$_}{$val};
                    }
                    return 1, "__unknownAttrOrMacro__: $val";
                }
            },
            'type' => 'doubleHash'
        },
        'issuerDBGetPath' => {
            'default' => '^/get/',
            'type'    => 'text'
        },
        'issuerDBGetRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBJitsiMeetTokensActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBJitsiMeetTokensPath' => {
            'default' => '^/jitsi/',
            'type'    => 'text'
        },
        'issuerDBJitsiMeetTokensRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBOpenIDActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBOpenIDConnectActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBOpenIDConnectPath' => {
            'default' => '^/oauth2/',
            'type'    => 'text'
        },
        'issuerDBOpenIDConnectRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBOpenIDPath' => {
            'default' => '^/openidserver/',
            'type'    => 'pcre'
        },
        'issuerDBOpenIDRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBSAMLActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBSAMLPath' => {
            'default' => '^/saml/',
            'type'    => 'pcre'
        },
        'issuerDBSAMLRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuersTimeout' => {
            'default' => 120,
            'type'    => 'int'
        },
        'jitsiAppId' => {
            'type' => 'text'
        },
        'jitsiAppSecret' => {
            'type' => 'text'
        },
        'jitsiDefaultServer' => {
            'type' => 'url'
        },
        'jitsiExpiration' => {
            'default' => '300',
            'type'    => 'int'
        },
        'jitsiIdAttribute' => {
            'type' => 'text'
        },
        'jitsiMailAttribute' => {
            'type' => 'text'
        },
        'jitsiNameAttribute' => {
            'type' => 'text'
        },
        'jitsiSigningAlg' => {
            'default' => 'RS256',
            'select'  => [ {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'EdDSA'
                }
            ],
            'type' => 'select'
        },
        'jitsiSigningKey' => {
            'default' => 'default-oidc-sig, old-oidc-sig, new-oidc-sig',
            'type'    => 'text'
        },
        'jsRedirect' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'key' => {
            'type' => 'password'
        },
        'keyComment' => {
            'default' => '',
            'type'    => 'text'
        },
        'keyId' => {
            'default' => '',
            'type'    => 'text'
        },
        'keyNodes' => {
            'type' => 'keyNodeContainer'
        },
        'keyPrivate' => {
            'default' => '',
            'type'    => 'EcOrRSAPrivateKey'
        },
        'keyPrivatePwd' => {
            'default' => '',
            'type'    => 'password'
        },
        'keyPublic' => {
            'default' => '',
            'type'    => 'EcOrRSAPublicKeyOrCertificate'
        },
        'keys' => {
            'type' => 'subContainer'
        },
        'krbAllowedDomains' => {
            'type' => 'text'
        },
        'krbAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'krbByJs' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'krbKeytab' => {
            'type' => 'text'
        },
        'krbRemoveDomain' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'ldapAllowResetExpiredPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'ldapBase' => {
            'default' => 'dc=example,dc=com',
            'msgFail' => '__badValue__',
            'test'    => qr/^(?:\w+=.*|)$/,
            'type'    => 'text'
        },
        'ldapCAFile' => {
            'type' => 'text'
        },
        'ldapCAPath' => {
            'type' => 'text'
        },
        'ldapChangePasswordAsUser' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'LDAPFilter' => {
            'type' => 'text'
        },
        'ldapForcePasswordChangeExpirationWarning' => {
            'type' => 'intOrNull'
        },
        'ldapGetUserBeforePasswordChange' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapGroupAttributeName' => {
            'default' => 'member',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameGroup' => {
            'default' => 'dn',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameSearch' => {
            'default' => 'cn',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameUser' => {
            'default' => 'dn',
            'type'    => 'text'
        },
        'ldapGroupBase' => {
            'type' => 'text'
        },
        'ldapGroupDecodeSearchedValue' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapGroupObjectClass' => {
            'default' => 'groupOfNames',
            'type'    => 'text'
        },
        'ldapGroupRecursive' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapIOTimeout' => {
            'default' => 10,
            'type'    => 'int'
        },
        'ldapITDS' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapPasswordResetAttribute' => {
            'default' => 'pwdReset',
            'type'    => 'text'
        },
        'ldapPasswordResetAttributeValue' => {
            'default' => 'TRUE',
            'type'    => 'text'
        },
        'ldapPort' => {
            'type' => 'intOrNull'
        },
        'ldapPpolicyControl' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapPwdEnc' => {
            'default' => 'utf-8',
            'msgFail' => '__badEncoding__',
            'test'    => qr/^[a-zA-Z0-9_][a-zA-Z0-9_\-]*[a-zA-Z0-9_]$/,
            'type'    => 'text'
        },
        'ldapRaw' => {
            'type' => 'text'
        },
        'ldapSearchDeref' => {
            'default' => 'find',
            'select'  => [ {
                    'k' => 'never',
                    'v' => 'never'
                },
                {
                    'k' => 'search',
                    'v' => 'search'
                },
                {
                    'k' => 'find',
                    'v' => 'find'
                },
                {
                    'k' => 'always',
                    'v' => 'always'
                }
            ],
            'type' => 'select'
        },
        'ldapServer' => {
            'default' => 'ldap://localhost',
            'test'    => sub {
                my $l = shift();
                my @s = split( /[\s,]+/, $l, 0 );
                foreach my $s (@s) {
                    return 0, qq[__badLdapUri__: "$s"]
                      unless $s =~
m[^(?:ldapi://[^/]*/?|\w[\w\-\.]*(?::\d{1,5})?|ldap(?:s|\+tls)?://\w[\w\-\.]*(?::\d{1,5})?/?.*)$];
                }
                return 1;
            },
            'type' => 'text'
        },
        'ldapSetPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapTimeout' => {
            'default' => 10,
            'type'    => 'int'
        },
        'ldapUsePasswordResetAttribute' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'ldapVerify' => {
            'default' => 'require',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'optional',
                    'v' => 'Optional'
                },
                {
                    'k' => 'require',
                    'v' => 'Require'
                }
            ],
            'type' => 'select'
        },
        'ldapVersion' => {
            'default' => 3,
            'type'    => 'int'
        },
        'linkedInAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'linkedInClientID' => {
            'type' => 'text'
        },
        'linkedInClientSecret' => {
            'type' => 'password'
        },
        'linkedInFields' => {
            'default' => 'id,first-name,last-name,email-address',
            'type'    => 'text'
        },
        'linkedInScope' => {
            'default' => 'r_liteprofile r_emailaddress',
            'type'    => 'text'
        },
        'linkedInUserField' => {
            'default' => 'emailAddress',
            'type'    => 'text'
        },
        'localSessionStorage' => {
            'default' => 'Cache::FileCache',
            'type'    => 'PerlModule'
        },
        'localSessionStorageOptions' => {
            'default' => {
                'cache_depth'        => 3,
                'cache_root'         => '/var/cache/lemonldap-ng',
                'default_expires_in' => 600,
                'directory_umask'    => '007',
                'namespace'          => 'lemonldap-ng-sessions'
            },
            'type' => 'keyTextContainer'
        },
        'localStorage' => {
            'type' => 'text'
        },
        'localStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'locationDetect' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'locationDetectGeoIpDatabase' => {
            'type' => 'text'
        },
        'locationDetectGeoIpLanguages' => {
            'default' => 'en, fr',
            'type'    => 'text'
        },
        'locationDetectIpDetail' => {
            'type' => 'text'
        },
        'locationDetectUaDetail' => {
            'type' => 'text'
        },
        'locationRules' => {
            'default' => {
                'default' => 'deny'
            },
            'keyMsgFail' => '__badHostname__',
            'keyTest'    => qr/^\S+$/,
            'test'       => {
                'keyMsgFail' => '__badRegexp__',
                'keyTest'    => sub {
                    eval {
                        do {
                            qr/$_[0]/;
                        }
                    };
                    return $@ ? 0 : 1;
                },
                'msgFail' => '__badExpression__',
                'test'    => sub {
                    my ( $val, $conf ) = @_;
                    my $s = $val;
                    if ( $s =~ s/^logout(?:_(?:sso|app(?:_sso)?))?\s*// ) {
                        return $s =~ m[^(?:https?://.*)?$]
                          ? 1
                          : ( 0, '__badUrl__' );
                    }
                    $s =~ s/\b(accept|deny|unprotect|skip)\b/1/g;
                    return &perlExpr( $s, $conf );
                }
            },
            'type' => 'ruleContainer'
        },
        'log4perlConfFile' => {
            'type' => 'text'
        },
        'logger' => {
            'type' => 'text'
        },
        'loginHistoryEnabled' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'logLevel' => {
            'type' => 'text'
        },
        'logoutServices' => {
            'default' => {},
            'type'    => 'keyTextContainer'
        },
        'lokiAuthorization' => {
            'type' => 'text'
        },
        'lokiEnv' => {
            'type' => 'text'
        },
        'lokiInstance' => {
            'type' => 'text'
        },
        'lokiLabel' => {
            'type' => 'text'
        },
        'lokiService' => {
            'type' => 'text'
        },
        'lokiTenant' => {
            'type' => 'text'
        },
        'lokiTenantHeader' => {
            'type' => 'text'
        },
        'lokiUrl' => {
            'type' => 'text'
        },
        'lokiUserService' => {
            'type' => 'text'
        },
        'lwpOpts' => {
            'default' => {
                'timeout' => 10
            },
            'type' => 'keyTextContainer'
        },
        'lwpSslOpts' => {
            'type' => 'keyTextContainer'
        },
        'macros' => {
            'default'    => {},
            'keyMsgFail' => '__badMacroName__',
            'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
            'test'       => sub {
                return perlExpr(@_);
            },
            'type' => 'keyTextContainer'
        },
        'mail2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'mail2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'mail2fBody' => {
            'type' => 'longtext'
        },
        'mail2fCodeRegex' => {
            'default' => '\\d{6}',
            'type'    => 'pcre'
        },
        'mail2fLabel' => {
            'type' => 'text'
        },
        'mail2fLogo' => {
            'type' => 'text'
        },
        'mail2fResendInterval' => {
            'type' => 'text'
        },
        'mail2fSessionKey' => {
            'type' => 'text'
        },
        'mail2fSubject' => {
            'type' => 'text'
        },
        'mail2fTimeout' => {
            'type' => 'intOrNull'
        },
        'mailBody' => {
            'type' => 'longtext'
        },
        'mailCharset' => {
            'default' => 'utf-8',
            'type'    => 'text'
        },
        'mailConfirmBody' => {
            'type' => 'longtext'
        },
        'mailConfirmSubject' => {
            'type' => 'text'
        },
        'mailFrom' => {
            'default' => 'noreply@example.com',
            'type'    => 'text'
        },
        'mailLDAPFilter' => {
            'type' => 'text'
        },
        'mailOnPasswordChange' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'mailReplyTo' => {
            'type' => 'text'
        },
        'mailSessionKey' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'mailSubject' => {
            'type' => 'text'
        },
        'mailTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'mailUrl' => {
            'type' => 'url'
        },
        'maintenance' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'managerDn' => {
            'default' => '',
            'msgFail' => '__badValue__',
            'test'    => qr/^.*$/,
            'type'    => 'text'
        },
        'managerPassword' => {
            'default' => '',
            'msgFail' => '__badValue__',
            'test'    => qr/^\S*$/,
            'type'    => 'password'
        },
        'max2FDevices' => {
            'default' => 10,
            'type'    => 'int'
        },
        'max2FDevicesNameLength' => {
            'default' => 20,
            'type'    => 'int'
        },
        'messageBroker' => {
            'select' => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => '::Redis',
                    'v' => 'Redis'
                },
                {
                    'k' => '::Pg',
                    'v' => 'PostgreSQL'
                },
                {
                    'k' => '::MQTT',
                    'v' => 'MQTT'
                },
                {
                    'k' => '::Web',
                    'v' => 'Web'
                }
            ],
            'type' => 'select'
        },
        'messageBrokerOptions' => {
            'default' => {},
            'type'    => 'keyTextContainer'
        },
        'multiValuesSeparator' => {
            'default' => '; ',
            'type'    => 'authParamsText'
        },
        'mySessionAuthorizedRWKeys' => {
            'default' => [
                '_appsListOrder',      '_oidcConnectedRP',
                '_oidcConnectedRPIDs', '_oidcConsents'
            ],
            'type' => 'array'
        },
        'newLocationWarning' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'newLocationWarningLocationAttribute' => {
            'default' => 'ipAddr',
            'type'    => 'text'
        },
        'newLocationWarningLocationDisplayAttribute' => {
            'default' => '',
            'type'    => 'text'
        },
        'newLocationWarningMailAttribute' => {
            'type' => 'text'
        },
        'newLocationWarningMailBody' => {
            'type' => 'longtext'
        },
        'newLocationWarningMailSubject' => {
            'type' => 'text'
        },
        'newLocationWarningMaxValues' => {
            'default' => '0',
            'type'    => 'int'
        },
        'nginxCustomHandlers' => {
            'keyTest' => qr/^\w+$/,
            'msgFail' => '__badPerlPackageName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9]*(?:::[a-zA-Z][a-zA-Z0-9]*)*$/,
            'type'    => 'keyTextContainer'
        },
        'noAjaxHook' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notification' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationDefaultCond' => {
            'default' => '',
            'type'    => 'text'
        },
        'notificationServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationServerDELETE' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationServerGET' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationServerPOST' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'notificationServerSentAttributes' => {
            'default' => 'uid reference date title subtitle text check',
            'type'    => 'text'
        },
        'notificationsExplorer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationsMaxRetrieve' => {
            'default' => 3,
            'type'    => 'int'
        },
        'notificationStorage' => {
            'default' => 'File',
            'type'    => 'PerlModule'
        },
        'notificationStorageOptions' => {
            'default' => {
                'dirName' => '/var/lib/lemonldap-ng/notifications'
            },
            'type' => 'keyTextContainer'
        },
        'notificationWildcard' => {
            'default' => 'allusers',
            'type'    => 'text'
        },
        'notificationXSLTfile' => {
            'type' => 'text'
        },
        'notifyDeleted' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'notifyOther' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'nullAuthnLevel' => {
            'default' => 0,
            'type'    => 'int'
        },
        'oidcAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'oidcDropCspHeaders' => {
            'type' => 'bool'
        },
        'oidcOfflineTokens' => {
            'type' => 'bool'
        },
        'oidcOPMetaDataExportedVars' => {
            'default' => {
                'cn'   => 'name',
                'mail' => 'email',
                'sn'   => 'family_name',
                'uid'  => 'sub'
            },
            'type' => 'keyTextContainer'
        },
        'oidcOPMetaDataJSON' => {
            'keyTest' => sub {
                1;
            },
            'type' => 'file'
        },
        'oidcOPMetaDataJWKS' => {
            'keyTest' => sub {
                1;
            },
            'type' => 'file'
        },
        'oidcOPMetaDataNodes' => {
            'type' => 'oidcOPMetaDataNodeContainer'
        },
        'oidcOPMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'oidcOPMetaDataOptionsAcrValues' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsAuthnEndpointAuthMethod' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => 'jws',
                    'v' => 'Signed JWT'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsAuthnEndpointAuthSigAlg' => {
            'default' => 'RS256',
            'select'  => [ {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'EdDSA'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsCheckJWTSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsClientID' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsClientSecret' => {
            'type' => 'password'
        },
        'oidcOPMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'oidcOPMetaDataOptionsConfigurationURI' => {
            'type' => 'url'
        },
        'oidcOPMetaDataOptionsDisplay' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'page',
                    'v' => 'page'
                },
                {
                    'k' => 'popup',
                    'v' => 'popup'
                },
                {
                    'k' => 'touch',
                    'v' => 'touch'
                },
                {
                    'k' => 'wap',
                    'v' => 'wap'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsIDTokenMaxAge' => {
            'default' => 30,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsJWKSTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsMaxAge' => {
            'default' => 0,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsNoJwtHeader' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsPrompt' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsRequirePkce' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsResolutionRule' => {
            'default' => '',
            'type'    => 'longtext'
        },
        'oidcOPMetaDataOptionsScope' => {
            'default' => 'openid profile',
            'type'    => 'text'
        },
        'oidcOPMetaDataOptionsSigningKey' => {
            'default' => '',
            'type'    => 'text'
        },
        'oidcOPMetaDataOptionsSortNumber' => {
            'type' => 'int'
        },
        'oidcOPMetaDataOptionsStoreIDToken' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsTokenEndpointAuthMethod' => {
            'default' => 'client_secret_post',
            'select'  => [ {
                    'k' => 'client_secret_post',
                    'v' => 'client_secret_post'
                },
                {
                    'k' => 'client_secret_basic',
                    'v' => 'client_secret_basic'
                },
                {
                    'k' => 'client_secret_jwt',
                    'v' => 'client_secret_jwt'
                },
                {
                    'k' => 'private_key_jwt',
                    'v' => 'private_key_jwt'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsTokenEndpointAuthSigAlg' => {
            'default' => 'RS256',
            'select'  => [ {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'EdDSA'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsTooltip' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsUiLocales' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsUseNonce' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsUserAttribute' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsUserinfoSource' => {
            'default' => 'userinfo',
            'select'  => [ {
                    'k' => 'userinfo',
                    'v' => 'Userinfo endpoint'
                },
                {
                    'k' => 'id_token',
                    'v' => 'ID Token'
                },
                {
                    'k' => 'access_token',
                    'v' => 'Access Token'
                }
            ],
            'type' => 'select'
        },
        'oidcRPCallbackGetParam' => {
            'default' => 'openidconnectcallback',
            'type'    => 'text'
        },
        'oidcRPMetaDataExportedVars' => {
            'default' => {
                'email'              => 'mail',
                'name'               => 'cn',
                'preferred_username' => 'uid'
            },
            'keyTest' => qr/\w/,
            'test'    => qr/\w/,
            'type'    => 'oidcAttributeContainer'
        },
        'oidcRPMetaDataMacros' => {
            'default' => {},
            'test'    => {
                'keyMsgFail' => '__badMacroName__',
                'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'oidcRPMetaDataNodes' => {
            'type' => 'oidcRPMetaDataNodeContainer'
        },
        'oidcRPMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'oidcRPMetaDataOptionsAccessTokenClaims' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAccessTokenEncContentEncAlg' => {
            'default' => 'A256GCM',
            'select'  => [ {
                    'k' => 'A256CBC-HS512',
                    'v' => 'A256CBC-HS512'
                },
                {
                    'k' => 'A256GCM',
                    'v' => 'A256GCM'
                },
                {
                    'k' => 'A192CBC-HS384',
                    'v' => 'A192CBC-HS384'
                },
                {
                    'k' => 'A192GCM',
                    'v' => 'A192GCM'
                },
                {
                    'k' => 'A128CBC-HS256',
                    'v' => 'A128CBC-HS256'
                },
                {
                    'k' => 'A128GCM',
                    'v' => 'A128GCM'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsAccessTokenEncKeyMgtAlg' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => 'RSA-OAEP',
                    'v' => 'RSA-OAEP'
                },
                {
                    'k' => 'RSA-OAEP-256',
                    'v' => 'RSA-OAEP-256'
                },
                {
                    'k' => 'RSA1_5',
                    'v' => 'RSA1_5'
                },
                {
                    'k' => 'ECDH-ES',
                    'v' => 'ECDH-ES'
                },
                {
                    'k' => 'ECDH-ES+A128KW',
                    'v' => 'ECDH-ES+A128KW'
                },
                {
                    'k' => 'ECDH-ES+A192KW',
                    'v' => 'ECDH-ES+A192KW'
                },
                {
                    'k' => 'ECDH-ES+A256KW',
                    'v' => 'ECDH-ES+A256KW'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsAccessTokenExpiration' => {
            'type' => 'intOrNull'
        },
        'oidcRPMetaDataOptionsAccessTokenJWT' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAccessTokenSignAlg' => {
            'default' => 'RS256',
            'select'  => [ {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'EdDSA'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsAdditionalAudiences' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsAllowClientCredentialsGrant' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAllowNativeSso' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAllowOffline' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAllowPasswordGrant' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAuthMethod' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'Any'
                },
                {
                    'k' => 'client_secret_post',
                    'v' => 'client_secret_post'
                },
                {
                    'k' => 'client_secret_basic',
                    'v' => 'client_secret_basic'
                },
                {
                    'k' => 'client_secret_jwt',
                    'v' => 'client_secret_jwt'
                },
                {
                    'k' => 'private_key_jwt',
                    'v' => 'private_key_jwt'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsAuthnLevel' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsAuthnRequireNonce' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAuthnRequireState' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsAuthorizationCodeExpiration' => {
            'type' => 'intOrNull'
        },
        'oidcRPMetaDataOptionsAuthRequiredForAuthorize' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsBypassConsent' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsClientID' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsClientSecret' => {
            'type' => 'password'
        },
        'oidcRPMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'oidcRPMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsExtraClaims' => {
            'default' => {},
            'keyTest' => qr/^[\x21\x23-\x5B\x5D-\x7E]+$/,
            'type'    => 'keyTextContainer'
        },
        'oidcRPMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsIdTokenEncContentEncAlg' => {
            'default' => 'A256GCM',
            'select'  => [ {
                    'k' => 'A256CBC-HS512',
                    'v' => 'A256CBC-HS512'
                },
                {
                    'k' => 'A256GCM',
                    'v' => 'A256GCM'
                },
                {
                    'k' => 'A192CBC-HS384',
                    'v' => 'A192CBC-HS384'
                },
                {
                    'k' => 'A192GCM',
                    'v' => 'A192GCM'
                },
                {
                    'k' => 'A128CBC-HS256',
                    'v' => 'A128CBC-HS256'
                },
                {
                    'k' => 'A128GCM',
                    'v' => 'A128GCM'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsIdTokenEncKeyMgtAlg' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => 'RSA-OAEP',
                    'v' => 'RSA-OAEP'
                },
                {
                    'k' => 'RSA-OAEP-256',
                    'v' => 'RSA-OAEP-256'
                },
                {
                    'k' => 'RSA1_5',
                    'v' => 'RSA1_5'
                },
                {
                    'k' => 'ECDH-ES',
                    'v' => 'ECDH-ES'
                },
                {
                    'k' => 'ECDH-ES+A128KW',
                    'v' => 'ECDH-ES+A128KW'
                },
                {
                    'k' => 'ECDH-ES+A192KW',
                    'v' => 'ECDH-ES+A192KW'
                },
                {
                    'k' => 'ECDH-ES+A256KW',
                    'v' => 'ECDH-ES+A256KW'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsIDTokenExpiration' => {
            'type' => 'intOrNull'
        },
        'oidcRPMetaDataOptionsIDTokenForceClaims' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsIDTokenSignAlg' => {
            'default' => 'RS256',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'EdDSA'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsJwks' => {
            'keyTest' => sub {
                1;
            },
            'type' => 'file'
        },
        'oidcRPMetaDataOptionsJwksUri' => {
            'type' => 'url'
        },
        'oidcRPMetaDataOptionsLogoutBypassConfirm' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsLogoutEncContentEncAlg' => {
            'default' => 'A256GCM',
            'select'  => [ {
                    'k' => 'A256CBC-HS512',
                    'v' => 'A256CBC-HS512'
                },
                {
                    'k' => 'A256GCM',
                    'v' => 'A256GCM'
                },
                {
                    'k' => 'A192CBC-HS384',
                    'v' => 'A192CBC-HS384'
                },
                {
                    'k' => 'A192GCM',
                    'v' => 'A192GCM'
                },
                {
                    'k' => 'A128CBC-HS256',
                    'v' => 'A128CBC-HS256'
                },
                {
                    'k' => 'A128GCM',
                    'v' => 'A128GCM'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsLogoutEncKeyMgtAlg' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => 'RSA-OAEP',
                    'v' => 'RSA-OAEP'
                },
                {
                    'k' => 'RSA-OAEP-256',
                    'v' => 'RSA-OAEP-256'
                },
                {
                    'k' => 'RSA1_5',
                    'v' => 'RSA1_5'
                },
                {
                    'k' => 'ECDH-ES',
                    'v' => 'ECDH-ES'
                },
                {
                    'k' => 'ECDH-ES+A128KW',
                    'v' => 'ECDH-ES+A128KW'
                },
                {
                    'k' => 'ECDH-ES+A192KW',
                    'v' => 'ECDH-ES+A192KW'
                },
                {
                    'k' => 'ECDH-ES+A256KW',
                    'v' => 'ECDH-ES+A256KW'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsLogoutSessionRequired' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsLogoutType' => {
            'default' => 'front',
            'select'  => [ {
                    'k' => 'front',
                    'v' => 'Front Channel'
                },
                {
                    'k' => 'back',
                    'v' => 'Back Channel'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsLogoutUrl' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsNoJwtHeader' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsOfflineSessionExpiration' => {
            'type' => 'intOrNull'
        },
        'oidcRPMetaDataOptionsPostLogoutRedirectUris' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsPublic' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsRedirectUris' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsRefreshToken' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsRefreshTokenRotation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsRequestUris' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsRequirePKCE' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsRtActivity' => {
            'default' => 0,
            'test'    => sub {
                $_[0] >= 0;
            },
            'type' => 'int'
        },
        'oidcRPMetaDataOptionsRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsSigningKey' => {
            'default' => '',
            'type'    => 'text'
        },
        'oidcRPMetaDataOptionsTokenXAuthorizedRP' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsUserIDAttr' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsUserInfoEncContentEncAlg' => {
            'default' => 'A256GCM',
            'select'  => [ {
                    'k' => 'A256CBC-HS512',
                    'v' => 'A256CBC-HS512'
                },
                {
                    'k' => 'A256GCM',
                    'v' => 'A256GCM'
                },
                {
                    'k' => 'A192CBC-HS384',
                    'v' => 'A192CBC-HS384'
                },
                {
                    'k' => 'A192GCM',
                    'v' => 'A192GCM'
                },
                {
                    'k' => 'A128CBC-HS256',
                    'v' => 'A128CBC-HS256'
                },
                {
                    'k' => 'A128GCM',
                    'v' => 'A128GCM'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsUserInfoEncKeyMgtAlg' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => 'RSA-OAEP',
                    'v' => 'RSA-OAEP'
                },
                {
                    'k' => 'RSA-OAEP-256',
                    'v' => 'RSA-OAEP-256'
                },
                {
                    'k' => 'RSA1_5',
                    'v' => 'RSA1_5'
                },
                {
                    'k' => 'ECDH-ES',
                    'v' => 'ECDH-ES'
                },
                {
                    'k' => 'ECDH-ES+A128KW',
                    'v' => 'ECDH-ES+A128KW'
                },
                {
                    'k' => 'ECDH-ES+A192KW',
                    'v' => 'ECDH-ES+A192KW'
                },
                {
                    'k' => 'ECDH-ES+A256KW',
                    'v' => 'ECDH-ES+A256KW'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsUserinfoRequireHeaderToken' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcRPMetaDataOptionsUserInfoSignAlg' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'JSON'
                },
                {
                    'k' => 'none',
                    'v' => 'JWT/None'
                },
                {
                    'k' => 'HS256',
                    'v' => 'JWT/HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'JWT/HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'JWT/HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'JWT/RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'JWT/RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'JWT/RS512'
                },
                {
                    'k' => 'PS256',
                    'v' => 'JWT/PS256'
                },
                {
                    'k' => 'PS384',
                    'v' => 'JWT/PS384'
                },
                {
                    'k' => 'PS512',
                    'v' => 'JWT/PS512'
                },
                {
                    'k' => 'ES256',
                    'v' => 'JWT/ES256'
                },
                {
                    'k' => 'ES384',
                    'v' => 'JWT/ES384'
                },
                {
                    'k' => 'ES512',
                    'v' => 'JWT/ES512'
                },
                {
                    'k' => 'EdDSA',
                    'v' => 'JWT/EdDSA'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataScopeRules' => {
            'default' => {},
            'test'    => {
                'keyMsgFail' => '__badMacroName__',
                'keyTest'    => qr/^[\x21\x23-\x5B\x5D-\x7E]+$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'oidcRPStateTimeout' => {
            'default' => 600,
            'type'    => 'int'
        },
        'oidcServiceAccessTokenExpiration' => {
            'default' => 3600,
            'type'    => 'int'
        },
        'oidcServiceAllowAuthorizationCodeFlow' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcServiceAllowDynamicRegistration' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAllowHybridFlow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAllowImplicitFlow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAllowOnlyDeclaredScopes' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAuthorizationCodeExpiration' => {
            'default' => 60,
            'type'    => 'int'
        },
        'oidcServiceDynamicRegistrationExportedVars' => {
            'type' => 'keyTextContainer'
        },
        'oidcServiceDynamicRegistrationExtraClaims' => {
            'keyTest' => qr/^[\x21\x23-\x5B\x5D-\x7E]+$/,
            'type'    => 'keyTextContainer'
        },
        'oidcServiceEncAlgorithmAlg' => {
            'default' => 'RSA-OAEP',
            'select'  => [ {
                    'k' => 'RSA-OAEP',
                    'v' => 'RSA-OAEP'
                },
                {
                    'k' => 'RSA-OAEP-256',
                    'v' => 'RSA-OAEP-256'
                },
                {
                    'k' => 'RSA1_5',
                    'v' => 'RSA1_5'
                },
                {
                    'k' => 'ECDH-ES',
                    'v' => 'ECDH-ES'
                },
                {
                    'k' => 'ECDH-ES+A128KW',
                    'v' => 'ECDH-ES+A128KW'
                },
                {
                    'k' => 'ECDH-ES+A192KW',
                    'v' => 'ECDH-ES+A192KW'
                },
                {
                    'k' => 'ECDH-ES+A256KW',
                    'v' => 'ECDH-ES+A256KW'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceEncAlgorithmEnc' => {
            'default' => 'A256GCM',
            'select'  => [ {
                    'k' => 'A256CBC-HS512',
                    'v' => 'A256CBC-HS512'
                },
                {
                    'k' => 'A256GCM',
                    'v' => 'A256GCM'
                },
                {
                    'k' => 'A192CBC-HS384',
                    'v' => 'A192CBC-HS384'
                },
                {
                    'k' => 'A192GCM',
                    'v' => 'A192GCM'
                },
                {
                    'k' => 'A128CBC-HS256',
                    'v' => 'A128CBC-HS256'
                },
                {
                    'k' => 'A128GCM',
                    'v' => 'A128GCM'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceEncryptionKey' => {
            'default' => 'default-oidc-enc',
            'type'    => 'text'
        },
        'oidcServiceHideMetadata' => {
            'type' => 'bool'
        },
        'oidcServiceIDTokenExpiration' => {
            'default' => 3600,
            'type'    => 'int'
        },
        'oidcServiceIgnoreScopeForClaims' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceKeyIdEnc' => {
            'type' => 'text'
        },
        'oidcServiceKeyIdSig' => {
            'type' => 'text'
        },
        'oidcServiceKeyTypeEnc' => {
            'default' => 'RSA',
            'select'  => [ {
                    'k' => 'RSA',
                    'v' => 'RSA'
                },
                {
                    'k' => 'EC',
                    'v' => 'EC'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceKeyTypeSig' => {
            'default' => 'RSA',
            'select'  => [ {
                    'k' => 'RSA',
                    'v' => 'RSA'
                },
                {
                    'k' => 'EC',
                    'v' => 'EC'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceMetaDataAmrRules' => {
            'default' => {
                'mfa' => '$_2f',
                'otp' => '$_2f eq "TOTP"',
                'pop' => '$_auth eq "WebAuthn" or $_auth eq "SSL"',
                'pwd' => '$authenticationLevel == 2'
            },
            'keyTest' => qr/\w/,
            'test'    => sub {
                return perlExpr(@_);
            },
            'type' => 'keyTextContainer'
        },
        'oidcServiceMetaDataAuthnContext' => {
            'default' => {
                'loa-1' => 1,
                'loa-2' => 2,
                'loa-3' => 3,
                'loa-4' => 4,
                'loa-5' => 5
            },
            'keyTest' => qr/\w/,
            'type'    => 'keyTextContainer'
        },
        'oidcServiceMetaDataAuthorizeURI' => {
            'default' => 'authorize',
            'type'    => 'text'
        },
        'oidcServiceMetaDataBackChannelURI' => {
            'default' => 'blogout',
            'type'    => 'text'
        },
        'oidcServiceMetaDataCheckSessionURI' => {
            'default' => 'checksession.html',
            'type'    => 'text'
        },
        'oidcServiceMetaDataDisallowNoneAlg' => {
            'type' => 'bool'
        },
        'oidcServiceMetaDataEndSessionURI' => {
            'default' => 'logout',
            'type'    => 'text'
        },
        'oidcServiceMetaDataFrontChannelURI' => {
            'default' => 'flogout',
            'type'    => 'text'
        },
        'oidcServiceMetaDataIntrospectionURI' => {
            'default' => 'introspect',
            'type'    => 'text'
        },
        'oidcServiceMetaDataIssuer' => {
            'type' => 'text'
        },
        'oidcServiceMetaDataJWKSURI' => {
            'default' => 'jwks',
            'type'    => 'text'
        },
        'oidcServiceMetaDataRegistrationURI' => {
            'default' => 'register',
            'type'    => 'text'
        },
        'oidcServiceMetaDataRevokeURI' => {
            'default' => 'revoke',
            'type'    => 'text'
        },
        'oidcServiceMetaDataRpLogoutReturnURI' => {
            'default' => 'rlogoutreturn',
            'type'    => 'text'
        },
        'oidcServiceMetaDataTokenURI' => {
            'default' => 'token',
            'type'    => 'text'
        },
        'oidcServiceMetadataTtl' => {
            'type' => 'int'
        },
        'oidcServiceMetaDataUserInfoURI' => {
            'default' => 'userinfo',
            'type'    => 'text'
        },
        'oidcServiceNewKeyIdSig' => {
            'type' => 'text'
        },
        'oidcServiceNewKeyTypeSig' => {
            'default' => 'RSA',
            'select'  => [ {
                    'k' => 'RSA',
                    'v' => 'RSA'
                },
                {
                    'k' => 'EC',
                    'v' => 'EC'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceNewPrivateKeySig' => {
            'type' => 'EcOrRSAPrivateKey'
        },
        'oidcServiceNewPublicKeySig' => {
            'type' => 'EcOrRSAPublicKeyOrCertificate'
        },
        'oidcServiceOfflineSessionExpiration' => {
            'default' => 2592000,
            'type'    => 'int'
        },
        'oidcServiceOldKeyIdEnc' => {
            'type' => 'text'
        },
        'oidcServiceOldKeyIdSig' => {
            'type' => 'text'
        },
        'oidcServiceOldKeyTypeEnc' => {
            'default' => 'RSA',
            'select'  => [ {
                    'k' => 'RSA',
                    'v' => 'RSA'
                },
                {
                    'k' => 'EC',
                    'v' => 'EC'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceOldKeyTypeSig' => {
            'default' => 'RSA',
            'select'  => [ {
                    'k' => 'RSA',
                    'v' => 'RSA'
                },
                {
                    'k' => 'EC',
                    'v' => 'EC'
                }
            ],
            'type' => 'select'
        },
        'oidcServiceOldPrivateKeyEnc' => {
            'type' => 'RSAPrivateKey'
        },
        'oidcServiceOldPrivateKeySig' => {
            'type' => 'EcOrRSAPrivateKey'
        },
        'oidcServiceOldPublicKeyEnc' => {
            'type' => 'RSAPublicKeyOrCertificate'
        },
        'oidcServiceOldPublicKeySig' => {
            'type' => 'EcOrRSAPublicKeyOrCertificate'
        },
        'oidcServicePrivateKeyEnc' => {
            'type' => 'RSAPrivateKey'
        },
        'oidcServicePrivateKeySig' => {
            'type' => 'EcOrRSAPrivateKey'
        },
        'oidcServicePublicKeyEnc' => {
            'type' => 'RSAPublicKeyOrCertificate'
        },
        'oidcServicePublicKeySig' => {
            'type' => 'EcOrRSAPublicKeyOrCertificate'
        },
        'oidcServiceSignatureKey' => {
            'default' => 'default-oidc-sig, old-oidc-sig, new-oidc-sig',
            'type'    => 'text'
        },
        'oidcStorage' => {
            'type' => 'PerlModule'
        },
        'oidcStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'okta2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'okta2fAdminURL' => {
            'type' => 'url'
        },
        'okta2fApiKey' => {
            'type' => 'text'
        },
        'okta2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'okta2fLabel' => {
            'type' => 'text'
        },
        'okta2fLoginAttribute' => {
            'type' => 'text'
        },
        'okta2fLogo' => {
            'type' => 'text'
        },
        'oldNotifFormat' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'openIdAttr' => {
            'type' => 'text'
        },
        'openIdAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'openIdExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'openIdIDPList' => {
            'default' => '0;',
            'type'    => 'blackWhiteList'
        },
        'openIdIssuerSecret' => {
            'type' => 'text'
        },
        'openIdSecret' => {
            'type' => 'text'
        },
        'openIdSPList' => {
            'default' => '0;',
            'type'    => 'blackWhiteList'
        },
        'openIdSreg_country' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_dob' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_email' => {
            'default' => 'mail',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_fullname' => {
            'default' => 'cn',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_gender' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_language' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_nickname' => {
            'default' => 'uid',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_postcode' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_timezone' => {
            'default' => '_timezone',
            'type'    => 'lmAttrOrMacro'
        },
        'pamAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'pamService' => {
            'default' => 'login',
            'type'    => 'text'
        },
        'password2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'password2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'password2fLabel' => {
            'type' => 'text'
        },
        'password2fLogo' => {
            'type' => 'text'
        },
        'password2fSelfRegistration' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'password2fTTL' => {
            'type' => 'intOrNull'
        },
        'password2fUserCanRemoveKey' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'passwordDB' => {
            'default' => 'Demo',
            'select'  => [ {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'Choice',
                    'v' => 'authChoice'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'REST',
                    'v' => 'REST'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'Combination',
                    'v' => 'combineMods'
                },
                {
                    'k' => 'Custom',
                    'v' => 'customModule'
                }
            ],
            'type' => 'select'
        },
        'passwordPolicyActivation' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'passwordPolicyMaxSize' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicyMinDigit' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicyMinLower' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicyMinSize' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicyMinSpeChar' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicyMinUpper' => {
            'default' => 0,
            'type'    => 'int'
        },
        'passwordPolicySpecialChar' => {
            'default' => '__ALL__',
            'test'    => qr/^(?:__ALL__|[\S\W]*)$/,
            'type'    => 'text'
        },
        'passwordResetAllowedRetries' => {
            'default' => 3,
            'type'    => 'int'
        },
        'pdataDomain' => {
            'default' => '',
            'msgFail' => '__badDomainName__',
            'test'    =>
qr/^(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?))?$/,
            'type' => 'text'
        },
        'persistentSessionAttributes' => {
            'default' => '_loginHistory _2fDevices _oidcConsents notification_',
            'type'    => 'text'
        },
        'persistentStorage' => {
            'type' => 'PerlModule'
        },
        'persistentStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'port' => {
            'default' => -1,
            'type'    => 'int'
        },
        'portal' => {
            'default' => 'http://auth.example.com/',
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'url'
        },
        'portalAntiFrame' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalCheckLogins' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalCustomCss' => {
            'type' => 'text'
        },
        'portalCustomJs' => {
            'type' => 'text'
        },
        'portalCustomTplParams' => {
            'type' => 'keyTextContainer'
        },
        'portalDisplayAppslist' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayCertificateResetByMail' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalDisplayChangePassword' => {
            'default' => '$_auth =~ /^(LDAP|DBI|Demo)$/',
            'type'    => 'boolOrExpr'
        },
        'portalDisplayGeneratePassword' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalDisplayLoginHistory' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayLogout' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayOfflineTokens' => {
            'default' => '$_auth eq \'OIDC\'',
            'type'    => 'boolOrExpr'
        },
        'portalDisplayOidcConsents' => {
            'default' => '$_oidcConsents && $_oidcConsents =~ /\\w+/',
            'type'    => 'boolOrExpr'
        },
        'portalDisplayOrder' => {
            'default' =>
              'Appslist ChangePassword LoginHistory OidcConsents Logout',
            'type' => 'text'
        },
        'portalDisplayPasswordPolicy' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalDisplayRefreshMyRights' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalDisplayRegister' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalDisplayResetPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalEnablePasswordDisplay' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalErrorOnExpiredSession' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalErrorOnMailNotFound' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalFavicon' => {
            'default' => 'common/favicon.ico',
            'type'    => 'text'
        },
        'portalForceAuthn' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalForceAuthnInterval' => {
            'default' => 30,
            'type'    => 'int'
        },
        'portalMainLogo' => {
            'default' => 'common/logos/logo_llng_400px.png',
            'type'    => 'text'
        },
        'portalOpenLinkInNewWindow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalPingInterval' => {
            'default' => 60000,
            'type'    => 'int'
        },
        'portalRequireOldPassword' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalSkin' => {
            'default' => 'bootstrap',
            'select'  => [ {
                    'k' => 'bootstrap',
                    'v' => 'Bootstrap'
                }
            ],
            'type' => 'portalskin'
        },
        'portalSkinBackground' => {
            'select' => [ {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => '1280px-Anse_Source_d\'Argent_2-La_Digue.jpg',
                    'v' => 'Anse'
                },
                {
                    'k' =>
'1280px-Autumn-clear-water-waterfall-landscape_-_Virginia_-_ForestWander.jpg',
                    'v' => 'Waterfall'
                },
                {
                    'k' => '1280px-BrockenSnowedTrees.jpg',
                    'v' => 'Snowed Trees'
                },
                {
                    'k' =>
                      '1280px-Cedar_Breaks_National_Monument_partially.jpg',
                    'v' => 'National Monument'
                },
                {
                    'k' => '1280px-Parry_Peak_from_Winter_Park.jpg',
                    'v' => 'Winter'
                },
                {
                    'k' => 'Aletschgletscher_mit_Pinus_cembra1.jpg',
                    'v' => 'Pinus'
                }
            ],
            'type' => 'portalskinbackground'
        },
        'portalSkinRules' => {
            'keyMsgFail' => '__badSkinRule__',
            'keyTest'    => sub {
                return perlExpr(@_);
            },
            'msgFail' => '__badValue__',
            'test'    => sub {
                1;
            },
            'type' => 'keyTextContainer'
        },
        'portalStatus' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalUserAttr' => {
            'default' => '_user',
            'type'    => 'text'
        },
        'post' => {
            'keyMsgFail' => '__badHostname__',
            'keyTest'    => qr/^\S+$/,
            'test'       => sub {
                1;
            },
            'type' => 'postContainer'
        },
        'protection' => {
            'msgFail' => '__authorizedValues__: none authenticate manager',
            'test'    => qr/^(?:none|authenticate|manager|)$/,
            'type'    => 'text'
        },
        'proxyAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'proxyAuthService' => {
            'type' => 'text'
        },
        'proxyAuthServiceChoiceParam' => {
            'default' => 'lmAuth',
            'type'    => 'text'
        },
        'proxyAuthServiceChoiceValue' => {
            'type' => 'text'
        },
        'proxyAuthServiceImpersonation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'proxyCookieName' => {
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'proxySessionService' => {
            'type' => 'text'
        },
        'proxyUseSoap' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'publicNotifications' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'radius2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'radius2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'radius2fDictionaryFile' => {
            'type' => 'text'
        },
        'radius2fLabel' => {
            'type' => 'text'
        },
        'radius2fLogo' => {
            'type' => 'text'
        },
        'radius2fMsgAuth' => {
            'type' => 'bool'
        },
        'radius2fRequestAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^[a-zA-Z0-9_-]*$/,
            'type'       => 'keyTextContainer'
        },
        'radius2fSecret' => {
            'type' => 'text'
        },
        'radius2fSendInitialRequest' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'radius2fServer' => {
            'type' => 'text'
        },
        'radius2fTimeout' => {
            'default' => 20,
            'type'    => 'int'
        },
        'radius2fUsernameSessionKey' => {
            'type' => 'text'
        },
        'radiusAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'radiusDictionaryFile' => {
            'type' => 'text'
        },
        'radiusExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'radiusMsgAuth' => {
            'type' => 'bool'
        },
        'radiusRequestAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^[a-zA-Z0-9_-]*$/,
            'type'       => 'keyTextContainer'
        },
        'radiusSecret' => {
            'type' => 'text'
        },
        'radiusServer' => {
            'type' => 'text'
        },
        'radiusTimeout' => {
            'type' => 'intOrNull'
        },
        'randomPasswordRegexp' => {
            'default' => '[A-Z]{3}[a-z]{5}.\\d{2}',
            'type'    => 'pcre'
        },
        'redirectFormMethod' => {
            'default' => 'get',
            'select'  => [ {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'refreshSessions' => {
            'type' => 'bool'
        },
        'registerConfirmBody' => {
            'type' => 'longtext'
        },
        'registerConfirmSubject' => {
            'type' => 'text'
        },
        'registerDB' => {
            'default' => 'Null',
            'select'  => [ {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'Custom',
                    'v' => 'customModule'
                }
            ],
            'type' => 'select'
        },
        'registerDoneBody' => {
            'type' => 'longtext'
        },
        'registerDoneSubject' => {
            'type' => 'text'
        },
        'registerTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'registerUrl' => {
            'type' => 'url'
        },
        'reloadTimeout' => {
            'default' => 5,
            'type'    => 'int'
        },
        'reloadUrls' => {
            'keyTest' =>
qr/^(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+))(?::\d+)?$/,
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'keyTextContainer'
        },
        'rememberAuthChoiceForgetAtLogout' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'rememberAuthChoiceRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'rememberCookieName' => {
            'default' => 'llngrememberauthchoice',
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'rememberCookieTimeout' => {
            'default' => 31536000,
            'type'    => 'int'
        },
        'rememberDefaultChecked' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'rememberTimer' => {
            'default' => 5,
            'type'    => 'int'
        },
        'remoteCookieName' => {
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'remoteGlobalStorage' => {
            'default' => 'Lemonldap::NG::Common::Apache::Session::SOAP',
            'type'    => 'PerlModule'
        },
        'remoteGlobalStorageOptions' => {
            'default' => {
                'ns' =>
'http://auth.example.com/Lemonldap/NG/Common/PSGI/SOAPService',
                'proxy' => 'http://auth.example.com/sessions'
            },
            'type' => 'keyTextContainer'
        },
        'remotePortal' => {
            'type' => 'text'
        },
        'requireToken' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'rest2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'rest2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'rest2fCodeActivation' => {
            'type' => 'pcre'
        },
        'rest2fInitArgs' => {
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^\w+$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^\w+$/,
            'type'       => 'keyTextContainer'
        },
        'rest2fInitUrl' => {
            'type' => 'url'
        },
        'rest2fLabel' => {
            'type' => 'text'
        },
        'rest2fLogo' => {
            'type' => 'text'
        },
        'rest2fResendInterval' => {
            'type' => 'text'
        },
        'rest2fVerifyArgs' => {
            'type' => 'keyTextContainer'
        },
        'rest2fVerifyUrl' => {
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^\w+$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^\w+$/,
            'type'       => 'url'
        },
        'restAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'restAuthServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'restAuthUrl' => {
            'type' => 'url'
        },
        'restClockTolerance' => {
            'default' => 15,
            'type'    => 'int'
        },
        'restConfigServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'restExportSecretKeys' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'restFindUserDBUrl' => {
            'type' => 'url'
        },
        'restPasswordServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'restPwdConfirmUrl' => {
            'type' => 'url'
        },
        'restPwdModifyUrl' => {
            'type' => 'url'
        },
        'restSessionServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'restUserDBUrl' => {
            'type' => 'url'
        },
        'sameSite' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'Strict',
                    'v' => 'Strict'
                },
                {
                    'k' => 'Lax',
                    'v' => 'Lax'
                },
                {
                    'k' => 'None',
                    'v' => 'None'
                }
            ],
            'type' => 'select'
        },
        'samlAttributeAuthorityDescriptorAttributeServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/AA/SOAP;',
            'type' => 'samlService'
        },
        'samlAuthnContextMapExtra' => {
            'keyTest' => qr/\w/,
            'type'    => 'keyTextContainer'
        },
        'samlAuthnContextMapKerberos' => {
            'default' => 4,
            'type'    => 'int'
        },
        'samlAuthnContextMapPassword' => {
            'default' => 2,
            'type'    => 'int'
        },
        'samlAuthnContextMapPasswordProtectedTransport' => {
            'default' => 3,
            'type'    => 'int'
        },
        'samlAuthnContextMapTLSClient' => {
            'default' => 5,
            'type'    => 'int'
        },
        'samlCommonDomainCookieActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlCommonDomainCookieDomain' => {
            'msgFail' => '__badDomainName__',
            'test'    =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'type' => 'text'
        },
        'samlCommonDomainCookieReader' => {
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'samlCommonDomainCookieWriter' => {
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'samlDiscoveryProtocolActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlDiscoveryProtocolIsPassive' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlDiscoveryProtocolPolicy' => {
            'type' => 'text'
        },
        'samlDiscoveryProtocolURL' => {
            'msgFail' => '__badUrl__',
            'test'    =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'samlEntityID' => {
            'default' => '#PORTAL#/saml/metadata',
            'type'    => 'text'
        },
        'samlFederationFiles' => {
            'type' => 'text'
        },
        'samlIDPMetaDataExportedAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/\w/,
            'type'       => 'samlAttributeContainer'
        },
        'samlIDPMetaDataNodes' => {
            'type' => 'samlIDPMetaDataNodeContainer'
        },
        'samlIDPMetaDataOptions' => {
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'type'       => 'keyTextContainer'
        },
        'samlIDPMetaDataOptionsAdaptSessionUtime' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsAllowLoginFromIDP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckAudience' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckSLOMessageSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckSSOMessageSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckTime' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'samlIDPMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'samlIDPMetaDataOptionsEncryptionMode' => {
            'default' => 'none',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'nameid',
                    'v' => 'Name ID'
                },
                {
                    'k' => 'assertion',
                    'v' => 'Assertion'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsFederationEntityID' => {
            'type' => 'text'
        },
        'samlIDPMetaDataOptionsForceAuthn' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsForceUTF8' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'samlIDPMetaDataOptionsIsPassive' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsNameIDFormat' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'unspecified',
                    'v' => 'Unspecified'
                },
                {
                    'k' => 'email',
                    'v' => 'Email'
                },
                {
                    'k' => 'x509',
                    'v' => 'X509 certificate'
                },
                {
                    'k' => 'windows',
                    'v' => 'Windows'
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'entity',
                    'v' => 'Entity'
                },
                {
                    'k' => 'persistent',
                    'v' => 'Persistent'
                },
                {
                    'k' => 'transient',
                    'v' => 'Transient'
                },
                {
                    'k' => 'encrypted',
                    'v' => 'Encrypted'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsRelayStateURL' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsRequestedAuthnContext' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'password-protected-transport',
                    'v' => 'Password protected transport'
                },
                {
                    'k' => 'password',
                    'v' => 'Password'
                },
                {
                    'k' => 'tls-client',
                    'v' => 'TLS client certificate'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsResolutionRule' => {
            'default' => '',
            'type'    => 'longtext'
        },
        'samlIDPMetaDataOptionsSignatureKey' => {
            'default' => '',
            'type'    => 'text'
        },
        'samlIDPMetaDataOptionsSignatureMethod' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'default'
                },
                {
                    'k' => 'RSA_SHA1',
                    'v' => 'RSA SHA1'
                },
                {
                    'k' => 'RSA_SHA256',
                    'v' => 'RSA SHA256'
                },
                {
                    'k' => 'RSA_SHA384',
                    'v' => 'RSA SHA384'
                },
                {
                    'k' => 'RSA_SHA512',
                    'v' => 'RSA SHA512'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsSignSLOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlIDPMetaDataOptionsSignSSOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlIDPMetaDataOptionsSLOBinding' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'http-post',
                    'v' => 'POST'
                },
                {
                    'k' => 'http-redirect',
                    'v' => 'Redirect'
                },
                {
                    'k' => 'http-soap',
                    'v' => 'SOAP'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsSortNumber' => {
            'type' => 'int'
        },
        'samlIDPMetaDataOptionsSSOBinding' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'http-post',
                    'v' => 'POST'
                },
                {
                    'k' => 'http-redirect',
                    'v' => 'Redirect'
                },
                {
                    'k' => 'artifact-get',
                    'v' => 'Artifact GET'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsStoreSAMLToken' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsTooltip' => {
            'type' => 'text'
        },
        'samlIDPMetaDataOptionsURL' => {
            'type' => 'url'
        },
        'samlIDPMetaDataOptionsUserAttribute' => {
            'type' => 'text'
        },
        'samlIDPMetaDataXML' => {
            'type' => 'file'
        },
        'samlIDPSSODescriptorArtifactResolutionServiceArtifact' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/artifact',
            'type' => 'samlAssertion'
        },
        'samlIDPSSODescriptorSingleLogoutServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/singleLogout;#PORTAL#/saml/singleLogoutReturn',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleLogoutServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/singleLogout;#PORTAL#/saml/singleLogoutReturn',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleLogoutServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/singleLogoutSOAP;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPArtifact' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact;#PORTAL#/saml/singleSignOnArtifact;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/singleSignOn;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/singleSignOn;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorWantAuthnRequestsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlMetadataForceUTF8' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlNameIDFormatMapEmail' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'samlNameIDFormatMapKerberos' => {
            'default' => 'uid',
            'type'    => 'text'
        },
        'samlNameIDFormatMapWindows' => {
            'default' => 'uid',
            'type'    => 'text'
        },
        'samlNameIDFormatMapX509' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'samlOrganizationDisplayName' => {
            'default' => 'Example',
            'type'    => 'text'
        },
        'samlOrganizationName' => {
            'default' => 'Example',
            'type'    => 'text'
        },
        'samlOrganizationURL' => {
            'default' => 'http://www.example.com',
            'type'    => 'text'
        },
        'samlOverrideIDPEntityID' => {
            'default' => '',
            'type'    => 'text'
        },
        'samlRelayStateTimeout' => {
            'default' => 600,
            'type'    => 'int'
        },
        'samlServiceEncryptionKey' => {
            'default' => 'default-saml-enc',
            'type'    => 'text'
        },
        'samlServicePrivateKeyEnc' => {
            'default' => '',
            'type'    => 'RSAPrivateKey'
        },
        'samlServicePrivateKeyEncPwd' => {
            'type' => 'password'
        },
        'samlServicePrivateKeySig' => {
            'default' => '',
            'type'    => 'RSAPrivateKey'
        },
        'samlServicePrivateKeySigPwd' => {
            'default' => '',
            'type'    => 'password'
        },
        'samlServicePublicKeyEnc' => {
            'default' => '',
            'type'    => 'RSAPublicKeyOrCertificate'
        },
        'samlServicePublicKeySig' => {
            'default' => '',
            'type'    => 'RSAPublicKeyOrCertificate'
        },
        'samlServiceSignatureKey' => {
            'default' => 'default-saml-sig',
            'type'    => 'text'
        },
        'samlServiceSignatureMethod' => {
            'default' => 'RSA_SHA256',
            'select'  => [ {
                    'k' => 'RSA_SHA1',
                    'v' => 'RSA SHA1'
                },
                {
                    'k' => 'RSA_SHA256',
                    'v' => 'RSA SHA256'
                },
                {
                    'k' => 'RSA_SHA384',
                    'v' => 'RSA SHA384'
                },
                {
                    'k' => 'RSA_SHA512',
                    'v' => 'RSA SHA512'
                }
            ],
            'type' => 'select'
        },
        'samlServiceUseCertificateInResponse' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataExportedAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/\w/,
            'type'       => 'samlAttributeContainer'
        },
        'samlSPMetaDataMacros' => {
            'default' => {},
            'test'    => {
                'keyMsgFail' => '__badMacroName__',
                'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
                'test'       => sub {
                    return perlExpr(@_);
                }
            },
            'type' => 'keyTextContainer'
        },
        'samlSPMetaDataNodes' => {
            'type' => 'samlSPMetaDataNodeContainer'
        },
        'samlSPMetaDataOptions' => {
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'type'       => 'keyTextContainer'
        },
        'samlSPMetaDataOptionsAuthnLevel' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'samlSPMetaDataOptionsCheckSLOMessageSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsCheckSSOMessageSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsComment' => {
            'type' => 'longtext'
        },
        'samlSPMetaDataOptionsEnableIDPInitiatedURL' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsEncryptionMode' => {
            'default' => 'none',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'nameid',
                    'v' => 'Name ID'
                },
                {
                    'k' => 'assertion',
                    'v' => 'Assertion'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsFederationEntityID' => {
            'type' => 'text'
        },
        'samlSPMetaDataOptionsFederationOptionalAttributes' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'keep'
                },
                {
                    'k' => 'ignore',
                    'v' => 'ignore'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsFederationRequiredAttributes' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'keep'
                },
                {
                    'k' => 'optional',
                    'v' => 'makeoptional'
                },
                {
                    'k' => 'ignore',
                    'v' => 'ignore'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsForceUTF8' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsNameIDFormat' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'unspecified',
                    'v' => 'Unspecified'
                },
                {
                    'k' => 'email',
                    'v' => 'Email'
                },
                {
                    'k' => 'x509',
                    'v' => 'X509 certificate'
                },
                {
                    'k' => 'windows',
                    'v' => 'Windows'
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'entity',
                    'v' => 'Entity'
                },
                {
                    'k' => 'persistent',
                    'v' => 'Persistent'
                },
                {
                    'k' => 'transient',
                    'v' => 'Transient'
                },
                {
                    'k' => 'encrypted',
                    'v' => 'Encrypted'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsNameIDSessionKey' => {
            'type' => 'text'
        },
        'samlSPMetaDataOptionsNotOnOrAfterTimeout' => {
            'default' => 72000,
            'type'    => 'int'
        },
        'samlSPMetaDataOptionsOneTimeUse' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsRule' => {
            'test' => sub {
                return perlExpr(@_);
            },
            'type' => 'text'
        },
        'samlSPMetaDataOptionsSessionNotOnOrAfterTimeout' => {
            'default' => 72000,
            'type'    => 'int'
        },
        'samlSPMetaDataOptionsSignatureKey' => {
            'default' => '',
            'type'    => 'text'
        },
        'samlSPMetaDataOptionsSignatureMethod' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'default'
                },
                {
                    'k' => 'RSA_SHA1',
                    'v' => 'RSA SHA1'
                },
                {
                    'k' => 'RSA_SHA256',
                    'v' => 'RSA SHA256'
                },
                {
                    'k' => 'RSA_SHA384',
                    'v' => 'RSA SHA384'
                },
                {
                    'k' => 'RSA_SHA512',
                    'v' => 'RSA SHA512'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsSignSLOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlSPMetaDataOptionsSignSSOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlSPMetaDataOptionsURL' => {
            'type' => 'url'
        },
        'samlSPMetaDataXML' => {
            'type' => 'file'
        },
        'samlSPSSODescriptorArtifactResolutionServiceArtifact' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/artifact',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAssertionConsumerServiceHTTPArtifact' => {
            'default' =>
'0;1;urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact;#PORTAL#/saml/proxySingleSignOnArtifact',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAssertionConsumerServiceHTTPPost' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/proxySingleSignOnPost',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAuthnRequestsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPSSODescriptorSingleLogoutServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/proxySingleLogout;#PORTAL#/saml/proxySingleLogoutReturn',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorSingleLogoutServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/proxySingleLogout;#PORTAL#/saml/proxySingleLogoutReturn',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorSingleLogoutServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/proxySingleLogoutSOAP;',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorWantAssertionsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlStorage' => {
            'type' => 'PerlModule'
        },
        'samlStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'samlUseQueryStringSpecific' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'scrollTop' => {
            'default' => 400,
            'type'    => 'int'
        },
        'securedCookie' => {
            'default' => 0,
            'select'  => [ {
                    'k' => '0',
                    'v' => 'unsecuredCookie'
                },
                {
                    'k' => '1',
                    'v' => 'securedCookie'
                },
                {
                    'k' => '2',
                    'v' => 'doubleCookie'
                },
                {
                    'k' => '3',
                    'v' => 'doubleCookieForSingleSession'
                }
            ],
            'type' => 'select'
        },
        'secureTokenAllowOnError' => {
            'type' => 'text'
        },
        'secureTokenAttribute' => {
            'type' => 'text'
        },
        'secureTokenExpiration' => {
            'type' => 'text'
        },
        'secureTokenHeader' => {
            'type' => 'text'
        },
        'secureTokenMemcachedServers' => {
            'type' => 'text'
        },
        'secureTokenUrls' => {
            'type' => 'text'
        },
        'sentryDsn' => {
            'type' => 'text'
        },
        'sessionDataToRemember' => {
            'keyMsgFail' => '__invalidSessionData__',
            'keyTest'    => qr/^(\d+_)?[_a-zA-Z][a-zA-Z0-9_]*$/,
            'type'       => 'keyTextContainer'
        },
        'sfEngine' => {
            'default' => '::2F::Engines::Default',
            'type'    => 'text'
        },
        'sfExtra' => {
            'keyTest' => qr/^\w+$/,
            'select'  => [ {
                    'k' => 'Mail2F',
                    'v' => 'E-Mail'
                },
                {
                    'k' => 'REST',
                    'v' => 'REST'
                },
                {
                    'k' => 'Ext2F',
                    'v' => 'External'
                },
                {
                    'k' => 'Radius',
                    'v' => 'Radius'
                }
            ],
            'test' => sub {
                1;
            },
            'type' => 'sfExtraContainer'
        },
        'sfLoginTimeout' => {
            'type' => 'intOrNull'
        },
        'sfManagerRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'sfOnlyUpgrade' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'sfRegisterTimeout' => {
            'type' => 'intOrNull'
        },
        'sfRemovedMsgRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'sfRemovedNotifMsg' => {
            'default' =>
'_removedSF_ expired second factor(s) has/have been removed (_nameSF_)!',
            'type' => 'text'
        },
        'sfRemovedNotifRef' => {
            'default' => 'RemoveSF',
            'type'    => 'text'
        },
        'sfRemovedNotifTitle' => {
            'default' => 'Second factor notification',
            'type'    => 'text'
        },
        'sfRemovedUseNotif' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'sfRequired' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'sfRetries' => {
            'type' => 'intOrNull'
        },
        'showLanguages' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'singleIP' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'singleSession' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'singleUserByIP' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'skipRenewConfirmation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'skipUpgradeConfirmation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'slaveAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'slaveDisplayLogo' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'slaveExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'slaveHeaderContent' => {
            'type' => 'text'
        },
        'slaveHeaderName' => {
            'type' => 'text'
        },
        'slaveMasterIP' => {
            'msgFail' => '__badIPv4Address__',
            'test'    => qr/^((?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)\s*)*$/,
            'type'    => 'text'
        },
        'slaveUserHeader' => {
            'type' => 'text'
        },
        'SMTPAuthPass' => {
            'type' => 'password'
        },
        'SMTPAuthUser' => {
            'type' => 'text'
        },
        'SMTPPort' => {
            'type' => 'int'
        },
        'SMTPServer' => {
            'default' => '',
            'test'    =>
qr/^(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+))(?::\d+)?)?$/,
            'type' => 'text'
        },
        'SMTPTLS' => {
            'default' => '',
            'select'  => [ {
                    'k' => '',
                    'v' => 'none'
                },
                {
                    'k' => 'starttls',
                    'v' => 'SMTP + STARTTLS'
                },
                {
                    'k' => 'ssl',
                    'v' => 'SMTPS'
                }
            ],
            'type' => 'select'
        },
        'SMTPTLSOpts' => {
            'type' => 'keyTextContainer'
        },
        'soapConfigServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'soapProxyUrn' => {
            'default' => 'urn:Lemonldap/NG/Common/PSGI/SOAPService',
            'type'    => 'text'
        },
        'soapSessionServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'SSLAuthnLevel' => {
            'default' => 5,
            'type'    => 'int'
        },
        'sslByAjax' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'sslHost' => {
            'type' => 'url'
        },
        'SSLIssuerVar' => {
            'default' => 'SSL_CLIENT_I_DN',
            'type'    => 'text'
        },
        'SSLVar' => {
            'default' => 'SSL_CLIENT_S_DN_Email',
            'type'    => 'text'
        },
        'SSLVarIf' => {
            'default' => {},
            'keyTest' => sub {
                1;
            },
            'type' => 'keyTextContainer'
        },
        'staticPrefix' => {
            'type' => 'text'
        },
        'statusQueueName' => {
            'default' => 'llng_status',
            'type'    => 'text'
        },
        'stayConnected' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'stayConnectedBypassFG' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'stayConnectedCookieName' => {
            'default' => 'llngconnection',
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'stayConnectedSingleSession' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'stayConnectedTimeout' => {
            'default' => 2592000,
            'type'    => 'int'
        },
        'storePassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'storePasswordEncrypted' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'strictTransportSecurityMax_Age' => {
            'type' => 'text'
        },
        'successLoginNumber' => {
            'default' => 5,
            'type'    => 'int'
        },
        'syslogFacility' => {
            'type' => 'text'
        },
        'syslogSockOptions' => {
            'keyTest' => qr/^(?:type|path|timeout|host|port)$/,
            'type'    => 'keyTextContainer'
        },
        'timeout' => {
            'default' => 72000,
            'test'    => sub {
                $_[0] > 0;
            },
            'type' => 'int'
        },
        'timeoutActivity' => {
            'default' => 0,
            'test'    => sub {
                $_[0] >= 0;
            },
            'type' => 'int'
        },
        'timeoutActivityInterval' => {
            'default' => 60,
            'test'    => sub {
                $_[0] >= 0;
            },
            'type' => 'int'
        },
        'tokenUseGlobalStorage' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'totp2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'totp2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'totp2fDigits' => {
            'default' => 6,
            'type'    => 'int'
        },
        'totp2fEncryptSecret' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'totp2fInterval' => {
            'default' => 30,
            'type'    => 'int'
        },
        'totp2fIssuer' => {
            'type' => 'text'
        },
        'totp2fLabel' => {
            'type' => 'text'
        },
        'totp2fLogo' => {
            'type' => 'text'
        },
        'totp2fRange' => {
            'default' => 1,
            'type'    => 'int'
        },
        'totp2fSelfRegistration' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'totp2fTTL' => {
            'type' => 'intOrNull'
        },
        'totp2fUserCanRemoveKey' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'trustedBrowserRule' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'trustedBrowserUseTotp' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'trustedDomains' => {
            'type' => 'text'
        },
        'twitterAppName' => {
            'type' => 'text'
        },
        'twitterAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'twitterKey' => {
            'type' => 'text'
        },
        'twitterSecret' => {
            'type' => 'text'
        },
        'twitterUserField' => {
            'default' => 'screen_name',
            'type'    => 'text'
        },
        'upgradeSession' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'userControl' => {
            'default' => '^[\\w\\.\\-@]+$',
            'type'    => 'pcre'
        },
        'userDB' => {
            'default' => 'Same',
            'select'  => [ {
                    'k' => 'Same',
                    'v' => 'Same'
                },
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'REST',
                    'v' => 'REST'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'Custom',
                    'v' => 'customModule'
                }
            ],
            'type' => 'select'
        },
        'useRedirectAjaxOnUnauthorized' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'useRedirectOnError' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'useRedirectOnForbidden' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'userLogger' => {
            'type' => 'text'
        },
        'userPivot' => {
            'type' => 'text'
        },
        'userSyslogFacility' => {
            'type' => 'text'
        },
        'useSafeJail' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'vhostAccessToTrace' => {
            'default' => '',
            'type'    => 'text'
        },
        'vhostAliases' => {
            'default' => '',
            'type'    => 'text'
        },
        'vhostAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'vhostComment' => {
            'default' => '',
            'type'    => 'longtext'
        },
        'vhostDevOpsRulesUrl' => {
            'type' => 'url'
        },
        'vhostHttps' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'vhostMaintenance' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'vhostOptions' => {
            'type' => 'subContainer'
        },
        'vhostPort' => {
            'default' => -1,
            'type'    => 'int'
        },
        'vhostServiceTokenTTL' => {
            'default' => -1,
            'type'    => 'int'
        },
        'vhostType' => {
            'default' => 'Main',
            'select'  => [ {
                    'k' => 'AuthBasic',
                    'v' => 'AuthBasic'
                },
                {
                    'k' => 'CDA',
                    'v' => 'CDA'
                },
                {
                    'k' => 'DevOps',
                    'v' => 'DevOps'
                },
                {
                    'k' => 'DevOpsST',
                    'v' => 'DevOpsST'
                },
                {
                    'k' => 'DevOpsCDA',
                    'v' => 'DevOpsCDA'
                },
                {
                    'k' => 'Main',
                    'v' => 'Main'
                },
                {
                    'k' => 'OAuth2',
                    'v' => 'OAuth2'
                },
                {
                    'k' => 'SecureToken',
                    'v' => 'SecureToken'
                },
                {
                    'k' => 'ServiceToken',
                    'v' => 'ServiceToken'
                },
                {
                    'k' => 'ZimbraPreAuth',
                    'v' => 'ZimbraPreAuth'
                }
            ],
            'type' => 'select'
        },
        'viewerAllowBrowser' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'viewerAllowDiff' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'viewerHiddenKeys' => {
            'default' => 'samlIDPMetaDataNodes, samlSPMetaDataNodes',
            'type'    => 'text'
        },
        'virtualHosts' => {
            'type' => 'virtualHostContainer'
        },
        'webauthn2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'webauthn2fAttestation' => {
            'default' => 'none',
            'select'  => [ {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'direct',
                    'v' => 'Direct'
                },
                {
                    'k' => 'indirect',
                    'v' => 'Indirect'
                },
                {
                    'k' => 'enterprise',
                    'v' => 'Enterprise'
                }
            ],
            'type' => 'select'
        },
        'webauthn2fAttestationTrust' => {
            'type' => 'file'
        },
        'webauthn2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'webauthn2fLabel' => {
            'type' => 'text'
        },
        'webauthn2fLogo' => {
            'type' => 'text'
        },
        'webauthn2fResidentKey' => {
            'select' => [ {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'discouraged',
                    'v' => 'Discouraged'
                },
                {
                    'k' => 'preferred',
                    'v' => 'Preferred'
                },
                {
                    'k' => 'required',
                    'v' => 'Required'
                }
            ],
            'type' => 'select'
        },
        'webauthn2fSelfRegistration' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'webauthn2fUserCanRemoveKey' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'webauthn2fUserVerification' => {
            'default' => 'preferred',
            'select'  => [ {
                    'k' => 'discouraged',
                    'v' => 'Discouraged'
                },
                {
                    'k' => 'preferred',
                    'v' => 'Preferred'
                },
                {
                    'k' => 'required',
                    'v' => 'Required'
                }
            ],
            'type' => 'select'
        },
        'webauthnAppId' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'webauthnAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'webauthnDefaultTransports' => {
            'type' => 'text'
        },
        'webauthnDisplayNameAttr' => {
            'type' => 'text'
        },
        'webauthnRpId' => {
            'type' => 'text'
        },
        'webauthnRpName' => {
            'type' => 'text'
        },
        'webCronSecret' => {
            'type' => 'text'
        },
        'webIDAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'webIDExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'webIDWhitelist' => {
            'type' => 'text'
        },
        'whatToTrace' => {
            'default' => 'uid',
            'type'    => 'lmAttrOrMacro'
        },
        'wsdlServer' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'yubikey2fActivation' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'yubikey2fAuthnLevel' => {
            'type' => 'intOrNull'
        },
        'yubikey2fClientID' => {
            'type' => 'text'
        },
        'yubikey2fFromSessionAttribute' => {
            'type' => 'text'
        },
        'yubikey2fLabel' => {
            'type' => 'text'
        },
        'yubikey2fLogo' => {
            'type' => 'text'
        },
        'yubikey2fNonce' => {
            'type' => 'text'
        },
        'yubikey2fPublicIDSize' => {
            'default' => 12,
            'type'    => 'int'
        },
        'yubikey2fSecretKey' => {
            'type' => 'text'
        },
        'yubikey2fSelfRegistration' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'yubikey2fTTL' => {
            'type' => 'intOrNull'
        },
        'yubikey2fUrl' => {
            'type' => 'url'
        },
        'yubikey2fUserCanRemoveKey' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'zimbraAccountKey' => {
            'type' => 'text'
        },
        'zimbraBy' => {
            'type' => 'text'
        },
        'zimbraPreAuthKey' => {
            'type' => 'text'
        },
        'zimbraSsoUrl' => {
            'type' => 'text'
        },
        'zimbraUrl' => {
            'type' => 'text'
        }
    };
}

