# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::SM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191017;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[89]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[5-7]',
                  'pattern' => '(\\d{2})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'pattern' => '(\\d{4})(\\d{6})'
                }
              ];

my $validators = {
                'fixed_line' => '
          0549(?:
            8[0157-9]|
            9\\d
          )\\d{4}
        ',
                'geographic' => '
          0549(?:
            8[0157-9]|
            9\\d
          )\\d{4}
        ',
                'mobile' => '6[16]\\d{6}',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(7[178]\\d{6})',
                'toll_free' => '',
                'voip' => '5[158]\\d{6}'
              };
my $timezones = {
               '' => [
                       'Europe/San_Marino'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+378|\D)//g;
      my $self = bless({ country_code => '378', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, }, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:([89]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/0549$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '378', number => $number, formatters => $formatters, validators => $validators, }, $class);
      return $self->is_valid() ? $self : undef;
    }
1;