/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@TitleProperty(name="code")
@XmlType(name="RS_Identifier_Type", propOrder={"authority", "code", "codeSpace", "version"})
@XmlRootElement(name="RS_Identifier")
public class ImmutableIdentifier
extends FormattableObject
implements ReferenceIdentifier,
Serializable {
    private static final long serialVersionUID = -7681717592582493409L;
    public static final String DESCRIPTION_KEY = "description";
    @XmlElement(required=true)
    private final Citation authority;
    @XmlElement(required=true)
    private final String code;
    @XmlElement(required=true)
    private final String codeSpace;
    @XmlElement
    private final String version;
    private final InternationalString description;

    public ImmutableIdentifier(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("identifier", referenceIdentifier);
        this.code = referenceIdentifier.getCode();
        this.codeSpace = referenceIdentifier.getCodeSpace();
        this.authority = referenceIdentifier.getAuthority();
        this.version = referenceIdentifier.getVersion();
        this.description = referenceIdentifier instanceof DefaultIdentifier ? ((DefaultIdentifier)((Object)referenceIdentifier)).getDescription() : null;
        this.validate(null);
    }

    public ImmutableIdentifier(Citation citation, String string, String string2) {
        this(citation, string, string2, null, null);
    }

    public ImmutableIdentifier(Citation citation, String string, String string2, String string3, InternationalString internationalString) {
        this.code = string2;
        this.codeSpace = string;
        this.authority = citation;
        this.version = string3;
        this.description = internationalString;
        this.validate(null);
    }

    public ImmutableIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("properties", map);
        this.code = CharSequences.trimWhitespaces(Containers.property(map, "code", String.class));
        this.version = CharSequences.trimWhitespaces(Containers.property(map, "version", String.class));
        this.description = Types.toInternationalString(map, DESCRIPTION_KEY);
        Object obj = map.get("authority");
        if (obj instanceof String) {
            this.authority = Citations.fromName((String)obj);
        } else if (obj == null || obj instanceof Citation) {
            this.authority = (Citation)obj;
        } else {
            throw ImmutableIdentifier.illegalPropertyType(map, "authority", obj);
        }
        obj = map.get("codespace");
        if (obj == null) {
            this.codeSpace = Citations.getCodeSpace(this.authority);
        } else if (obj instanceof String) {
            this.codeSpace = CharSequences.trimWhitespaces((String)obj);
        } else {
            throw ImmutableIdentifier.illegalPropertyType(map, "codespace", obj);
        }
        this.validate(map);
    }

    private void validate(Map<String, ?> map) {
        if (this.code == null || this.code.isEmpty()) {
            throw new IllegalArgumentException(Errors.getResources(map).getString(this.code == null ? (short)89 : 32, "code"));
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, object.getClass()));
    }

    public static ImmutableIdentifier castOrCopy(ReferenceIdentifier referenceIdentifier) {
        if (referenceIdentifier == null || referenceIdentifier instanceof ImmutableIdentifier) {
            return (ImmutableIdentifier)referenceIdentifier;
        }
        return new ImmutableIdentifier(referenceIdentifier);
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codeSpace;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public int hashCode() {
        int n = -1925158113;
        if (this.code != null) {
            n ^= this.code.hashCode();
        }
        if (this.codeSpace != null) {
            n = n * 31 + this.codeSpace.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            ImmutableIdentifier immutableIdentifier = (ImmutableIdentifier)object;
            return Objects.equals(this.code, immutableIdentifier.code) && Objects.equals(this.codeSpace, immutableIdentifier.codeSpace) && Objects.equals(this.authority, immutableIdentifier.authority) && Objects.equals(this.version, immutableIdentifier.version) && Objects.equals(this.description, immutableIdentifier.description);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String string = null;
        String string2 = this.getCode();
        if (string2 != null) {
            String string3;
            String string4 = this.getCodeSpace();
            Citation citation = this.getAuthority();
            String string5 = string3 = string4 != null ? string4 : org.apache.sis.internal.util.Citations.getIdentifier(citation, true);
            if (string3 != null) {
                Convention convention = formatter.getConvention();
                if (convention.majorVersion() == 1) {
                    string = "Authority";
                    formatter.append(string3, ElementKind.IDENTIFIER);
                    formatter.append(string2, ElementKind.IDENTIFIER);
                } else {
                    String string6;
                    boolean bl;
                    string = "Id";
                    formatter.append(string3, ElementKind.IDENTIFIER);
                    ImmutableIdentifier.appendCode(formatter, string2);
                    String string7 = this.getVersion();
                    if (string7 != null) {
                        ImmutableIdentifier.appendCode(formatter, string7);
                    }
                    FormattableObject formattableObject = formatter.getEnclosingElement(1);
                    boolean bl2 = bl = formatter.getEnclosingElement(2) == null;
                    if (!(!bl && formattableObject instanceof ParameterValue || (string6 = org.apache.sis.internal.util.Citations.getIdentifier(citation, false)) == null || string6.equals(string3))) {
                        formatter.append(new Cite(string6));
                    }
                    if (bl && formattableObject != null && convention != Convention.INTERNAL && (string6 = NameMeaning.toURN(formattableObject.getClass(), string3, string7, string2)) != null) {
                        formatter.append(new FormattableObject(){

                            @Override
                            protected String formatTo(Formatter formatter) {
                                formatter.append(string6, null);
                                return "URI";
                            }
                        });
                    }
                }
            }
        }
        return string;
    }

    private static void appendCode(Formatter formatter, String string) {
        if (string != null) {
            long l;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                formatter.append(string, ElementKind.IDENTIFIER);
                return;
            }
            formatter.append(l);
        }
    }

    private ImmutableIdentifier() {
        this.code = null;
        this.codeSpace = null;
        this.authority = null;
        this.version = null;
        this.description = null;
    }

    private static final class Cite
    extends FormattableObject {
        private final String identifier;

        Cite(String string) {
            this.identifier = string;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.identifier, ElementKind.CITATION);
            return "Citation";
        }
    }
}

