/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.jaxb.gmd.CodeListUID;
import org.apache.sis.internal.jaxb.gmd.Country;
import org.apache.sis.internal.jaxb.gmd.LanguageCode;
import org.apache.sis.internal.jaxb.gmd.PT_FreeText;
import org.apache.sis.internal.jaxb.gmx.Anchor;
import org.apache.sis.internal.jaxb.gmx.FileName;
import org.apache.sis.internal.jaxb.gmx.MimeFileType;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;

@XmlType(name="CharacterString_PropertyType")
@XmlSeeAlso(value={PT_FreeText.class, LanguageCode.class, Country.class})
public class GO_CharacterString {
    public static final byte MIME_TYPE = 1;
    public static final byte FILENAME = 2;
    private static final byte ANCHOR = 3;
    private static final byte ENUM = 4;
    private CharSequence text;
    public byte type;

    private static String nameOf(byte by) {
        switch (by) {
            case 0: {
                return "CharacterString";
            }
            case 1: {
                return "MimeFileType";
            }
            case 2: {
                return "FileName";
            }
            case 3: {
                return "Anchor";
            }
            case 4: {
                return "ControlledVocabulary";
            }
        }
        throw new AssertionError(by);
    }

    protected GO_CharacterString() {
    }

    protected GO_CharacterString(CharSequence charSequence) {
        this.text = charSequence;
        if (charSequence instanceof Anchor) {
            this.type = (byte)3;
        } else if (Types.forCodeTitle(charSequence) != null) {
            this.type = (byte)4;
        }
    }

    private void setText(CharSequence charSequence, byte by) {
        if ((charSequence = CharSequences.trimWhitespaces(charSequence)) != null && charSequence.length() != 0) {
            if (this.text != null && !charSequence.equals(this.text)) {
                byte by2 = this.type;
                boolean bl = false;
                if (by2 > by) {
                    by2 = by;
                    by = this.type;
                    bl = true;
                }
                Context.warningOccured(Context.current(), this.getClass(), "setText", Messages.class, (short)19, GO_CharacterString.nameOf(by2), GO_CharacterString.nameOf(by));
                if (bl) {
                    return;
                }
            }
            this.text = charSequence;
            this.type = by;
        }
    }

    @XmlElements(value={@XmlElement(type=String.class, name="CharacterString"), @XmlElement(type=Anchor.class, name="Anchor", namespace="http://www.isotc211.org/2005/gmx"), @XmlElement(type=FileName.class, name="FileName", namespace="http://www.isotc211.org/2005/gmx"), @XmlElement(type=MimeFileType.class, name="MimeFileType", namespace="http://www.isotc211.org/2005/gmx")})
    private Object getValue() {
        switch (this.type) {
            case 0: {
                return StringAdapter.toString(this.text);
            }
            case 2: {
                return new FileName(this.text.toString());
            }
            case 1: {
                return new MimeFileType(this.text.toString());
            }
            case 3: {
                return this.text;
            }
        }
        return null;
    }

    private void setValue(Object object) {
        if (object instanceof Anchor) {
            this.setText((Anchor)object, (byte)3);
        } else if (object instanceof FileName) {
            this.setText(object.toString(), (byte)2);
        } else if (object instanceof MimeFileType) {
            this.setText(object.toString(), (byte)1);
        } else {
            this.setText((CharSequence)object, (byte)0);
        }
    }

    @XmlAnyElement
    private Object getCodeList() {
        if (this.type != 4) {
            return null;
        }
        CodeList<?> codeList = Types.forCodeTitle(this.text);
        String string = Types.getListName(codeList);
        String string2 = string.startsWith("MD_") || string.startsWith("CI_") || string.startsWith("DS_") ? "http://www.isotc211.org/2005/gmd" : (string.startsWith("MI_") ? "http://www.isotc211.org/2005/gmi" : (string.startsWith("SV_") || string.equals("DCPList") ? "http://www.isotc211.org/2005/srv" : (string.startsWith("CS_") || string.startsWith("CD_") || string.startsWith("SC_") ? "http://www.opengis.net/gml/3.2" : "")));
        return new JAXBElement<CodeListUID>(new QName(string2, string), CodeListUID.class, new CodeListUID(Context.current(), codeList));
    }

    private void setCodeList(Object object) {
        Element element = (Element)object;
        if (element.getNodeType() == 1) {
            String string;
            Class<?> clazz = Types.forStandardName(element.getLocalName());
            if (clazz != null && CodeList.class.isAssignableFrom(clazz) && !(string = element.getAttribute("codeListValue")).isEmpty()) {
                this.text = Types.getCodeTitle(Types.forCodeName(clazz, string, true));
                this.type = (byte)4;
                return;
            }
            Context.warningOccured(Context.current(), GO_CharacterString.class, "setCodeList", Errors.class, (short)149, element.getNodeName());
        }
    }

    protected CharSequence toCharSequence() {
        CharSequence charSequence = CharSequences.trimWhitespaces(this.text);
        if (charSequence != null && (charSequence.length() != 0 || charSequence instanceof Anchor)) {
            return charSequence;
        }
        return null;
    }

    public final String toString() {
        CharSequence charSequence = this.text;
        return charSequence != null ? charSequence.toString() : null;
    }
}

