/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.webvtt.sampleboxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.util.CastUtils;
import com.mp4parser.streaming.WriteOnlyBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractCueBox
extends WriteOnlyBox {
    String content = "";

    public AbstractCueBox(String type) {
        super(type);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public long getSize() {
        return 8 + Utf8.utf8StringLengthInBytes(this.content);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
        IsoTypeWriter.writeUInt32(header, this.getSize());
        header.put(IsoFile.fourCCtoBytes(this.getType()));
        header.put(Utf8.convert(this.content));
        writableByteChannel.write((ByteBuffer)header.rewind());
    }
}

