#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More;

plan skip_all => "Disabled" if $ENV{NO_JIRA_CHECK};

my @commits = split /\n/, <<'EOC';
84aaa9f6 (sandbox/master, origin/master, origin/HEAD, dagolden/master) PERL-1120 CI: Only test ZAP platforms on 4.0+
f5ab951a PERL-1105: Finer-grained updates from aggregation via $merge
f113a26b PERL-1025: Retryable Reads
94f238be PERL-1085 Document connection string options precedence
361bea09 PERL-1082: Add the ability to specify a pipeline to an update command
be174a63 PERL-1028: Connections survive primary stepdown
e5a5f4ac (shadowcat/staging) PERL-1117: Specify effect of client-side errors on transactions
607a814e PERL-1109: Fix result assertion in change stream test
2e93556a PERL-1112: Update change stream docs example
97d62011 PERL-1051: Bugfix startAfter support
0c5b62e1 PERL-1070: Support postBatchResumeToken in change streams
70ff6fff PERL-1097: Discard ServerSessions involved in network errors
08b65478 PERL-1022: Implement Convenient API for Transactions
229083e3 PERL-1102: CI: Update Perl Toolchain versions
ac873557 PERL-1107 CI: Add MongoDB 4.2 test tasks
fcb36c21 PERL-1076: Ensure that getMore right after resume is retried
f30a83d0 PERL-1098: Allow applications to set maxTimeMS for commitTransaction
0aca0396 PERL-1035: Support sharded transactions recovery token
ff9554f7 PERL-1087: Use runOn syntax
3de3e474 PERL-1090: Update change-stream tests
68f986ea PERL-1096: ChangeStream spec's Resumable Error
28336beb (auth-spec-tests) PERL-1021 Make invalid URI values warn instead of throw
7ec8edf6 PERL-1100 Connection string spec update
4348ca75 PERL-1101 Docs for count_documents must mention estimated_document_count
08aef14f PERL-1074: Resync transaction spec tests for bulk write error reporting change
4adfbe14 PERL-1057: use majority write concern when retrying commitTransaction
c491d54c PERL-1083: Work around StaleDbVersion distinct bug
d8337562 PERL-1048: Use primary preference and local concern for reading outcome
e73e9d55 PERL-1024: Support mongos pinning for sharded transactions
5694af88 PERL-1017: Ignore db and collection read concern in transaction
4c805d0e PERL-1095 Stop testing or supporting Perl threads
5866cd19 PERL-1068 Support Retryable Writes on by Default
c978d867 PERL-1018 Prep delete/updateMany retryWrites tests
905d4223 (shadowcat/master) PERL-1078 count_documents should use group with _id: 1
20620078 PERL-1052: Support 'startAfter' option
c6ef8439 PERL-1026: Support polling SRV records for mongos discovery
1d03fbd2 PERL-989: Implement SDAM Monitoring spec
76604a56 PERL-1075: Add support for read concern to Aggregation $out
80e847c1 PERL-1056: Update transaction examples
1a77cf77 PERL-1060: Make Compress::Snappy dependency optional
b53e883f PERL-1060: Add support for Snappy compression
53b45ef1 PERL-1053: Make Compress::Zstd dependency optional
80c60e40 PERL-1053: Add support for Zstandard compression
52bc25bd PERL-1054: Disable TLS renegotiation when possible
e4d2f711 PERL-1021: Stop double normalization of boolean options
a32de587 PERL-1021: Implement Unified URI Options
4cdc9cbf PERL-1051: use transaction spec test format
5ffa17ec PERL-1058: Ignore batchSize=0 for aggregate with $out

EOC

my %ticket_map;
for my $commit ( @commits ) {
    next if $commit =~ /PERL-\d+:?\s+CI:/i;
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}

done_testing();
