package Daje;
use Mojo::Base 'Mojolicious', -signatures;

# NAME
# ====
#
# Daje - is a Mojolicious server serving Daje stuff
#
#
#
# SYNOPSIS
# ========
#
#    use Daje;
#
# DESCRIPTION
# ===========
#
# Daje is a web server
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
use Cwd;
#use Daje::Tools::JWT;
use Mojo::Pg;

our $VERSION = "0.07";
# $ENV{DAJE_HOME} = '/home/jan/Project/Daje/'
#     unless $ENV{DAJE_HOME};

has home => sub {
  Mojo::Home->new(cwd);
};

# This method will run once at server start
sub startup ($self) {

  # Load configuration from config file
  my $logfile = $self->home() . "/../config/config.conf";
  say $logfile;
  say cwd;

  my $config = $self->plugin('Config',{file => $logfile});
  $self->log->path($self->home() . $self->config('log'));
  $self->log->level($self->config('loglevel'));

  $self->log->debug("Test");
  $self->helper(pg => sub {state $pg = Mojo::Pg->new->dsn(shift->config('pg'))});
  say $self->pg->db->query('select version() as version')->hash->{version};
  $self->log->debug($self->pg->db->query('select version() as version')->hash->{version});

  $self->plugin('Daje::Plugin::Apploader');
  # Configure the application
  $self->secrets($config->{secrets});

}

1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje - is a Mojolicious server serving Daje stuff





=head1 SYNOPSIS


   use Daje;



=head1 DESCRIPTION


Daje is a web server




=head1 REQUIRES

L<Mojo::Pg> 

L<Cwd> 

L<Mojo::Base> 


=head1 METHODS

=head2 startup

 startup();

This method will run once at server start



=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

