/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgish.upload;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jolokia.osgish.upload.UploadStoreMBean;

public class UploadStore
implements UploadStoreMBean,
MBeanRegistration {
    File dataDir;
    private static final String UPLOAD_STORE_NAME = "osgish:type=Upload";

    public UploadStore(File pDataDir) {
        this.dataDir = pDataDir;
        if (!this.dataDir.exists()) {
            throw new IllegalArgumentException("No data directory " + this.dataDir.getAbsolutePath() + " found");
        }
        if (!this.dataDir.isDirectory()) {
            throw new IllegalArgumentException(this.dataDir.getAbsolutePath() + " is not a directory");
        }
    }

    public Map listUploadDirectory() {
        File[] files = this.dataDir.listFiles();
        HashMap<String, File> ret = new HashMap<String, File>();
        for (File file : files) {
            ret.put(file.getName(), file);
        }
        return ret;
    }

    public String deleteFile(String pFilename) {
        if (pFilename == null) {
            return "No filename given";
        }
        if (pFilename.startsWith("/")) {
            return "Path " + pFilename + " must not be an absolute path";
        }
        File dir = this.dataDir;
        String[] parts = pFilename.split("/");
        String last = parts[parts.length - 1];
        for (int i = 0; i < parts.length - 1; ++i) {
            if ((dir = new File(dir, parts[i])).isDirectory()) continue;
            return dir.getPath() + " is not a directory";
        }
        File file = new File(dir, last);
        if (!file.exists()) {
            return file.getName() + ": No such file";
        }
        if (!file.delete()) {
            return "Could not delete file " + file.getName();
        }
        return null;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(UPLOAD_STORE_NAME);
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

