/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UMotif;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class GraphicsPath {
    private final String path;
    private final ColorMapper colorMapper;

    public GraphicsPath(ColorMapper colorMapper, String string) {
        this.path = string;
        this.colorMapper = colorMapper;
    }

    public ImageData writeImage(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.createImage();
        PngIO.write((RenderedImage)bufferedImage, outputStream, 96);
        return new ImageDataSimple(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private BufferedImage createImage() {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(50, 50, Color.WHITE);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(this.colorMapper, graphics2D, 1.0);
        uGraphicG2d.setBufferedImage(bufferedImage);
        UMotif uMotif = new UMotif(this.path);
        uMotif.drawHorizontal(uGraphicG2d.apply(new UChangeColor(HtmlColorUtils.BLACK)), 20.0, 20.0, 1);
        graphics2D.dispose();
        return bufferedImage;
    }
}

