/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.tree.wrapper.WrappingFunction;
import net.sf.saxon.tree.wrapper.WrappingIterator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class SpaceStrippedNode
extends AbstractVirtualNode
implements WrappingFunction {
    protected SpaceStrippedNode() {
    }

    protected SpaceStrippedNode(NodeInfo node, SpaceStrippedNode parent) {
        this.node = node;
        this.parent = parent;
    }

    protected static SpaceStrippedNode makeWrapper(NodeInfo node, SpaceStrippedDocument docWrapper, SpaceStrippedNode parent) {
        SpaceStrippedNode wrapper = new SpaceStrippedNode(node, parent);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public VirtualNode makeWrapper(NodeInfo node, VirtualNode parent) {
        SpaceStrippedNode wrapper = new SpaceStrippedNode(node, (SpaceStrippedNode)parent);
        wrapper.docWrapper = this.docWrapper;
        return wrapper;
    }

    public Value atomize() throws XPathException {
        Value baseVal = this.node.atomize();
        if (baseVal instanceof StringValue) {
            int primitiveType = ((StringValue)baseVal).getTypeLabel().getPrimitiveType();
            switch (primitiveType) {
                case 513: {
                    return new StringValue(this.getStringValueCS());
                }
                case 529: {
                    return new AnyURIValue(this.getStringValueCS());
                }
            }
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        return baseVal;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof SpaceStrippedNode) {
            return this.node.isSameNodeInfo(((SpaceStrippedNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof SpaceStrippedNode) {
            return this.node.compareOrder(((SpaceStrippedNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    public CharSequence getStringValueCS() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                Object it;
                AxisIterator iter = this.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(3));
                FastStringBuffer sb = new FastStringBuffer(64);
                while ((it = iter.next()) != null) {
                    sb.append(it.getStringValueCS());
                }
                return sb.condense();
            }
        }
        return this.node.getStringValueCS();
    }

    public NodeInfo getParent() {
        NodeInfo realParent;
        if (this.parent == null && (realParent = this.node.getParent()) != null) {
            this.parent = SpaceStrippedNode.makeWrapper(realParent, (SpaceStrippedDocument)this.docWrapper, null);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 2: 
            case 8: {
                return new WrappingIterator(this.node.iterateAxis(axisNumber), this, this);
            }
            case 3: {
                return new StrippingIterator(this.node.iterateAxis(axisNumber), this);
            }
            case 7: 
            case 11: {
                SpaceStrippedNode parent = (SpaceStrippedNode)this.getParent();
                if (parent == null) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return new StrippingIterator(this.node.iterateAxis(axisNumber), parent);
            }
        }
        return new StrippingIterator(this.node.iterateAxis(axisNumber), null);
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Stripper stripper = new Stripper(((SpaceStrippedDocument)this.docWrapper).getStrippingRule(), out);
        this.node.copy(stripper, copyOptions, locationId);
    }

    private final class StrippingIterator
    implements AxisIterator {
        AxisIterator base;
        SpaceStrippedNode parent;
        NodeInfo currentVirtualNode;
        int position;

        public StrippingIterator(AxisIterator base, SpaceStrippedNode parent) {
            this.base = base;
            this.parent = parent;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public NodeInfo next() {
            Object nextRealNode;
            do {
                if ((nextRealNode = this.base.next()) != null) continue;
                return null;
            } while (!this.isPreserved((NodeInfo)nextRealNode));
            this.currentVirtualNode = SpaceStrippedNode.makeWrapper(nextRealNode, (SpaceStrippedDocument)SpaceStrippedNode.this.docWrapper, this.parent);
            ++this.position;
            return this.currentVirtualNode;
        }

        private boolean isPreserved(NodeInfo nextRealNode) {
            NodeInfo actualParent;
            if (nextRealNode.getNodeKind() != 3) {
                return true;
            }
            if (!Whitespace.isWhite(nextRealNode.getStringValueCS())) {
                return true;
            }
            NodeInfo nodeInfo = actualParent = this.parent == null ? nextRealNode.getParent() : this.parent.node;
            if (((SpaceStrippedDocument)SpaceStrippedNode.this.docWrapper).containsPreserveSpace()) {
                NodeInfo p = actualParent;
                while (p.getNodeKind() == 1) {
                    String val = p.getAttributeValue(386);
                    if (val != null) {
                        if ("preserve".equals(val)) {
                            return true;
                        }
                        if ("default".equals(val)) break;
                    }
                    p = p.getParent();
                }
            }
            try {
                byte preserve = ((SpaceStrippedDocument)SpaceStrippedNode.this.docWrapper).getStrippingRule().isSpacePreserving(new NameOfNode(actualParent));
                return preserve == 1;
            }
            catch (XPathException e) {
                return true;
            }
        }

        public NodeInfo current() {
            return this.currentVirtualNode;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.currentVirtualNode.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.currentVirtualNode.atomize();
        }

        public CharSequence getStringValue() {
            return this.currentVirtualNode.getStringValue();
        }

        public AxisIterator getAnother() {
            return new StrippingIterator(this.base.getAnother(), this.parent);
        }

        public int getProperties() {
            return 0;
        }
    }
}

